//////////////////////////////////////////////////////////////////////////////
// FILE          : TXTINTER.H
// PURPOSE       : Text interface dialog library
// 		   Include files for the following text controls:
//
//			Text Labels
//			Prompt Boxes
//			Check Boxes
//			Radio Buttons
//			Push Buttons
//
//                 Everything needed is included to make a simple but
//		   very good text interface for console applications.
//
// The Following files must be included for the library to work:
//
//	userdefs.h      // Common user defined definitions
//	ctrldefs.h   	// Common definitions file for text controls
//	txtlabel.h	// Text label control header file
//	txtlabel.cpp	// Text label control source file
//	pushbtn.h	// Push button control header file
//	pushbtn.cpp	// Push button control source file
//	keycodes.h	// Keyboard code table header file
//	keycodes.cpp	// Keyboard code table source file
//	asserts.h	// Assertions header file
//	asserts.cpp	// Assertions source file
//	usermsg.h	// Common user defined error messages header file
//	usermsg.cpp	// Common user defined error messages source file
//	promptbox.h	// Prompt box control header file
//	promptbox.cpp	// Prompt box control source file
//	checkbox.h	// Check box control header file
//	checkbox.cpp	// Check box control source file
//	radiobtn.h	// Radio button control header file
//	radiobtn.cpp	// Radio button control source file
//	txtinter.h	// Header file which includes all the above files.
//
// WRITTEN BY    : Joseph Wong
//
// MODIFIED BY:         LAST MODIFIED:  COMMENTS:
// ------------         --------------  ---------
// Joseph Wong          Nov 12 1998     Original Writing
//
//////////////////////////////////////////////////////////////////////////////
#ifndef TEXTINTERFACE_H
#define TEXTINTERFACE_H
#ifndef CHECKBOX_H
  #include "checkbox.h"
#endif
#ifndef RADIOBTN_H
  #include "radiobtn.h"
#endif
#ifndef PUSHBTN_H
  #include "pushbtn.h"
#endif
#ifndef PROMPTBOX_H
  #include "promptbox.h"
#endif
#ifndef TXTLABEL_H
  #include "txtlabel.h"
#endif
#endif
