#ifndef TEXTLABEL_CPP
#define TEXTLABEL_CPP
#ifndef TEXTLABEL_H
  #include "txtlabel.h"
#endif

/****************************************************************************/
/****************************************************************************/
TextLabel::TextLabel(char* msg):
_Owner(NULL),
_HotKey(0),
_HotIndex(0),
_msg(SetMessage_Method(msg, _Dummy, _HotKey, _HotIndex)),
_xpos(wherex()),
_ypos(wherey()),
_Hidden(TRUE),
_InFocus(FALSE),
_TextWidgetActive(TRUE),
_SavedCursX(WHEREX()),
_SavedCursY(WHEREY()),

// Internal data monitoring function pointers
_hidden_monitor(NULL),
_active_monitor(NULL),
_infocus_monitor(NULL),

// Handles to external objects, used by data monitors
_hidden_handle(NULL),
_active_handle(NULL),
_infocus_handle(NULL)
{}

/****************************************************************************/
TextLabel::TextLabel(TextLabel& tl):
_Owner(NULL),
_HotKey(tl._HotKey),
_HotIndex(tl._HotIndex),
_msg(tl._msg ? strcpy(new char[strlen(tl._msg)+1], tl._msg):NULL),
_xpos(tl._xpos),
_ypos(tl._ypos),
_Hidden(TRUE),
_InFocus(FALSE),
_TextWidgetActive(TRUE),
_SavedCursX(WHEREX()),
_SavedCursY(WHEREY()),

// Internal data monitoring function pointers
_hidden_monitor(NULL),
_active_monitor(NULL),
_infocus_monitor(NULL),

// Handles to external objects, used by data monitors
_hidden_handle(NULL),
_active_handle(NULL),
_infocus_handle(NULL)
{}

/****************************************************************************/
void TextLabel::Clear()
{
  delete[] _msg;
  _msg = NULL;
}

/****************************************************************************/
const int* TextLabel::Monitor(const int*(*monptr_)(void*, TextLabel*, const int*), void* This_, const int* ptr_)
{
  if (monptr_ != NULL)
  {
    SaveCursorPosition();
    const int* RetVal_ = (*monptr_)(This_, this, ptr_);
    RestoreCursorPosition();

    return RetVal_;
  }

  return ptr_;
}

/****************************************************************************/
void TextLabel::SaveCursorPosition()
{
  _SavedCursX = WHEREX();
  _SavedCursY = WHEREY();
}

/****************************************************************************/
void TextLabel::RestoreCursorPosition()
{
  GOTOXY(_SavedCursX, _SavedCursY);
}

/****************************************************************************/
const int* TextLabel::MonitorHiddenStatus(void* This_, const int*(*FnPtr_)(void*, TextLabel*, const int*))
{
  _hidden_handle = This_;
  _hidden_monitor = FnPtr_;
  return &_Hidden;
}

/****************************************************************************/
const int* TextLabel::MonitorActiveStatus(void* This_, const int*(*FnPtr_)(void*, TextLabel*, const int*))
{
  _active_handle = This_;
  _active_monitor = FnPtr_;
  return &_TextWidgetActive;
}

/****************************************************************************/
const int* TextLabel::MonitorInFocusStatus(void* This_, const int*(*FnPtr_)(void*, TextLabel*, const int*))
{
  _infocus_handle = This_;
  _infocus_monitor = FnPtr_;
  return &_InFocus;
}

/****************************************************************************/
/****************************************************************************/
TextLabel& TextLabel::operator = (TextLabel& tl)
{
  if (this != &tl)
  {
    Clear();

    _msg = tl._msg ? strcpy(new char[strlen(tl._msg)+1], tl._msg):NULL;
    _xpos = tl._xpos;
    _ypos = tl._ypos;
    _HotIndex = tl._HotIndex;
    _HotKey = tl._HotKey;
  }

  return *this;
}

/****************************************************************************/
TextLabel* TextLabel::Make(TextLabel& Tlabel_)
{
  TextLabel* tl;
  tl = new TextLabel(Tlabel_);
  return tl;
}

/****************************************************************************/
TextLabel* TextLabel::Make(char* msg)
{
  TextLabel* tl;
  tl = new TextLabel(msg);
  return tl;
}

/****************************************************************************/
/****************************************************************************/
void TextLabel::PrintBlanks(int Max_)
{
  for (int Index_ = 0; Index_ < Max_; Index_++)
    PUTCH(' ');
}

/****************************************************************************/
// PURPOSE:
//   Set Label message method
//
// PRE:
//   The original value of the message data member
//
// POST:
//   The message data member is assigned new memory copied from the argument
//   string.
//
char* TextLabel::SetMessage(const char* str)
{
  if (str != _msg)
  {
    delete[] _msg;
    _msg = SetMessage_Method(str, _Dummy, _HotKey, _HotIndex);
  }

  return _msg;
}

/****************************************************************************/
void TextLabel::RemoveMessage()
{
  SetMessage(NULL);
}

/****************************************************************************/
void TextLabel::SetXYpos(int x, int y)
{
  SetXpos(x);
  SetYpos(y);
}

/****************************************************************************/
/****************************************************************************/
// PURPOSE:
//   Shows Label method
//
// POST:
//   Shows Label message
//
void TextLabel::Show()
{
  if (!IsActive())
    return;

  _InFocus = TRUE;
  Monitor(_infocus_monitor, _infocus_handle, &_InFocus);
  Monitor(_hidden_monitor, _hidden_handle, &_Hidden);

  GOTOXY(_xpos, _ypos);
  SetupColors(ColorInfo::NORMAL_COLORS);

  if (_HotKey && UsesColor())
  {
    int* Colors_ = NormalColors();
    char* Temps_ = strncpy(new char[_HotIndex + 1], _msg, _HotIndex);
    Temps_[_HotIndex] = 0;

    CPUTS(Temps_);
    textcolor(HotKeyColor());
    PUTCH(_msg[_HotIndex]);
    textcolor(Colors_[0]);
    CPUTS(&_msg[_HotIndex + 1]);

    delete[] Temps_;
  }
  else
    CPUTS(_msg);

  _InFocus = FALSE;
  Monitor(_infocus_monitor, _infocus_handle, &_InFocus);
  _Hidden = FALSE;
  Monitor(_hidden_monitor, _hidden_handle, &_Hidden);
}

/****************************************************************************/
// PURPOSE:
//   Hide Label method
//
// POST:
//   goes to the specified coordinates of the Label then Clears the
//   line containing the Label.
//
void TextLabel::Hide()
{
  if (!IsActive())
    return;

  _InFocus = TRUE;
  Monitor(_infocus_monitor, _infocus_handle, &_InFocus);
  Monitor(_hidden_monitor, _hidden_handle, &_Hidden);

  GOTOXY(_xpos, _ypos);
  
  SetupColors(ColorInfo::BACKGROUND_COLOR);
  PrintBlanks(strlen(_msg));

  GOTOXY(_xpos, _ypos);

  _InFocus = FALSE;
  Monitor(_infocus_monitor, _infocus_handle, &_InFocus);
  _Hidden = TRUE;
  Monitor(_hidden_monitor, _hidden_handle, &_Hidden);
}

/****************************************************************************/
// PURPOSE:
//   Hide Label method
//
// POST:
//   goes to the specified coordinates of the Label then Clears the
//   line containing the Label.
//
void TextLabel::IntHide()
{
  if (!IsActive())
    return;

  GOTOXY(_xpos, _ypos);
  SetupColors(ColorInfo::BACKGROUND_COLOR);
  PrintBlanks(strlen(_msg));
  GOTOXY(_xpos, _ypos);
}

/****************************************************************************/
void TextLabel::Erase()
{
  if (!IsActive())
    return;

  _InFocus = TRUE;
  Monitor(_infocus_monitor, _infocus_handle, &_InFocus);
  Monitor(_hidden_monitor, _hidden_handle, &_Hidden);

  if (!_Hidden)
  {
    IntHide();
    _Hidden = TRUE;
    Monitor(_hidden_monitor, _hidden_handle, &_Hidden);
  }

  SetMessage("");

  _InFocus = FALSE;
  Monitor(_infocus_monitor, _infocus_handle, &_InFocus);
}

/****************************************************************************/
Boolean TextLabel::IsOwner(ControlWindow* Pwin_) const
{
  return (_Owner == Pwin_);
}

/****************************************************************************/
int TextLabel::GetHotKey() const
{
  return 0;
}

/****************************************************************************/
int TextLabel::GetShortCut() const
{
  return 0;
}

/****************************************************************************/
int TextLabel::GetHotKeyType() const
{
  return 0;
}

/****************************************************************************/
Boolean TextLabel::IsEnterable() const
{
  return FALSE;
}

/****************************************************************************/
Boolean TextLabel::IsSelectable() const
{
  return FALSE;
}

/****************************************************************************/
Boolean TextLabel::IsSelected() const
{
  return 1;
}

/****************************************************************************/
Boolean TextLabel::IsEmpty() const
{
  return 0;
}

/****************************************************************************/
Boolean TextLabel::IsEscaped() const
{
  return 1;
}

/****************************************************************************/
Boolean TextLabel::IsValid() const
{
  return 1;
}

/****************************************************************************/
Boolean TextLabel::IsActive() const
{
  return _TextWidgetActive;
}

/****************************************************************************/
Boolean TextLabel::IsInFocus() const
{
  return _InFocus;
}

/****************************************************************************/
void TextLabel::Activate()
{
  _TextWidgetActive = TRUE;
  Monitor(_active_monitor, _active_handle, &_TextWidgetActive);
}

/****************************************************************************/
void TextLabel::Deactivate()
{
  _TextWidgetActive = FALSE;
  Monitor(_active_monitor, _active_handle, &_TextWidgetActive);
}

/****************************************************************************/
int TextLabel::Prompt(int status_)
{
  return 1;
}

/****************************************************************************/
void TextLabel::SetOwner(ControlWindow* Pwin_, TextControl* TxtCtrl_)
{
  if (_Owner && _Owner != Pwin_)
    _Owner->RemoveControl(TxtCtrl_);
  _Owner = Pwin_;
}

/****************************************************************************/
void TextLabel::SetupColors(int Mode_)
{
  if (!_ColorInfo.SetupColors(Mode_))
    GetDefaultColorInfo().SetupColors(Mode_);
}

/****************************************************************************/
void TextLabel::UseColor(Boolean Flag_)
{
  if (_ColorInfo._UseColor)
    *_ColorInfo._UseColor = Flag_;
  else
    _ColorInfo._UseColor = new Boolean(Flag_);

  GetDefaultColorInfo().UseColor(Flag_);
}

/****************************************************************************/
void TextLabel::SetNormalColors(int FgCol_, int BgCol_)
{
  if (_ColorInfo._NormalColors)
  {
    _ColorInfo._NormalColors[0] = FgCol_;
    _ColorInfo._NormalColors[1] = BgCol_;
  }
  else
  {
    _ColorInfo._NormalColors = new int[2];
    SetNormalColors(FgCol_, BgCol_);
  }
}

/****************************************************************************/
void TextLabel::SetHighLightColors(int FgCol_, int BgCol_)
{
  if (_ColorInfo._HighLightColors)
  {
    _ColorInfo._HighLightColors[0] = FgCol_;
    _ColorInfo._HighLightColors[1] = BgCol_;
  }
  else
  {
    _ColorInfo._HighLightColors = new int[2];
    SetHighLightColors(FgCol_, BgCol_);
  }
}

/****************************************************************************/
void TextLabel::SetHotKeyColor(int Col_)
{
  if (_ColorInfo._HkColor)
    *_ColorInfo._HkColor = Col_;
  else
    _ColorInfo._HkColor = new int(Col_);
}

/****************************************************************************/
void TextLabel::SetBackGroundColor(int Col_)
{
  if (_ColorInfo._BackGroundColor)
    *_ColorInfo._BackGroundColor = Col_;
  else
    _ColorInfo._BackGroundColor = new int(Col_);
}

/****************************************************************************/
void TextLabel::UseDefaultColors()
{
  _ColorInfo.ClearColors();
  UseColor();
}

/****************************************************************************/
Boolean TextLabel::UsesColor() const
{
  return
  (
    _ColorInfo._UseColor ?
      *(_ColorInfo._UseColor):
      *(GetDefaultColorInfo()._UseColor)
  );
}

/****************************************************************************/
int* TextLabel::NormalColors() const
{
  return
  (
    _ColorInfo._NormalColors ?
      _ColorInfo._NormalColors:
      GetDefaultColorInfo()._NormalColors
  );
}

/****************************************************************************/
int* TextLabel::HighLightColors() const
{
  return
  (
    _ColorInfo._HighLightColors ?
      _ColorInfo._HighLightColors:
      GetDefaultColorInfo()._HighLightColors
  );
}

/****************************************************************************/
int TextLabel::HotKeyColor() const
{
  return
  (
    _ColorInfo._HkColor ?
      *(_ColorInfo._HkColor):
      *(GetDefaultColorInfo()._HkColor)
  );
}

/****************************************************************************/
int TextLabel::BackGroundColor() const
{
  return
  (
    _ColorInfo._HkColor ?
      *(_ColorInfo._HkColor):
      *(GetDefaultColorInfo()._HkColor)
  );
}

/****************************************************************************/
/****************************************************************************/
// PURPOSE:
//   Prompt window default constructor
//
// PRE:
//   an uninitialize Prompt window
//
// POST:
//   a Prompt window is constructed and assigned the default values
//   specified.
//
LabelWindow::LabelWindow():
PromptWindow()
{}

/****************************************************************************/
// PURPOSE:
//   Prompt window copy construcor
//
// PRE:
//   An uninitialized Prompt window.
//
// POST:
//   a Prompt window is constructed and assigned the corresponding values
//   in the Prompt window argument passed to the constructor.
//
LabelWindow::LabelWindow(LabelWindow& Lwin_):
PromptWindow(Lwin_._maxbox)
{
  _pbox = new TextControl*[_maxbox];

  for (int index = 0; index < _maxbox; index++)
    if (Lwin_[index])
    {
      _pbox[index] = TextLabel::Make(*Lwin_[index]);
      SetControlData(_pbox, _Info, index);
    }
    else
      RemoveControlData(_pbox, _Info, index);
}

/****************************************************************************/
Boolean LabelWindow::ValidityCheck()
{
  return TRUE;
}

/****************************************************************************/
// PURPOSE:
//   Method to Grow the size of the array by some number passed as an
//   argument to the method. The array contents are preserved.
//
// PRE:
//   The old size of the Prompt box array and its contents
//
// POST:
//   The array size is Grown by the extra size given and the original
//   contents of the array are preserved in the new array.
//
void LabelWindow::Grow(int extra)
{
  int index;
  int newlen = _maxbox + extra;
  
  TextControl** newp = new TextControl*[newlen];
  ControlInfo* newi = new ControlInfo(newlen);

  for (index = 0; index < _maxbox; index++)
  {
    newp[index] = TextLabel::Make(*((TextLabel*)_pbox[index]));
    SetControlData(newp, newi, index);
  }

  for (;index < newlen; index++)
    RemoveControlData(newp, newi, index);

  Clear();

  _maxbox = newlen;
  _pbox = newp;
  _Info = newi;
}

/****************************************************************************/
int LabelWindow::Prompt(int StartIndex_)
{
  return 1;
}

/****************************************************************************/
// PURPOSE:
//   Prompt box Index operator. To index individual Prompt boxes from the
//   Prompt window given the position of the Prompt box within the array.
//
// PRE:
//   int index : the index position of the Prompt box in the array
//
// POST:
//   Go into the specified index position in the Prompt box array and
//   Retrieve its element.
//
LabelWindowRef LabelWindow::operator [] (int index)
{
  ASSERT((index >= 0 && index < _maxbox), USER_Message_t::ERRMSG_INDEXRANGE);

  LabelWindowRef PboxRef(this, index);
  return PboxRef;
}

/****************************************************************************/
/****************************************************************************/
LabelWindowRef::LabelWindowRef(LabelWindow* Boss_, int Index_):
_BossPtr(Boss_),
_Index(Index_)
{}

/****************************************************************************/
LabelWindowRef& LabelWindowRef::operator = (TextLabel* Tlabel_)
{
  _BossPtr->Control(_Index, Tlabel_);
  return *this;
}

/****************************************************************************/
LabelWindowRef::operator TextLabel* ()
{
  return CastToTextLabel(_BossPtr->Control(_Index));
}

/****************************************************************************/
TextLabel* LabelWindowRef::operator -> ()
{
  return CastToTextLabel(_BossPtr->Control(_Index));
}

/****************************************************************************/
/****************************************************************************/
#if TEXTLABEL_DEBUG
int main()
{
  CLRSCR();

  TextLabel* tl;
  LabelWindow pw;

  pw.MaxControl(1);

  tl = TextLabel::Make("This is &Label #1 : ");
  tl->SetXpos(3);
  tl->SetYpos(2);
  pw[0] = tl;

  pw.Grow(3);

  tl = TextLabel::Make("This is L&abel #2 : ");
  tl->SetXpos(3);
  tl->SetYpos(4);
  pw[1] = tl;

  tl = TextLabel::Make("This is La&bel #3 : ");
  tl->SetXpos(3);
  tl->SetYpos(6);
  pw[2] = tl;

  tl = TextLabel::Make("This is Lab&el #4 : ");
  tl->SetXpos(3);
  tl->SetYpos(8);
  pw[3] = tl;

  pw.UseColor();
  pw.Show();
  GETCH();
  pw.UseColor(FALSE);
  pw.Hide();

  int index;
  pw.UseColor();
  
  for (index = 0; index < pw.MaxControl(); index++)
  {
    tl = pw[index];
    GETCH();
    tl->Show();
  }

  pw.UseColor(FALSE);

  for (index = 0; index < pw.MaxControl(); index++)
  {
    tl = pw[index];
    GETCH();
    tl->Hide();
  }

  pw.Erase();
  return 0;
}

#endif
/****************************************************************************/
#endif

