#ifndef TEXTLABEL_H
#define TEXTLABEL_H
#ifndef PROMPTBOX_H
  #include "promptbox.h"
#endif

#define TEXTLABEL_DEBUG		0

/****************************************************************************/
class LabelWindow;

class TextLabel : public TextControl
{
  protected:
    ControlWindow* _Owner;
    ColorInfo _ColorInfo;

    int _HotIndex;                      // Hot key string index
    int _HotKey;                        // Hot key
    int _Dummy;
    
    char* _msg;				// prompt message buffer
    int _xpos;				// horizontal coordinate position
    int _ypos;				// vertical coordinate position

    int _Hidden;
    int _InFocus;			// Text widget in focus flag
    int _TextWidgetActive;		// Active flag for this text widget

    int _SavedCursX;			// Saved cursor x position
    int _SavedCursY;			// Saved cursor y position

    // Internal data monitoring function pointers
    const int*(*_hidden_monitor)(void*, TextLabel*, const int*);
    const int*(*_active_monitor)(void*, TextLabel*, const int*);
    const int*(*_infocus_monitor)(void*, TextLabel*, const int*);

    // Handles to external objects, used by data monitors
    void* _hidden_handle;
    void* _active_handle;
    void* _infocus_handle;

    // Clear prompt box method
    void PrintBlanks(int Max_);

    // data member destruction method
    void Clear();

    // internal hide method
    void IntHide();

    // Monitor functions execution and management methods
    const int* Monitor(const int*(*monptr_)(void*, TextLabel*, const int*), void* This_, const int* ptr_);
    void SaveCursorPosition();
    void RestoreCursorPosition();

    // Text color methods
    void SetupColors(int Mode_);

    // promptbox constructors
    TextLabel(char* msg);
    TextLabel(TextLabel& pb);

  public:
    virtual ~TextLabel()
	{ Clear(); }

    // promptbox assignment operator
    TextLabel& operator = (TextLabel& pb);
    static TextLabel* Make(char* msg=NULL);
    static TextLabel* Make(TextLabel& pbox);

    // prompt box properties mutators
    virtual char* SetMessage(const char* str);
    virtual void RemoveMessage();
    
    inline char* GetMessage()
	{ return _msg; }
    void SetXYpos(int x, int y);
    inline void SetXpos(int x)
	{ _xpos = x; }
    inline void SetYpos(int y)
	{ _ypos = y; }

    // prompt box manipulators
    virtual void Show();
    virtual void ShowInput() {}
    virtual void Hide();
    virtual int Prompt(int status_);
    virtual void Erase();

    // Accelerator key methods
    virtual int GetHotKey() const;
    virtual int GetShortCut() const;
    virtual int GetHotKeyType() const;

    // Empty or selected Label box test
    virtual void Select() {}
    virtual void Deselect() {}

    // Empty, valid and selected Text Control test
    virtual Boolean IsEnterable() const;
    virtual Boolean IsSelectable() const;
    virtual Boolean IsSelected() const;
    virtual Boolean IsEmpty() const;
    virtual Boolean IsEscaped() const;
    virtual Boolean IsValid() const;
    virtual Boolean IsActive() const;
    virtual Boolean IsInFocus() const;

    // Activation/Deactivation for this text widget
    virtual void Activate();
    virtual void Deactivate();

    // Control Ownership methods
    virtual void SetOwner(ControlWindow* Pwin_, TextControl* TxtCtrl_);
    virtual Boolean IsOwner(ControlWindow* Pwin_) const;

    // Text color methods
    virtual void UseColor(Boolean Flag_=TRUE);
    virtual void SetNormalColors(int FgCol_, int BgCol_);
    virtual void SetHighLightColors(int FgCol_, int BgCol_);
    virtual void SetHotKeyColor(int Col_);
    virtual void SetBackGroundColor(int Col_);
    virtual void UseDefaultColors();

    virtual Boolean UsesColor() const;
    virtual int* NormalColors() const;
    virtual int* HighLightColors() const;
    virtual int HotKeyColor() const;
    virtual int BackGroundColor() const;

    // Internal data monitoring methods
    const int* MonitorHiddenStatus(void* This_, const int*(*FnPtr_)(void*, TextLabel*, const int*));
    const int* MonitorActiveStatus(void* This_, const int*(*FnPtr_)(void*, TextLabel*, const int*));
    const int* MonitorInFocusStatus(void* This_, const int*(*FnPtr_)(void*, TextLabel*, const int*));
};

/****************************************************************************/
/****************************************************************************/
class LabelWindowRef;

class LabelWindow : public PromptWindow
{
  friend class LabelWindowRef;

  protected:
    virtual Boolean ValidityCheck();

  public:
    // prompt window constructors
    LabelWindow();
    LabelWindow(LabelWindow& pw);
    virtual ~LabelWindow()
	{ Clear(); }

    // prompt window data mutators
    virtual void Grow(int extra);

    // Text label specific accessors
    LabelWindowRef operator [] (int index);
    TextLabel* NextSelected(int& Start_);

    // prompt window manipulators
    virtual int Prompt(int StartIndex_=0);
};

/****************************************************************************/
class LabelWindowRef
{
  friend class LabelWindow;
  private:
    LabelWindow* _BossPtr;
    int _Index;

    LabelWindowRef(LabelWindow* Boss_, int Index_);
    static TextLabel* CastToTextLabel(TextControl* TxtCtrl_)
	{ return ((TextLabel*)TxtCtrl_); }

  public:
    LabelWindowRef& operator = (TextLabel* Tlabel_);
    operator TextLabel* ();
    TextLabel* operator -> ();
};

/****************************************************************************/
#endif

