#ifndef INCL_STDLIB_H
  #include <stdlib.h>
  #define INCL_STDLIB_H
#endif
#ifndef INCL_PTHREAD_H
  #include <pthread.h>
  #define INCL_PTHREAD_H
#endif
#ifndef INCL_SYSTIME_H
  #include <sys/time.h>
  #define INCL_SYSTIME_H
#endif
#ifndef UTHREAD_H
  #include "uthread.h"
#endif

/****************************************************************************/
static void* ThreadFunction(void* object)
{
  THREAD* thread = (THREAD*)object;
  return thread->Run(thread->Param);
}

/****************************************************************************/
THREAD::THREAD()
{
  Started = FALSE;
  Detached = FALSE;
  ThreadID = 0;

  _ThreadFunction = (void*(*)(void*))Dummy;
  _pObjThdFn = NULL;
  _nStatus = STATUS_CLOSED;
  _nSuspend = 0;

  int nRet = pthread_mutex_init(&_SuspendMutex,NULL); // Return Check
  if (nRet != 0)
    return;

  nRet = pthread_cond_init(&_ResumeCond,NULL); // Return Check
  if (nRet != 0)
    return;
}

/****************************************************************************/
THREAD::~THREAD()
{
  if (ThreadID == 0)
    return;

  if (STATUS_INIT == _nStatus)
	return;

  // resume if suspend
  if (STATUS_SUSPEND == _nStatus)
  {
	Resume(_ThreadFunction, this);
	return;
  }

  // close thread...
  if (STATUS_CLOSING != _nStatus)
  {
	Close();
	return;
  }

  // waiting for close
  Stop();
  ThreadID = 0;
}

/****************************************************************************/
int THREAD::Start(void* param)
{
  if (!Started)
  {
    pthread_attr_t attributes;
    pthread_attr_init(&attributes);
    if (Detached)
      pthread_attr_setdetachstate(&attributes, PTHREAD_CREATE_DETACHED);

    Param = param;
    if (pthread_create(&ThreadHandle, &attributes, ThreadFunction, this) == 0)
    {
      Started = TRUE;
      _nStatus = STATUS_RUNNING;
      ThreadID++;
    }

    pthread_attr_destroy(&attributes);
  }

  return Started;
}

/****************************************************************************/
void THREAD::Detach()
{
  if (Started && !Detached)
    pthread_detach(ThreadHandle);

  Detached = TRUE;
}

/****************************************************************************/
void* THREAD::Wait()
{
  void* status = NULL;

  if (Started && !Detached)
  {
    pthread_join(ThreadHandle, &status);
    Detached = TRUE;
  }

  return status;
}

/****************************************************************************/
void THREAD::Stop()
{
  if (Started && !Detached)
  {
    pthread_cancel(ThreadHandle);
    pthread_detach(ThreadHandle);
    Detached = TRUE;
    _nStatus = STATUS_CLOSED;
  }
}

/****************************************************************************/
void THREAD::Sleep(int delay)
{
  timeval timeout = {(delay / 1000), ((delay * 1000) % 1000000)};
  select(0, (fd_set*)NULL, (fd_set*)NULL, (fd_set*)NULL, &timeout);
}

/****************************************************************************/
void* THREAD::Run(void* Dum_)
{
  return Dum_;
}

/****************************************************************************/
bool THREAD::IsThdSuspended()
{
   int nRet;

   nRet = pthread_mutex_trylock(&_SuspendMutex);
   if (nRet == 0) // Thread was suspended
   {
     nRet = pthread_mutex_unlock(&_SuspendMutex);
     return true;
   }

   return false;
}

/****************************************************************************/
bool THREAD::Close()
{
  _nStatus = STATUS_CLOSING;
  Stop();
  return true;
}

/****************************************************************************/
int THREAD::Resume(void*(*func)(void*), void* pObj_)
{
  if (STATUS_SUSPEND != _nStatus)
	return 0;

  int nCondRet;
  if (!IsThdSuspended())
    return 0;

  _pObjThdFn = pObj_;
  _ThreadFunction = (void*(*)(void*))func;

  nCondRet = pthread_cond_signal(&_ResumeCond);
  if (nCondRet != 0)
    return 0;

  _nStatus = STATUS_RUNNING;
  return 1;
}

/****************************************************************************/
int THREAD::Suspend()
{
  if (STATUS_RUNNING != _nStatus)
	return 0;

  int nRet = pthread_mutex_lock(&_SuspendMutex); // Return Check
  if (nRet != 0)
    return 0;

  if (IsThdSuspended())
    return 0; // Alredy Suspended

  _nSuspend = true;
  _nStatus = STATUS_SUSPEND;
  return 1;
}

/****************************************************************************/
int THREAD::IsSuspended()
{
  return (_nStatus = STATUS_SUSPEND);
}

/****************************************************************************/
void* THREAD::ThdFn(void *ptr)
{
  char* chp;
  int nSuspRet;
  THREAD *pCthd = (THREAD*)ptr;

  pthread_cleanup_push(&CallBack,pCthd);}

  while(1)
  {
    if (pCthd->_nSuspend)
    {
      pCthd->_nSuspend = false;
      pCthd->_nStatus = STATUS_SUSPEND;
      pthread_cond_wait(&pCthd->_ResumeCond,&pCthd->_SuspendMutex);
    }

    pCthd->_nStatus = STATUS_RUNNING;
    // usleep(2000);

    // check if the funtion is exited, Call the thread cancelation
    chp = (char*)(*(pCthd->_ThreadFunction))(pCthd->_pObjThdFn);

    if (chp == 0)
    {
      nSuspRet = pCthd->Suspend();

      if (!nSuspRet)
      {
        pthread_exit(0);
        pCthd->_nStatus = STATUS_CLOSED;
      }
    }
  }
}

/****************************************************************************/
void THREAD::CallBack(void *ptr)
{
  THREAD* pCthd = (THREAD*)ptr;

  pCthd->_nStatus = STATUS_CLOSED;
  pCthd->ThreadID = 0;
}

/****************************************************************************/
void* THREAD::Dummy(void* arg)
{
  static char dum[] = "1";
  ::usleep(1);
  return dum;
}

/****************************************************************************/




