#ifndef UTHREAD_H
#define UTHREAD_H

#ifndef INCL_STDLIB_H
  #include <stdlib.h>
  #define INCL_STDLIB_H
#endif
#ifndef INCL_PTHREAD_H
  #include <pthread.h>
  #define INCL_PTHREAD_H
#endif
#ifndef INCL_SYSTIME_H
  #include <sys/time.h>
  #define INCL_SYSTIME_H
#endif
#ifndef INCL_UNISTD_H
  #include <unistd.h>
  #define INCL_UNISTD_H
#endif
#ifndef BOOLEAN_H
  #include "boolean.h"
#endif

static void* ThreadFunction(void*);

class THREAD
{
  friend void* ThreadFunction(void*);

  public:
	enum
	{
      SUSPEND = true,
      RUN = false
    };

	enum
	{
      STATUS_INIT = 0,
      STATUS_SUSPEND,
      STATUS_RUNNING,
      STATUS_CLOSING,
      STATUS_CLOSED,

      TIME_WAITINGCLOSE = 3000
    };

  public:
    THREAD();
    virtual ~THREAD();
	THREAD& operator = (const THREAD&)
	   { return *this; }

    int Start(void* = NULL);
    void Detach();
    void* Wait();
    void Stop();
    unsigned int GetThreadID()
	{ return ThreadID; }
    static unsigned int GetCurrentID()
	{ return 0; }
    static void Sleep(int);

    bool Close();
    int Suspend(void);
    int Resume(void*(*func)(void*), void* pObj_);
    int IsSuspended();
    static void* ThdFn(void *pObj);

  protected:
    virtual void* Run(void*);
    bool IsThdSuspended();

  private:
    pthread_t ThreadHandle;
    unsigned int ThreadID;
    int Started;
    int Detached;
    void* Param;

    pthread_mutex_t _SuspendMutex;
    pthread_cond_t _ResumeCond;
	volatile int _nStatus;
    int _nSuspend;
    void* _pObjThdFn;
    void*(*_ThreadFunction)(void*);

    static void* Dummy(void *arg);
    static void CallBack(void *arg);
};

#endif



