#include <qobject.h>
#include <qprocess.h>
#include <qapplication.h>
#include <qmessagebox.h>
#include <qfiledialog.h>



#include <stdlib.h>

#define HELP_START_FILE         "qmcalchelp.html"


#define WEB_BROWSER_PATH_FILE   "webpath.dat"

#if defined(Q_OS_WIN32) & !defined(__linux__) & !defined(__unix__)

#define DIRSEP                   "\\"
#define EOLCHARLEN               2
#define DEFAULT_WEB_BROWSER      "c:\\Program Files\\Mozilla Firefox\\firefox.exe"
#define WEB_BROWSER_2ND_CHOICE   "c:\\Program Files\\Opera\\opera.exe"
#define WEB_BROWSER_3RD_CHOICE   "c:\\Program Files\\Google\\Chrome\\Application\\chrome.exe"
#define WEB_BROWSER_4TH_CHOICE   "c:\\Program Files\\Safari\\safari.exe"
#define WEB_BROWSER_5TH_CHOICE   "c:\\Program Files\\Internet Explorer\\iexplore.exe"

#define WEB_BROWSER_ABSPATH      "c:\\Program Files\\Cybernadian\\Qmcalc\\webpath.dat"
#define HELP_DOCS_ABSPATH        "c:\\Program Files\\Cybernadian\\Qmcalc\\qmcalc_doc\\qmcalchelp.html"
#define PROGRAM_INSTALL_ABSPATH  "c:\\Program Files\\Cybernadian\\Qmcalc\\"

#define DEFAULT_APPS_DIR         "c:\\Program Files\\"
#define DOCUMENT_DIR             "qmcalc_doc"
#define APPS_FILE_FILTER         "Programs (*.exe)"
#define COPYCMD                  "copy"

#else

#define DIRSEP                   "/"
#define EOLCHARLEN               2

#define DEFAULT_WEB_BROWSER      "/usr/bin/firefox"
#define WEB_BROWSER_2ND_CHOICE   "/usr/bin/opera"
#define WEB_BROWSER_3RD_CHOICE   "/usr/bin/chromium"
#define WEB_BROWSER_4TH_CHOICE   "/usr/bin/safari"
#define WEB_BROWSER_5TH_CHOICE   "/usr/bin/mozilla"

#define WEB_BROWSER_ABSPATH      "/usr/local/bin/qmcalc-2/webpath.dat"
#define HELP_DOCS_ABSPATH        "/usr/local/bin/qmcalc-2/qmcalc_doc/qmcalchelp.html"
#define PROGRAM_INSTALL_ABSPATH  "/usr/local/bin/qmcalc-2/"

#define DEFAULT_APPS_DIR         "/usr"
#define DOCUMENT_DIR             "qmcalc_doc"
#define APPS_FILE_FILTER         NULL
#define COPYCMD                  "cp"

#endif

#if defined(Q_OS_WIN32) & !defined(__linux__) & !defined(__unix__)
  #include "installstd.h"
#else
  #include "installpref.h"
#endif

class HelpViewer : public QWidget
{
    Q_OBJECT

public:
    HelpViewer();
    ~HelpViewer() {}

private:
    QProcess *proc;
    QString _WebBrowserPath;

    bool SelectPathToWebBrowser();
    void ShowHelp();
};

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
HelpViewer::HelpViewer()
{
  _WebBrowserPath = "";
  ShowHelp();
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
bool HelpViewer::SelectPathToWebBrowser()
{
    QString CurPath_ = _WebBrowserPath;

    QString Start_;
    QString Caption_ = "Select File Path to Web Browser Program";

    if (CurPath_.isEmpty() || CurPath_ == QString("."))
    {
      if (QFile::exists(DEFAULT_WEB_BROWSER))
        Start_ = DEFAULT_WEB_BROWSER;
      else
        Start_ = DEFAULT_APPS_DIR;
    }
    else
      Start_ = CurPath_;

    QString FilePath_ =
    QFileDialog::getOpenFileName
    (
      Start_,
      APPS_FILE_FILTER,
      this,
      "GetWebPath",
      Caption_
    );

    if (!FilePath_.isEmpty() && QFile::exists(FilePath_))
      _WebBrowserPath = FilePath_;
    else if (QFile::exists(DEFAULT_WEB_BROWSER))
      _WebBrowserPath = DEFAULT_WEB_BROWSER;

    return (!_WebBrowserPath.isEmpty());
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void HelpViewer::ShowHelp()
{
    QDir Dir_(QDir::currentDirPath());
    bool FileFound_ = false;

    if (_WebBrowserPath.isEmpty())
    {
      QString FilePath_ = Dir_.absPath();
      FilePath_ += QString(QChar(QDir::separator()));
      FilePath_ += QString(WEB_BROWSER_PATH_FILE);

      QFile File_;      
      
      // try absolute path to software install dir. if web browser path file not detected
      FileFound_ = QFile::exists(FilePath_);
      if (!FileFound_)
        FilePath_ = WEB_BROWSER_ABSPATH;

      if (FileFound_ || QFile::exists(FilePath_))
      {
        File_.setName(FilePath_);

        if (!File_.open(IO_ReadOnly | IO_Translate))
        {
          if (SelectPathToWebBrowser())
          {
            ShowHelp();
            return;
          }
          else
          {
            QMessageBox::critical(0,
              QString(tr("Fatal Error")),
              QString(tr("Fatal Error: Could not start the web browser program.\n")),
              QString(tr("Quit")));
            exit( -1 );
          }
        }
        else
        {
          QTextStream fin(&File_);
          fin.setEncoding(QTextStream::UnicodeUTF8);

          QString Str_ = fin.readLine();
          Str_ = Str_.stripWhiteSpace();
          _WebBrowserPath = Str_;
          File_.close();

          if (!QFile::exists(_WebBrowserPath))
          {
            File_.setName(FilePath_);
            File_.open(IO_WriteOnly | IO_Translate);

            QTextStream fout(&File_);
            fout.setEncoding(QTextStream::UnicodeUTF8);
            fout.setDevice(&File_);

            Str_ = WEB_BROWSER_2ND_CHOICE;
            Str_ = Str_.stripWhiteSpace();

            if (QFile::exists(Str_))
            {
              _WebBrowserPath = Str_;
              fout <<_WebBrowserPath <<"\n";
              File_.close();
            }
            else
            {
              Str_ = WEB_BROWSER_3RD_CHOICE;
              Str_ = Str_.stripWhiteSpace();

              if (QFile::exists(Str_))
              {
                _WebBrowserPath = Str_;
                fout <<_WebBrowserPath <<"\n";
                File_.close();
              }
              else
              {
                Str_ = WEB_BROWSER_4TH_CHOICE;
                Str_ = Str_.stripWhiteSpace();

                if (QFile::exists(Str_))
                {
                  _WebBrowserPath = Str_;
                  fout <<_WebBrowserPath <<"\n";
                  File_.close();
                }
                else
                {
                  Str_ = WEB_BROWSER_5TH_CHOICE;
                  Str_ = Str_.stripWhiteSpace();

                  if (QFile::exists(Str_))
                  {
                    _WebBrowserPath = Str_;
                    fout <<_WebBrowserPath <<"\n";
                    File_.close();
                  }
                }
              }
            }
          }
        }
      }
      else
      {
        if (SelectPathToWebBrowser())
        {
          ShowHelp();
          return;
        }
        else
        {
          QMessageBox::critical(0,
            QString(tr("Fatal Error")),
            QString(tr("Fatal Error: Could not start the web browser program.\n")),
            QString(tr("Quit")));
          exit( -1 );
        }
      }
    }

    QString DocPath_ = Dir_.absPath();
    #if defined(Q_OS_WIN32) & !defined(__linux__) & !defined(__unix__)
      DocPath_.replace(QChar('/'), "\\");
    #endif

    // DocPath_ += QString(QChar(QDir::separator()));
    DocPath_ += QString(DIRSEP);
    DocPath_ += QString(DOCUMENT_DIR);
    // DocPath_ += QString(QChar(QDir::separator()));
    DocPath_ += QString(DIRSEP);

    DocPath_ += QString(HELP_START_FILE);
    
    // try absolute path to software install dir. if help document file not detected
    FileFound_ = QFile::exists(DocPath_);
    if (!FileFound_)
      DocPath_ = HELP_DOCS_ABSPATH;
    
    // QProcess related code
    proc = new QProcess( this );

    // Set up the command and arguments.
    // On the command line you would do:
    //   uic -tr i18n "small_dialog.ui"
    proc->addArgument(_WebBrowserPath);
    proc->addArgument(DocPath_);

    connect(proc, SIGNAL(processExited()),
            qApp, SLOT(quit()));

    if (!proc->start())
    {
      // error handling
      QMessageBox::critical(0,
        QString(tr("Fatal Error")),
        QString(tr("Fatal Error: Could not start the web browser program.\n")),
        QString(tr("Quit")));
      exit( -1 );
    }
}

int main( int argc, char **argv )
{
    QApplication a( argc, argv );
    HelpViewer HelpView_;
    a.setMainWidget( &HelpView_ );
    return a.exec();
}

#include "viewhelp.moc"
