#ifndef WTHREAD_H
#define WTHREAD_H

#ifndef INCL_WINDOWS_H
  #define INCL_WINDOWS_H
  #include <windows.h>
#endif
#ifndef INCL_STDLIB_H
  #define INCL_STDLIB_H
  #include <stdlib.h>
#endif
#ifndef INCL_PROCESS_H
  #define INCL_PROCESS_H
  #include <process.h>
#endif
#ifndef BOOLEAN_H
  #include "boolean.h"
#endif

static DWORD WINAPI ThreadFunction(LPVOID);

class ThreadEvent
{
  public:
    virtual int OnThreadCreate() = 0;
	virtual int OnThreadDestroy() = 0;

    virtual int	OnThreadEvent() = 0;
    virtual int	OnThreadProcess() = 0;
};

class THREAD
{
  friend DWORD WINAPI ThreadFunction(LPVOID);

  public:
	enum
	{
      SUSPEND = true,
      RUN = false
    };

	enum
	{
      STATUS_INIT = 0,
      STATUS_SUSPEND,
      STATUS_RUNNING,
      STATUS_CLOSING,
      STATUS_CLOSED,

      TIME_WAITINGCLOSE = 3000
    };

  public:
    THREAD(ThreadEvent* pEvent_=NULL);
    virtual ~THREAD();
	THREAD& operator = (const THREAD&)
	   { return *this; }

    int Start(void* = NULL);
    void Detach();
    void* Wait();
    void Stop();
    unsigned int GetThreadID()
	{ return ThreadID; }
    static unsigned int GetCurrentThreadID()
	{ return GetCurrentThreadId(); }
    static void Sleep(int delay)
	{ ::Sleep(delay); }

	bool Init(bool bSuspend = SUSPEND, DWORD dwWorkInterval=-1);
	bool Close();
	void Resume();
	void Suspend();
	void SetEvent()
	    { ::SetEvent(_hWorkEvent); }
	int GetStatus() const
	    { return _nStatus; }

  protected:
	DWORD _dwWorkInterval;
	ThreadEvent* _event;

    virtual void* Run(void*);
    void* Param;

  private:
    HANDLE ThreadHandle;
	HANDLE _hExitEvent;
	HANDLE _hWorkEvent;
	volatile int _nStatus;

    DWORD ThreadID;
    BOOL Started;
    BOOL Detached;

	static DWORD WINAPI RunThread(LPVOID pThreadParameter);

  public:
	static THREAD* CreateNew(ThreadEvent* pEvent_, bool bSuspend = SUSPEND, DWORD dwWorkInterval=-1);
};

#endif



