#ifndef EXECPRGNAME_H
#define EXECPRGNAME_H
#ifndef INCL_NEW_H
  // #include <new.h>
  #include <new>
  #define INCL_NEW_H
#endif
#ifndef INCL_CTYPE_H
  #include <ctype.h>
  // #include <ctype>
  #define INCL_CTYPE_H
#endif
#ifndef INCL_STRING_H
  #include <string.h>
  // #include <string>
  #define INCL_STRING_H
#endif

/****************************************************************************/
class ExecutingProgramName
{
  protected:  
    char* _Name;
    const char* _PrgExecuted;
    
    size_t _Length;
    bool _InInputFile;
    bool _InProgramFile;
    bool _InputFilePause;
    int _Level;
    
    ExecutingProgramName* _Next;

    ExecutingProgramName(char* Name_, const char* PrgExec_,
                         bool InputFile_, int Level, bool Pause_);
    ExecutingProgramName* CopyOldProgramName(char* Name_, const char* PrgExec_,
                                             bool InputFile_, int Level_, bool Pause_);

    int StriCaseComp(const char* s1, const char* s2, bool SkipWs_=false) const;

  public:
    ExecutingProgramName(const char* Name_=NULL);
    ~ExecutingProgramName();

    ExecutingProgramName* PopLevel(ExecutingProgramName*& OldNode_);
    ExecutingProgramName* SetNewProgramName(const char* Name_);

    const char* ReplaceName(const char* Name_, bool SetPrgExec_=false);
    const char* NameIndexAt(size_t x, char ch);
    const char* NameIndexAt(size_t x);
    
    void SetAsInputFile(bool flag_);
    void SetPauseSwitch(bool flag_);
    void SetPrgExecuted(const char* Name_);
    
    bool IsMatchingPrgExec() const;
    bool MatchName(const char* Name_);
    bool IsBatchInputFile() const;
    
    inline const char* Name() const
        { return _Name; }
    inline const char* PrgExecuted() const
        { return _PrgExecuted; }
    inline size_t NameLength() const
        { return (_Name ? ::strlen(_Name):0); }
    inline bool InInputFile() const
        { return _InInputFile; }
    inline bool InProgramFile() const
        { return _InProgramFile; }
    inline bool InputFilePause() const
        { return _InputFilePause; }
    inline int Level() const
        { return _Level; }
};

/****************************************************************************/
#endif
