#ifndef MOCKCLIENT_H
#define MOCKCLIENT_H

/****************************************************************************/
class CalculatorBase;

class ServerPollingMgr
{
  friend class CalculatorBase;

  protected:
    enum
    {
      READ    = 0,
      WRITE   = 1,
      BUFSIZE = 64,
      LOOP_GUARD_LIMIT = 100,

      INITIALSTATE = 0,
      NOTREQUIRED  = 1,
      REQUIRED     = 2,
      INPROCESS    = 4,
      COMPLETED    = 8
    };

    CalculatorBase* _Parent;        // Parent calculator driver object
    char* _StrBuffer;           // string buffer for state file date reading

    int _CycleNum;              // Poll process cycle number
    bool _CycleActive;          // Poll process cycle in active state
    int _RetrievedCycle;        // Retrieved process cycle number from client

    int _ClientPollProcess;     // Client polling process steps
    int _ServerPollProcess;     // Server polling process steps
    int _PrevServerProcess;     // Saved previous server polling process value
    int _PrevClientProcess;     // Saved previous receive from server poll process value
    
    int _RetryReadCount;        // Counter for retry attempts to read I/O state file
    int _RetryPollCount;        // Retry attempts counter for client program "keep alive" polling
    int _PollState;             // Client polling state
    int _ServerState;           // Server keep alive state
    int _ClientState;           // client keep alive state

    bool _AllowPollServer;      // Allow polling of server program
    bool _SleepWaiting;         // Sleep only when waiting for client response to server signal
    bool _ResetStatesOnDone;    // Reset poll process state after poll process completed
    bool _BreakOnPollError;     // Break out of polling loop on encounter of polling error
    bool _KeepAlivePollError;   // Error indicator for client program "keep alive" polling
    bool _ConfirmedClientAlive; // Confirmed client program is alive after polling client
    bool _ConfirmedServerAlive; // Confirmed server program is alive after client polled server
    bool _ServerAliveConfSent;  // Server alive confirmation sent to calculator object

    bool _AsyncMode;
    bool _ExitAtRetryMax;
    bool _StopTracking;         // debug mode method and data tracking
    bool _WaitUntilResponse;    // Wait indefinitely until client response
    bool _PausePollResults;     // Pause after showing poll results
    bool _ResetWhenNotReq;      // Reset polling/receiving when condition not required
    bool _ForceReset;           // Force reset polling/receiving on condition

    ServerPollingMgr* _Backup;  // backup version to compare differences in polling results data

    // server-polling-client process steps
    bool ServerIsPolling() const;
    bool ClientIsAlive() const;
    bool ServerAcked() const;
    bool ResetSignalSent() const;
    bool PollingResetByServer() const;

    // client-polling-server process steps
    bool AtInitialState();
    bool ClientIsPolling() const;
    bool ServerIsAlive() const;
    bool ClientAcked() const;
    bool ResetRequested() const;
    bool PollingReset() const;

    // polling variables and poll cycle number
    void ResetPollingVars();
    void ResetPollCycle();
    void SetNewPollCycle();
    void AcceptPollCycle();
    int IncCycleNum();

    // methods for polling server in order (top to bottom)
    bool PollServerIfAlive_IMPL(int Sleep_, bool ResponseOnly_);
    bool SendPollServerSignal();
    void ConfirmServerAlive(bool ReceiveClient_=false);
    bool SendClientAckServerSignal();
    bool ResetPolling();

    // methods for receiving client poll in order (top to bottom)
    bool ReceiveKeepAlivePoll_IMPL(int Sleep_);
    bool SendClientAliveSignal();
    void ConfirmClientAlive(bool PollServer_=false);
    bool SendResetPollingSignal();

    bool PollServerCompleted_IMPL(bool InclNotReq_, bool InclPrev_) const;
    bool ClientReceiveCompleted_IMPL(bool InclNotReq_, bool InclPrev_) const;

    bool SetPollState(int State_);
    bool SetClientState(int State_);
    int ReadClientState(bool RdPoll_);
    bool ResponseRequired(int PrevPollState_,
                          int LoopGuard_, int LoopLimit_);
    void SetTrackingOnStateChange(bool Reset_=false);

  public:
    void ResetPollResults(bool& PollingServer_,
                          bool& PollError_,
                          bool& PollAnswered_);
    void GivePollResults(bool& PollingServer_,
                         bool& PollError_,
                         bool& PollAnswered_);
    void ShowPollResults(bool PollingServer_,
                         bool PollError_,
                         bool PollAnswered_);

    void ReadAllStates(int Sleep_);
    int ReadServerState(int Sleep_);
    int ReadClientState();

    bool WaitingForServerResponse(bool* FromClt_=NULL) const;
    bool PollServerIfAlive(int Sleep_=0,
                           bool UntilEnd_=false, bool ResponseOnly_=true);
    bool ReceiveKeepAlivePoll(int Sleep_=0, bool UntilEnd_=false);

    bool ResetServerPolling(bool ForceReset_=false);
    bool ResetReceivePoll(bool ForceReset_=false);
    bool ForceResetAllPolling();

    void ResetRetryRead();
    void ResetPollCount();

  public:
    ServerPollingMgr(CalculatorBase* Parent_, bool CreateBackup_=true);
    ~ServerPollingMgr();

    static bool IsServerAliveStates(int State_);
    static bool IsClientAliveStates(int State_);

    ServerPollingMgr& operator = (const ServerPollingMgr& Obj_);

    ServerPollingMgr* SetAllowServerPolling(bool flag_);
    ServerPollingMgr* SetSleepWaiting(bool flag_);
    ServerPollingMgr* SetResetStatesOnDone(bool flag_);
    ServerPollingMgr* SetBreakOnPollError(bool flag_);
    ServerPollingMgr* SetExitAtRetryMax(bool flag_);
    ServerPollingMgr* SetWaitUntilResponse(bool flag_);
    ServerPollingMgr* SetStopTracking(bool flag_);
    ServerPollingMgr* SetPausePollResults(bool flag_);
    ServerPollingMgr* ResetWhenNotRequired(bool Forced_);
    
    bool PollServerRequired(int Sleep_=0, bool ResponseOnly_=true);
    bool PollServerNotRequired(bool InclAtInitial_) const;
    bool PollServerInProcess() const;
    bool PollServerCompleted(bool InclNotReq_) const;

    bool ClientReceiveRequired(int Sleep_=0);
    bool ClientReceiveNotRequired(bool InclAtInitial_) const;
    bool ClientReceiveInProcess() const;
    bool ClientReceiveCompleted(bool InclNotReq_) const;

    bool ServerPollingAllowed() const;
    bool ConfirmedServerAlive() const;
    bool ConfirmedClientAlive() const;
    bool ServerAliveConfirmedSent() const;
    bool ExitAtRetryMax() const;
    bool SleepWaiting() const;
    bool WaitUntilResponse() const;
    bool StopTracking() const;
    bool PausePollResults() const;

    bool AtMaxReadAttempts() const;
    bool ReAttemptFileRead();

    bool AtMaxPollAttempts() const;
    bool ReAttemptPolling();

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif    
};

/****************************************************************************/
#endif

