/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/
void CmdHistoryDialog::init()
{
// in cmdhistorydialog.h
// #include <qvariant.h>
// #include <qdialog.h>
// #include <qfile.h>
// #include <qtextstream.h>
// #include <qstring.h>
// #include <qtable.h>
// #include <qmessagebox.h>
// #include <qtimer.h>

    int x;
    MAXHISTORY = 50;
    CMDHISTORYFILE = new char[128];
    strcpy(CMDHISTORYFILE, "mcalc_cmdhistory.dat");

    _CmdHistoryList = new char*[MAXHISTORY+1];
    _CmdHistoryEntry = NULL;
    _CmdHistoryIndex = -1;
    _CmdHistoryLength = 0;

    _RetCode = QDialog::Accepted + QDialog::Rejected + 1;
    _SetClearHistory = false;
    _CurRow = -1;
    _CurCol = -1;

    for (x = 0; x <= MAXHISTORY; x++)
      _CmdHistoryList[x] = NULL;

    CmdSelectedEdit->setReadOnly(true);
    CmdSelectedEdit->clear();
    CmdHistoryTable->setColumnReadOnly(0, TRUE);
    CmdHistoryTable->setColumnWidth(0, 432);
    CmdHistoryTable->setColumnWidth(1, 65);
    _ChkTimer = new QTimer(this);

    connect( _ChkTimer, SIGNAL( timeout() ),
                 this, SLOT( CheckCurPt() ) );
    connect( CmdHistoryTable, SIGNAL( currentChanged(int,int) ),
                 this, SLOT( CurrentChanged(int,int) ) );

    connect( buttonOk, SIGNAL( clicked() ), this, SLOT( accept() ) );
    connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );
    connect( buttonClearHistory, SIGNAL( clicked() ), this, SLOT( SetClearHistory() ) );
    connect( buttonHelp, SIGNAL( clicked() ), this, SLOT( ShowHelp() ) );
}

/*****************************************************************************/
void CmdHistoryDialog::destroy()
{
  int x;

  _ChkTimer->stop();
  delete[] CMDHISTORYFILE;
  CMDHISTORYFILE = NULL;

  for (x = 0; x < MAXHISTORY; x++)
    delete[] _CmdHistoryList[x];

  delete[] _CmdHistoryList;
}

/*****************************************************************************/
void CmdHistoryDialog::ReadFromDataFile(const QString& Filename_)
{
  QString Fname_;
  QString ValidStr_;
  QString ExprStr_;
  QString SzStr_;

  int valid_ = 0;
  int index_ = 0;
  int start_ = 0;
  int sz = 0;
  int x = 0;
  int y = 0;

  char* temp_;
  bool ArgNameSelected_ = Filename_.length() > 0;
  bool FileExists_ = false;

  if (ArgNameSelected_)
    strcpy(CMDHISTORYFILE, Filename_.ascii());
  else
    strcpy(CMDHISTORYFILE, "mcalc_cmdhistory.dat");

  Fname_ = QString(CMDHISTORYFILE);
  _CmdFileFinished = false;

  if (QFile::exists(Fname_))
  {
    _QFin.setName(Fname_);
    FileExists_ = true;
  }
  else if (ArgNameSelected_)
  {
    Fname_ = "mcalc_cmdhistory.dat";

    if (QFile::exists(Fname_))
    {
      _QFin.setName(Fname_);
      FileExists_ = true;
    }
  }

  if (!FileExists_ || !_QFin.open(IO_ReadOnly))
    return;

  // Reset object data to original starting state values
  _CmdHistoryIndex = -1;
  _CmdHistoryLength = 0;
  _CmdHistoryEntry = NULL;
  _RetCode = QDialog::Accepted + QDialog::Rejected + 1;
  _SetClearHistory = false;
  _CurRow = -1;
  _CurCol = -1;
  CmdSelectedEdit->clear();
  CmdHistoryTable->setCurrentCell(0, 0);

  // Remove old command history entries from list
  sz = CmdHistoryTable->numRows();
  for (y = 0; y < sz; y++)
  {
    SetTableText(y, 0, QString(""));
    SetTableText(y, 1, QString(""));
  }

  sz = 0;
  _InputOpened = true;
  _QStrm.setDevice(&_QFin);
  _QStrm.setEncoding(QTextStream::UnicodeUTF8);

  while ( !_QStrm.atEnd() )
  {
    _FileLineRead = _QStrm.readLine();
    index_ = _FileLineRead.find(QString("<EndOfFile NumEntries="));

    if (index_ >= 0)
    {
      _CmdFileFinished = true;
      break;
    }
  }

  if (!_CmdFileFinished)
  {
    _QStrm.unsetDevice();
    _QFin.close();
    _InputOpened = false;
    return;
  }
  else
    _QStrm.device()->reset();

  x = 0;
  while ( !_QStrm.atEnd() )
  {
    _FileLineRead = _QStrm.readLine();
    index_ = _FileLineRead.find(QString("VALID"));

    if (index_ > 0)
    {
      index_ += 9;
      ValidStr_ = _FileLineRead.mid(index_);
      valid_ = ValidStr_.toInt();
      valid_ = valid_ == 8;

      if (valid_)
      {
        _FileLineRead = _QStrm.readLine();
        index_ = _FileLineRead.find(QString("LENGTH"));
      }

      if (valid_ && index_ > 0)
      {
        index_ += 10;
        SzStr_ = _FileLineRead.mid(index_);

        _FileLineRead = _QStrm.readLine();
        index_ = _FileLineRead.find('=');

        if (index_ > 0)
        {
          index_ += 2;
          ExprStr_ = _FileLineRead.mid(index_);
          ExprStr_ = ExprStr_.stripWhiteSpace();
          sz = SzStr_.toInt();

          delete[] _CmdHistoryList[x];
          _CmdHistoryList[x] = new char[sz + 1];
          strcpy(_CmdHistoryList[x++], ExprStr_.ascii());
        }
      }
    }
  }

  if (x > MAXHISTORY)
    x = MAXHISTORY;

  _CmdHistoryLength = x;
  delete[] _CmdHistoryList[x];
  _CmdHistoryList[x--] = NULL;

  if (x > start_)
    for (start_ = 0; start_ < x; start_++)
    {
      temp_ = _CmdHistoryList[start_];
      _CmdHistoryList[start_] = _CmdHistoryList[x];
      _CmdHistoryList[x--] = temp_;
    }

  _QStrm.unsetDevice();
  _QFin.close();
  _InputOpened = false;

  for (y = 0; y < MAXHISTORY; y++)
    if (y < _CmdHistoryLength && _CmdHistoryList[y])
      SetTableText(y, 0, QString(""));
}

/*****************************************************************************/
void CmdHistoryDialog::LoadToTable(const QString& Filename_)
{
  int x, y;
  ReadFromDataFile(Filename_);

  if (!_CmdFileFinished)
  {
      _ChkTimer->stop();
      _RetCode = QDialog::Rejected;
      QDialog::done(QDialog::Rejected);
      return;
  }

  for (y = 0; y < MAXHISTORY; y++)
    if (y < _CmdHistoryLength && _CmdHistoryList[y])
    {
      x = 0;
      CmdHistoryTable->clearCell(y, x);
      CmdHistoryTable->setText(y, x, QString(_CmdHistoryList[y]));

      x = 1;
      SetTableEntry(y, x, false);
    }
    else
    {
      x = 0;
      CmdHistoryTable->clearCell(y, x);
      CmdHistoryTable->setText(y, x, QString(""));

      x = 1;
      CmdHistoryTable->clearCell(y, x);
      CmdHistoryTable->setText(y, x, QString(""));
    }

  if (_CmdFileFinished)
    _ChkTimer->start(5);
}

/*****************************************************************************/
void CmdHistoryDialog::CheckCurPt()
{
  if (_CurRow < 0 || _CurCol < 0)
    return;

  int row = _CurRow;
  int col = 1;

  QCheckTableItem* CellCheckItem;
  QTableItem* CellItem;

  if (row < _CmdHistoryLength && _CmdHistoryList[row])
  {
    CellItem = CmdHistoryTable->item(row, col);

    if (CellItem && CellItem->rtti() == 2)
    {
      CellCheckItem = (QCheckTableItem*)CellItem;

      if (CellCheckItem && !CellCheckItem->isChecked())
        SetTableEntry(row, col, true);
    }
  }
}

/*****************************************************************************/
void CmdHistoryDialog::SetClearHistory()
{
  int x, y;

  _ChkTimer->stop();
  _SetClearHistory = true;
  
  for (y = 0; y < MAXHISTORY; y++)
  {
      x = 0;
      CmdHistoryTable->clearCell(y, x);
      CmdHistoryTable->setText(y, x, QString(""));

      x = 1;
      CmdHistoryTable->clearCell(y, x);
      CmdHistoryTable->setText(y, x, QString(""));
  }
}

/*****************************************************************************/
void CmdHistoryDialog::ResetClearHistory()
{
    _SetClearHistory = true;
}

/*****************************************************************************/
void CmdHistoryDialog::SetEntry( int row, int col)
{
    // SIGNAL: clicked(int,int,int,const QPoint&)
    QString text_;
    CmdHistoryTable->setFocus();

    if (col == 1 && row < _CmdHistoryLength && _CmdHistoryList[row])
    {
        SetTableEntry(row, col, true);

        col = 0;
        text_ = CmdHistoryTable->text(row, col);

        if (strcmp(text_.ascii(), _CmdHistoryList[row]) == 0)
        {
          _CmdHistoryEntry = _CmdHistoryList[row];
          _CmdHistoryIndex = row;
          CmdSelectedEdit->setText(text_);
        }
    }
}

/*****************************************************************************/
void CmdHistoryDialog::SetTableText(int row, int col, const QString& Str_)
{
  if (col == 0 || col == 1)
  {
    CmdHistoryTable->clearCell(row, col);
    CmdHistoryTable->setText(row, col, Str_);
  }
}

/*****************************************************************************/
void CmdHistoryDialog::SetTableEntry(int row, int col, bool val)
{
  QCheckTableItem* CellCheckItem;
  QTableItem* CellItem;

  if (col == 1)
  {
    CellItem = CmdHistoryTable->item(row, col);

    if (CellItem && CellItem->rtti() == 2)
    {
      CellCheckItem = (QCheckTableItem*)CellItem;
      CellCheckItem->setText(QString(tr("Select")));
      CellCheckItem->setChecked(val);
    }
    else
    {
      CellCheckItem = new QCheckTableItem(CmdHistoryTable, QString(tr("Select")));
      CellCheckItem->setChecked(val);
      CmdHistoryTable->setItem(row, col, CellCheckItem);
    }
  }
}

/*****************************************************************************/
void CmdHistoryDialog::CurrentChanged( int row, int col )
{
  // SIGNAL: currentChanged(int,int)
  int x;
  int y;
  CmdHistoryTable->setFocus();

  if (col == 1 && row < _CmdHistoryLength && _CmdHistoryList[row])
  {
    _CurRow = row;
    _CurCol = col;
    x = col;

    SetEntry(row, col);

    for (y = 0; y < _CmdHistoryLength && _CmdHistoryList[y]; y++)
      if (y != _CurRow)
        SetTableEntry(y, x, false);
  }
}

/*****************************************************************************/
void CmdHistoryDialog::ShowHelp()
{
  QMessageBox::information(0, QString(tr("Command History Help")),
      QString(tr("Displays the 50 most recent previously entered calculator commands or math statements.\n"
                 "Select the statement you want to execute or modify using the checkboxes beside each statement.\n\n")),
      QString(tr("Close")));
}

/*****************************************************************************/
bool CmdHistoryDialog::CmdFileFinished() const
{
    return _CmdFileFinished;
}

/*****************************************************************************/
const char* CmdHistoryDialog::GiveCmdHistoryEntry() const
{
    return _CmdHistoryEntry;
}

/*****************************************************************************/
int CmdHistoryDialog::GiveCmdHistoryIndex() const
{
    return _CmdHistoryIndex;
}

/*****************************************************************************/
bool CmdHistoryDialog::IsClearHistorySet() const
{
    return _SetClearHistory;
}

/*****************************************************************************/
int CmdHistoryDialog::GiveRetCode() const
{
    return _RetCode;
}

/*****************************************************************************/
void CmdHistoryDialog::accept()
{
  if (!_CmdFileFinished)
  {
    _ChkTimer->stop();
    _RetCode = QDialog::Rejected;
    QDialog::done(QDialog::Rejected);
    return;
  }

  int col = 1;
  int row = _CmdHistoryIndex;
  bool Accepted_ = false;

  QCheckTableItem* CellCheckItem;
  QTableItem* CellItem;

  if (_SetClearHistory)
  {
      _ChkTimer->stop();
      _CurRow = -1;
      _CurCol = -1;
      Accepted_ = true;
  }
  else if (_CmdHistoryEntry && strlen(_CmdHistoryEntry) &&
             _CmdHistoryIndex >= 0 && _CmdHistoryIndex < _CmdHistoryLength)
  {
    CellItem = CmdHistoryTable->item(row, col);

    if (CellItem && CellItem->rtti() == 2)
    {
      CellCheckItem = (QCheckTableItem*)CellItem;

      if (CellCheckItem->isChecked())
        Accepted_ = true;
    }
  }

  if (Accepted_)
  {
    _ChkTimer->stop();
    // emit Confirmed(QString(_CmdHistoryEntry));

    _RetCode = QDialog::Accepted;
    QDialog::done(QDialog::Accepted);
  }
  else if (_RetCode != QDialog::Accepted)
    CmdHistoryDialog::reject();
}

/*****************************************************************************/
void CmdHistoryDialog::reject()
{
  if (_SetClearHistory)
  {
      _CurRow = -1;
      _CurCol = -1;
      _SetClearHistory = false;
  }

  _ChkTimer->stop();
  _RetCode = QDialog::Rejected;
  QDialog::done(QDialog::Rejected);
}

/*****************************************************************************/
