/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/
void ExecPrgDialog::init()
{
// in cmdhistorydialog.h
// #include <qvariant.h>
// #include <qdialog.h>
// #include <qfile.h>
// #include <qtextstream.h>
// #include <qstring.h>
// #include <qtable.h>
// #include <qmessagebox.h>
// #include <qtimer.h>
// #include <qdir.h>

   AMPERSAND_CHS =           '&';
   AMPERSAND_SCHS =          strcpy(new char[strlen("&amp;")+1], "&amp;");
   AMPERSAND_NCHS =          strcpy(new char[strlen("&#38;")+1], "&#38;");
   SEMICOLON_CHS =           ';';
   SEMICOLON_SCHS =          strcpy(new char[strlen("&sc;")+1], "&sc;");
   SEMICOLON_NCHS =          strcpy(new char[strlen("&#59;")+1], "&#59;");
   NUMBERSIGN_CHS =          '#';
   NUMBERSIGN_SCHS =         strcpy(new char[strlen("&hash;")+1], "&hash;");
   NUMBERSIGN_NCHS =         strcpy(new char[strlen("&#35;")+1], "&#35;");
   COLON_CHS =               ':';
   COLON_SCHS =              strcpy(new char[strlen("&col;")+1], "&col;");
   COLON_NCHS =              strcpy(new char[strlen("&#58;")+1], "&#58;");
   EQUAL_CHS =               '=';
   EQUAL_SCHS =              strcpy(new char[strlen("&eq;")+1], "&eq;");
   EQUAL_NCHS =              strcpy(new char[strlen("&#61;")+1], "&#61;");

    int x;
    SPECCHARS_STARTCHAR = '&';
    SPECCHARS_TERMCHAR = ';';
    MAXCALCSCRIPTS = 100;
    CALCSCRIPTFILE = new char[128];
    ::memset(CALCSCRIPTFILE, 0, 128 * sizeof(char));
    PRGLISTFILE = new char[128];
    ::strcpy(PRGLISTFILE, "prglist.dat");

    _CalcScriptList = new char*[MAXCALCSCRIPTS+1];
    _ScriptDescList = new char*[MAXCALCSCRIPTS+1];
    _CalcScriptEntry = NULL;    
    _HasExecScriptOption = false;
    _ExecScriptOptionsConfirmed = false;
    _ExecScriptOption = "";
    _CalcScriptIndex = -1;
    _CalcScriptLength = 0;

    _RetCode = QDialog::Accepted + QDialog::Rejected + 1;
    _CurRow = -1;
    _CurCol = -1;
    
    _DirPath1valid =
    _DirPath2valid =
    _DirPath3valid = false;
    _CustomPathValid = false;
    _FileNotFound = false;
    _PrgListFileRead = false;
    _CustomPrgName = false;
    
  #if ((defined(__linux__) | defined(__unix__)) & defined(Q_OS_LINUX))
    _DirPath1 = QDir::homeDirPath();
    _DirPath2 = _DirPath1 + QString("qmcalc-2");
    _DirPath3 = QString("/usr/local/bin/qmcalc-2");
  #else
    _DirPath1 = QDir::homeDirPath();
    _DirPath2 = _DirPath1 + QString("Qmcalc");
    _DirPath3 = QString("c:\\Program Files\\Cybernadian\\Qmcalc");
  #endif

    for (x = 0; x <= MAXCALCSCRIPTS; x++)
    {
      _CalcScriptList[x] = NULL;
      _ScriptDescList[x] = NULL;
    }

    ScriptNameLineEdit->setReadOnly(TRUE);
    ExecPrgTable->setColumnReadOnly(0, TRUE);
    ExecPrgTable->setColumnReadOnly(1, TRUE);
    ExecPrgTable->setColumnWidth(0, 120);
    ExecPrgTable->setColumnWidth(1, 698);
    ExecPrgTable->setColumnWidth(2, 65);
    _ChkTimer = new QTimer(this);

    connect( _ChkTimer, SIGNAL( timeout() ),
                 this, SLOT( CheckCurPt() ) );
    connect( ExecPrgTable, SIGNAL( currentChanged(int,int) ),
                 this, SLOT( CurrentChanged(int,int) ) );

    connect( buttonOk, SIGNAL( clicked() ), this, SLOT( accept() ) );
    connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );
    connect( buttonHelp, SIGNAL( clicked() ), this, SLOT( ShowHelp() ) );
}

/*****************************************************************************/
void ExecPrgDialog::destroy()
{
  int x;

  _ChkTimer->stop();
  delete[] CALCSCRIPTFILE;
  CALCSCRIPTFILE = NULL;

  for (x = 0; x < MAXCALCSCRIPTS; x++)
  {
    delete[] _CalcScriptList[x];
    delete[] _ScriptDescList[x];
  }

  delete[] _CalcScriptList;
  delete[] _ScriptDescList;
  _CalcScriptList = NULL;
  _ScriptDescList = NULL;
  
  delete[] AMPERSAND_SCHS;
  delete[] AMPERSAND_NCHS;
  delete[] SEMICOLON_SCHS;
  delete[] SEMICOLON_NCHS;
  delete[] NUMBERSIGN_SCHS;
  delete[] NUMBERSIGN_NCHS;
  delete[] COLON_SCHS;
  delete[] COLON_NCHS;
  delete[] EQUAL_SCHS;
  delete[] EQUAL_NCHS;

  AMPERSAND_SCHS = NULL;
  AMPERSAND_NCHS = NULL;
  SEMICOLON_SCHS = NULL;
  SEMICOLON_NCHS = NULL;
  NUMBERSIGN_SCHS = NULL;
  NUMBERSIGN_NCHS = NULL;
  COLON_SCHS = NULL;
  COLON_NCHS = NULL;
  EQUAL_SCHS = NULL;
  EQUAL_NCHS = NULL;
}

/*****************************************************************************/
int ExecPrgDialog::StrniCompare(const char* s1, const char* s2, size_t max)
{
  size_t index;
  int diff;

  if (!s1 || !s2)
    return (s1 ? 1:
	    s2 ? -1:0);

  for (index = 0, diff = 0;
       index < max &&
       !(diff = tolower(s1[index]) - tolower(s2[index])) &&
       s1[index] && s2[index];
       index++);

  return diff;
}

/*****************************************************************************/
char* ExecPrgDialog::ConvertSpecChrs(char* str)
{
  if (!str)
    return str;
  
  int x;
  int max = strlen(str);
  int spos = 0;
  int epos = 0;
  int len = 0;
  int slen = 0;
  int numsel = 0;
  int match = 0;
  bool scstart = false;
  bool scend = false;
  bool chspec = false;
  bool sform = false;
  bool nform = false;

  for (x = 0; x < max && str[x]; x++)
  {
    if (!scend && !scstart)
    {
      scstart = str[x] == SPECCHARS_STARTCHAR;
      
      if (scstart)
      {
        spos = x;
        continue;
      }
    }
    
    if (!scend && scstart)
    {
      scend = chspec && str[x] == SPECCHARS_TERMCHAR;
      
      if (scend)
      {
        epos = x;

        if (str[x+1])
          continue;
        else if (scstart)
          ++x;
      }
      else if (!chspec)
      {
        if (str[x] != '#' && !isalpha(str[x]))
          scstart = false;
        else
        {
          if (!nform)
          {
            sform = isalpha(str[x]);
            if (sform)
              chspec = true;
          }

          if (!sform)
          {
            nform = str[x] == '#' && isdigit(str[x+1]);
            if (nform)
              chspec = true;
          }
        }
      }
      else
      {
        if (nform && !isdigit(str[x]))
        {
          nform = false;
          scstart = false;
          chspec = false;  
        }
        else if (sform && !isalpha(str[x]))
        {
          sform = false;
          scstart = false;
          chspec = false;  
        }
      }
    }

    if (scstart && scend)
    {
      scstart = false;
      scend = false;
      chspec = false;
      sform = false;
      nform = false;

      slen = (epos + 1) - spos;
      epos = spos = 0;
      numsel = 0;
      match = FALSE;

      len = strlen(AMPERSAND_SCHS);
      if (!match && x >= len && slen == len && StrniCompare(str+x-len, AMPERSAND_SCHS, len) == 0)
      {
        match = TRUE;
        numsel = 1;
        slen = len;
      }
      
      len = strlen(AMPERSAND_NCHS);
      if (!match && x >= len && slen == len && StrniCompare(str+x-len, AMPERSAND_NCHS, len) == 0)
      {
        match = TRUE;
        numsel = 2;
        slen = len;
      }

      len = strlen(SEMICOLON_SCHS);
      if (!match && x >= len && slen == len && StrniCompare(str+x-len, SEMICOLON_SCHS, len) == 0)
      {
        match = TRUE;
        numsel = 3;
        slen = len;
      }
      
      len = strlen(SEMICOLON_NCHS);
      if (!match && x >= len && slen == len && StrniCompare(str+x-len, SEMICOLON_NCHS, len) == 0)
      {
        match = TRUE;
        numsel = 4;
        slen = len;
      }
      
      len = strlen(NUMBERSIGN_SCHS);
      if (!match && x >= len && slen == len && StrniCompare(str+x-len, NUMBERSIGN_SCHS, len) == 0)
      {
        match = TRUE;
        numsel = 5;
        slen = len;
      }
      
      len = strlen(NUMBERSIGN_NCHS);
      if (!match && x >= len && slen == len && StrniCompare(str+x-len, NUMBERSIGN_NCHS, len) == 0)
      {
        match = TRUE;
        numsel = 6;
        slen = len;
      }
      
      len = strlen(COLON_SCHS);
      if (!match && x >= len && slen == len && StrniCompare(str+x-len, COLON_SCHS, len) == 0)
      {
        match = TRUE;
        numsel = 7;
        slen = len;
      }
      
      len = strlen(COLON_NCHS);
      if (!match && x >= len && slen == len && StrniCompare(str+x-len, COLON_NCHS, len) == 0)
      {
        match = TRUE;
        numsel = 8;
        slen = len;
      }
      
      len = strlen(EQUAL_SCHS);
      if (!match && x >= len && slen == len && StrniCompare(str+x-len, EQUAL_SCHS, len) == 0)
      {
        match = TRUE;
        numsel = 9;
        slen = len;
      }
      
      len = strlen(EQUAL_NCHS);
      if (!match && x >= len && slen == len && StrniCompare(str+x-len, EQUAL_NCHS, len) == 0)
      {
        match = TRUE;
        numsel = 10;
        slen = len;
      }
      
      if (match && slen)
      {
        len = str[x-slen];
        str[x-slen] = (numsel == 1 || numsel == 2) ? AMPERSAND_CHS:
                      (numsel == 3 || numsel == 4) ? SEMICOLON_CHS:
                      (numsel == 5 || numsel == 6) ? NUMBERSIGN_CHS:
                      (numsel == 7 || numsel == 8) ? COLON_CHS:
                      (numsel == 9 || numsel == 10) ? EQUAL_CHS:len;

        len = strlen(str+x);
        ::memmove(str+x-slen+1, str+x, len+1);
        x -= slen;
      }
    }
  }
  
  return str;
}

/*****************************************************************************/
void ExecPrgDialog::ReadFromDirectory(const QString& DirPath_)
{ 
    int y;
    int x;
    int sz;
    int len;
    int dot;
    int findex;
    int dindex;
    
    bool DirPathValid_ = false;
    bool FileExists_ = false;
    bool NameRead_ = false;
    bool DescRead_ = false;
    bool PrgExists1_ = false;
    bool PrgExists2_ = false;
    
    QString Fname_;
    QString FileExt_;
    QString PrgName_;
    QString PrgDesc_;
    QString FullPrgName_;
    QString UsedDirPath_;
    QString PrgListFile1_ = PRGLISTFILE;    
    QString PrgListFile2_;
    
    _DirPath1valid =
    _DirPath2valid =
    _DirPath3valid = false;
    _FileNotFound = false;
    _PrgListFileRead = false;

    _QDirin.setFilter(QDir::Files);
    _QDirin.setNameFilter("*.prg;*.in");
    _QDirin.setSorting(QDir::Name);

    if (DirPath_.length())
    {
      _QDirin.setPath(DirPath_);
      DirPathValid_ = _QDirin.count() > 0;
    }
    
    if (!DirPathValid_ || !DirPath_.length())
    {
      _CustomPath = "";
      _CustomPathValid = false;

      _QDirin.setPath(_DirPath1);
      _DirPath1valid = _QDirin.count() > 0;
    
      if (!_DirPath1valid)
      {
        _QDirin.setPath(_DirPath2);
        _DirPath2valid = _QDirin.count() > 0;
      
        if (!_DirPath2valid)
        {
          _QDirin.setPath(_DirPath3);
          _DirPath3valid = _QDirin.count() > 0;
	
          if (!_DirPath3valid)
            _FileNotFound = true;
        }
      }
    }
    else
    {
      _CustomPath = DirPath_;
      _CustomPathValid = true;
    }

    #if ((defined(__linux__) | defined(__unix__)) & defined(Q_OS_LINUX))
      PrgListFile2_ = _DirPath1valid ? _DirPath1 + QString("/") + QString(PRGLISTFILE):
                      _DirPath2valid ? _DirPath2 + QString("/") + QString(PRGLISTFILE):
                      _CustomPathValid ? _CustomPath + QString("/") + QString(PRGLISTFILE):
                                         _DirPath3 + QString("/") + QString(PRGLISTFILE);
    #else
      PrgListFile2_ = _DirPath1valid ? _DirPath1 + QString("\\") + QString(PRGLISTFILE):
                      _DirPath2valid ? _DirPath2 + QString("\\") + QString(PRGLISTFILE):
                      _CustomPathValid ? _CustomPath + QString("\\") + QString(PRGLISTFILE):
                                         _DirPath3 + QString("\\") + QString(PRGLISTFILE);
    #endif

    PrgExists1_ = QFile::exists(PrgListFile1_);
    PrgExists2_ = QFile::exists(PrgListFile2_);

    if (!_FileNotFound)
    {
      // Reset object data to original starting state values
      _CalcScriptIndex = -1;
      _CalcScriptLength = 0;
      _CalcScriptEntry = NULL;
      _PrgListFileRead = false;
      _HasExecScriptOption = false;
      _ExecScriptOptionsConfirmed = false;
      _ExecScriptOption = "";
      _RetCode = QDialog::Accepted + QDialog::Rejected + 1;
      _CurRow = -1;
      _CurCol = -1;
      ExecPrgTable->setCurrentCell(0, 0);

      // Remove old command history entries from list
      sz = ExecPrgTable->numRows();
      for (y = 0; y < sz; y++)
      {
        SetTableText(y, 0, QString(""));
        SetTableText(y, 1, QString(""));
        SetTableText(y, 2, QString(""));
      }
      
      QStringList Flist_(_QDirin.entryList());
      QStringList::Iterator it;
      x = 0;
      
      UsedDirPath_ = _DirPath1valid ? _DirPath1:
                     _DirPath2valid ? _DirPath2:
                     _DirPath3valid ? _DirPath3:
                     _CustomPathValid ? _CustomPath:"";
      
      for ( it = Flist_.begin(); it != Flist_.end() && x < MAXCALCSCRIPTS; ++it)
        if (PutPrgFileEntry(*it, QString("prg"), UsedDirPath_))
          ++x;

      for ( it = Flist_.begin(); it != Flist_.end() && x < MAXCALCSCRIPTS; ++it)
        if (PutPrgFileEntry(*it, QString("in"), UsedDirPath_))
          ++x;

      _CalcScriptIndex = -1;
      
      for (y = 0; y < MAXCALCSCRIPTS; y++)
        if (y < _CalcScriptLength && _CalcScriptList[y])
        {
          SetTableText(y, 0, QString(""));
          SetTableText(y, 1, QString(""));
        }
    }
    else if (PrgExists1_ || PrgExists2_)
    {
      _FileNotFound = true;
      ExecPrgTable->setCurrentCell(0, 0);
      Fname_ = PrgExists1_ ? PrgListFile1_:PrgListFile2_;

      if (Fname_.length() > 0 && QFile::exists(Fname_))
      {
        _QFin.setName(Fname_);
        FileExists_ = true;
      }
  
      if (!FileExists_ || !_QFin.open(IO_ReadOnly))
        return;
  
      // Reset object data to original starting state values
      _CalcScriptIndex = -1;
      _CalcScriptLength = 0;
      _CalcScriptEntry = NULL;
      _PrgListFileRead = false;
      _HasExecScriptOption = false;
      _ExecScriptOptionsConfirmed = false;
      _ExecScriptOption = "";
      _RetCode = QDialog::Accepted + QDialog::Rejected + 1;
      _CurRow = -1;
      _CurCol = -1;
      dot = sz = x = 0;
      
      _InputOpened = true;
      _QStrm.setDevice(&_QFin);
      _QStrm.setEncoding(QTextStream::UnicodeUTF8);
     
      while (!_QStrm.atEnd())
      {
        _ScriptFileFinished = false;
        NameRead_ = false;
        DescRead_ = false;
        findex = dindex = 0;

        while ( (!NameRead_ || !DescRead_) && !_QStrm.atEnd() )
        {
          _FileLineRead = _QStrm.readLine();
          _FileLineRead = _FileLineRead.stripWhiteSpace();
    
          if (_FileLineRead.at(0) != QChar('#'))
            break;

          if (!NameRead_ && !DescRead_)
          {
            findex = _FileLineRead.find(QString("# name="));

            if (findex >= 0)
            {
              findex += ::strlen("# name=");
              Fname_ = _FileLineRead.mid(findex);
              Fname_ = Fname_.stripWhiteSpace();
    
              findex = Fname_.find(QChar(':'));
              NameRead_ = findex > 0;
      
              if (NameRead_)
                Fname_ = Fname_.left(findex);      
            }
          }

          if (NameRead_ && !DescRead_)
          {
            dindex = _FileLineRead.find(QString("# description="));

            if (dindex >= 0)
            {
              dindex += ::strlen("# description=");
              PrgDesc_ = _FileLineRead.mid(dindex);
              PrgDesc_ = PrgDesc_.stripWhiteSpace();
    
              dindex = PrgDesc_.find(QChar(':'));
              DescRead_ = dindex > 0;
      
              if (DescRead_)
              {
                PrgDesc_ = PrgDesc_.left(dindex);      
                _ScriptFileFinished = true;
              }
            }
          }
        }

        if (NameRead_ && DescRead_)
        {
          if (!_PrgListFileRead)
            _PrgListFileRead = true;
  
          if (_ScriptFileFinished && findex > 0)
          {
            PrgName_ = Fname_;
            FullPrgName_ = PrgName_.stripWhiteSpace();
            len = FullPrgName_.length();
            dot = Fname_.findRev('.');
            FileExt_ = (0 < dot && dot < len-1) ? Fname_.mid(dot+1):QString("");
            FileExt_ = FileExt_.lower();

            if ((0 < dot && dot < len-1) && (FileExt_ == QString("prg") || FileExt_ == QString("in")))
            {
              PrgName_ = Fname_.left(dot);
              PrgName_ = PrgName_.stripWhiteSpace();
    
              sz = FullPrgName_.length();
              x = ++_CalcScriptIndex;
            }
            else
              sz = 0;
          }
          else
            dot = sz = 0;

          if ((0 < dot && dot < len-1) && sz > 0 && findex > 0)
          {
            if (x >= MAXCALCSCRIPTS)
            {
              _QStrm.unsetDevice();
              _QFin.close();
              _InputOpened = false;
              return;
            }
            else
            {
              sz = FullPrgName_.length();
              delete[] _CalcScriptList[x];
            }
  
            _CalcScriptList[x] = strcpy(new char[sz + 1], FullPrgName_.ascii());
          }
          else
            _CalcScriptList[x] = NULL;
  
          if (_ScriptFileFinished && dindex > 0)
          {
            if (x >= MAXCALCSCRIPTS)
            {
              _QStrm.unsetDevice();
              _QFin.close();
              _InputOpened = false;
              return;
            }
            else
            {
              sz = PrgDesc_.length();
              delete[] _ScriptDescList[x];
            }
  
            if (sz)
            {
              _ScriptDescList[x] = strcpy(new char[sz + 1], PrgDesc_.ascii());
              _ScriptDescList[x] = ConvertSpecChrs(_ScriptDescList[x]);
            }
            else
              _ScriptDescList[x] = NULL;
          }
          else
            _ScriptDescList[x] = NULL;

          x = _CalcScriptIndex + 1;
          _CalcScriptLength = x;
          delete[] _CalcScriptList[x];
          delete[] _ScriptDescList[x];
          _CalcScriptList[x] =
          _ScriptDescList[x] = NULL;
          --x;
        }
      }
      
      _QStrm.unsetDevice();
      _QFin.close();
      _InputOpened = false;
      
      if (_PrgListFileRead)
      {
        _CalcScriptIndex = -1;

        // Remove old command history entries from list
        sz = ExecPrgTable->numRows();
        for (y = 0; y < sz; y++)
        {
          SetTableText(y, 0, QString(""));
          SetTableText(y, 1, QString(""));
          SetTableText(y, 2, QString(""));
        }
      
        for (y = 0; y < MAXCALCSCRIPTS; y++)
          if (y < _CalcScriptLength && _CalcScriptList[y])
          {
            SetTableText(y, 0, QString(""));
            SetTableText(y, 1, QString(""));
          }
      }
    }
}

/*****************************************************************************/
bool ExecPrgDialog::PutPrgFileEntry(const QString& Fnamestr_, const QString& Fext_, const QString& DirPath_)
{
  QString DescStr_;
  QString PrgName_;
  QString FullPrgName_;
  QString FileExt_;
  QString Fname_ = Fnamestr_;
  
  bool FileExists_ = false;
  int dot = 0;
  int len = 0;
  int sz = 0;
  int x = 0;
  int index = 0;

  if (Fname_.length() > 0 && QFile::exists(Fname_))
  {
    _QFin.setName(Fname_);
    FileExists_ = true;
  }
  
  if (!FileExists_ || !_QFin.open(IO_ReadOnly))
  {
    #if ((defined(__linux__) | defined(__unix__)) & defined(Q_OS_LINUX))
      Fname_ = DirPath_ + QString("/") + QString(Fnamestr_);
    #else
      Fname_ = DirPath_ + QString("\\") + QString(Fnamestr_);
    #endif
    
    if (QFile::exists(Fname_))
    {
      _QFin.setName(Fname_);
      FileExists_ = true;
    }
    
    if (!FileExists_ || !_QFin.open(IO_ReadOnly))
      return false;
  }

  // Reset object data to original starting state values
  _ScriptFileFinished = false;
  _InputOpened = true;
  _QStrm.setDevice(&_QFin);
  _QStrm.setEncoding(QTextStream::UnicodeUTF8);
  
  while ( !_QStrm.atEnd() )
  {
    _FileLineRead = _QStrm.readLine();
    _FileLineRead = _FileLineRead.stripWhiteSpace();
    
    if (_FileLineRead.at(0) != QChar('#'))
      break;
    
    index = _FileLineRead.find(QString("# description="));

    if (index >= 0)
    {
      _ScriptFileFinished = true;
      index += ::strlen("# description=");
      break;
    }
  }

  PrgName_ = Fnamestr_;
  FullPrgName_ = PrgName_.stripWhiteSpace();
  len = FullPrgName_.length();
  dot = Fnamestr_.findRev('.');
  FileExt_ = (0 < dot && dot < len-1) ? Fnamestr_.mid(dot+1):QString("");
  FileExt_ = FileExt_.lower();
  
  if ((0 < dot && dot < len-1) && (FileExt_ == QString("prg") || FileExt_ == QString("in")))
  {
    PrgName_ = Fnamestr_.left(dot);
    PrgName_ = PrgName_.stripWhiteSpace();
    
    if (FileExt_ == Fext_)
    {
      sz = FullPrgName_.length();
      x = ++_CalcScriptIndex;
    }
    else
    {
      sz = 0;      
      _QStrm.unsetDevice();
      _QFin.close();
      _InputOpened = false;
      return false;
    }
  }
  else
  {
    sz = 0;
    _QStrm.unsetDevice();
    _QFin.close();
    _InputOpened = false;
    return false;
  }

  if ((0 < dot && dot < len-1) && sz > 0)
  {
    if (x >= MAXCALCSCRIPTS)
    {
      _QStrm.unsetDevice();
      _QFin.close();
      _InputOpened = false;
      return false;
    }
    else
      delete[] _CalcScriptList[x];
  
    _CalcScriptList[x] = strcpy(new char[sz + 1], FullPrgName_.ascii());
  }
  else
    _CalcScriptList[x] = NULL;  
  
  if (_ScriptFileFinished && index > 0)
  {
    DescStr_ = _FileLineRead.mid(index);
    DescStr_ = DescStr_.stripWhiteSpace();
    
    sz = DescStr_.length();
    delete[] _ScriptDescList[x];
    
    index = DescStr_.find(QChar(':'));
    DescStr_[index] = 0;
  
    if (sz)
    {
      _ScriptDescList[x] = strcpy(new char[sz + 1], DescStr_.ascii());
      _ScriptDescList[x] = ConvertSpecChrs(_ScriptDescList[x]);
    }
    else
      _ScriptDescList[x] = NULL;
  }
  else
    _ScriptDescList[x] = NULL;
  
  x = _CalcScriptIndex + 1;
  _CalcScriptLength = x;
  delete[] _CalcScriptList[x];
  delete[] _ScriptDescList[x];
  _CalcScriptList[x] =
  _ScriptDescList[x] = NULL;
  --x;

  _QStrm.unsetDevice();
  _QFin.close();
  _InputOpened = false;
  
  return true;
}

/*****************************************************************************/
void ExecPrgDialog::SetPrgFileLineEdit(const QString& Fname_)
{
  if (Fname_.length() > 0)
  {
    QString ScriptName_ = Fname_;
    QString ScriptExt_;    
    int dot = ScriptName_.findRev('.');
    
    if (dot > 0)
    {
      ScriptExt_ = Fname_.mid(dot+1);
      ScriptExt_ = ScriptExt_.lower();
      
      if (ScriptExt_ == QString("prg"))
	ScriptName_ = Fname_.left(dot);
    }
    
    ScriptNameLineEdit->setText(ScriptName_);
    if (CALCSCRIPTFILE)
      ::strcpy(CALCSCRIPTFILE, ScriptName_.ascii());
  }
  else
  {
    ScriptNameLineEdit->setText(QString(""));
    if (CALCSCRIPTFILE)
      CALCSCRIPTFILE[0] = 0;
  }
}

/*****************************************************************************/
void ExecPrgDialog::LoadToTable(bool IsFnameEntry_, const QString& Fname_,
				bool IsDirEntry_, const QString& DirPath_)
{
   int x, y;
  
   if (IsFnameEntry_)
     SetPrgFileLineEdit(Fname_);
   else if (IsDirEntry_)
   {
     SetPrgFileLineEdit(QString(""));
     ReadFromDirectory(DirPath_);
   }
    
   if (IsDirEntry_ && (!_FileNotFound || _PrgListFileRead))
   {
      SetPrgFileLineEdit(QString(""));
     
      for (y = 0; y < MAXCALCSCRIPTS; y++)
        if (y < _CalcScriptLength && _CalcScriptList[y])
        {
          x = 0;
          ExecPrgTable->clearCell(y, x);
          ExecPrgTable->setText(y, x, QString(_CalcScriptList[y]));

          x = 1;
          ExecPrgTable->clearCell(y, x);
          if (_ScriptDescList[y])
            ExecPrgTable->setText(y, x, QString(_ScriptDescList[y]));
	  else
	    ExecPrgTable->setText(y, x, QString(""));

          x = 2;
          SetTableEntry(y, x, false);
        }
        else
        {
          x = 0;
          ExecPrgTable->clearCell(y, x);
          ExecPrgTable->setText(y, x, QString(""));	  

          x = 1;
          ExecPrgTable->clearCell(y, x);
          ExecPrgTable->setText(y, x, QString(""));

          x = 2;
          ExecPrgTable->clearCell(y, x);
          ExecPrgTable->setText(y, x, QString(""));
        }

      if (_CalcScriptLength > 0)
        _ChkTimer->start(5);
   }
}

/*****************************************************************************/
void ExecPrgDialog::CheckCurPt()
{
  if (_CurRow < 0 || _CurCol < 0)
    return;

  int row = _CurRow;
  int col = 2;

  QCheckTableItem* CellCheckItem;
  QTableItem* CellItem;

  if (row < _CalcScriptLength && _CalcScriptList[row])
  {
    CellItem = ExecPrgTable->item(row, col);

    if (CellItem && CellItem->rtti() == 2)
    {
      CellCheckItem = (QCheckTableItem*)CellItem;

      if (CellCheckItem && !CellCheckItem->isChecked())
        SetTableEntry(row, col, true);
    }
  }
}

/*****************************************************************************/
void ExecPrgDialog::SetEntry(int row, int col)
{
    // SIGNAL: clicked(int,int,int,const QPoint&)
    QString text_;
    ExecPrgTable->setFocus();

    if (col == 2 && row < _CalcScriptLength && _CalcScriptList[row])
    {
        SetTableEntry(row, col, true);

        col = 0;
        text_ = ExecPrgTable->text(row, col);

        if (strcmp(text_.ascii(), _CalcScriptList[row]) == 0)
        {
          _CalcScriptEntry = _CalcScriptList[row];
          _CalcScriptIndex = row;
  
          SetPrgFileLineEdit(QString(_CalcScriptEntry));
          _CustomPrgName = false;  
        }
    }
}

/*****************************************************************************/
void ExecPrgDialog::SetTableText(int row, int col, const QString& Str_)
{
  if (col == 0 || col == 1 || col == 2)
  {
    ExecPrgTable->clearCell(row, col);
    ExecPrgTable->setText(row, col, Str_);
  }
}

/*****************************************************************************/
void ExecPrgDialog::SetTableEntry(int row, int col, bool val)
{
  QCheckTableItem* CellCheckItem;
  QTableItem* CellItem;

  if (col == 2)
  {
    CellItem = ExecPrgTable->item(row, col);

    if (CellItem && CellItem->rtti() == 2)
    {
      CellCheckItem = (QCheckTableItem*)CellItem;
      CellCheckItem->setText(QString(tr("Select")));
      CellCheckItem->setChecked(val);
    }
    else
    {
      CellCheckItem = new QCheckTableItem(ExecPrgTable, QString(tr("Select")));
      CellCheckItem->setChecked(val);
      ExecPrgTable->setItem(row, col, CellCheckItem);
    }
  }
}

/*****************************************************************************/
void ExecPrgDialog::CurrentChanged(int row, int col)
{
  // SIGNAL: currentChanged(int,int)
  int x;
  int y;
  ExecPrgTable->setFocus();

  if (col == 2 && row < _CalcScriptLength && _CalcScriptList[row])
  {
    _CurRow = row;
    _CurCol = col;
    x = col;

    SetEntry(row, col);

    for (y = 0; y < _CalcScriptLength && _CalcScriptList[y]; y++)
      if (y != _CurRow)
        SetTableEntry(y, x, false);
  }
}

/*****************************************************************************/
void ExecPrgDialog::ShowHelp()
{
  QMessageBox::information(0, QString(tr("Calculator Scripts Help")),
      QString(tr("Displays recognizable calculator script files in calculator accessible directories on a table list.\n"
                 "Select the calculator program script you want to execute using the checkboxes beside each script file entry.\n\n")),
      QString(tr("Close")));
}

/*****************************************************************************/
bool ExecPrgDialog::ScriptFileFinished() const
{
    return ((!_FileNotFound || _PrgListFileRead) && _CalcScriptLength > 0);
}

/*****************************************************************************/
const char* ExecPrgDialog::GiveCalcScriptEntry() const
{
    return _CalcScriptEntry;
}

/*****************************************************************************/
int ExecPrgDialog::GiveCalcScriptIndex() const
{
    return (_CustomPrgName ? -1:_CalcScriptIndex);
}

/*****************************************************************************/
int ExecPrgDialog::GiveRetCode() const
{
    return _RetCode;
}

/*****************************************************************************/
bool ExecPrgDialog::IsCustomPrgName() const
{
    return _CustomPrgName;
}

/*****************************************************************************/
bool ExecPrgDialog::IsCalcTestFile() const
{
    return _CalcTestFile;
}

/*****************************************************************************/
bool ExecPrgDialog::IsCalcProgFile() const
{
    return _CalcProgFile;
}

/*****************************************************************************/
bool ExecPrgDialog::HasExecScriptOption() const
{
    return _HasExecScriptOption;
}

/*****************************************************************************/
const char* ExecPrgDialog::OptionString() const
{
    if (_HasExecScriptOption && _ExecScriptOptionsConfirmed && _ExecScriptOption.length())
      return _ExecScriptOption.ascii();
    
    return NULL;
}

/*****************************************************************************/
/*****************************************************************************/
void ExecPrgDialog::MakeOptionString(bool Pause_)
{
    _ExecScriptOption = Pause_ ? "pause":"nopause";
    _ExecScriptOptionsConfirmed = true;
}

/*****************************************************************************/
void ExecPrgDialog::CheckUserEnteredOptions()
{
    int comma = 0;
    bool PauseOpt_ = false;
    bool NoPauseOpt_ = false;

    QString FileName_;
    QString FileOption_;

    if (!_ExecScriptOptionsConfirmed)
    {
      FileName_ = QString(_CalcScriptEntry);
      comma = FileName_.findRev(QChar(','));
    }
    
    if (comma > 0 && !_ExecScriptOptionsConfirmed)
    {
      FileOption_ = FileName_.mid(comma+1);
      FileOption_ = FileOption_.stripWhiteSpace();
      FileOption_ = FileOption_.lower();
    
      PauseOpt_ = FileOption_ == QString("pause");
      NoPauseOpt_ = FileOption_ == QString("nopause");
      _HasExecScriptOption = NoPauseOpt_ || PauseOpt_;
      _CalcScriptEntry[comma] = 0;
      
      if (_HasExecScriptOption)      
        MakeOptionString(PauseOpt_);
      else
        _ExecScriptOptionsConfirmed = true;
    }
}

/*****************************************************************************/
int ExecPrgDialog::PromptExecScriptOptions()
{
  if (!_ExecScriptOptionsConfirmed)
  {
    int BoxRetVal_;
    BoxRetVal_ = QMessageBox::question(this, QString(tr("Pause execution?")),
			    QString(tr("\nPause execution for each input line completed?\n")),
			    QMessageBox::Yes | QMessageBox::Default,
			    QMessageBox::No | QMessageBox::Escape);
      
    if (BoxRetVal_ == QMessageBox::Yes)
        _HasExecScriptOption = false;
    else if (BoxRetVal_ == QMessageBox::No)
        _HasExecScriptOption = true;
  }
  
  return _HasExecScriptOption;
}

/*****************************************************************************/
void ExecPrgDialog::accept()
{
  if (!ScriptFileFinished())
  {
    _ChkTimer->stop();
    _RetCode = QDialog::Rejected;
    QDialog::done(QDialog::Rejected);
    return;
  }

  int col = 2;
  int row = _CalcScriptIndex;
  int dot = 0;
  int comma = 0;
  bool Accepted_ = false;

  QCheckTableItem* CellCheckItem;
  QTableItem* CellItem;
  QString ScriptEditText_;
  QString FileName_;
  QString FileSeg_;
  QString FileExt_;

  if (_CalcScriptEntry && strlen(_CalcScriptEntry) &&
      _CalcScriptIndex >= 0 && _CalcScriptIndex < _CalcScriptLength)
  {
    CellItem = ExecPrgTable->item(row, col);

    if (CellItem && CellItem->rtti() == 2)
    {
      CellCheckItem = (QCheckTableItem*)CellItem;

      if (CellCheckItem->isChecked())
      {
        Accepted_ = true;
        _CustomPrgName = false;
      }
      else 
      {
        ScriptEditText_ = ScriptNameLineEdit->text();

        if (ScriptEditText_.length() > 0 && CALCSCRIPTFILE && ::strlen(CALCSCRIPTFILE) > 0)
        {
          _CalcScriptEntry = CALCSCRIPTFILE;
          _CustomPrgName = true;
          Accepted_ = true;
        }
      }
    }
  }

  if (Accepted_)
  {
    _ChkTimer->stop();
    // emit Confirmed(QString(_CmdHistoryEntry));

    FileName_ = QString(_CalcScriptEntry);
    dot = FileName_.findRev(QChar('.'));
    FileSeg_ = FileName_.mid(dot+1);
    FileSeg_ = FileSeg_.stripWhiteSpace();
    FileSeg_ = FileSeg_.lower();
    FileExt_ = FileSeg_;
    
    _CalcTestFile = FileExt_ == QString("in");
    _CalcProgFile = FileExt_ == QString("prg");
    
    if (_CalcTestFile)
    {
      if (PromptExecScriptOptions())
        MakeOptionString(false);
      else
        _ExecScriptOptionsConfirmed = true;
    }
    else
    {
      comma = FileSeg_.findRev(QChar(','));
    
      if (comma > 0)
        FileExt_ = FileSeg_.left(comma);
      else
        FileExt_ = FileSeg_;
      
      _CalcTestFile = FileExt_ == QString("in");
      _CalcProgFile = FileExt_ == QString("prg");
      
      if (comma > 0 && _CalcTestFile)
        CheckUserEnteredOptions();
      else
        _ExecScriptOptionsConfirmed = true;
    }
    
    _RetCode = QDialog::Accepted;
    QDialog::done(QDialog::Accepted);
  }
  else if (_RetCode != QDialog::Accepted)
    ExecPrgDialog::reject();
}

/*****************************************************************************/
void ExecPrgDialog::reject()
{
  if (!ScriptFileFinished())
  {
    _ChkTimer->stop();
    _RetCode = QDialog::Rejected;
    QDialog::done(QDialog::Rejected);
    return;
  }

  _ChkTimer->stop();
  _RetCode = QDialog::Rejected;
  QDialog::done(QDialog::Rejected);
}

/*****************************************************************************/
