#ifndef EXPRSTRINGSTACK_CPP
#define EXPRSTRINGSTACK_CPP
#ifndef EXPRSTRINGSTACK_H
  #include "exprstringstack.h"
#endif

void*(*ExprStringStack::_AllocFnc)(size_t, size_t) = NULL;
void*(*ExprStringStack::_DelFnc)(size_t, void*) = NULL;

/****************************************************************************/
// ExprStringStack class definitions
/****************************************************************************/
ExprStringStack::ExprStringStack():
_ExprStk(NULL),
_Size(0),
_Index(0),
_OwnsStack(true)
{}

/****************************************************************************/
ExprStringStack::~ExprStringStack()
{
  if (_OwnsStack)
    DestroyStack();
}

/****************************************************************************/
char* ExprStringStack::AllocCpyStr(char* str_)
{
  if (str_)
  {
    char* newstr_ = (char*)ExecAllocFnc(strlen(str_), sizeof(char));
    str_ = newstr_ ? strcpy(newstr_, str_):NULL;
  }

  return str_;
}

/****************************************************************************/
void* ExprStringStack::ExecAllocFnc(size_t len, size_t sz)
{
  if (_AllocFnc)
    return (*_AllocFnc)(len, sz);
  return (new char[len * sz]);
}

/****************************************************************************/
void* ExprStringStack::ExecDelFnc(size_t len, void* ptr)
{
  if (_DelFnc)
    return (*_DelFnc)(len, ptr);
  return ptr;
}

/****************************************************************************/
void ExprStringStack::SetAllocFnc(void*(*AllocFnc_)(size_t, size_t))
{
  _AllocFnc = AllocFnc_;
}

/****************************************************************************/
void ExprStringStack::SetDelFnc(void*(*DelFnc_)(size_t, void*))
{
  _DelFnc = DelFnc_;
}

/****************************************************************************/
bool ExprStringStack::HasAllocFnc()
{
  return (_AllocFnc != NULL);
}
 
/****************************************************************************/
bool ExprStringStack::HasDelFnc()
{
  return (_DelFnc != NULL);
}

/****************************************************************************/
char** ExprStringStack::CreateStack(int Size_)
{
  size_t x;

  char** ExprStrStk_ = GetStkPtr();
  int ExprStkSz_ = GetStkSz();
  int ExprStkIndex_ = GetStkIndex();

  if (!ExprStrStk_)
  {
    ExprStkSz_ = _Size = (Size_ > 0) ? Size_:DEFAULT_INCR;
    ExprStkIndex_ = _Index = 0;
    ExprStrStk_ = (char**)ExecAllocFnc(_Size, sizeof(char*));
    // (char**)MemMatrix::Matrix().Callocate(_Size * sizeof(char*));

    for (x = 0; x < _Size; x++)
      ExprStrStk_[x] = NULL;
  }

  _Size = ExprStkSz_;
  _Index = ExprStkIndex_;
  _ExprStk = ExprStrStk_;
  
  return _ExprStk;
}

/****************************************************************************/
char** ExprStringStack::GrowStack(int Size_)
{
  if (_ExprStk && _Size && _Index)
  {
    char** oldexp_ = _ExprStk;
    int oldsz_ = _Size;
    int x;

    _Size += (Size_ > 0) ? Size_:DEFAULT_INCR;
    _ExprStk = (char**)ExecAllocFnc(_Size, sizeof(char*));
    // (char**)MemMatrix::Matrix().Callocate(_Size * sizeof(char*));

    for (x = 0; x < oldsz_; x++)
      _ExprStk[x] = oldexp_[x];

    for (x = oldsz_; x < _Size; x++)
      _ExprStk[x] = NULL;

    EXPRSTRINGSTACK__EXECDEL(oldsz_, oldexp_);
    //MemMatrix::Matrix().Deallocate(oldexp_);
  }

  return _ExprStk;
}

/****************************************************************************/
char** ExprStringStack::DestroyStack()
{
  if (_ExprStk && _Size)
  {
    int x;
    size_t len;
    
    for (x = 0; x < _Size; x++)
    {
      len = _ExprStk[x] ? strlen(_ExprStk[x]):0;
      EXPRSTRINGSTACK__EXECDEL(len, _ExprStk[x]);
      // MemMatrix::Matrix().Deallocate(_ExprStk[x]);
      _ExprStk[x] = NULL;
    }

    EXPRSTRINGSTACK__EXECDEL(_Size, _ExprStk[x]);
    // MemMatrix::Matrix().Deallocate(_ExprStk);
    _ExprStk = NULL;
    
    _Size =
    _Index = 0;
  }

  return NULL;
}

/****************************************************************************/
bool ExprStringStack::TidyStack(int Index_)
{
  int len = _Index - (Index_+1);

  if (len > 0 && !_ExprStk[Index_])
  {
    ::memmove(&_ExprStk[Index_], &_ExprStk[Index_+1], len * sizeof(char*));
    _ExprStk[--_Index] = NULL;
    return true;
  }

  return false;
}

/****************************************************************************/
bool ExprStringStack::HasAnyExpr() const
{
  int x = _Index;
  
  for (--x; x >= 0; x--)
    if (_ExprStk[x])
      break;

  return (x >= 0);
}

/****************************************************************************/
bool ExprStringStack::HasExprStr(const char* Ptr_, int* Index_)
{
  bool Found_ = false;
  int x = _Index;
  
  for (--x; x >= 0; x--)
    if (_ExprStk[x] == Ptr_)
      break;

  Found_ = x >= 0;
  if (Found_ && Index_)
    *Index_ = x;

  return Found_;
}

/****************************************************************************/
char* ExprStringStack::PopString(int sIndex_)
{
  char* RetStr_ = NULL;

  if (_ExprStk && _Index && _Size && sIndex_ <= _Index-1)
  {
    RetStr_ = _ExprStk[sIndex_];
    _ExprStk[sIndex_] = NULL;

    if (sIndex_ < _Index-1)
      TidyStack(sIndex_);
    else if (_Index)
      _Index--;
  }

  return RetStr_;
}

/****************************************************************************/
char* ExprStringStack::PushString(char* ExprStr_, bool Alloc_)
{
  if (!_ExprStk)
    CreateStack();
  else if (_Index == _Size)
    GrowStack();

  char* NextSub_ = NULL;

  if (_ExprStk && ExprStr_ && _Size)
  {
    NextSub_ = Alloc_ ? AllocCpyStr(ExprStr_):ExprStr_;
  
    if (NextSub_)
    {
      _ExprStk[_Index++] = NextSub_;
      return NextSub_;
    }
  }

  return NULL;
}

/****************************************************************************/
#endif
