#ifndef EXPRSTRINGSTACK_H
#define EXPRSTRINGSTACK_H
#ifndef INCL_NEW_H
  // #include <new.h>
  #include <new>
  #define INCL_NEW_H
#endif
#ifndef INCL_STRING_H
  #include <string.h>
  // #include <string>
  #define INCL_STRING_H
#endif

#define EXPRSTRINGSTACK__EXECDEL(LEN, PTR) \
        if (!_DelFnc) {                    \
          if (LEN > 1)                     \
            delete[] PTR;                  \
          else                             \
            delete PTR;                    \
          PTR = NULL;                      \
        }else {                            \
          if (ExecDelFnc(LEN, (void*)PTR)) \
            PTR = NULL; }

/****************************************************************************/
class ExprStringStack
{
  protected:
    enum { DEFAULT_INCR = 5 };
    
    char** _ExprStk;
    int _Size;
    int _Index;
    bool _OwnsStack;
    
    static void*(*_AllocFnc)(size_t, size_t);
    static void*(*_DelFnc)(size_t, void*);

    static char* AllocCpyStr(char* str_);
    static void* ExecAllocFnc(size_t len, size_t sz);
    static void* ExecDelFnc(size_t len, void* ptr);
    
    bool TidyStack(int Index_);

  public:
    ExprStringStack();
    ~ExprStringStack();

    static void SetAllocFnc(void*(*AllocFnc_)(size_t, size_t));
    static void SetDelFnc(void*(*DelFnc_)(size_t, void*));

    static bool HasAllocFnc();
    static bool HasDelFnc();

    bool HasAnyExpr() const;
    bool HasExprStr(const char* Ptr_, int* Index_);
    
    char** CreateStack(int Size_=0);
    char** GrowStack(int Size_=0);
    char** DestroyStack();
    
    char* PushString(char* ExprStr_, bool Alloc_);
    char* PopString(int Index_);

    inline void SetOwnsStack(bool Flag_)
        { _OwnsStack = Flag_; }
    inline char** GetStkPtr()
        { return _ExprStk; }
    inline int GetStkIndex()
        { return _Index; }
    inline int GetStkSz()
        { return _Size; }

#if OVERLOAD_NEW
    void* operator new (size_t Bytes_);
    void operator delete (void* Space_);

#if HAS_ARRAY_NEW
    void* operator new[] (size_t Bytes_);
    void operator delete[] (void* Space_);
#endif
#endif    
};

/****************************************************************************/
#endif

