/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/
//
#define MCALCDIALOG_DEBUG1  0
#define MCALCDIALOG_DEBUG1b 0
#define MCALCDIALOG_DEBUG1c 0

#define MCALCDIALOG_DEBUG2a 0
#define MCALCDIALOG_DEBUG2b 0
#define MCALCDIALOG_DEBUG2c 0
#define MCALCDIALOG_DEBUG2d 0   // send debug info to output data file

void McalcDialog::init()
{
// in mcalcdialog.h
// #include "calcdriver.h"
// #include "plotter.h"
// #include "printform.h"
// #include "cmdhistorydialog.h"
// #include "execprgdialog.h"
// #include "progressform.h"

  GRAPH_HELP_MSG =
  "# Use the arrow keys or mouse wheel to scroll the graph\n"
  "# Use the + - keys to zoom in or out\n"
  "# selecting a rectangle with the mouse zooms in on the specified region\n"
  "# Plotting data points for function graph. Please wait...   0% -";

  GRAPH_HELP_MSG2 =
  "# Plotting data points for function graph. Please wait...   0% -";

  GRAPH_HELP_MSG3 =
  "\n\n"
  "# Use the left and right arrow keys to move the blue trace point on the graph\n"
  "# Use the page up and page down keys to move the trace point a whole number distance\n"
  "# Click the enter button to move the trace point to alternate ends of the graph\n"
  "# Click the trace button to move the trace point to another graph, if any\n"
  "# To exit trace mode click on the clear button\n";

  SPLASH_IMAGE_FILE = "splash.png";

  _ServerMsgBox =
  new QMessageBox(QString(tr("Calculation In Progress")),
                  QString(tr("\nCalculation is in progress... Please wait.\n")),
                  QMessageBox::Information,
                  QMessageBox::Ok,
                  QMessageBox::NoButton,
                  QMessageBox::NoButton);

  _PrintForm = new PrintForm(this);
  _CmdHistoryForm = new CmdHistoryDialog(this);
  _ExecPrgForm = new ExecPrgDialog(this);
  _Driver = new CalcDriver();
  _Driver->SetupDataFiles();
  _ProgressForm = new ProgressForm(this);
  _ProgressForm->SetCalcObject(_Driver);  
  _ProgressForm->ResetWaitTextLabel();

  _Printer = new QPrinter(QPrinter::HighResolution);
  _Plotter = new Plotter();
  _Plotter->setCaption(QObject::tr("Plotter"));
  _Plotter->SetErrorMargin(QMCALC_ERROR_MARGIN);
  _Plotter->SetInfPointRadius(QMCALC_INF_POINT_RADIUS);
  _Plotter->SetSession(_Driver->SessionNum());
  _Plotter->SetThePrinter(_Printer);

  _GraphResult = GraphPlotOpType::NO_GRAPH;
  _CurveNum = 0;
  _StartPtx = 0;
  _StartPty = 0;
  _SendingResponse = 0;
  _SendGraphResponse = 0;
  _BatchDataInput = false;
  _AllowBatchQuit = false;
  _NumGraphPlotDone = 0;
  _DoContinuePlot = 0;
  _DoQuitBatchData = false;
  _DoProcessReset = true;
  _Processing = false;  
  _Quitting = false;
  _ErrorResponse = false;
  _GraphResponse = false;
  _CalcResponse = false;
  _EvalMode = false;
  _ResultReturned = false;
  _NewlineAppended = false;
  _NewlineReq = false;
  _EvalPos = 0;
  _FatalErrCount = 0;

  _CmdHistoryEntryFound = false;
  _CmdHistoryCalled = false;
  _CmdHistoryLoading = false;
  _CmdHistoryPos = 0;
  _CmdHistoryEntryLength = 0;
  _CmdEraseValid = false;
  _CmdEraseConfirmed = false;  
 
  _ExecPrgEntryFound = false;
  _ExecPrgCalled = false;
  _ExecPrgLoading = false;
  _ExecCmdPos = 0;
  _ExecPrgName = QString("");
  _ExecPrgOption = QString("");
  _InputFileInProcess = false;
  _RecurseLimitGuard = 0;
  _CalcErrorSignal = false;
  _GraphOutputSignal = false;

  _InputRequest = false;
  _CalcResponseSignal = false;
  _InputRequestDetected = false;
  _CalcResponseDetected = false;
  _InputRequestReplied = false;
  _CalcResponseAnswered = false;
  
  _WaitingForServerResponse = false;
  _ExpectedStatesHandled = false;
  _ExpectedStatesReceived = false;
  _SignalHandled = 0;

  _TraceMode = false;
  _EndToTrace = 1;
  _TraceCurveNum = 0;
  _TraceIndex = 0;
  _TraceMax = 0;

  _VarComboBox->insertItem("ANS");
  _VarComboBox->insertItem("FRACANS");
  _VarComboBox->insertItem("ANSSTR");
  _VarComboBox->insertItem("DUMPVARS");
  _VarComboBox->insertItem("$A");
  _VarComboBox->insertItem("$B");
  _VarComboBox->insertItem("$C");
  _VarComboBox->insertItem("$D");
  _VarComboBox->insertItem("$E");
  _VarComboBox->insertItem("$F");
  _VarComboBox->insertItem("$G");
  _VarComboBox->insertItem("$H");
  _VarComboBox->insertItem("$I");
  _VarComboBox->insertItem("$J");
  _VarComboBox->insertItem("$K");
  _VarComboBox->insertItem("$L");
  _VarComboBox->insertItem("$M");
  _VarComboBox->insertItem("$N");
  _VarComboBox->insertItem("$O");
  _VarComboBox->insertItem("$P");
  _VarComboBox->insertItem("$Q");
  _VarComboBox->insertItem("$R");
  _VarComboBox->insertItem("$S");
  _VarComboBox->insertItem("$T");
  _VarComboBox->insertItem("$U");
  _VarComboBox->insertItem("$V");
  _VarComboBox->insertItem("$W");
  _VarComboBox->insertItem("$X");
  _VarComboBox->insertItem("$Y");
  _VarComboBox->insertItem("$Z");

  _PrecComboBox->insertItem("Float (7-digit)");
  _PrecComboBox->insertItem("Double (15-digit)");
  _PrecComboBox->insertItem("Long Double (19-digit)");
  _PrecComboBox->insertItem("Long Number");
  _PrecComboBox->setCurrentItem(3);

  _ModeComboBox->insertItem("Radian");
  _ModeComboBox->insertItem("Degree");

  _Group = new QButtonGroup(this);
  _Group->insert(_QuitButton, ButtonId::QUIT);
  _Group->insert(_Num0Button, ButtonId::NUM0);
  _Group->insert(_Num1Button, ButtonId::NUM1);
  _Group->insert(_Num2Button, ButtonId::NUM2);
  _Group->insert(_Num3Button, ButtonId::NUM3);
  _Group->insert(_Num4Button, ButtonId::NUM4);
  _Group->insert(_Num5Button, ButtonId::NUM5);
  _Group->insert(_Num6Button, ButtonId::NUM6);
  _Group->insert(_Num7Button, ButtonId::NUM7);
  _Group->insert(_Num8Button, ButtonId::NUM8);
  _Group->insert(_Num9Button, ButtonId::NUM9);
  _Group->insert(_OrAssignButton, ButtonId::ORASSIGN);
  _Group->insert(_AndAssignButton, ButtonId::ANDASSIGN);
  _Group->insert(_AssignButton, ButtonId::ASSIGN);
  _Group->insert(_DivAssignButton, ButtonId::DIVASSIGN);
  _Group->insert(_MultAssignButton, ButtonId::MULTASSIGN);
  _Group->insert(_MinusAssignButton, ButtonId::MINUSASSIGN);
  _Group->insert(_PlusAssignButton, ButtonId::PLUSASSIGN);
  _Group->insert(_ModAssignButton, ButtonId::MODASSIGN);
  _Group->insert(_DivButton, ButtonId::DIV);
  _Group->insert(_MultButton, ButtonId::MULT);
  _Group->insert(_MinusButton, ButtonId::MINUS);
  _Group->insert(_PlusButton, ButtonId::PLUS);
  _Group->insert(_ModButton, ButtonId::MOD);
  _Group->insert(_NegButton, ButtonId::NEG);
  _Group->insert(_DecPointButton, ButtonId::DECPOINT);
  _Group->insert(_RightBracketButton, ButtonId::RIGHTBRACKET);
  _Group->insert(_LeftBracketButton, ButtonId::LEFTBRACKET);
  _Group->insert(_CeilButton, ButtonId::CEIL);
  _Group->insert(_FloorButton, ButtonId::FLOOR);
  _Group->insert(_MinButton, ButtonId::MIN);
  _Group->insert(_MaxButton, ButtonId::MAX);
  _Group->insert(_RandButton, ButtonId::RAND);
  _Group->insert(_SinButton, ButtonId::SIN);
  _Group->insert(_CosButton, ButtonId::COS);
  _Group->insert(_TanButton, ButtonId::TAN);
  _Group->insert(_AsinButton, ButtonId::ASIN);
  _Group->insert(_AcosButton, ButtonId::ACOS);
  _Group->insert(_AtanButton, ButtonId::ATAN);
  _Group->insert(_SinhButton, ButtonId::SINH);
  _Group->insert(_CoshButton, ButtonId::COSH);
  _Group->insert(_TanhButton, ButtonId::TANH);
  _Group->insert(_SqrButton, ButtonId::SQR);
  _Group->insert(_SqrtButton, ButtonId::SQRT);
  _Group->insert(_CubeButton, ButtonId::CUBE);
  _Group->insert(_CubeRtButton, ButtonId::CUBERT);
  _Group->insert(_PermButton, ButtonId::PERM);
  _Group->insert(_CombButton, ButtonId::COMB);
  _Group->insert(_CombRepButton, ButtonId::COMBREP);
  _Group->insert(_PermRepButton, ButtonId::PERMREP);
  _Group->insert(_FactButton, ButtonId::FACT);
  _Group->insert(_EqualButton, ButtonId::EQUAL);
  _Group->insert(_NotEqualButton, ButtonId::NOTEQUAL);
  _Group->insert(_GreaterThanButton, ButtonId::GREATERTHAN);
  _Group->insert(_LessThanButton, ButtonId::LESSTHAN);
  _Group->insert(_GreaterThanOrEqualButton, ButtonId::GREATERTHANOREQUAL);
  _Group->insert(_LessThanOrEqualButton, ButtonId::LESSTHANOREQUAL);
  _Group->insert(_ExpButton, ButtonId::EXP);
  _Group->insert(_LogButton, ButtonId::LOG);
  _Group->insert(_Log10Button, ButtonId::LOG10);
  _Group->insert(_PowButton, ButtonId::POW);
  _Group->insert(_PolToRecxButton, ButtonId::POLTORECX);
  _Group->insert(_PolToRecyButton, ButtonId::POLTORECY);
  _Group->insert(_RecToPolrButton, ButtonId::RECTOPOLR);
  _Group->insert(_RecToPolaButton, ButtonId::RECTOPOLA);
  _Group->insert(_RoundButton, ButtonId::ROUND);
  _Group->insert(_RndButton, ButtonId::RND);
  _Group->insert(_PercentButton, ButtonId::PERCENT);
  _Group->insert(_InvButton, ButtonId::INVERSE);
  _Group->insert(_FracButton, ButtonId::FRAC);
  _Group->insert(_SciButton, ButtonId::SCI);
  _Group->insert(_FromCmp2BinButton, ButtonId::FROMCMP2BIN);
  _Group->insert(_FromBinButton, ButtonId::FROMBIN);
  _Group->insert(_FromOctButton, ButtonId::FROMOCT);
  _Group->insert(_FromHexButton, ButtonId::FROMHEX);
  _Group->insert(_ToCmp2BinButton, ButtonId::TOCMP2BIN);
  _Group->insert(_ToBinButton, ButtonId::TOBIN);
  _Group->insert(_ToOctButton, ButtonId::TOOCT);
  _Group->insert(_ToHexButton, ButtonId::TOHEX);
  _Group->insert(_ItemPermButton, ButtonId::ITEMPERM);
  _Group->insert(_ItemCombButton, ButtonId::ITEMCOMB);
  _Group->insert(_ItemPermRepButton, ButtonId::ITEMPERMREP);
  _Group->insert(_ItemCombRepButton, ButtonId::ITEMCOMBREP);
  _Group->insert(_FracPartButton, ButtonId::FRACPART);
  _Group->insert(_IntPartButton, ButtonId::INTPART);
  _Group->insert(_AbsButton, ButtonId::ABS);
  _Group->insert(_AndButton, ButtonId::AND);
  _Group->insert(_OrButton, ButtonId::OR);
  _Group->insert(_XorButton, ButtonId::XOR);
  _Group->insert(_NotButton, ButtonId::NOT);
  _Group->insert(_DerivButton, ButtonId::DERIV);
  _Group->insert(_IntegButton, ButtonId::INTEG);
  _Group->insert(_FminButton, ButtonId::FMIN);
  _Group->insert(_FmaxButton, ButtonId::FMAX);
  _Group->insert(_SolveButton, ButtonId::SOLVE);
  _Group->insert(_HexPrefixButton, ButtonId::HEXPREFIX);
  _Group->insert(_ExecButton, ButtonId::EXEC);
  _Group->insert(_EvalButton, ButtonId::EVAL);
  _Group->insert(_GetPrecButton, ButtonId::GETPREC);
  _Group->insert(_HelpButton, ButtonId::HELP);
  _Group->insert(_EditButton, ButtonId::EDIT);
  _Group->insert(_GraphButton, ButtonId::GRAPH);
  _Group->insert(_DeleteButton, ButtonId::DEL);
  _Group->insert(_ClearButton, ButtonId::CLEAR);
  _Group->insert(_EnterButton, ButtonId::ENTER);
  _Group->insert(_AvgMeanButton, ButtonId::AVGMEAN);
  _Group->insert(_AvgModeButton, ButtonId::AVGMODE);
  _Group->insert(_AvgMedianButton, ButtonId::AVGMEDIAN);
  _Group->insert(_StdDevButton, ButtonId::STDDEV);
  _Group->insert(_SumButton, ButtonId::SUM);
  _Group->insert(_ProductButton, ButtonId::PRODUCT);
  _Group->insert(_ShowButton, ButtonId::SHOW);
  _Group->insert(_MatSolveButton, ButtonId::MATSOLVE);
  _Group->insert(_GraphAllPtsButton, ButtonId::GRAPHALLPTS);
  _Group->insert(_Deriv2Button, ButtonId::DERIV2);
  _Group->insert(_SetButton, ButtonId::SET);
  _Group->insert(_SetUnionButton, ButtonId::SETUNI);
  _Group->insert(_SetIntersectionButton, ButtonId::SETINT);
  _Group->insert(_SetDifferenceButton, ButtonId::SETDIF);
  _Group->insert(_SetXDifferenceButton, ButtonId::SETXDIF);
  _Group->insert(_ShowSetButton, ButtonId::SHOWSET);
  _Group->insert(_GraphPrecButton, ButtonId::GRAPHPREC);
  _Group->insert(_CommaButton, ButtonId::COMMA);
  _Group->insert(_XButton, ButtonId::XVAR);
  _Group->insert(_PiButton, ButtonId::PI);
  _Group->insert(_eButton, ButtonId::NAT_E);
  _Group->insert(_ClearGraphButton, ButtonId::CLEARGRAPH);
  _Group->insert(_BreakButton, ButtonId::BREAK);
  _Group->insert(_IntersectButton, ButtonId::INTERSECT);
  _Group->insert(_TraceButton, ButtonId::TRACE);
  _Group->insert(_PrintButton, ButtonId::PRINT);
  _Group->insert(_HistoryButton, ButtonId::HISTORY);
  _Group->hide();

  _InputArray = new ButtonInfo*[2048];
  _Buttons = new ButtonInfo*[ButtonId::MAX_BUTTONS];
  int x;

  for (x = 0; x < ButtonId::MAX_BUTTONS; x++)
  {
    _Buttons[x] = new ButtonInfo;
    _Buttons[x]->_Command = NULL;
    _Buttons[x]->_UserDefined = false;
    _Buttons[x]->_CombinedCharStr = false;
  }

  _CurPos = 0;
  _Index = 0;
  for (x = 0; x < 2048; x++)
    _InputArray[x] = NULL;

  _Buttons[ButtonId::NO_BUTTON]->_Command = strcpy(new char[1], "");
  _Buttons[ButtonId::NO_BUTTON]->_Length = 0;
  _Buttons[ButtonId::QUIT]->_Command = strcpy(new char[5], "quit");
  _Buttons[ButtonId::QUIT]->_Length = 4;
  _Buttons[ButtonId::NUM0]->_Command = strcpy(new char[2], "0");
  _Buttons[ButtonId::NUM0]->_Length = 1;
  _Buttons[ButtonId::NUM1]->_Command = strcpy(new char[2], "1");
  _Buttons[ButtonId::NUM1]->_Length = 1;
  _Buttons[ButtonId::NUM2]->_Command = strcpy(new char[2], "2");
  _Buttons[ButtonId::NUM2]->_Length = 1;
  _Buttons[ButtonId::NUM3]->_Command = strcpy(new char[2], "3");
  _Buttons[ButtonId::NUM3]->_Length = 1;
  _Buttons[ButtonId::NUM4]->_Command = strcpy(new char[2], "4");
  _Buttons[ButtonId::NUM4]->_Length = 1;
  _Buttons[ButtonId::NUM5]->_Command = strcpy(new char[2], "5");
  _Buttons[ButtonId::NUM5]->_Length = 1;
  _Buttons[ButtonId::NUM6]->_Command = strcpy(new char[2], "6");
  _Buttons[ButtonId::NUM6]->_Length = 1;
  _Buttons[ButtonId::NUM7]->_Command = strcpy(new char[2], "7");
  _Buttons[ButtonId::NUM7]->_Length = 1;
  _Buttons[ButtonId::NUM8]->_Command = strcpy(new char[2], "8");
  _Buttons[ButtonId::NUM8]->_Length = 1;
  _Buttons[ButtonId::NUM9]->_Command = strcpy(new char[2], "9");
  _Buttons[ButtonId::NUM9]->_Length = 1;
  _Buttons[ButtonId::ORASSIGN]->_Command = strcpy(new char[3], "|=");
  _Buttons[ButtonId::ORASSIGN]->_Length = 2;
  _Buttons[ButtonId::ANDASSIGN]->_Command = strcpy(new char[3], "&=");
  _Buttons[ButtonId::ANDASSIGN]->_Length = 2;
  _Buttons[ButtonId::ASSIGN]->_Command = strcpy(new char[2], "=");
  _Buttons[ButtonId::ASSIGN]->_Length = 1;
  _Buttons[ButtonId::DIVASSIGN]->_Command = strcpy(new char[3], "/=");
  _Buttons[ButtonId::DIVASSIGN]->_Length = 2;
  _Buttons[ButtonId::MULTASSIGN]->_Command = strcpy(new char[3], "*=");
  _Buttons[ButtonId::MULTASSIGN]->_Length = 2;
  _Buttons[ButtonId::MINUSASSIGN]->_Command = strcpy(new char[3], "-=");
  _Buttons[ButtonId::MINUSASSIGN]->_Length = 2;
  _Buttons[ButtonId::PLUSASSIGN]->_Command = strcpy(new char[3], "+=");
  _Buttons[ButtonId::PLUSASSIGN]->_Length = 2;
  _Buttons[ButtonId::MODASSIGN]->_Command = strcpy(new char[3], "@=");
  _Buttons[ButtonId::MODASSIGN]->_Length = 2;
  _Buttons[ButtonId::DIV]->_Command = strcpy(new char[2], "/");
  _Buttons[ButtonId::DIV]->_Length = 1;
  _Buttons[ButtonId::MULT]->_Command = strcpy(new char[2], "*");
  _Buttons[ButtonId::MULT]->_Length = 1;
  _Buttons[ButtonId::MINUS]->_Command = strcpy(new char[2], "-");
  _Buttons[ButtonId::MINUS]->_Length = 1;
  _Buttons[ButtonId::PLUS]->_Command = strcpy(new char[2], "+");
  _Buttons[ButtonId::PLUS]->_Length = 1;
  _Buttons[ButtonId::MOD]->_Command = strcpy(new char[2], "@");
  _Buttons[ButtonId::MOD]->_Length = 1;
  _Buttons[ButtonId::NEG]->_Command = strcpy(new char[2], "-");
  _Buttons[ButtonId::NEG]->_Length = 1;
  _Buttons[ButtonId::DECPOINT]->_Command = strcpy(new char[2], ".");
  _Buttons[ButtonId::DECPOINT]->_Length = 1;
  _Buttons[ButtonId::RIGHTBRACKET]->_Command = strcpy(new char[2], ")");
  _Buttons[ButtonId::RIGHTBRACKET]->_Length = 1;
  _Buttons[ButtonId::LEFTBRACKET]->_Command = strcpy(new char[2], "(");
  _Buttons[ButtonId::LEFTBRACKET]->_Length = 1;
  _Buttons[ButtonId::CEIL]->_Command = strcpy(new char[5], "CEIL");
  _Buttons[ButtonId::CEIL]->_Length = 4;
  _Buttons[ButtonId::FLOOR]->_Command = strcpy(new char[6], "FLOOR");
  _Buttons[ButtonId::FLOOR]->_Length = 5;
  _Buttons[ButtonId::MIN]->_Command = strcpy(new char[4], "MIN");
  _Buttons[ButtonId::MIN]->_Length = 3;
  _Buttons[ButtonId::MAX]->_Command = strcpy(new char[4], "MAX");
  _Buttons[ButtonId::MAX]->_Length = 3;
  _Buttons[ButtonId::RAND]->_Command = strcpy(new char[5], "RAND");
  _Buttons[ButtonId::RAND]->_Length = 4;
  _Buttons[ButtonId::SIN]->_Command = strcpy(new char[4], "SIN");
  _Buttons[ButtonId::SIN]->_Length = 3;
  _Buttons[ButtonId::COS]->_Command = strcpy(new char[4], "COS");
  _Buttons[ButtonId::COS]->_Length = 3;
  _Buttons[ButtonId::TAN]->_Command = strcpy(new char[4], "TAN");
  _Buttons[ButtonId::TAN]->_Length = 3;
  _Buttons[ButtonId::ASIN]->_Command = strcpy(new char[5], "ASIN");
  _Buttons[ButtonId::ASIN]->_Length = 4;
  _Buttons[ButtonId::ACOS]->_Command = strcpy(new char[5], "ACOS");
  _Buttons[ButtonId::ACOS]->_Length = 4;
  _Buttons[ButtonId::ATAN]->_Command = strcpy(new char[5], "ATAN");
  _Buttons[ButtonId::ATAN]->_Length = 4;
  _Buttons[ButtonId::SINH]->_Command = strcpy(new char[5], "SINH");
  _Buttons[ButtonId::SINH]->_Length = 4;
  _Buttons[ButtonId::COSH]->_Command = strcpy(new char[5], "COSH");
  _Buttons[ButtonId::COSH]->_Length = 4;
  _Buttons[ButtonId::TANH]->_Command = strcpy(new char[5], "TANH");
  _Buttons[ButtonId::TANH]->_Length = 4;
  _Buttons[ButtonId::SQR]->_Command = strcpy(new char[4], "SQR");
  _Buttons[ButtonId::SQR]->_Length = 3;
  _Buttons[ButtonId::SQRT]->_Command = strcpy(new char[5], "SQRT");
  _Buttons[ButtonId::SQRT]->_Length = 4;
  _Buttons[ButtonId::CUBE]->_Command = strcpy(new char[5], "CUBE");
  _Buttons[ButtonId::CUBE]->_Length = 4;
  _Buttons[ButtonId::CUBERT]->_Command = strcpy(new char[7], "CUBERT");
  _Buttons[ButtonId::CUBERT]->_Length = 6;
  _Buttons[ButtonId::PERM]->_Command = strcpy(new char[5], "PERM");
  _Buttons[ButtonId::PERM]->_Length = 4;
  _Buttons[ButtonId::COMB]->_Command = strcpy(new char[5], "COMB");
  _Buttons[ButtonId::COMB]->_Length = 4;
  _Buttons[ButtonId::PERMREP]->_Command = strcpy(new char[8], "PERMREP");
  _Buttons[ButtonId::PERMREP]->_Length = 7;
  _Buttons[ButtonId::COMBREP]->_Command = strcpy(new char[8], "COMBREP");
  _Buttons[ButtonId::COMBREP]->_Length = 7;
  _Buttons[ButtonId::FACT]->_Command = strcpy(new char[5], "FACT");
  _Buttons[ButtonId::FACT]->_Length = 4;
  _Buttons[ButtonId::EQUAL]->_Command = strcpy(new char[3], "==");
  _Buttons[ButtonId::EQUAL]->_Length = 2;
  _Buttons[ButtonId::NOTEQUAL]->_Command = strcpy(new char[3], "!=");
  _Buttons[ButtonId::NOTEQUAL]->_Length = 2;
  _Buttons[ButtonId::GREATERTHAN]->_Command = strcpy(new char[2], ">");
  _Buttons[ButtonId::GREATERTHAN]->_Length = 1;
  _Buttons[ButtonId::LESSTHAN]->_Command = strcpy(new char[2], "<");
  _Buttons[ButtonId::LESSTHAN]->_Length = 1;
  _Buttons[ButtonId::GREATERTHANOREQUAL]->_Command = strcpy(new char[3], ">=");
  _Buttons[ButtonId::GREATERTHANOREQUAL]->_Length = 2;
  _Buttons[ButtonId::LESSTHANOREQUAL]->_Command = strcpy(new char[3], "<=");
  _Buttons[ButtonId::LESSTHANOREQUAL]->_Length = 2;
  _Buttons[ButtonId::EXP]->_Command = strcpy(new char[4], "EXP");
  _Buttons[ButtonId::EXP]->_Length = 3;
  _Buttons[ButtonId::LOG]->_Command = strcpy(new char[4], "LOG");
  _Buttons[ButtonId::LOG]->_Length = 3;
  _Buttons[ButtonId::LOG10]->_Command = strcpy(new char[6], "LOG10");
  _Buttons[ButtonId::LOG10]->_Length = 5;
  _Buttons[ButtonId::POW]->_Command = strcpy(new char[2], "^");
  _Buttons[ButtonId::POW]->_Length = 1;
  _Buttons[ButtonId::POLTORECX]->_Command = strcpy(new char[10], "POLTORECX");
  _Buttons[ButtonId::POLTORECX]->_Length = 9;
  _Buttons[ButtonId::POLTORECY]->_Command = strcpy(new char[10], "POLTORECY");
  _Buttons[ButtonId::POLTORECY]->_Length = 9;
  _Buttons[ButtonId::RECTOPOLA]->_Command = strcpy(new char[10], "RECTOPOLA");
  _Buttons[ButtonId::RECTOPOLA]->_Length = 9;
  _Buttons[ButtonId::RECTOPOLR]->_Command = strcpy(new char[10], "RECTOPOLR");
  _Buttons[ButtonId::RECTOPOLR]->_Length = 9;
  _Buttons[ButtonId::ROUND]->_Command = strcpy(new char[6], "ROUND");
  _Buttons[ButtonId::ROUND]->_Length = 5;
  _Buttons[ButtonId::RND]->_Command = strcpy(new char[4], "RND");
  _Buttons[ButtonId::RND]->_Length = 3;
  _Buttons[ButtonId::PERCENT]->_Command = strcpy(new char[2], "%");
  _Buttons[ButtonId::PERCENT]->_Length = 1;
  _Buttons[ButtonId::INVERSE]->_Command = strcpy(new char[4], "INV");
  _Buttons[ButtonId::INVERSE]->_Length = 3;
  _Buttons[ButtonId::FRAC]->_Command = strcpy(new char[5], "FRAC");
  _Buttons[ButtonId::FRAC]->_Length = 4;
  _Buttons[ButtonId::SCI]->_Command = strcpy(new char[2], "E");
  _Buttons[ButtonId::SCI]->_Length = 1;
  _Buttons[ButtonId::FROMCMP2BIN]->_Command = strcpy(new char[12], "FROMCMP2BIN");
  _Buttons[ButtonId::FROMCMP2BIN]->_Length = 11;
  _Buttons[ButtonId::FROMBIN]->_Command = strcpy(new char[8], "FROMBIN");
  _Buttons[ButtonId::FROMBIN]->_Length = 7;
  _Buttons[ButtonId::FROMOCT]->_Command = strcpy(new char[8], "FROMOCT");
  _Buttons[ButtonId::FROMOCT]->_Length = 7;
  _Buttons[ButtonId::FROMHEX]->_Command = strcpy(new char[8], "FROMHEX");
  _Buttons[ButtonId::FROMHEX]->_Length = 7;
  _Buttons[ButtonId::TOCMP2BIN]->_Command = strcpy(new char[10], "TOCMP2BIN");
  _Buttons[ButtonId::TOCMP2BIN]->_Length = 9;
  _Buttons[ButtonId::TOBIN]->_Command = strcpy(new char[6], "TOBIN");
  _Buttons[ButtonId::TOBIN]->_Length = 5;
  _Buttons[ButtonId::TOOCT]->_Command = strcpy(new char[6], "TOOCT");
  _Buttons[ButtonId::TOOCT]->_Length = 5;
  _Buttons[ButtonId::TOHEX]->_Command = strcpy(new char[6], "TOHEX");
  _Buttons[ButtonId::TOHEX]->_Length = 5;
  _Buttons[ButtonId::ITEMPERM]->_Command = strcpy(new char[9], "ITEMPERM");
  _Buttons[ButtonId::ITEMPERM]->_Length = 8;
  _Buttons[ButtonId::ITEMCOMB]->_Command = strcpy(new char[9], "ITEMCOMB");
  _Buttons[ButtonId::ITEMCOMB]->_Length = 8;
  _Buttons[ButtonId::ITEMPERMREP]->_Command = strcpy(new char[12], "ITEMPERMREP");
  _Buttons[ButtonId::ITEMPERMREP]->_Length = 11;
  _Buttons[ButtonId::ITEMCOMBREP]->_Command = strcpy(new char[12], "ITEMCOMBREP");
  _Buttons[ButtonId::ITEMCOMBREP]->_Length = 11;
  _Buttons[ButtonId::FRACPART]->_Command = strcpy(new char[9], "FRACPART");
  _Buttons[ButtonId::FRACPART]->_Length = 8;
  _Buttons[ButtonId::INTPART]->_Command = strcpy(new char[8], "INTPART");
  _Buttons[ButtonId::INTPART]->_Length = 7;
  _Buttons[ButtonId::ABS]->_Command = strcpy(new char[4], "ABS");
  _Buttons[ButtonId::ABS]->_Length = 3;
  _Buttons[ButtonId::AND]->_Command = strcpy(new char[4], "AND");
  _Buttons[ButtonId::AND]->_Length = 3;
  _Buttons[ButtonId::OR]->_Command = strcpy(new char[3], "OR");
  _Buttons[ButtonId::OR]->_Length = 2;
  _Buttons[ButtonId::XOR]->_Command = strcpy(new char[4], "XOR");
  _Buttons[ButtonId::XOR]->_Length = 3;
  _Buttons[ButtonId::NOT]->_Command = strcpy(new char[4], "NOT");
  _Buttons[ButtonId::NOT]->_Length = 3;
  _Buttons[ButtonId::DERIV]->_Command = strcpy(new char[6], "DERIV");
  _Buttons[ButtonId::DERIV]->_Length = 5;
  _Buttons[ButtonId::INTEG]->_Command = strcpy(new char[6], "INTEG");
  _Buttons[ButtonId::INTEG]->_Length = 5;
  _Buttons[ButtonId::FMIN]->_Command = strcpy(new char[5], "FMIN");
  _Buttons[ButtonId::FMIN]->_Length = 4;
  _Buttons[ButtonId::FMAX]->_Command = strcpy(new char[5], "FMAX");
  _Buttons[ButtonId::FMAX]->_Length = 4;
  _Buttons[ButtonId::SOLVE]->_Command = strcpy(new char[6], "SOLVE");
  _Buttons[ButtonId::SOLVE]->_Length = 5;
  _Buttons[ButtonId::HEXPREFIX]->_Command = strcpy(new char[3], "0x");
  _Buttons[ButtonId::HEXPREFIX]->_Length = 2;
  _Buttons[ButtonId::EXEC]->_Command = strcpy(new char[5], "EXEC");
  _Buttons[ButtonId::EXEC]->_Length = 4;
  _Buttons[ButtonId::EVAL]->_Command = strcpy(new char[5], "EVAL");
  _Buttons[ButtonId::EVAL]->_Length = 4;
  _Buttons[ButtonId::GETPREC]->_Command = strcpy(new char[13], "GETPRECISION");
  _Buttons[ButtonId::GETPREC]->_Length = 12;
  _Buttons[ButtonId::HELP]->_Command = strcpy(new char[5], "HELP");
  _Buttons[ButtonId::HELP]->_Length = 4;
  _Buttons[ButtonId::GRAPH]->_Command = strcpy(new char[6], "GRAPH");
  _Buttons[ButtonId::GRAPH]->_Length = 5;
  _Buttons[ButtonId::CLEARGRAPH]->_Command = strcpy(new char[12], "CLEAR GRAPH");
  _Buttons[ButtonId::CLEARGRAPH]->_Length = 11;
  _Buttons[ButtonId::AVGMEAN]->_Command = strcpy(new char[8], "AVGMEAN");
  _Buttons[ButtonId::AVGMEAN]->_Length = 7;
  _Buttons[ButtonId::AVGMODE]->_Command = strcpy(new char[8], "AVGMODE");
  _Buttons[ButtonId::AVGMODE]->_Length = 7;
  _Buttons[ButtonId::AVGMEDIAN]->_Command = strcpy(new char[7], "AVGMED");
  _Buttons[ButtonId::AVGMEDIAN]->_Length = 6;
  _Buttons[ButtonId::STDDEV]->_Command = strcpy(new char[7], "STDDEV");
  _Buttons[ButtonId::STDDEV]->_Length = 6;
  _Buttons[ButtonId::SUM]->_Command = strcpy(new char[4], "SUM");
  _Buttons[ButtonId::SUM]->_Length = 3;
  _Buttons[ButtonId::PRODUCT]->_Command = strcpy(new char[5], "PROD");
  _Buttons[ButtonId::PRODUCT]->_Length = 4;
  _Buttons[ButtonId::SHOW]->_Command = strcpy(new char[5], "SHOW");
  _Buttons[ButtonId::SHOW]->_Length = 4;
  _Buttons[ButtonId::MATSOLVE]->_Command = strcpy(new char[9], "MATSOLVE");
  _Buttons[ButtonId::MATSOLVE]->_Length = 8;
  _Buttons[ButtonId::GRAPHALLPTS]->_Command = strcpy(new char[17], "GRAPHALLPTS=TRUE");
  _Buttons[ButtonId::GRAPHALLPTS]->_Length = 16;
  _Buttons[ButtonId::DERIV2]->_Command = strcpy(new char[7], "DERIV2");
  _Buttons[ButtonId::DERIV2]->_Length = 6;
  _Buttons[ButtonId::PI]->_Command = strcpy(new char[3], "PI");
  _Buttons[ButtonId::PI]->_Length = 2;
  _Buttons[ButtonId::NAT_E]->_Command = strcpy(new char[2], "e");
  _Buttons[ButtonId::NAT_E]->_Length = 1;
  _Buttons[ButtonId::COMMA]->_Command = strcpy(new char[2], ",");
  _Buttons[ButtonId::COMMA]->_Length = 1;
  _Buttons[ButtonId::XVAR]->_Command = strcpy(new char[2], "x");
  _Buttons[ButtonId::XVAR]->_Length = 1;
  _Buttons[ButtonId::BREAK]->_Command = strcpy(new char[6], "break");
  _Buttons[ButtonId::BREAK]->_Length = 5;
  _Buttons[ButtonId::INTERSECT]->_Command = strcpy(new char[10], "INTERSECT");
  _Buttons[ButtonId::INTERSECT]->_Length = 9;
  _Buttons[ButtonId::TRACE]->_Command = strcpy(new char[6], "TRACE");
  _Buttons[ButtonId::TRACE]->_Length = 5;
  _Buttons[ButtonId::PRINT]->_Command = strcpy(new char[6], "PRINT");
  _Buttons[ButtonId::PRINT]->_Length = 5;
  _Buttons[ButtonId::EDIT]->_Command = strcpy(new char[1], "");
  _Buttons[ButtonId::EDIT]->_Length = 0;
  _Buttons[ButtonId::DEL]->_Command = strcpy(new char[1], "");
  _Buttons[ButtonId::DEL]->_Length = 0;
  _Buttons[ButtonId::CLEAR]->_Command = strcpy(new char[1], "");
  _Buttons[ButtonId::CLEAR]->_Length = 0;
  _Buttons[ButtonId::ENTER]->_Command = strcpy(new char[1], "");
  _Buttons[ButtonId::ENTER]->_Length = 0;
  _Buttons[ButtonId::SET]->_Command = strcpy(new char[4], "SET");
  _Buttons[ButtonId::SET]->_Length = 3;
  _Buttons[ButtonId::SETUNI]->_Command = strcpy(new char[7], "SETUNI");
  _Buttons[ButtonId::SETUNI]->_Length = 6;
  _Buttons[ButtonId::SETINT]->_Command = strcpy(new char[7], "SETINT");
  _Buttons[ButtonId::SETINT]->_Length = 6;
  _Buttons[ButtonId::SETDIF]->_Command = strcpy(new char[7], "SETDIF");
  _Buttons[ButtonId::SETDIF]->_Length = 6;
  _Buttons[ButtonId::SETXDIF]->_Command = strcpy(new char[8], "SETXDIF");
  _Buttons[ButtonId::SETXDIF]->_Length = 7;
  _Buttons[ButtonId::SHOWSET]->_Command = strcpy(new char[8], "SHOWSET");
  _Buttons[ButtonId::SHOWSET]->_Length = 7;
  _Buttons[ButtonId::GRAPHPREC]->_Command = strcpy(new char[11], "GRAPHPREC=");
  _Buttons[ButtonId::GRAPHPREC]->_Length = 10;
  _Buttons[ButtonId::HISTORY]->_Command = strcpy(new char[8], "HISTORY");
  _Buttons[ButtonId::HISTORY]->_Length = 7;

  // Buttons that are not calc commands
  // ButtonId::BREAK
  // ButtonId::QUIT
  // ButtonId::EDIT
  // ButtonId::DEL
  // ButtonId::CLEAR
  // ButtonId::ENTER
  // ButtonId::TRACE

  // Buttons that should go to the plotter
  // ButtonId::GRAPH
  // ButtonId::CLEARGRAPH

  _SplashScreen = new QSplashScreen(QPixmap::fromMimeSource(SPLASH_IMAGE_FILE));
  _UserTextEdit->installEventFilter(this);
  _UserTextEdit->setCursorPosition(0, 1);
  _Driver->Execute();
  MoveToEnd();

  connect(_Group, SIGNAL(clicked(int)),
          this, SLOT(HandleButton(int)));
  connect(_Driver, SIGNAL(DoQuit()),
          this, SLOT(close()));

  connect(_Driver, SIGNAL(DisableEnterKey()),
          this, SLOT(DisableEnterButton()));
  connect(_Driver, SIGNAL(EnableEnterKey()),
          this, SLOT(EnableEnterButton()));

  connect(_Driver, SIGNAL(ProcessSignal()),
          this, SLOT(ResetExpectedStates()));
  connect(_Driver, SIGNAL(CreateNewMcalc()),
          this, SLOT(AckNewMcalc()));
  connect(_Driver, SIGNAL(ErrorFound()),
          this, SLOT(ShowErrorOutput()));
  connect(_Driver, SIGNAL(ProcessAcked()),
          this, SLOT(ClearInputBuffer()));
  connect(_Driver, SIGNAL(InputNeeded()),
          this, SLOT(ShowCalcOutput()));
  connect(_Driver, SIGNAL(OutputReady()),
          this, SLOT(FetchOutput()));
  connect(_Driver, SIGNAL(ProgressReady()),
          this, SLOT(FetchProgress()));
  connect(_Driver, SIGNAL(ResultsFileReady(const QString&, const QString&)),
          this, SLOT(ShowResultsFile(const QString&, const QString&)));
          
  connect(_Driver, SIGNAL(GraphOutput()),
          this, SLOT(FetchAndGraphOutput()));
  connect(_Driver, SIGNAL(GraphWait()),
          this, SLOT(WaitForGraphOutput()));
  connect(_Driver, SIGNAL(GraphProgress()),
          this, SLOT(WaitForGraphProgress()));
  connect(_Driver, SIGNAL(EndOfBatchData()),
          this, SLOT(AckEndOfBatchData()));

  connect(_Driver, SIGNAL(CalcServerTimeout()),
          this, SLOT(ShowTimeoutMessage()));
  connect(_Driver, SIGNAL(ServerAliveConfirmed()),
          this, SLOT(ResetShutdownTimer()));
  connect(&_RetryReadTimer, SIGNAL(timeout()),
          this, SLOT(CheckForServerAlive()));

  connect(&_ReEnableTimer, SIGNAL(timeout()),
          this, SLOT(EnableEnterButton()));
  connect(&_ServerMsgTimer, SIGNAL(timeout()),
          this, SLOT(HideTimeoutMessage()));
  connect(&_TwirlyTimer, SIGNAL(timeout()),
          this, SLOT(StartTwirly()));
  connect(&_SplashTimer, SIGNAL(timeout()),
          _SplashScreen, SLOT(close()));

  connect(_PrintForm, SIGNAL(PrintCalcScreen()),
          this, SLOT(DoPrintCalcScreen()));
  connect(_PrintForm, SIGNAL(PrintFunctionPlotter()),
          this, SLOT(DoPrintFunctionPlotter()));

  #if IMPLEMENT_KEEP_ALIVE
    _RetryReadTimer.start(QMCALC_SERVERCHECK_INTERVAL);
  #endif
  
  // connect(_CmdHistoryForm, SIGNAL(Confirmed(const QString&)),
  //         this, SLOT(ShowHistoryEntry(const QString&)));
}

/****************************************************************************/
void McalcDialog::ShowSplashScreen()
{
  _SplashScreen->raise();
  _SplashScreen->show();
  _SplashTimer.start(8000);
}

/****************************************************************************/
void McalcDialog::ShowTimeoutMessage()
{
  int msecs_ = QMCALC_TIMEOUT_DURATION * 1000;

  #if MCALCDIALOG_DEBUG2d
    _Driver->DbgPtr()->EnterLevel("ShowTimeoutMessage()");
    _Driver->DbgPtr()->ShowInt(msecs_, "msecs_");
  #endif

  _Driver->SetCalcElapsedTimeState(Mcalc_ElapsedTime::ACKNOWLEDGED,
                                   "McalcDialog::ShowTimeoutMessage()");
  
  _ServerMsgBox->raise();
  _ServerMsgBox->show();
  _ServerMsgTimer.start(msecs_);

  #if MCALCDIALOG_DEBUG2d
    _Driver->DbgPtr()->LeaveLevel();
  #endif
}

/****************************************************************************/
void McalcDialog::HideTimeoutMessage()
{
  #if MCALCDIALOG_DEBUG2d
    _Driver->DbgPtr()->EnterLevel("HideTimeoutMessage()");
  #endif

  _ServerMsgTimer.stop();

  if (_ServerMsgBox->isVisible() || _ServerMsgBox->isShown())
  {
    _ServerMsgBox->hide();
    _ServerMsgBox->close();
  }

  #if MCALCDIALOG_DEBUG2d
    _Driver->DbgPtr()->LeaveLevel();
  #endif
}

/****************************************************************************/
void McalcDialog::destroy()
{
  int x;

  _RetryReadTimer.stop();
  _ServerMsgTimer.stop();
  _TwirlyTimer.stop();
  _SplashTimer.stop();

  for (x = 0; x < ButtonId::MAX_BUTTONS; x++)
  {
    delete[] _Buttons[x]->_Command;
    delete _Buttons[x];
  }

  delete[] _Buttons;
  delete _Driver;

  _Plotter->Destruct();
  delete _Plotter;
  delete _Printer;

  for (x = 0; x < _Index; x++)
  {
    if (_InputArray[x] && _InputArray[x]->_UserDefined)
    {
      delete[] _InputArray[x]->_Command;
      delete _InputArray[x];
    }

    _InputArray[x] = NULL;
  }

  _CurPos =
  _Index = 0;
  _SplashScreen->close();
  delete _SplashScreen;

  _ServerMsgBox->close();
  delete _ServerMsgBox;
}

/****************************************************************************/
void McalcDialog::DoHide()
{
  showMinimized();
}

/****************************************************************************/
void McalcDialog::EnableEnterButton()
{
  if (!_EnterButton->isEnabled())
  {
    _EnterButton->setEnabled(true);
    _ReEnableTimer.stop();
  }
  else if (_ReEnableTimer.isActive())
    _ReEnableTimer.stop();
}

/****************************************************************************/
void McalcDialog::DisableEnterButton()
{
  if (_EnterButton->isEnabled())
  {
    _EnterButton->setEnabled(false);
    _ReEnableTimer.start(QMCALC_REENABLE_DURATION);
  }
  else if (!_ReEnableTimer.isActive())
    _ReEnableTimer.start(QMCALC_REENABLE_DURATION);
}

/****************************************************************************/
void McalcDialog::DoPrintCalcScreen()
{
    _Printer->setFullPage( TRUE );

    if ( _Printer->setup(this) )  // printer dialog
    {
        QPainter p;

        if ( !p.begin( _Printer ) )  // paint on printer
            return;

        QPaintDeviceMetrics metrics( p.device() );
        int dpiy = metrics.logicalDpiY();
        int margin = (int) ( (2/2.54)*dpiy ); // 2 cm margins
        QRect body( margin, margin, metrics.width() - 2*margin, metrics.height() - 2*margin );
        QSimpleRichText richText( QStyleSheet::convertFromPlainText(_UserTextEdit->text()),
                                  QFont(),
                                  _UserTextEdit->context(),
                                  _UserTextEdit->styleSheet(),
                                  _UserTextEdit->mimeSourceFactory(),
                                  body.height() );

        richText.setWidth( &p, body.width() );
        QRect view( body );
        int page = 1;

        do
        {
            richText.draw( &p, body.left(), body.top(), view, colorGroup() );
            view.moveBy( 0, body.height() );
            p.translate( 0 , -body.height() );
            p.drawText( view.right() - p.fontMetrics().width( QString::number( page ) ),
                        view.bottom() + p.fontMetrics().ascent() + 5, QString::number( page ) );
            if ( view.top()  >= richText.height() )
                break;
            _Printer->newPage();
            page++;
        }
        while (TRUE);

        p.end();
    }
}

/****************************************************************************/
void McalcDialog::DoPrintFunctionPlotter()
{
    _Plotter->SetThePrinter(_Printer);
    _Plotter->SetToPaintOnPrinter();
}

/****************************************************************************/
void McalcDialog::ShowOutputFile()
{
  // Replace with process execution code
  #if defined(__linux__) | defined(__unix__)
    QString ProgName_ = "calcedit";
  #else
    QString ProgName_ = "calcedit.exe";
  #endif

  QProcess* ProcPtr_;
  QString OutFile_ = _ProgressForm->GetOutputFilename();
  QString InFile_ = _ProgressForm->GetInputFilename();
  
  if (!_InputFilename.length() && InFile_.length())
    _InputFilename = InFile_;
  
  if (!_OutputFilename.length() && OutFile_.length())
    _OutputFilename = OutFile_;
  
  _InputFileInProcess = false;
  ProcPtr_ = new QProcess(this);
  ProcPtr_->addArgument(ProgName_);
  ProcPtr_->addArgument(_InputFilename);
  ProcPtr_->addArgument(_OutputFilename);
  ProcPtr_->setCommunication(QProcess::Stdin | QProcess::Stdout);

  if (!ProcPtr_->start())
  {
    #if defined(__linux__) | defined(__unix__)
      ProgName_ = "./calcedit";
    #else
      ProgName_ = ".\\calcedit.exe";
    #endif
    
    delete ProcPtr_;
    ProcPtr_ = new QProcess(this);
    ProcPtr_->addArgument(ProgName_);
    ProcPtr_->addArgument(InFile_);
    ProcPtr_->addArgument(OutFile_);
    ProcPtr_->setCommunication(QProcess::Stdin | QProcess::Stdout);

    if (!ProcPtr_->start())
    {
      if (_FatalErrCount < QMCALC_MAX_FATAL_ERRORS)
      {
        QMessageBox::critical(0, tr("Fatal Error"),
                                 tr("Could not start external text editor program"),
                                 tr("Quit"));
        _FatalErrCount++;
      }
    }
    else
      _FatalErrCount = 0;
  }
}

/****************************************************************************/
void McalcDialog::StartEditor()
{
  // Replace with process execution code
  #if defined(__linux__) | defined(__unix__)
    QString ProgName_ = "calcedit";
  #else
    QString ProgName_ = "calcedit.exe";
  #endif

  QProcess* ProcPtr_;
  ProcPtr_ = new QProcess(this);
  ProcPtr_->addArgument(ProgName_);
  ProcPtr_->setCommunication(QProcess::Stdin | QProcess::Stdout);

  if (!ProcPtr_->start())
  {
    #if defined(__linux__) | defined(__unix__)
      ProgName_ = "./calcedit";
    #else
      ProgName_ = ".\\calcedit.exe";
    #endif
    
    delete ProcPtr_;
    ProcPtr_ = new QProcess(this);
    ProcPtr_->addArgument(ProgName_);
    ProcPtr_->setCommunication(QProcess::Stdin | QProcess::Stdout);

    if (!ProcPtr_->start())
    {
      if (_FatalErrCount < QMCALC_MAX_FATAL_ERRORS)
      {
        QMessageBox::critical(0, tr("Fatal Error"),
                                 tr("Could not start external text editor program"),
                                 tr("Quit"));
        _FatalErrCount++;
      }
    }
    else
      _FatalErrCount = 0;
  }
}

/****************************************************************************/
void McalcDialog::StartHelpViewer()
{
  // Replace with process execution code
  #if defined(__linux__) | defined(__unix__)
    QString ProgName_ = "viewhelp";
  #else
    QString ProgName_ = "viewhelp.exe";
  #endif

  QProcess* ProcPtr_;
  ProcPtr_ = new QProcess(this);
  ProcPtr_->addArgument(ProgName_);
  ProcPtr_->setCommunication(QProcess::Stdin | QProcess::Stdout);

  if (!ProcPtr_->start())
  {
    #if defined(__linux__) | defined(__unix__)
      ProgName_ = "./viewhelp";
    #else
      ProgName_ = ".\\viewhelp.exe";
    #endif
    
    delete ProcPtr_;
    ProcPtr_ = new QProcess(this);
    ProcPtr_->addArgument(ProgName_);
    ProcPtr_->setCommunication(QProcess::Stdin | QProcess::Stdout);

    if (!ProcPtr_->start())
    {
      if (_FatalErrCount < QMCALC_MAX_FATAL_ERRORS)
      {
        QMessageBox::critical(0, tr("Fatal Error"),
                                 tr("Could not start external help viewer program"),
                                 tr("Quit"));
        _FatalErrCount++;
      }
    }
    else
      _FatalErrCount = 0;
  }
}

/****************************************************************************/
void McalcDialog::StartTwirly()
{
  if (_DoQuitBatchData)
    return;

  bool AllowQuit_ = _BatchDataInput && _AllowBatchQuit;
  int FormerState_ = ++_TwirlyState;

  if (_TwirlyState == 1)
  {
    _TwirlyIncrNum++;
    _SavedScreen = _SavedInput;
    uint len_ = _SavedScreen.length();
    _SavedScreen = _SavedScreen.left(len_ - 1);
    _SavedScreen += AllowQuit_ ? "\\ ":"\\\n";
    _SavedScreen += _QuestionBuffer;
    _PrevBuffer = _SavedScreen;
    _UserTextEdit->setText(_SavedScreen);
    _UserTextEdit->show();
  }
  else if (_TwirlyState == 2)
  {
    _TwirlyIncrNum++;
    _SavedScreen = _SavedInput;
    uint len_ = _SavedScreen.length();
    _SavedScreen = _SavedScreen.left(len_ - 1);
    _SavedScreen += AllowQuit_ ? "| ":"|\n";
    _SavedScreen += _QuestionBuffer;
    _PrevBuffer = _SavedScreen;
    _UserTextEdit->setText(_SavedScreen);
    _UserTextEdit->show();
  }
  else if (_TwirlyState == 3)
  {
    _TwirlyIncrNum++;
    _SavedScreen = _SavedInput;
    uint len_ = _SavedScreen.length();
    _SavedScreen = _SavedScreen.left(len_ - 1);
    _SavedScreen += AllowQuit_ ? "/ ":"/\n";
    _SavedScreen += _QuestionBuffer;
    _PrevBuffer = _SavedScreen;
    _UserTextEdit->setText(_SavedScreen);
    _UserTextEdit->show();
  }
  else if (_TwirlyState == 4)
  {
    _TwirlyIncrNum++;
    _SavedScreen = _SavedInput;
    uint len_ = _SavedScreen.length();
    _SavedScreen = _SavedScreen.left(len_ - 1);
    _SavedScreen += AllowQuit_ ? "- ":"-\n";
    _SavedScreen += _QuestionBuffer;
    _PrevBuffer = _SavedScreen;
    _UserTextEdit->setText(_SavedScreen);
    _UserTextEdit->show();
    _TwirlyState = 0;
  }
  else
    _TwirlyState = 0;

  if (1 <= FormerState_ && FormerState_ <= 4)
  {
    // resend graph signal fetched acknowledgement response if there is
    // no corresponding response signal received from the server
  
    if ((_SendGraphResponse == ResponseSignal::SEND_GRAPHPROGRESSFETCHED) ||
        (_PrevGraphResponse == ResponseSignal::SEND_GRAPHPROGRESSFETCHED &&
         _TwirlyIncrNum > 1 && _TwirlyIncrNum % 2))
    {
      _UserTextEdit->update();
      _UserTextEdit->repaint();

      _PrevGraphResponse = _SendGraphResponse;
      _SendGraphResponse = 0;
      _Driver->SendGraphProgressFetched();
    }
    else if ((_SendGraphResponse == ResponseSignal::SEND_GRAPHWAITFETCHED) ||
             (_PrevGraphResponse == ResponseSignal::SEND_GRAPHWAITFETCHED &&
              _TwirlyIncrNum > 1 && _TwirlyIncrNum % 2))
    {
      #if MCALCDIALOG_DEBUG2d
        _Driver->DbgPtr()->EnterLevel("StartTwirly -- else if (_SendGraphResponse...");
        
        _Driver->DbgPtr()->ShowInt(_DoContinuePlot, "_DoContinuePlot");
        _Driver->DbgPtr()->ShowInt(_BatchDataInput, "_BatchDataInput");
        _Driver->DbgPtr()->ShowInt(_AllowBatchQuit, "_AllowBatchQuit");
        _Driver->DbgPtr()->ShowInt(_NumGraphPlotDone, "_NumGraphPlotDone");
        _Driver->DbgPtr()->ShowStr(_Driver->IoStateToStr(_Driver->IoState()), "IoState()");

        _Driver->DbgPtr()->ShowInt(_TwirlyState, "_TwirlyState");
        _Driver->DbgPtr()->ShowInt(_TwirlyIncrNum, "_TwirlyIncrNum");
        _Driver->DbgPtr()->ShowInt(_SendGraphResponse, "_SendGraphResponse");
        _Driver->DbgPtr()->ShowInt(_PrevGraphResponse, "_PrevGraphResponse");
      #endif
    
      _UserTextEdit->update();
      _UserTextEdit->repaint();

      if (!_BatchDataInput || !_AllowBatchQuit ||
          _NumGraphPlotDone == 0 || _DoContinuePlot)
      {
        if (_DoContinuePlot == 1)
        {
          _DoContinuePlot++;
          _TwirlyTimer.start(QMCALC_TWIRLY_INTERVAL);
        }

        _PrevGraphResponse = _SendGraphResponse;
        _SendGraphResponse = 0;
        _Driver->SendGraphWaitFetched();
      }
      else
        _TwirlyTimer.stop();

      #if MCALCDIALOG_DEBUG2d
        _Driver->DbgPtr()->LeaveLevel();
      #endif
    }
  }
}

/****************************************************************************/
void McalcDialog::BuildCombinedCharStr(const QString& Entry_)
{
    int x;
    int max = Entry_.length();
    _CmdHistoryPos = -1;
    _CmdHistoryEntryLength = 0;

    for (x = 0; x < max; x++)
      ShowHistoryEntry(QString(Entry_[x]));
    
    if (_CmdHistoryEntryLength > 0)
    {
      _CmdEraseConfirmed = false;
      _CmdEraseValid = true;
    }
}

/****************************************************************************/
void McalcDialog::ShowHistoryEntry(const QString& Entry_)
{
        int x;
        bool DoReshow_ = false;

        if (_CurPos < _Index)
        {
          DoReshow_ = true;
          for (x = _Index; x > _CurPos; x--)
            _InputArray[x] = _InputArray[x - 1];
        }

        if (_CurPos == 0)
        {
          _EvalMode = true;
          _EvalPos = _UserTextEdit->text().length();
        }

        _Index++;
        _InputArray[_CurPos] = new ButtonInfo;
        _InputArray[_CurPos]->_Command = strcpy(new char[Entry_.length() + 1], Entry_.ascii());
        _InputArray[_CurPos]->_Length = Entry_.length();
        _InputArray[_CurPos]->_UserDefined = true;
        _InputArray[_CurPos]->_CombinedCharStr = true;

        if (_CmdHistoryPos < 0)
        {
          _CmdHistoryPos = _CurPos;
          ++_CmdHistoryEntryLength;
        }
        else if (_CmdHistoryEntryLength > 0)
          ++_CmdHistoryEntryLength;

        if (DoReshow_)
        {
          ReShowOutput();
          _CurPos++;
        }
        else
        {
          _InputBuffer = QString(_InputArray[_CurPos]->_Command);
          _UserTextEdit->setText(_UserTextEdit->text() + _InputBuffer);
          _UserTextEdit->scrollToBottom();
          _UserTextEdit->moveCursor(QTextEdit::MoveEnd, false);
          _UserTextEdit->show();
          _InputBuffer = QString("");
          _CurPos = _Index;
        }
}

/****************************************************************************/
void McalcDialog::ShowVar( const QString& Var_ )
{
        int x;
        bool DoReshow_ = false;

        if (_CurPos < _Index)
        {
          DoReshow_ = true;
          for (x = _Index; x > _CurPos; x--)
            _InputArray[x] = _InputArray[x - 1];
        }

        if (_CurPos == 0)
        {
          _EvalMode = true;
          _EvalPos = _UserTextEdit->text().length();
        }

        _Index++;
        _InputArray[_CurPos] = new ButtonInfo;
        _InputArray[_CurPos]->_Command = strcpy(new char[Var_.length() + 1], Var_.ascii());
        _InputArray[_CurPos]->_Length = Var_.length();
        _InputArray[_CurPos]->_UserDefined = true;
        _InputArray[_CurPos]->_CombinedCharStr = false;

        if (DoReshow_)
        {
          ReShowOutput();
          _CurPos++;
        }
        else
        {
          _InputBuffer = QString(_InputArray[_CurPos]->_Command);
          _UserTextEdit->setText(_UserTextEdit->text() + _InputBuffer);
          _UserTextEdit->scrollToBottom();
          _UserTextEdit->moveCursor(QTextEdit::MoveEnd, false);
          _UserTextEdit->show();
          _InputBuffer = QString("");
          _CurPos = _Index;
        }
}

/****************************************************************************/
void McalcDialog::ChangeMode( const QString& Mode_ )
{
  QString ModeStr_ = QString("mode=") + Mode_;
  QString NullHistCmd_ = QString("cmdhistoryentry(cancel): ");
  
  if (_CmdHistoryForm->CmdFileFinished() &&
      _CmdHistoryEntryFound && _CmdHistoryForm->GiveCmdHistoryEntry())
  {            
    _CmdHistoryEntryFound = false;
    ModeStr_ = NullHistCmd_ + ModeStr_;
  }

  _ResponseFromInput = false;
  _Driver->SendUserResponse(ModeStr_);
}

/****************************************************************************/
void McalcDialog::ChangePrec( const QString& Prec_ )
{
  QString PrecStr_;
  QString NullHistCmd_ = QString("cmdhistoryentry(cancel): ");
  
  if (Prec_ == QString("Float (7-digit)"))
    PrecStr_ = QString("precision=float");
  else if (Prec_ == QString("Double (15-digit)"))
    PrecStr_ = QString("precision=double");
  else if (Prec_ == QString("Long Double (19-digit)"))
    PrecStr_ = QString("precision=longdouble");
  else if (Prec_ == QString("Long Number"))
    PrecStr_ = QString("precision=longnum");
  
  if (_CmdHistoryForm->CmdFileFinished() && PrecStr_.length() &&
      _CmdHistoryEntryFound && _CmdHistoryForm->GiveCmdHistoryEntry())
  {
    _CmdHistoryEntryFound = false;
    PrecStr_ = NullHistCmd_ + PrecStr_;
  }
  
  if (PrecStr_.length())
  {
    _ResponseFromInput = false;
    _Driver->SendUserResponse(PrecStr_);
  }
}

/****************************************************************************/
void McalcDialog::ShowExecEntry(const QString& Entry_, int& ExecCmdEntryLength_)
{
        int x;
        int ExecLen_ = ::strlen("EXEC ") + Entry_.length();
        char* ExecCmd_ = strcpy(new char[ExecLen_ + 1], "EXEC ");
                         strcat(ExecCmd_, Entry_.ascii());
        bool DoReshow_ = false;

        if (_ExecCmdPos < 0)
        {
          _ExecCmdPos = _CurPos;
          ExecCmdEntryLength_ = ExecCmd_ ? ::strlen(ExecCmd_):0;
  
          if (!ExecCmdEntryLength_ || ExecCmdEntryLength_ != ExecLen_)
          {
            ExecCmdEntryLength_ = -1;
            return;
          }
        }
        else
          return;

        if (_CurPos < _Index)
        {
          DoReshow_ = true;
          for (x = _Index; x > _CurPos; x--)
            _InputArray[x] = _InputArray[x - 1];
        }

        if (_CurPos == 0)
        {
          _EvalMode = true;
          _EvalPos = _UserTextEdit->text().length();
        }
        
        _Index++;
        _InputArray[_CurPos] = new ButtonInfo;
        _InputArray[_CurPos]->_Command = ExecCmd_;
        _InputArray[_CurPos]->_Length = ExecLen_;
        _InputArray[_CurPos]->_UserDefined = true;
        _InputArray[_CurPos]->_CombinedCharStr = false;

        if (DoReshow_)
        {
          ReShowOutput();
          _CurPos++;
        }
        else
        {
          _InputBuffer = QString(_InputArray[_CurPos]->_Command);
          _UserTextEdit->setText(_UserTextEdit->text() + _InputBuffer);
          _UserTextEdit->scrollToBottom();
          _UserTextEdit->moveCursor(QTextEdit::MoveEnd, false);
          _UserTextEdit->show();
          _InputBuffer = QString("");
          _CurPos = _Index;
        }
}

/****************************************************************************/
void McalcDialog::ShowPrgExecEntry(const QString& PrgName_)
{
    int dot;
    int max = PrgName_.length();    
    int ExecCmdEntryLength_ = 0;
    bool HasOption_ = false;
    
    QString FileExt_;
    QString LwFileExt_;
    QString PrgExecStr_;
    
    _ExecCmdPos = -1;
    dot = PrgName_.find(QChar('.'));
    
    if (dot > 0)
    {
      FileExt_ = PrgName_.mid(dot+1);
      LwFileExt_ = FileExt_.lower();
    }
   
    if ((0 < dot && dot < max-1) && (LwFileExt_ == QString("in") || LwFileExt_ == QString("prg")))
    {      
      _ExecPrgName = _ExecPrgForm->IsCalcProgFile() ? PrgName_.left(dot):PrgName_;
      HasOption_ = _ExecPrgForm->IsCalcTestFile() &&
                   _ExecPrgForm->HasExecScriptOption() && _ExecPrgForm->OptionString();
      
      if (HasOption_)
        _ExecPrgOption = _ExecPrgForm->OptionString();
      else
        _ExecPrgOption = "";
      
      max = ::strlen("EXEC ");
      max += _ExecPrgName.length();
      
      if (HasOption_)
      {
        ++max;
        max += _ExecPrgOption.length();
        PrgExecStr_ = _ExecPrgName + QString(",");
        PrgExecStr_ += _ExecPrgOption;
      }
      else
        PrgExecStr_ = _ExecPrgName;
      
      ShowExecEntry(PrgExecStr_, ExecCmdEntryLength_);
      
      if (ExecCmdEntryLength_ != max)
      {
        _ExecCmdPos = -1;
        _ExecPrgName = QString("");
        _ExecPrgOption = QString("");
      }
    }
}

/****************************************************************************/
void McalcDialog::ShowPrgExecDialog()
{
  const char* EntryPtr_ = NULL;
  QString ExecPrgEntry_;
  
  if (_ExecPrgCalled && !_ExecPrgLoading)
  {
    _ExecPrgCalled = false;
    _ExecPrgLoading = true;
    _ExecPrgForm->LoadToTable(false, "", true, ".");
    _ExecPrgEntryFound = _ExecPrgForm->exec() == QDialog::Accepted;
    _ExecPrgEntryFound = _ExecPrgEntryFound ||
                         _ExecPrgForm->GiveRetCode() == QDialog::Accepted;
    
    if (_ExecPrgEntryFound)
    {
      EntryPtr_ = _ExecPrgForm->GiveCalcScriptEntry();
      
      if (EntryPtr_)
      {
        ExecPrgEntry_ = EntryPtr_;
        ShowPrgExecEntry(ExecPrgEntry_);
      }
    }
    else
    {
      if (!_ExecPrgForm->ScriptFileFinished() && _ExecPrgForm->GiveRetCode() != QDialog::Rejected)
        QMessageBox::information(0, QString(tr("Calculator Script List Empty")),
          QString(tr("\nNo Calculator Script Entries\n")),
          QMessageBox::Ok);
    }
    
    _ExecPrgLoading = false;
    _ExecPrgCalled = false;    
  }
}

/****************************************************************************/
void McalcDialog::HandleButton( int Id_ )
{
  const char* sptr = NULL;

  switch (Id_)
  {
    case ButtonId::PRINT:
      _PrintForm->show();
      break;

    case ButtonId::BREAK:
      SendBreak();
      break;

    case ButtonId::QUIT:
      SendQuit();
      break;

    case ButtonId::HISTORY:
      SendHistoryEntry();
      break;

    case ButtonId::EDIT:
      StartEditor();
      break;
      
    case ButtonId::EXEC:
      if (!_ExecPrgCalled && !_ExecPrgLoading)
      {      
        _ExecPrgCalled = true;
        ShowPrgExecDialog();
      }
      break;

    case ButtonId::CLEARGRAPH:
      ClearTraceMode();
      ProcessButton(Id_);
      break;

    case ButtonId::GRAPH:
      ClearTraceMode();
      ProcessButton(Id_);
      break;

    case ButtonId::HELP:
      StartHelpViewer();
      break;

    case ButtonId::DEL:
      DeleteEntry(true);
      break;

    case ButtonId::CLEAR:
      _EvalMode = false;
      _CmdEraseValid = false;
      _InputBuffer = "";
      _UserTextEdit->clear();
      _UserTextEdit->show();
      _CurPos =
      _Index = 0;

      if (_InputArray[0] && _InputArray[0]->_UserDefined)
      {
        delete[] _InputArray[0]->_Command;
        delete _InputArray[0];
      }
      
      _InputArray[0] = NULL;
      ClearTraceMode();
      break;

    case ButtonId::TRACE:
      if (!_TraceMode)
        EnterTraceMode();
      else
        GetNextCurve();
      break;

    case ButtonId::ENTER:
      #if MCALCDIALOG_DEBUG1b
        QMessageBox::warning(0, "DEBUG HandleButton",
                             QString("\nEntering HandleButton(int)"),
                             QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
      #endif

      if (!_TraceMode)
      {
        _RecurseLimitGuard = 0;
        sptr = _InputBuffer.ascii();
        _DoQuitBatchData = _DoQuitBatchData && sptr &&
                           ::strlen(sptr) == 1 && toupper(sptr[0]) == 'Q';
        
        SendToInput();
      }
      else
      {
        _EndToTrace *= -1;
        if (_EndToTrace < 0)
          SetTracePtToEnd();
        else
          SetTracePtToStart();
      }
      break;

    default:
      ProcessButton(Id_);
      break;
  }
}

/****************************************************************************/
void McalcDialog::keyPressEvent(QKeyEvent *event)
{
  const char* sptr = NULL;

  if (_TraceMode)
  {
    switch (event->key())
    {
      // toggle between graph endpoints
      case Key_Enter:
        _EndToTrace *= -1;
        if (_EndToTrace < 0)
          SetTracePtToEnd();
        else
          SetTracePtToStart();
        break;

      default:
        QWidget::keyPressEvent(event);
    }
  }
  else
  {
    #if MCALCDIALOG_DEBUG1b
      QMessageBox::warning(0, "DEBUG KeyPressEvent(QKeyEvent*)",
                           QString("\nEntering KeyPressEvent(QKeyEvent*)"),
                           QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
    #endif

    if (event->key() == Key_Enter)
    {
      _RecurseLimitGuard = 0;
      sptr = _InputBuffer.ascii();
      _DoQuitBatchData = _DoQuitBatchData && sptr &&
                         ::strlen(sptr) == 1 && toupper(sptr[0]) == 'Q';
      
      SendToInput();
    }
    else
      QWidget::keyPressEvent(event);
  }
}

/****************************************************************************/
void McalcDialog::MoveToEnd()
{
  _UserTextEdit->scrollToBottom();
  _UserTextEdit->moveCursor(QTextEdit::MoveEnd, false);
  _UserTextEdit->show();
  _CurPos = _Index;
}

/****************************************************************************/
void McalcDialog::ProcessButton(int Id_)
{
  if (_CurPos == _Index)
  {
    _CmdEraseValid = false;
    _InputArray[_Index++] = _Buttons[Id_];
    _InputBuffer = QString(_Buttons[Id_]->_Command);
    _UserTextEdit->setText(_UserTextEdit->text() + _InputBuffer);
    _UserTextEdit->scrollToBottom();
    _UserTextEdit->moveCursor(QTextEdit::MoveEnd, false);
    _UserTextEdit->show();
    _InputBuffer = QString("");
    _CurPos = _Index;
  }
  else if (_CurPos < _Index)
  {
    int x;
    for (x = _Index; x > _CurPos; x--)
      _InputArray[x] = _InputArray[x - 1];

    _CmdEraseValid = false;
    _Index++;
    _InputArray[_CurPos] = _Buttons[Id_];
    ReShowOutput();
    _CurPos++;
  }
}

/****************************************************************************/
void McalcDialog::ReShowOutput()
{
  int x;
  int Para_, Index_;

  _InputBuffer = "";
  for (x = 0; x < _Index; x++)
    _InputBuffer += QString(_InputArray[x]->_Command);

  _UserTextEdit->getCursorPosition(&Para_, &Index_);
  _UserTextEdit->setText(_SavedScreen + _InputBuffer);
  _UserTextEdit->setCursorPosition(Para_, Index_);
  int Length_ = _InputArray[_CurPos] ? _InputArray[_CurPos]->_Length:0;

  for (x = 0; x < Length_; x++)
    _UserTextEdit->moveCursor(QTextEdit::MoveForward, false);

  _InputBuffer = QString("");
  _UserTextEdit->show();
}

/****************************************************************************/
/*****************************************************************************
  Process step-through of how GRAPH_WAIT process works:
  
  // orginal code from from SendToInput method:
  CutInput();
  _SavedScreen += GRAPH_HELP_MSG;
  _SavedInput = _SavedScreen;      // Everything before user typed graph command
  _SavedScreen += "\n";
  _SavedScreen += _InputBuffer;    // graph deriv2(cube(x)-3*sqr(x)+4/3,x,0)
  _QuestionBuffer = _InputBuffer;  // graph deriv2(cube(x)-3*sqr(x)+4/3,x,0)
  _UserTextEdit->setText(_SavedScreen);

  // original code from WaitForGraphOutput method:
  _GraphResult = GraphPlotOpType::BATCH_GRAPH_PLOT;
  _PrevBuffer = _SavedScreen;
  _SavedScreen += GRAPH_HELP_MSG2;
  _SavedInput = _SavedScreen;
  _QuestionBuffer = "";
  _UserTextEdit->setText(_SavedScreen);

// SendToInput example start:
  # Use the arrow keys or mouse wheel to scroll the graph
  # Use the + - keys to zoom in or out
  # selecting a rectangle with the mouse zooms in on the specified region
  # Plotting data points for function graph. Please wait...   0% -
  graph deriv2(cube(x)-3*sqr(x)+4/3,x,0)

// note: graph deriv2(cube(x)-3*sqr(x)+4/3,x,0) is stored in the question
// buffer and will be appended to _SavedScreen after the twirly char change.
// The twirly graphic will change, but everything else remains unaffected.
// example end:

// WaitForGraphOutput example start:
  fact(5)
   = 120
  # Plotting data points for function graph. Please wait...   0% -

// note: no input is saved when calculator is in input file batch processing
// mode, so no user commands is appended after the graph help message is
// assigned to _SavedScreen. The twirly graph will change, but nothing else
// is appended to the help message after the change. Question buffer is blank.
// example end:

  _TwirlyState = 0;
  _TwirlyTimer.start(QMCALC_TWIRLY_INTERVAL);

// StartTwirly method code start:
    _SavedScreen = _SavedInput;
    uint len_ = _SavedScreen.length();
    _SavedScreen = _SavedScreen.left(len_ - 1); // move back 1 spc to twirly char
    _SavedScreen += "\\\n";                     // alter twirly char
    _SavedScreen += _QuestionBuffer;            // show original question
    _UserTextEdit->setText(_SavedScreen);
// StartTwirly method code end:

  _Driver->SendGraphWaitFetched();

*****************************************************************************/
void McalcDialog::WaitForGraphOutput()
{
  #if MCALCDIALOG_DEBUG2a
    QMessageBox::warning(0, "DEBUG Entering WaitForGraphOutput",
                         QString("\nEntering WaitForGraphOutput"),
                         QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
  #elif MCALCDIALOG_DEBUG2d
    _Driver->DbgPtr()->EnterLevel("WaitForGraphOutput");
  #endif

  if (_SendGraphResponse == ResponseSignal::SEND_GRAPHPROGRESSFETCHED)
  {
    _UserTextEdit->update();
    _UserTextEdit->repaint();

    _PrevGraphResponse = _SendGraphResponse;
    _SendGraphResponse = 0;
    _Driver->SendGraphProgressFetched();
  }
  else if (_SendGraphResponse == ResponseSignal::SEND_GRAPHWAITFETCHED)
  {
    _UserTextEdit->update();
    _UserTextEdit->repaint();

    _PrevGraphResponse = _SendGraphResponse;
    _SendGraphResponse = 0;
    _Driver->SendGraphWaitFetched();
  }

  QString Gptype_;
  QString GraphTypeFile_ = QString("mcalc_graphoper") +
                           QString::number(_Driver->SessionNum()) +
                           QString(".dat");
  QFile gptypefile(GraphTypeFile_);

  if (gptypefile.open(IO_ReadOnly))
  {
    // Structure of graph operation file:
    // 1st line, 1st integer value: Graph plotting operation type
    //   One of:
    //     FUNCTION_PLOT    = 1, // straight function plot of math expression
    //     APPLIED_FNCGRAPH = 2, // extra applied functions: deriv, integ, etc...
    //     BATCH_GRAPH_PLOT = 3  // batch input of graph operations
    //
    // 2nd line, 2nd integer value: graph type:
    //   One of:
    //     FUNCTION   = 1,
    //     EXTREMA    = 2,
    //     DERIVATIVE = 3,
    //     INTEGRAL   = 4,
    //     ROOTSOLVE  = 5,
    //     INTERSECT1 = 6,
    //     INTERSECT2 = 7,
    //
    // 3rd line, 3rd integer value: graph subtype:
    //   One of:
    //     MIN_EXTREMA  = 101,
    //     MAX_EXTREMA  = 102,
    //     FIRST_DERIV  = 201,
    //     SECOND_DERIV = 202
    //
    // 4th line, 4th integer value: allow quit of batch data file processing
    //   One of:
    //     0 : No quitting of batch data file allowed
    //     1 : Quitting of batch data file processing allowed
    //
  
    QTextStream Gptin(&gptypefile);

    // 1st value: retrieving graph plotting operation value
    Gptype_ = Gptin.readLine();
    Gptype_ = Gptype_.stripWhiteSpace();
    _GraphResult = Gptype_.toInt();

    // 2nd value: retrieving graph type value
    Gptype_ = Gptin.readLine();
    Gptype_ = Gptype_.stripWhiteSpace();
    _GraphType = Gptype_.toInt();

    // 4th value: retrieving allow quit of batch data file processing
    Gptype_ = Gptin.readLine();
    Gptype_ = Gptin.readLine();
    Gptype_ = Gptype_.stripWhiteSpace();
    _AllowBatchQuit = Gptype_.toInt() != 0;

    gptypefile.close();

    #if MCALCDIALOG_DEBUG2d
      _Driver->DbgPtr()->ShowInt(_GraphType, "_GraphType");
      _Driver->DbgPtr()->ShowInt(_GraphResult, "_GraphResult");
    #endif
  }
  
  bool BatchInput_ = _GraphResult == GraphPlotOpType::BATCH_GRAPH_PLOT;
  bool GraphCmdEntry_ = (_GraphResult == GraphPlotOpType::FUNCTION_PLOT ||
                         _GraphResult == GraphPlotOpType::APPLIED_FNCGRAPH) &&
                        _GraphType != GraphType::NO_GRAPH;

  #if MCALCDIALOG_DEBUG2d
    _Driver->DbgPtr()->ShowInt(BatchInput_, "BatchInput_");
    _Driver->DbgPtr()->ShowInt(GraphCmdEntry_, "GraphCmdEntry_");
  #endif

  if (BatchInput_)
  {
    _PrevBuffer = "";
    _GraphResult = GraphPlotOpType::BATCH_GRAPH_PLOT;
    _PrevBuffer = _SavedScreen;
    _SavedScreen += GRAPH_HELP_MSG2;
    _SavedInput = _SavedScreen;
    _QuestionBuffer = "";
    _BatchDataInput = true;
  }
  else if (GraphCmdEntry_)
  {
    CutInput();
    _SavedScreen += GRAPH_HELP_MSG;
    _SavedInput = _SavedScreen;
    _SavedScreen += "\n";
    _SavedScreen += _InputBuffer;
    _QuestionBuffer = _InputBuffer;
    _BatchDataInput = false;
  }

  if (BatchInput_ || GraphCmdEntry_)
  {
    _UserTextEdit->setText(_SavedScreen);
    _UserTextEdit->show();
    _UserTextEdit->update();
    _UserTextEdit->repaint();
    
    // Graph-Wait-Fetched signal sent after twirly timer has timed out
    // rather than sent immediately so progress animation graphic is shown
    //
    //   _Driver->SendGraphWaitFetched();
    //
    // Above method call refactored to be executed before the start of this
    // method or in the StartTwirly method
    //
    _TwirlyState = 0;
    _TwirlyIncrNum = 0;
    _SendGraphResponse = ResponseSignal::SEND_GRAPHWAITFETCHED;  // new
    _PrevGraphResponse = 0;

    _DoContinuePlot = 0;
    _DoQuitBatchData = false;
    
    _TwirlyTimer.start(QMCALC_TWIRLY_INTERVAL);

    #if MCALCDIALOG_DEBUG2d
      _Driver->DbgPtr()->LeaveLevel();
    #elif MCALCDIALOG_DEBUG2a
      QMessageBox::warning(0, "DEBUG Leaving WaitForGraphOutput",
                           QString("\nLeaving WaitForGraphOutput"),
                           QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
    #endif

    // _Driver->SendGraphWaitFetched();
  }
  #if MCALCDIALOG_DEBUG2d
    else
      _Driver->DbgPtr()->LeaveLevel();
  #elif MCALCDIALOG_DEBUG2a
    else
      QMessageBox::warning(0, "DEBUG Leaving WaitForGraphOutput",
                           QString("\nLeaving WaitForGraphOutput"),
                           QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
  #endif
}

/****************************************************************************/
void McalcDialog::WaitForGraphProgress()
{
  #if MCALCDIALOG_DEBUG2c
    QMessageBox::warning(0, "DEBUG Entering WaitForGraphProgress",
                         QString("\nEntering WaitForGraphProgress"),
                         QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
  #elif MCALCDIALOG_DEBUG2d
    _Driver->DbgPtr()->EnterLevel("WaitForGraphProgress");
  #endif

  if (_SendGraphResponse == ResponseSignal::SEND_GRAPHPROGRESSFETCHED)
  {
    _UserTextEdit->update();
    _UserTextEdit->repaint();

    _PrevGraphResponse = _SendGraphResponse;
    _SendGraphResponse = 0;
    _Driver->SendGraphProgressFetched();
  }
  else if (_SendGraphResponse == ResponseSignal::SEND_GRAPHWAITFETCHED)
  {
    _UserTextEdit->update();
    _UserTextEdit->repaint();

    _PrevGraphResponse = _SendGraphResponse;
    _SendGraphResponse = 0;
    _Driver->SendGraphWaitFetched();
  }

  bool BatchInput_ = _GraphResult == GraphPlotOpType::BATCH_GRAPH_PLOT;
  bool GraphCmdEntry_ = (_GraphResult == GraphPlotOpType::FUNCTION_PLOT ||
                         _GraphResult == GraphPlotOpType::APPLIED_FNCGRAPH) &&
                        _GraphType != GraphType::NO_GRAPH;

  if (BatchInput_ || GraphCmdEntry_)
    _TwirlyTimer.stop();
  else
    return;

  int colon = 0;
  int slash = 0;
  int numer = 0;
  int denom = 0;  
  int pct = 0;
  double fltpct = 0;

  QString TempStr_;
  QString GpProgress_ = "0";
  QString GraphProgressFile_ = QString("mcalc_graphprogress") +
                           QString::number(_Driver->SessionNum()) +
                           QString(".dat");
  QFile gpprogressfile(GraphProgressFile_);

  if (gpprogressfile.open(IO_ReadOnly))
  {
    QTextStream Gppin(&gpprogressfile);

    GpProgress_ = Gppin.readLine();
    GpProgress_ = GpProgress_.stripWhiteSpace();
    colon = GpProgress_.find(':');
    slash = GpProgress_.find('/');
    
    if (slash > 0 && colon > 0)
    {
      TempStr_ = GpProgress_;
      TempStr_ = TempStr_.mid(colon+1, slash-colon-1);
      numer = TempStr_.toInt();

      TempStr_ = GpProgress_;
      TempStr_ = TempStr_.mid(slash+1);
      denom = TempStr_.toInt();

      if (denom == 100)
        pct = numer;
      else if (denom > 0)
      {
        fltpct = double(numer) / denom;
        fltpct *= 100;
        fltpct += .5;
        
        pct = ::floor(fltpct);
      }
      
      GpProgress_ = QString::number(pct);

      #if MCALCDIALOG_DEBUG2d
        _Driver->DbgPtr()->ShowInt(BatchInput_, "BatchInput_");
        _Driver->DbgPtr()->ShowInt(GraphCmdEntry_, "GraphCmdEntry_");
      
        _Driver->DbgPtr()->ShowInt(numer, "numer");
        _Driver->DbgPtr()->ShowInt(denom, "denom");
        _Driver->DbgPtr()->ShowInt(pct, "pct");
      #endif
    }

    gpprogressfile.close();
  }

  QString SavedChar_;
  _SavedScreen = _SavedInput;
  uint len_ = _SavedScreen.length();
  
  SavedChar_ = (_TwirlyState == 1) ? '\\':
               (_TwirlyState == 2) ? '|':
               (_TwirlyState == 3) ? '/':
               (_TwirlyState == 0) ? '-':0;

  if (!SavedChar_)
    SavedChar_ = _SavedScreen.mid(len_ - 1);

  _SavedScreen = _SavedScreen.left(len_ - 6);
  uint pctslen_ = GpProgress_.length();
  
  if (pctslen_ < 3)
    _SavedScreen += QString(" ");
  
  if (pctslen_ < 2)
    _SavedScreen += QString(" ");

  _SavedScreen += (slash > 0 && colon > 0 && denom > 0) ? GpProgress_:
                                                          QString("0");
  _SavedScreen += QString("% ");
  _SavedScreen += SavedChar_;
  _SavedInput = _SavedScreen;

  if (BatchInput_)
  {
    _GraphResult = GraphPlotOpType::BATCH_GRAPH_PLOT;
    _QuestionBuffer = "";
  }
  else if (GraphCmdEntry_)
  {
    _SavedScreen += "\n";
    _SavedScreen += _QuestionBuffer;
  }

  _UserTextEdit->setText(_SavedScreen);
  _UserTextEdit->show();
  _UserTextEdit->update();
  _UserTextEdit->repaint();

  // Graph-Progress-Fetched signal sent after twirly timer has timed out
  // rather than sent immediately so progress animation graphic is shown
  //
  //   _Driver->SendGraphProgressFetched();
  //
  // Above method call refactored to be executed before the start of this
  // method or in the StartTwirly method
  //
  if (!(0 <= _TwirlyState && _TwirlyState <= 3))
    _TwirlyState = 0;

  _TwirlyIncrNum = 0;
  _SendGraphResponse = ResponseSignal::SEND_GRAPHPROGRESSFETCHED;  // new
  _PrevGraphResponse = 0;
  _TwirlyTimer.start(QMCALC_TWIRLY_INTERVAL);

  #if MCALCDIALOG_DEBUG2d
    _Driver->DbgPtr()->LeaveLevel();
  #elif MCALCDIALOG_DEBUG2c
    QMessageBox::warning(0, "DEBUG Leaving WaitForGraphProgress",
                         QString("\nLeaving WaitForGraphProgress"),
                         QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
  #endif

  // _Driver->SendGraphProgressFetched();
}

/****************************************************************************/
void McalcDialog::FetchAndGraphOutput()
{
  #if MCALCDIALOG_DEBUG2a
    QMessageBox::warning(0, "DEBUG Entering FetchAndGraphOutput",
                         QString("\nEntering FetchAndGraphOutput"),
                         QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
  #elif MCALCDIALOG_DEBUG2d
    _Driver->DbgPtr()->EnterLevel("FetchAndGraphOutput");
  #endif

  _InputRequest = false;
  _InputRequestDetected = false;
  _CalcResponseSignal = false;
  _CalcResponseDetected = false;

  _GraphResponse = true;
  _ExpectedStatesHandled = true;
  _ExpectedStatesReceived = false;
  _ResponseFromInput = true;
  _NewlineAppended = false;
  _SignalHandled = 0;
  
  _EnterButton->setEnabled(true);
  _ReEnableTimer.stop();
  
  ShowOutput();

  #if MCALCDIALOG_DEBUG2d
    _Driver->DbgPtr()->LeaveLevel();
  #endif

  _Driver->SendOutputFetched(&_ExpectedStatesReceived);

  #if MCALCDIALOG_DEBUG2a
    QMessageBox::warning(0, "DEBUG Leaving FetchAndGraphOutput",
                         QString("\nLeaving FetchAndGraphOutput"),
                         QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
  #endif
}

/****************************************************************************/
void McalcDialog::FetchProgress()
{
  #if MCALCDIALOG_DEBUG2d
    _Driver->DbgPtr()->EnterLevel("FetchProgress");
    _Driver->DbgPtr()->ShowMessage("_InputFileInProcess = true;\n");
    _Driver->DbgPtr()->ShowMessage("_Driver->FetchProgressData();\n");
    _Driver->DbgPtr()->ShowMessage("_Driver->SendProgressReady();\n");
  #endif

  _InputFileInProcess = true;
  _Driver->FetchProgressData();
  _Driver->SendProgressReady();

  #if MCALCDIALOG_DEBUG2d
    _Driver->DbgPtr()->LeaveLevel();
  #endif
}

/****************************************************************************/
void McalcDialog::AckNewMcalc()
{
  #if MCALCDIALOG_DEBUG2d
    _Driver->DbgPtr()->EnterLevel("AckNewMcalc");
    _Driver->DbgPtr()->ShowMessage("_ExpectedStatesHandled = true;\n");
    _Driver->DbgPtr()->ShowMessage("_ResponseFromInput = true;\n");
    _Driver->DbgPtr()->ShowMessage("_EnterButton->setEnabled(true);\n");
    _Driver->DbgPtr()->ShowMessage("_Driver->SendMcalcSpawned();\n");
  #endif

  _InputRequest = false;
  _InputRequestDetected = false;
  _CalcResponseSignal = false;
  _CalcResponseDetected = false;

  _ExpectedStatesHandled = true;
  _ExpectedStatesReceived = false;
  _ResponseFromInput = true;
  
  _SignalHandled = Mcalc_IOState::MCALC_SPAWNED;
  _EnterButton->setEnabled(true);
  _ReEnableTimer.stop();
  _Driver->SendMcalcSpawned(&_ExpectedStatesReceived);

  #if MCALCDIALOG_DEBUG2d
    _Driver->DbgPtr()->LeaveLevel();
  #endif
}

/****************************************************************************/
void McalcDialog::FetchOutput()
{
  int x;
  bool AppendNl_ = false;
  bool WasProcessing_ = !_Driver->InBatchFile() &&
                        _Processing && _Index && _InputArray[0];

  const char* sptr = NULL;
  int slen = 0;
  
  QString CalcOut_ = _Driver->_Output->text();
  QString BackLog_;

  sptr = _SavedScreen.ascii();
  slen = sptr ? ::strlen(sptr):0;
  
  for (--slen; slen >= 0; slen--)
  {
    AppendNl_ = !isspace(sptr[slen]);
    if (AppendNl_ || sptr[slen] == '\n')
      break;
  }

  if (CalcOut_.length())
  {
    // Backlog commmands processing...
    if (WasProcessing_)
    {
      _InputBuffer = "";
      for (x = 0; x < _Index; x++)
        _InputBuffer += QString(_InputArray[x]->_Command);

      BackLog_ = _InputBuffer = _InputBuffer.stripWhiteSpace();
      CutInput();
      _UserTextEdit->setText(_SavedScreen);
    }

    _SavedScreen = _UserTextEdit->text();
    
    if (_SavedScreen.length() > 0 && AppendNl_)
      _SavedScreen += "\n";
    
    _SavedScreen += CalcOut_;
    _SavedScreen += "\n";

    _UserTextEdit->setText(_SavedScreen);
    MoveToEnd();

    _InputRequest = false;
    _InputRequestDetected = false;
    _CalcResponseSignal = false;
    _CalcResponseDetected = false;
    
    _ExpectedStatesHandled = true;
    _ExpectedStatesReceived = false;
    _ResponseFromInput = true;
    _SignalHandled = Mcalc_IOState::OUTPUT_READY;

    #if MCALCDIALOG_DEBUG2d
      if (!_Driver->InBatchFile())
        ProcessSendingResponse(BackLog_);
      else
      {
        _Driver->DbgPtr()->ShowInt(_CalcResponse, "_CalcResponse");
        _Driver->DbgPtr()->ShowInt(_ExpectedStatesHandled, "_ExpectedStatesHandled");
        _Driver->DbgPtr()->ShowInt(_ResponseFromInput, "_ResponseFromInput");
      }
    #else
      if (!_Driver->InBatchFile())
        ProcessSendingResponse(BackLog_);
    #endif
  }

  _SignalHandled = Mcalc_IOState::OUTPUT_FETCHED;
  _EnterButton->setEnabled(true);
  _ReEnableTimer.stop();
  _Driver->SendOutputFetched(&_ExpectedStatesReceived);
}

/****************************************************************************/
void McalcDialog::ShowErrorOutput()
{
  _InputRequest = false;
  _InputRequestDetected = false;
  _CalcResponseSignal = false;
  _CalcResponseDetected = false;

  _ErrorResponse = true;
  _ExpectedStatesHandled = false;
  _ResponseFromInput = true;
  _NewlineAppended = false;
  _EnterButton->setEnabled(true);
  _ReEnableTimer.stop();
  _SignalHandled = 0;
  
  ShowOutput();
}

/****************************************************************************/
void McalcDialog::ShowCalcOutput()
{
  _InputRequest = false;
  _InputRequestDetected = _Driver->IoState() == Mcalc_IOState::INPUT_REQUIRED;
  _CalcResponseSignal = false;
  _CalcResponseDetected = _Driver->IoState() == Mcalc_IOState::CALC_RESPONSE;

  _CalcResponse = true;
  _ExpectedStatesHandled = false;
  _ResponseFromInput = true;
  _NewlineAppended = false;
  _EnterButton->setEnabled(true);
  _ReEnableTimer.stop();
  _SignalHandled = 0;
  
  ShowOutput();
}

/****************************************************************************/
void McalcDialog::DeleteInputBuffer()
{
  _EvalMode = false;
  _CurPos =
  _Index = 0;

  if (_InputArray[0] && _InputArray[0]->_UserDefined)
  {
    delete[] _InputArray[0]->_Command;
    delete _InputArray[0];
  }

  _InputArray[0] = NULL;
  _InputBuffer = QString("");

  _DoProcessReset = false;
}

/****************************************************************************/
void McalcDialog::ClearInputBuffer()
{
  #if MCALCDIALOG_DEBUG2d
    _Driver->DbgPtr()->EnterLevel("ClearInputBuffer");
  #endif

  bool AppendNl_ = false;

  const char* sptr = _SavedScreen.ascii();
  int slen = sptr ? ::strlen(sptr):0;

  for (--slen; slen >= 0; slen--)
  {
    AppendNl_ = !isspace(sptr[slen]);
    if (AppendNl_ || sptr[slen] == '\n')
      break;
  }

  if (!_Driver->InBatchFile())
  {
    if (_SavedScreen.length() > 0 && AppendNl_)
      _SavedScreen += "\n";

    _UserTextEdit->setText(_SavedScreen);
    _UserTextEdit->show();
  }

  MoveToEnd();

  _InputRequest = false;
  _InputRequestDetected = false;
  _CalcResponseSignal = false;
  _CalcResponseDetected = false;
  _CalcResponseAnswered = false;

  _SendingResponse = 0;
  _Processing = false;
  _ExpectedStatesHandled = true;
  _ExpectedStatesReceived = false;
  _SignalHandled = Mcalc_IOState::PROCESS_DONE;
  DeleteInputBuffer();

  _Driver->ClearInput();

  // Make sure appropriate response signal is sent
  // send PROCESS_DONE_ACK signal
  _SignalHandled = Mcalc_IOState::PROCESS_DONE_ACK;
  _EnterButton->setEnabled(true);
  _ReEnableTimer.stop();
  _Driver->SendProcessDoneAcked(&_ExpectedStatesReceived);

  #if MCALCDIALOG_DEBUG2d
    _Driver->DbgPtr()->LeaveLevel();
  #endif
}

/****************************************************************************/
void McalcDialog::GetPreviousCurve()
{
  bool Done_ = false;

  if (_TraceCurveNum > 0)
  {
    _TraceCurveNum--;
    Done_ = true;
  }
  else if (_TraceCurveNum < _Plotter->NumCurves() - 1)
  {
    _TraceCurveNum = _Plotter->NumCurves() - 1;
    Done_ = true;
  }

  if (Done_ && _Plotter->NumCurves())
  {
    _TraceIndex = 0;
    _EndToTrace = 1;
    _TraceMax = (_Plotter->GetCurveData(_TraceCurveNum).size() - 1) / 2;
    _Plotter->ShowTracePt(_TraceCurveNum, _TraceIndex,
                          _Plotter->GetCurveData(_TraceCurveNum)[1],
                          _Plotter->GetCurveData(_TraceCurveNum)[2],
                          QMCALC_MINOR_AXIS_RADIUS);
  }
}

/****************************************************************************/
void McalcDialog::GetNextCurve()
{
  bool Done_ = false;

  if (_TraceCurveNum < _Plotter->NumCurves() - 1)
  {
    _TraceCurveNum++;
    Done_ = true;
  }
  else if (_TraceCurveNum > 0)
  {
    _TraceCurveNum = 0;
    Done_ = true;
  }

  if (Done_ && _Plotter->NumCurves())
  {
    _TraceIndex = 0;
    _EndToTrace = 1;
    _TraceMax = (_Plotter->GetCurveData(_TraceCurveNum).size() - 1) / 2;
    _Plotter->ShowTracePt(_TraceCurveNum, _TraceIndex,
                          _Plotter->GetCurveData(_TraceCurveNum)[1],
                          _Plotter->GetCurveData(_TraceCurveNum)[2],
                          QMCALC_MINOR_AXIS_RADIUS);
  }
}

/****************************************************************************/
void McalcDialog::SetTracePtToStart()
{
  if (_Plotter->NumCurves())
  {
    _TraceIndex = 0;
    _Plotter->ShowTracePt(_TraceCurveNum, _TraceIndex,
                          _Plotter->GetCurveData(_TraceCurveNum)[1],
                          _Plotter->GetCurveData(_TraceCurveNum)[2],
                          QMCALC_MINOR_AXIS_RADIUS);
  }
}

/****************************************************************************/
void McalcDialog::SetTracePtToEnd()
{
  if (_Plotter->NumCurves())
  {
    _TraceIndex = _TraceMax - 1;
    _Plotter->ShowTracePt(_TraceCurveNum, _TraceIndex,
                          _Plotter->GetCurveData(_TraceCurveNum)[1 + (2 * _TraceIndex)],
                          _Plotter->GetCurveData(_TraceCurveNum)[1 + (2 * _TraceIndex + 1)],
                          QMCALC_MINOR_AXIS_RADIUS);
  }
}

/****************************************************************************/
void McalcDialog::ClearTraceMode()
{
  _TraceMode = false;
  _EndToTrace = 1;
  _TraceCurveNum = 0;
  _TraceIndex = 0;
  _TraceMax = 0;

  if (_Plotter->NumCurves())
    _Plotter->ClearTracePt();
}

/****************************************************************************/
void McalcDialog::EnterTraceMode()
{
  if (_Plotter->NumCurves() && _Plotter && !_Plotter->UseFileBuffers())
  {
    _SavedScreen += GRAPH_HELP_MSG3;
    _UserTextEdit->setText(_SavedScreen);
    MoveToEnd();

    _TraceMode = true;
    _EndToTrace = 1;
    _TraceCurveNum = 0;
    _TraceIndex = 0;
    _TraceMax = (_Plotter->GetCurveData(_TraceCurveNum).size() - 1) / 2;
    _Plotter->ShowTracePt(_TraceCurveNum, _TraceIndex,
                          _Plotter->GetCurveData(_TraceCurveNum)[1 + (2 * _TraceIndex)],
                          _Plotter->GetCurveData(_TraceCurveNum)[1 + (2 * _TraceIndex + 1)],
                          QMCALC_MINOR_AXIS_RADIUS);
  }
}

/****************************************************************************/
bool McalcDialog::CheckInfStartPts(bool& Validx_, bool& Validy_,
                                   bool XstartValid_, bool YstartValid_, bool Xvalid_, bool Yvalid_,
                                   bool prvAtNegInfx_, bool prvAtPosInfx_, bool prvAtNegInfy_, bool prvAtPosInfy_,
                                   bool LowXset_, bool HighXset_, double LowX_, double HighX_,
                                   bool LowPtset_, bool HighPtset_, double* LowPt_, double* HighPt_)
{
  bool StartPtsSet_ = false;
  Validx_ = XstartValid_;
  Validy_ = YstartValid_;
  StartPtsSet_ = Validx_ && Validy_;
  
  if (StartPtsSet_)
    return true;

  if (!YstartValid_ && Yvalid_ && (prvAtNegInfy_ || prvAtPosInfy_))
  {
    if (prvAtNegInfy_ && LowPtset_)
    {
      _StartPty = LowPt_[1];
      _StartPtx = LowPt_[0];
      YstartValid_ = XstartValid_ = true;
    }
    else if (prvAtPosInfy_ && HighPtset_)
    {
      _StartPty = HighPt_[1];
      _StartPtx = HighPt_[0];
      YstartValid_ = XstartValid_ = true;
    }
  }
  else if (!XstartValid_ && Xvalid_ && (prvAtNegInfx_ || prvAtPosInfx_))
  {
    if (prvAtNegInfx_ && LowXset_)
    {
      if (LowPtset_ && LowPt_[0] == LowX_)
      {
        _StartPtx = LowPt_[0];
        _StartPty = LowPt_[1];
        XstartValid_ = YstartValid_ = true;
      }
      else if (HighPtset_ && HighPt_[0] == LowX_)
      {
        _StartPtx = HighPt_[0];
        _StartPty = HighPt_[1];
        XstartValid_ = YstartValid_ = true;
      }
    }
    else if (prvAtPosInfx_ && HighXset_)
    {
      if (LowPtset_ && LowPt_[0] == HighX_)
      {
        _StartPtx = LowPt_[0];
        _StartPty = LowPt_[1];
        XstartValid_ = YstartValid_ = true;
      }
      else if (HighPtset_ && HighPt_[0] == HighX_)
      {
        _StartPtx = HighPt_[0];
        _StartPty = HighPt_[1];
        XstartValid_ = YstartValid_ = true;
      }
    }
  }
  
  StartPtsSet_ = XstartValid_ && YstartValid_;
  return StartPtsSet_;
}

/****************************************************************************/
void McalcDialog::SendExpectedResponse()
{
  #if MCALCDIALOG_DEBUG2d
    _Driver->DbgPtr()->EnterLevel("McalcDialog::SendExpectedResponse");
    _Driver->DbgPtr()->ShowInt(_Driver->HasExpectedStates(), "HasExpectedStates");
    _Driver->DbgPtr()->ShowInt(_ExpectedStatesHandled, "_ExpectedStatesHandled");
    _Driver->DbgPtr()->ShowStr(_Driver->IoStateToStr(_Driver->IoState()), "IoState()");
    _Driver->DbgPtr()->ShowInt(_Driver->InBatchFile(), "InBatchFile()");
    _Driver->DbgPtr()->ShowInt(_ResponseFromInput, "_ResponseFromInput");
    _Driver->DbgPtr()->ShowInt(_ErrorResponse, "_ErrorResponse");
    _Driver->DbgPtr()->ShowInt(_CalcResponse, "_CalcResponse");
    _Driver->DbgPtr()->ShowInt(_GraphResponse, "_GraphResponse");
  #endif

  if (_Driver->HasExpectedStates() && !_ExpectedStatesHandled)
  {
    if (_ErrorResponse || _CalcResponse)
    {
      // for Error/CalcResp/InputReq signals in batch file or
      // InputReq signal
      if (_Driver->InBatchFile() ||
          _Driver->IoState() == Mcalc_IOState::INPUT_REQUIRED)
        _Driver->PendingInputReceived();

      // for CalcResp or Error signals
      if (_Driver->IoState() != Mcalc_IOState::INPUT_REQUIRED)
        _Driver->PendingProcessSignal();

      _ExpectedStatesHandled = true;
      _ExpectedStatesReceived = true;
    }
    else if (_GraphResponse)
    {
      // for GraphOut signal
      _Driver->PendingOutputFetched();
      _ExpectedStatesHandled = true;
      _ExpectedStatesReceived = true;
    }
  }

  #if MCALCDIALOG_DEBUG2d
    _Driver->DbgPtr()->LeaveLevel();
  #endif
}

/****************************************************************************/
void McalcDialog::ProcessSendingResponse(const QString& BackLog_)
{
  #if MCALCDIALOG_DEBUG2d
    _Driver->DbgPtr()->EnterLevel("McalcDialog::ProcessingSendingResponse");
    _Driver->DbgPtr()->ShowStr(_Driver->IoStateToStr(_Driver->IoState()), "IoState()");
    _Driver->DbgPtr()->ShowInt(_ExpectedStatesHandled, "_ExpectedStatesHandled");
    _Driver->DbgPtr()->ShowInt(_ResponseFromInput, "_ResponseFromInput");
    _Driver->DbgPtr()->ShowInt(_ErrorResponse, "_ErrorResponse");
    _Driver->DbgPtr()->ShowInt(_CalcResponse, "_CalcResponse");
    _Driver->DbgPtr()->ShowInt(_GraphResponse, "_GraphResponse");
  #endif

  if (_Driver->IoState() == Mcalc_IOState::CALC_RESPONSE ||
      _Driver->IoState() == Mcalc_IOState::INPUT_RECEIVED ||
      _Driver->IoState() == Mcalc_IOState::OUTPUT_FETCHED ||
      _Driver->IoState() == Mcalc_IOState::PROCESS_DONE_ACK)
  {
    _InputRequest = false;

    if (_InputRequestDetected)
      _InputRequestReplied = true;
    
    _CalcResponseSignal = _Driver->IoState() == Mcalc_IOState::CALC_RESPONSE;

    if (_CalcResponseSignal)
    {
      _CalcResponseDetected = true;
      _CalcResponseAnswered = false;
    }

    if (!_ExpectedStatesHandled)
    {
      SendExpectedResponse();
      _SignalHandled = _ExpectedStatesHandled ? Mcalc_IOState::CALC_RESPONSE:0;
    }
  }
  else if (!_Driver->InProgressDataFile())
  {
    if (_ResultReturned &&
        _Driver->IoState() == Mcalc_IOState::INPUT_REQUIRED)
    {
      _InputRequest = true;
      _InputRequestDetected = true;      
      _InputRequestReplied = false;
      
      _CalcResponseSignal = false;
      _CalcResponseDetected = false;
    }
    else
    {
      _CalcErrorSignal = (_ErrorResponse && _Driver->IoState() == Mcalc_IOState::CALC_ERROR);
      _GraphOutputSignal = (_GraphResponse && _Driver->IoState() == Mcalc_IOState::GRAPH_OUTPUT);
    }

    if (!_ExpectedStatesHandled &&
        (_CalcResponse || _ErrorResponse || _GraphResponse))
    {
      SendExpectedResponse();
      _SignalHandled = _ExpectedStatesHandled ?
                         (_InputRequest      ? Mcalc_IOState::INPUT_REQUIRED:
                          _CalcErrorSignal   ? Mcalc_IOState::CALC_ERROR:
                          _GraphOutputSignal ? Mcalc_IOState::GRAPH_OUTPUT:0):0;
    }
    else if (_GraphOutputSignal && _ExpectedStatesHandled)
      _SignalHandled = Mcalc_IOState::GRAPH_OUTPUT;
  }

  bool WasProcessing_ = !_Driver->InBatchFile() &&
                        _Processing && _Index && _InputArray[0];
  bool SendOkCond_ = false;
  bool CalcSig_ = _CalcResponse ||
                  _SignalHandled == Mcalc_IOState::INPUT_REQUIRED ||
                  _SignalHandled == Mcalc_IOState::CALC_RESPONSE;
  bool GraphSig_ = (_GraphResult && _GraphResponse) ||
                   _SignalHandled == Mcalc_IOState::GRAPH_OUTPUT;
  bool ErrorSig_ = _ErrorResponse ||
                   _SignalHandled == Mcalc_IOState::CALC_ERROR;
  bool InputFileOk_ = !_Driver->InBatchFile() ||
                      ((_Driver->InProgramFile() || _Driver->InInputFile()) &&
                       ((CalcSig_ && ((_InputRequestDetected && _InputRequest) ||
                                      (_CalcResponseDetected && _CalcResponseSignal))) ||
                        (GraphSig_ && _GraphOutputSignal) ||
                        (ErrorSig_ && _CalcErrorSignal)));

  const char* sptr = NULL;

  if (!_Driver->InProgressDataFile() &&
      _ResponseFromInput && InputFileOk_)
  {
    if (_SendingResponse == ResponseSignal::SEND_TOCALC)
      _SendingResponse = ResponseSignal::SEND_TOCALC_ACK;

    SendOkCond_ = _SendingResponse == 0 ||
                  _SendingResponse > ResponseSignal::SEND_TOCALC;

    if (WasProcessing_)
    {
      _UserTextEdit->setText(_UserTextEdit->text() + BackLog_);

      if (_SendingResponse > ResponseSignal::SEND_TOCALC &&
          _SendingResponse != ResponseSignal::ERROR_FOUND &&
          _SendingResponse != ResponseSignal::OUTPUT_SHOWN)
      {
        _Processing = true;
        sptr = _InputBuffer.ascii();
        _DoQuitBatchData = _DoQuitBatchData && sptr &&
                           ::strlen(sptr) == 1 && toupper(sptr[0]) == 'Q';

        _SendingResponse = _ErrorResponse ? ResponseSignal::ERROR_FOUND:
                                            ResponseSignal::OUTPUT_SHOWN;

        SendToInput();
      }
    
      if (!SendOkCond_ || _ErrorResponse)
      {
        _Processing = false;
        _SendingResponse = _ErrorResponse ? ResponseSignal::ERROR_FOUND:0;
      }
    }
    else if (!SendOkCond_ || _ErrorResponse)
    {
      _Processing = false;
      _Driver->ReadIoState();
      _SendingResponse = _ErrorResponse ? ResponseSignal::ERROR_FOUND:0;
    }

    if (_SendingResponse > ResponseSignal::SEND_TOCALC &&
        _SendingResponse != ResponseSignal::ERROR_FOUND)
      _SendingResponse = ResponseSignal::OUTPUT_SHOWN;
  }

  if (_ErrorResponse)
    _Driver->AckErrorFetched();

  if (!_Driver->InProgressDataFile())
    _Processing = false;

  bool DoReset_ = !_Driver->InBatchFile() ||
                  !(_ErrorResponse || (_ResponseFromInput && InputFileOk_));

  DoReset_ = DoReset_ &&
             (_CalcResponse || _ErrorResponse || _GraphResponse) &&
             (!_Driver->HasExpectedStates() || _ExpectedStatesHandled);

  if (DoReset_)
  {
    _ErrorResponse = false;
    _CalcResponse = false;
    _GraphResponse = false;
  }

  #if MCALCDIALOG_DEBUG2d
    _Driver->DbgPtr()->LeaveLevel();
  #endif
}

/****************************************************************************/
void McalcDialog::ShowOutput()
{
  QString BackLog_;
  QString Output_;
  QString CalcOut_ = _Driver->_Output->text();
  bool WasProcessing_ = !_Driver->InBatchFile() &&
                        _Processing && _Index && _InputArray[0];
  bool EqAns_ = false;
  char FileSuffix_ = 0;
  int GraphNum_ = 0;
  int x;

  QTextStream in;
  QString CoordStr_;
  QStringList pcoords;
  QStringList coords;
  int slen = 0;
  int CntDataPts_ = 0;
  int PrevSendVal_ = 0;

  bool CalcSig_ = false;
  bool GraphSig_ = false;
  bool ErrorSig_ = false;
  bool HaveStartPt_ = false;
  bool Validx_ = false;
  bool Validy_ = false;
  bool Xvalid_ = false;
  bool Yvalid_ = false;
  bool XstartValid_ = false;
  bool YstartValid_ = false;
  bool AtNegInfx_ = false;
  bool AtPosInfx_ = false;
  bool AtNegInfy_ = false;
  bool AtPosInfy_ = false;
  bool prvAtNegInfx_ = false;
  bool prvAtPosInfx_ = false;
  bool prvAtNegInfy_ = false;
  bool prvAtPosInfy_ = false;	
  bool pcoordset_ = false;
  bool CoordConfirmed_ = false;
  bool GuiReadyToSend_ = false;
  bool ProcessAckDone_ = false;
  bool RestoreResponseFromInput_ = false;
  double CoordValx_;
  double CoordValy_;
  double LowX_ = 0;
  double HighX_ = 0;
  double LowY_ = 0;
  double HighY_ = 0;
  bool LowXset_ = false;
  bool HighXset_ = false;
  bool LowYset_ = false;
  bool HighYset_ = false;	
  bool RollbackLowXset_ = false;
  bool RollbackHighXset_ = false;
  double RollbackLowX_ = 0;
  double RollbackHighX_ = 0;
  int RollbackPos_ = 0;
  
  double HighPt_[2];
  double LowPt_[2];
  bool HighPtset_ = false;
  bool LowPtset_ = false;
  bool StartPtsSet_ = false;
  bool AllowQuit_ = _BatchDataInput && _AllowBatchQuit;
  bool DoResetResponse_ = false;
  bool InputProcessed_ = false;
  bool DeleteBuffers_ = false;
  bool InError_ = false;
  bool AppendNl_ = false;
  bool InputFileOk_ = false;
  bool InGraphPlot_ = _GraphResult &&
                      _GraphResponse && !_ErrorResponse && !_CalcResponse;
  
  const char* sptr = NULL;
  
  #if ((MCALCDIALOG_DEBUG1b)|(MCALCDIALOG_DEBUG2b))
    QMessageBox::warning(0, "DEBUG ShowOutput()",
                       QString("\nEntering ShowOutput()") +
                       QString("\nCalcOut_ == ") + CalcOut_ +
                       QString("\n_Processing == ") + QString::number(_Processing) +
                       QString("\n_SendingResponse == ") + QString::number(_SendingResponse) +
                       QString("\n_Index == ") + QString::number(_Index),
                       QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
  #elif MCALCDIALOG_DEBUG2d
    _Driver->DbgPtr()->EnterLevel("McalcDialog::ShowOutput");
    _Driver->DbgPtr()->ShowStr(CalcOut_.ascii(), "CalcOut_");
    _Driver->DbgPtr()->ShowInt(_Processing, "_Processing");
    _Driver->DbgPtr()->ShowInt(_SendingResponse, "_SendingResponse");
    _Driver->DbgPtr()->ShowInt(_Index, "_Index");
  #endif
  
  // If graphical result then stop twirly animation in all cases
  if (InGraphPlot_)
  {
    _TwirlyTimer.stop();
    _TwirlyState = 0;
    _TwirlyIncrNum = 0;
    _SendGraphResponse = 0;
    _PrevGraphResponse = 0;

    _DoContinuePlot = 0;
    _DoQuitBatchData = false;
  }

  // graphical calculator commands and function plotter processing
  if (InGraphPlot_ && !_ErrorResponse)
  {
    if (_GraphResult == GraphPlotOpType::BATCH_GRAPH_PLOT)
    {    
      _SavedScreen = _PrevBuffer;
      if (AllowQuit_)
        _SavedScreen += "\n";
      
      _UserTextEdit->setText(_SavedScreen);
      _NumGraphPlotDone++;
    }
    else
    {
      _SavedScreen = _SavedInput;
      _SavedInput = "";
      uint len_ = _SavedScreen.length();
      _SavedScreen = _SavedScreen.left(len_ - 1);
      _SavedScreen += "\n";
      _SavedScreen += _QuestionBuffer;
      _UserTextEdit->setText(_SavedScreen);
      // _SavedScreen += "\n";
    }

    QString Fname_;
    QString NameFileName_ = QString("mcalc_curgraph") +
                            QString::number(_Driver->SessionNum()) +
                            QString(".dat");
    QFile namefile(NameFileName_);

  if (namefile.open(IO_ReadOnly))
  {
    CurveData* curve_ = NULL;
    CurveData* infpts_ = NULL;
    QTextStream Fnin(&namefile);
    Fname_ = Fnin.readLine();
    Fname_ = Fname_.stripWhiteSpace();
    namefile.close();
    QFile file;
    file.setName(Fname_);

    const char* RawStr_ = Fname_.ascii();
    int len = ::strlen(RawStr_);
    for (x = 0; x < len; x++)
      if (RawStr_[x] == '.' && x)
      {
        --x;
        FileSuffix_ = RawStr_[x];
        Fname_ = Fname_.left(x);
        break;
      }

    for (;;)
    {
      if (file.open(IO_ReadOnly))
      {
        in.setDevice(&file);
        CoordStr_ = QString();
        pcoords = QStringList();
        coords = QStringList();
        curve_ = new CurveData;
        infpts_ = new CurveData;
        HaveStartPt_ = false;
        CntDataPts_ = 0;
        Validx_ = false;
        Validy_ = false;
        Xvalid_ = false;
        Yvalid_ = false;
        XstartValid_ = false;
        YstartValid_ = false;
        AtNegInfx_ = false;
        AtPosInfx_ = false;
        AtNegInfy_ = false;
        AtPosInfy_ = false;
        prvAtNegInfx_ = false;
        prvAtPosInfx_ = false;
        prvAtNegInfy_ = false;
        prvAtPosInfy_ = false;
        pcoordset_ = false;
        CoordConfirmed_ = false;
        CoordValx_ = 0;
        CoordValy_ = 0;
        LowX_ = 0;
        HighX_ = 0;
        LowY_ = 0;
        HighY_ = 0;
        LowXset_ = false;
        HighXset_ = false;
        LowYset_ = false;
        HighYset_ = false;
        RollbackLowXset_ = false;
        RollbackHighXset_ = false;
        RollbackLowX_ = 0;
        RollbackHighX_ = 0;
        RollbackPos_ = 0;
        HighPtset_ = false;
        LowPtset_ = false;
        StartPtsSet_ = false;

        _StartPtx = _StartPty = 0;
        ++GraphNum_;

        QString FuncName_ = in.readLine();
        QString line = in.readLine();
        _GraphType = line.toInt();
        line = in.readLine();
        _FillGraph = line.toInt();
        curve_->push_back(_FillGraph);
        bool InfVals_[2];
        InfVals_[0] = InfVals_[1] = false;

        while (!in.atEnd())
        {
            line = in.readLine();
            coords = QStringList::split(" ", line);

            if (coords.size() == 2)
            {
              if (!HaveStartPt_)
              {
                RollbackPos_ = 0;
                XstartValid_ = false;
                YstartValid_ = false;
                Xvalid_ = false;
                Yvalid_ = false;
                AtNegInfx_ = AtNegInfy_ = false;
                AtPosInfx_ = AtPosInfy_ = false;

                CoordStr_ = coords[0].lower();
                CoordStr_ = CoordStr_.stripWhiteSpace();
                AtNegInfx_ = CoordStr_ == QString("-inf");
                InfVals_[0] = AtNegInfx_ ||
                              CoordStr_ == QString("+inf") ||
                              CoordStr_ == QString("inf") ||
                              CoordStr_ == QString("nan");

                Validx_ = !InfVals_[0];
                if (Validx_)
                  _StartPtx = coords[0].toDouble(&Validx_);
                else
                {
                  AtPosInfx_ = !AtNegInfx_;
                  _StartPtx = AtNegInfx_ ? (LowXset_ ? LowX_:0):(HighXset_ ? HighX_:0);
                }

                if (Validx_)
                {
                  if (_StartPtx > HighX_)
                  {
                    RollbackPos_ = 2;
                    RollbackHighX_ = HighX_;
                    RollbackHighXset_ = HighXset_;

                    HighX_ = _StartPtx;
                    HighXset_ = true;
                  }
                  else if (_StartPtx < LowX_)
                  {
                    RollbackPos_ = 1;
                    RollbackLowX_ = LowX_;
                    RollbackLowXset_ = LowXset_;

                    LowX_ = _StartPtx;
                    LowXset_ = true;
                  }
                  
                  XstartValid_ = true;
                  Xvalid_ = true;
                }

                CoordStr_ = coords[1].lower();
                CoordStr_ = CoordStr_.stripWhiteSpace();
                AtNegInfy_ = CoordStr_ == QString("-inf");
                InfVals_[0] = AtNegInfy_ ||
                              CoordStr_ == QString("+inf") ||
                              CoordStr_ == QString("inf") ||
                              CoordStr_ == QString("nan");

                Validy_ = !InfVals_[0];
                if (Validy_)
                  _StartPty = coords[1].toDouble(&Validy_);
                else
                {
                  AtPosInfy_ = !AtNegInfy_;
                  _StartPty = AtNegInfy_ ? (LowYset_ ? LowY_:0):(HighYset_ ? HighY_:0);
                }

                if (Validy_)
                {
                  // Extrema low and high point values must be assigned as valid matching pairs
                  if (Validx_ && _StartPty > HighY_)
                  {
                    HighY_ = _StartPty;
                    HighYset_ = true;
    
                    if (RollbackPos_ == 1)
                    {
                      HighPt_[0] = LowX_;
                      HighPt_[1] = HighY_;
                      HighPtset_ = true;
                    }
                    else if (RollbackPos_ == 2)
                    {
                      HighPt_[0] = HighX_;
                      HighPt_[1] = HighY_;
                      HighPtset_ = true;
                    }
                  }
                  else if (Validx_ && _StartPty < LowY_)
                  {
                    LowY_ = _StartPty;
                    LowYset_ = true;
    
                    if (RollbackPos_ == 1)
                    {
                      LowPt_[0] = LowX_;
                      LowPt_[1] = LowY_;
                      LowPtset_ = true;
                    }
                    else if (RollbackPos_ == 2)
                    {
                      LowPt_[0] = HighX_;
                      LowPt_[1] = LowY_;
                      LowPtset_ = true;
                    }
                  }
                  else
                  {
                    if (RollbackPos_ == 1)
                    {
                      LowX_ = RollbackLowX_;
                      LowXset_ = RollbackLowXset_;
                    }
                    else if (RollbackPos_ == 2)
                    {
                      HighX_ = RollbackHighX_;
                      HighXset_ = RollbackHighXset_;
                    }
                  }
                  
                  YstartValid_ = true;
                  Yvalid_ = true;
                }
                else
                {
                  // Extrema low and high point values must be assigned as valid matching pairs
                  if (RollbackPos_ == 1)
                  {
                    LowX_ = RollbackLowX_;
                    LowXset_ = RollbackLowXset_;
                  }
                  else if (RollbackPos_ == 2)
                  {
                    HighX_ = RollbackHighX_;
                    HighXset_ = RollbackHighXset_;
                  }                  
                }

                StartPtsSet_ = XstartValid_ && YstartValid_;
                HaveStartPt_ = true;
              }
              else
              {
                ++CntDataPts_;
                CoordConfirmed_ = false;
                RollbackPos_ = 0;
                Xvalid_ = false;
                Yvalid_ = false;
                AtNegInfx_ = AtNegInfy_ = false;
                AtPosInfx_ = AtPosInfy_ = false;

                CoordStr_ = coords[0].lower();
                CoordStr_ = CoordStr_.stripWhiteSpace();
                AtNegInfx_ = CoordStr_ == QString("-inf");
                InfVals_[1] = AtNegInfx_ ||
                              CoordStr_ == QString("+inf") ||
                              CoordStr_ == QString("inf") ||
                              CoordStr_ == QString("nan");

                Validx_ = !InfVals_[1];
                if (Validx_)
                  CoordValx_ = coords[0].toDouble(&Validx_);
                else
                {
                  AtPosInfx_ = !AtNegInfx_;
                  CoordValx_ = AtNegInfx_ ? (LowXset_ ? LowX_:0):(HighXset_ ? HighX_:0);
                }

                if (Validx_)
                {
                  if (CoordValx_ > HighX_)
                  {
                    RollbackPos_ = 2;
                    RollbackHighX_ = HighX_;
                    RollbackHighXset_ = HighXset_;

                    HighX_ = CoordValx_;
                    HighXset_ = true;
                  }
                  else if (CoordValx_ < LowX_)
                  {
                    RollbackPos_ = 1;
                    RollbackLowX_ = LowX_;
                    RollbackLowXset_ = LowXset_;

                    LowX_ = CoordValx_;
                    LowXset_ = true;
                  }
                  
                  Xvalid_ = true;
                }

                CoordStr_ = coords[1].lower();
                CoordStr_ = CoordStr_.stripWhiteSpace();
                AtNegInfy_ = CoordStr_ == QString("-inf");
                InfVals_[1] = AtNegInfy_ ||
                              CoordStr_ == QString("+inf") ||
                              CoordStr_ == QString("inf") ||
                              CoordStr_ == QString("nan");

                Validy_ = !InfVals_[1];
                if (Validy_)
                  CoordValy_ = coords[1].toDouble(&Validy_);
                else
                {
                  AtPosInfy_ = !AtNegInfy_;
                  CoordValy_ = AtNegInfy_ ? (LowYset_ ? LowY_:0):(HighYset_ ? HighY_:0);
                }

                if (Validy_)
                {
                  // Extrema low and high point values must be assigned as valid matching pairs
                  if (Validx_ && CoordValy_ > HighY_)
                  {
                    HighY_ = CoordValy_;
                    HighYset_ = true;
    
                    if (RollbackPos_ == 1)
                    {
                      HighPt_[0] = LowX_;
                      HighPt_[1] = HighY_;
                      HighPtset_ = true;
                    }
                    else if (RollbackPos_ == 2)
                    {
                      HighPt_[0] = HighX_;
                      HighPt_[1] = HighY_;
                      HighPtset_ = true;
                    }
                  }
                  else if (Validx_ && CoordValy_ < LowY_)
                  {
                    LowY_ = CoordValy_;
                    LowYset_ = true;
    
                    if (RollbackPos_ == 1)
                    {
                      LowPt_[0] = LowX_;
                      LowPt_[1] = LowY_;
                      LowPtset_ = true;
                    }
                    else if (RollbackPos_ == 2)
                    {
                      LowPt_[0] = HighX_;
                      LowPt_[1] = LowY_;
                      LowPtset_ = true;
                    }
                  }
                  else
                  {
                    if (RollbackPos_ == 1)
                    {
                      LowX_ = RollbackLowX_;
                      LowXset_ = RollbackLowXset_;
                    }
                    else if (RollbackPos_ == 2)
                    {
                      HighX_ = RollbackHighX_;
                      HighXset_ = RollbackHighXset_;
                    }
                  }
                    
                  Yvalid_ = true;
                }
                else
                {
                  // Extrema low and high point values must be assigned as valid matching pairs
                  if (RollbackPos_ == 1)
                  {
                    LowX_ = RollbackLowX_;
                    LowXset_ = RollbackLowXset_;
                  }
                  else if (RollbackPos_ == 2)
                  {
                    HighX_ = RollbackHighX_;
                    HighXset_ = RollbackHighXset_;
                  }                  
                }

                if (Validx_ && Validy_)
                {
                  pcoords = coords;
                  pcoordset_ = true;
                  CoordConfirmed_ = true;
                    
                  curve_->push_back(CoordValx_);
                  curve_->push_back(CoordValy_);
                }
              }

              if (CntDataPts_ > 1)
              {
                if (InfVals_[0] && !InfVals_[1] && CoordConfirmed_)
                {
                  // CoordConfirmed set to true means both x,y points are valid 
                  infpts_->push_back(CoordValx_);
                  infpts_->push_back(CoordValy_);

                  #if PLOTTERDATA_DEBUG
                     QMessageBox::warning(0, "DEBUG(1a)",
                        QString("\ninfinity pt pushed:") +
                        QString("\nx = ") + QString::number(CoordValx_) +
                        QString("\ny = ") + QString::number(CoordValy_),
                        QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
                  #endif

                  if (!StartPtsSet_)
                  {
                    StartPtsSet_ = CheckInfStartPts(Validx_, Validy_, XstartValid_, YstartValid_, Xvalid_, Yvalid_,
                                                    prvAtNegInfx_, prvAtPosInfx_, prvAtNegInfy_, prvAtPosInfy_,
                                                    LowXset_, HighXset_, LowX_, HighX_,
                                                    LowPtset_, HighPtset_, LowPt_, HighPt_);

                    if (StartPtsSet_ && (!Validx_ || !Validy_))
                    {
                      infpts_->push_back(_StartPtx);
                      infpts_->push_back(_StartPty);

                      #if PLOTTERDATA_DEBUG
                         QMessageBox::warning(0, "DEBUG(1c)",
                            QString("\ninfinity pt pushed:") +
                            QString("\nx = ") + QString::number(_StartPtx) +
                            QString("\ny = ") + QString::number(_StartPty),
                            QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
                      #endif
                    }
                  }
                }
                else if (!InfVals_[0] && InfVals_[1] && pcoordset_)
                {
                  // Points marked as end points before infinity occurs must have valid values
                  CoordValx_ = pcoords[0].toDouble(&Validx_);
                  CoordValy_ = pcoords[1].toDouble(&Validy_);

                  if (Validx_ && Validy_)
                  {
                    infpts_->push_back(CoordValx_);
                    infpts_->push_back(CoordValy_);
                  }
                  else
                  {
                    CoordValx_ = ::atof(pcoords[0].ascii());
                    CoordValy_ = ::atof(pcoords[1].ascii());
                    
                    infpts_->push_back(CoordValx_);
                    infpts_->push_back(CoordValy_);
                  }
                  
                  #if PLOTTERDATA_DEBUG
                     QMessageBox::warning(0, "DEBUG(1b)",
                        QString("\ninfinity pt pushed:") +
                        QString("\nx = ") + QString::number(CoordValx_) +
                        QString("\ny = ") + QString::number(CoordValy_),
                        QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
                  #endif
                }
              }
              else if (CntDataPts_ == 1)
              {
                _Plotter->initCurveData(_CurveNum, FuncName_);

                if (!StartPtsSet_)
                {
                  StartPtsSet_ = CheckInfStartPts(Validx_, Validy_, XstartValid_, YstartValid_, Xvalid_, Yvalid_,
                                                  prvAtNegInfx_, prvAtPosInfx_, prvAtNegInfy_, prvAtPosInfy_,
                                                  LowXset_, HighXset_, LowX_, HighX_,
                                                  LowPtset_, HighPtset_, LowPt_, HighPt_);

                  if (StartPtsSet_ && (!Validx_ || !Validy_))
                  {
                    infpts_->push_back(_StartPtx);
                    infpts_->push_back(_StartPty);

                    #if PLOTTERDATA_DEBUG
                       QMessageBox::warning(0, "DEBUG(1c)",
                          QString("\ninfinity pt pushed:") +
                          QString("\nx = ") + QString::number(_StartPtx) +
                          QString("\ny = ") + QString::number(_StartPty),
                          QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
                    #endif
                  }
                }
              }

              if (CntDataPts_)
              {
                InfVals_[0] = InfVals_[1];
                pcoordset_ = CoordConfirmed_;
              }
              
              if (HaveStartPt_)
              {
                prvAtNegInfx_ = AtNegInfx_;
                prvAtNegInfy_ = AtNegInfy_;
                prvAtPosInfx_ = AtPosInfx_;
                prvAtPosInfy_ = AtPosInfy_;
              }
            }
        }

        file.close();
        QPointArray points(4);
        double Slope_;
        double InvSlope_;
        double Intercept1_;
        double Intercept2_;
        double Pt1a_;
        double Pt1b_;
        double Pt2a_;
        double Pt2b_;

        if (_GraphType == GraphType::DERIVATIVE)
        {
          if (CalcOut_.length())
          {
            Slope_ = CalcOut_.toDouble();

            if (Slope_ != double(0))
            {
              Intercept1_ = _StartPty - (Slope_ * _StartPtx);
              Pt1a_ = Slope_ * (_StartPtx + QMCALC_MAJOR_AXIS_RADIUS) + Intercept1_;
              Pt1b_ = Slope_ * (_StartPtx - QMCALC_MAJOR_AXIS_RADIUS) + Intercept1_;
              InvSlope_ = double(-1) / Slope_;
              Intercept2_ = _StartPty - (InvSlope_ * _StartPtx);
              Pt2a_ = InvSlope_ * (_StartPtx + QMCALC_MINOR_AXIS_RADIUS) + Intercept2_;
              Pt2b_ = InvSlope_ * (_StartPtx - QMCALC_MINOR_AXIS_RADIUS) + Intercept2_;
              _Plotter->setSecantData(_CurveNum, true,
                                      _StartPtx - QMCALC_MAJOR_AXIS_RADIUS, Pt1b_,
                                      _StartPtx + QMCALC_MAJOR_AXIS_RADIUS, Pt1a_,
                                      _StartPtx - QMCALC_MINOR_AXIS_RADIUS, Pt2b_,
                                      _StartPtx + QMCALC_MINOR_AXIS_RADIUS, Pt2a_);
            }
            else
              _Plotter->setSecantData(_CurveNum, true,
                                      _StartPtx - QMCALC_MAJOR_AXIS_RADIUS, _StartPty,
                                      _StartPtx + QMCALC_MAJOR_AXIS_RADIUS, _StartPty,
                                      _StartPtx, _StartPty - QMCALC_MINOR_AXIS_RADIUS,
                                      _StartPtx, _StartPty + QMCALC_MINOR_AXIS_RADIUS);
          }
          else
            _Plotter->setSecantData(_CurveNum, false, 0, 0, 0, 0, 0, 0, 0, 0);
        }
        else if (_GraphType == GraphType::ROOTSOLVE)
        {
          if (CalcOut_.length())
          {
            _StartPtx = CalcOut_.toDouble();
            _StartPty = 0;
            Slope_ = 1;
            InvSlope_ = -1;
            Intercept1_ = _StartPty - (Slope_ * _StartPtx);
            Pt1a_ = Slope_ * (_StartPtx + QMCALC_MINOR_AXIS_RADIUS) + Intercept1_;
            Pt1b_ = Slope_ * (_StartPtx - QMCALC_MINOR_AXIS_RADIUS) + Intercept1_;
            Intercept2_ = _StartPty - (InvSlope_ * _StartPtx);
            Pt2a_ = InvSlope_ * (_StartPtx + QMCALC_MINOR_AXIS_RADIUS) + Intercept2_;
            Pt2b_ = InvSlope_ * (_StartPtx - QMCALC_MINOR_AXIS_RADIUS) + Intercept2_;

            _Plotter->setSecantData(_CurveNum, true,
                                    _StartPtx - QMCALC_MINOR_AXIS_RADIUS, Pt1b_,
                                    _StartPtx + QMCALC_MINOR_AXIS_RADIUS, Pt1a_,
                                    _StartPtx - QMCALC_MINOR_AXIS_RADIUS, Pt2b_,
                                    _StartPtx + QMCALC_MINOR_AXIS_RADIUS, Pt2a_);
          }
          else
            _Plotter->setSecantData(_CurveNum, false, 0, 0, 0, 0, 0, 0, 0, 0);
        }
        else if ((_GraphType == GraphType::INTERSECT1 || _GraphType == GraphType::INTERSECT2) && GraphNum_ == 1)
        {
          if (CalcOut_.length())
          {
            QString IntFname_ = QString("mcalc_graph") +
                                QString::number(_Driver->SessionNum()) +
                                QString("z.out");
            QFile IntFile_(IntFname_);

            if (IntFile_.open(IO_ReadOnly))
            {
              QTextStream IntFin(&IntFile_);

              for (x = 0; !IntFin.atEnd() && x < 3; x++)
              {
                line = IntFin.readLine();
                QStringList Slist_ = QStringList::split(QChar(' '), line);

                if (x)
                  _Plotter->pushSecantData(_CurveNum);

                _StartPtx = Slist_[0].toDouble();
                _StartPty = Slist_[1].toDouble();
                Slope_ = 1;
                InvSlope_ = -1;
                Intercept1_ = _StartPty - (Slope_ * _StartPtx);
                Pt1a_ = Slope_ * (_StartPtx + QMCALC_MINOR_AXIS_RADIUS) + Intercept1_;
                Pt1b_ = Slope_ * (_StartPtx - QMCALC_MINOR_AXIS_RADIUS) + Intercept1_;
                Intercept2_ = _StartPty - (InvSlope_ * _StartPtx);
                Pt2a_ = InvSlope_ * (_StartPtx + QMCALC_MINOR_AXIS_RADIUS) + Intercept2_;
                Pt2b_ = InvSlope_ * (_StartPtx - QMCALC_MINOR_AXIS_RADIUS) + Intercept2_;

                _Plotter->setSecantData(_CurveNum, true,
                                        _StartPtx - QMCALC_MINOR_AXIS_RADIUS, Pt1b_,
                                        _StartPtx + QMCALC_MINOR_AXIS_RADIUS, Pt1a_,
                                        _StartPtx - QMCALC_MINOR_AXIS_RADIUS, Pt2b_,
                                        _StartPtx + QMCALC_MINOR_AXIS_RADIUS, Pt2a_);
              }

              IntFile_.close();
            }
          }
          else
            _Plotter->setSecantData(_CurveNum, false, 0, 0, 0, 0, 0, 0, 0, 0);
        }
        else if (_GraphType == GraphType::EXTREMA)
        {
          if (CalcOut_.length())
            _Plotter->setSecantData(_CurveNum, true,
                                    _StartPtx - QMCALC_MAJOR_AXIS_RADIUS, _StartPty,
                                    _StartPtx + QMCALC_MAJOR_AXIS_RADIUS, _StartPty,
                                    _StartPtx, _StartPty - QMCALC_MINOR_AXIS_RADIUS,
                                    _StartPtx, _StartPty + QMCALC_MINOR_AXIS_RADIUS);
          else
            _Plotter->setSecantData(_CurveNum, false, 0, 0, 0, 0, 0, 0, 0, 0);
        }
        else
          _Plotter->setSecantData(_CurveNum, false, 0, 0, 0, 0, 0, 0, 0, 0);

        _Plotter->setCurveData(_CurveNum, curve_, infpts_);
        curve_ = infpts_ = NULL;
        _Plotter->show();
        _CurveNum++;
      }
      else
        GraphNum_ = 2;

      if (_GraphType != GraphType::INTERSECT2 || GraphNum_ == 2)
      {
        int xMov = int(_StartPtx - QMCALC_GRAPH_RADIUS);
        int yMov = int(_StartPty - QMCALC_GRAPH_RADIUS);

        if (xMov || yMov)
          _Plotter->ScrollGraph(xMov, yMov);

        _Plotter->SetUseFileBuffers(false);
        break;
      }
      else if (_GraphType == GraphType::INTERSECT2)
      {
        if (FileSuffix_ == 'y')
          FileSuffix_ = 'a';
        else
          FileSuffix_++;

        Fname_ += FileSuffix_;
        Fname_ += ".out";
        file.setName(Fname_);
      }
    }
  }

    // No calculator output for batch input or straight function plot
    // operation with no extra applied functions: deriv, integ, etc...
    if (_GraphResult == GraphPlotOpType::FUNCTION_PLOT ||
        _GraphResult == GraphPlotOpType::BATCH_GRAPH_PLOT)
      CalcOut_ = "";
  }

  // Backlog commmands processing...
  if (WasProcessing_)
  {
    _InputBuffer = "";
    for (x = 0; x < _Index; x++)
      _InputBuffer += QString(_InputArray[x]->_Command);

    BackLog_ = _InputBuffer = _InputBuffer.stripWhiteSpace();
    CutInput();
    _UserTextEdit->setText(_SavedScreen);
  }

  sptr = _SavedScreen.ascii();
  slen = sptr ? ::strlen(sptr):0;
  AppendNl_ = false;
  
  for (--slen; slen >= 0; slen--)
  {
    AppendNl_ = !isspace(sptr[slen]);
    if (AppendNl_ || sptr[slen] == '\n')
      break;
  }

  if (CalcOut_.length() && _ResponseFromInput)
  {
    if (_ErrorResponse)
    {
      Output_ = (AppendNl_ ? QString("\n# "):QString("# ")) + CalcOut_;
      _ResultReturned = true;
    }
    else if (_Driver->IoState() == Mcalc_IOState::INPUT_REQUIRED ||
             _Driver->IoState() == Mcalc_IOState::OUTPUT_READY)
    {
      if (!InGraphPlot_)
      {
        if (_Driver->IoState() != Mcalc_IOState::INPUT_REQUIRED &&
            _Driver->InBatchFile())
          Output_ = CalcOut_;
        else
          Output_ = AppendNl_ ? (QString("\n") + CalcOut_):CalcOut_;
          
        _ResultReturned = true;
      }
      else
      {
        Output_ = QString("");
        _ResultReturned = false;
      }
    }
    else if (_Driver->IoState() != Mcalc_IOState::PROGRESS_READY)
    {
      Output_ = QString(" = ") + CalcOut_;
      EqAns_ = true;
      _ResultReturned = true;
    }
    else
    {
      Output_ = QString("");
      _ResultReturned = false;
    }
  }
  else
  {
    Output_ = QString("");
    
    if (_ResponseFromInput)
      _ResultReturned = false;
  }

  #if ((MCALCDIALOG_DEBUG1b)|(MCALCDIALOG_DEBUG2b))
    QMessageBox::warning(0, "DEBUG ShowOutput()",
                         QString("\nOutput_ == ") + Output_ +
                         QString("\nAppending To UserTextEdit dialog"),
                         QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
  #elif MCALCDIALOG_DEBUG2d
    _Driver->DbgPtr()->ShowStr(Output_.ascii(), "Output_");
    _Driver->DbgPtr()->ShowInt(CalcOut_.length(), "CalcOut_.length()");
    _Driver->DbgPtr()->ShowInt(_ResponseFromInput, "_ResponseFromInput");
    _Driver->DbgPtr()->ShowInt(_ResultReturned, "_ResultReturned");
  #endif

  _EqAnsNewLine = false;
  _SavedScreen = _UserTextEdit->text();
  _SavedScreen += Output_;

  if (_ErrorResponse ||
      (InGraphPlot_ && _GraphResult != GraphPlotOpType::BATCH_GRAPH_PLOT))
  {
    if (!_NewlineAppended)
    {
      _SavedScreen += "\n";
      _NewlineAppended = true;
    }
  }
  else if (_CalcResponse && EqAns_)
  {
    sptr = Output_.ascii();
    slen = sptr ? ::strlen(sptr):0;
    AppendNl_ = false;
    
    for (--slen; slen >= 0; slen--)
    {
      AppendNl_ = !isspace(sptr[slen]);
      if (AppendNl_ || sptr[slen] == '\n')
        break;
    }
    
    if (AppendNl_ && !_NewlineAppended)
    {
      _SavedScreen += "\n";
      _EqAnsNewLine = true;
      _NewlineAppended = true;
    }
  }

  _UserTextEdit->setText(_SavedScreen);
  _UserTextEdit->show();
  _UserTextEdit->update();
  
  MoveToEnd();

  #if MCALCDIALOG_DEBUG2d
    _Driver->DbgPtr()->ShowStr(_Driver->IoStateToStr(_Driver->IoState()), "IoState()");
    _Driver->DbgPtr()->ShowInt(_Driver->InBatchFile(), "InBatchFile()");
    _Driver->DbgPtr()->ShowInt(InGraphPlot_, "InGraphPlot_");
    _Driver->DbgPtr()->ShowInt(_EqAnsNewLine, "_EqAnsNewLine");
    _Driver->DbgPtr()->ShowInt(_ExpectedStatesHandled, "_ExpectedStatesHandled");
    _Driver->DbgPtr()->ShowInt(_ErrorResponse, "_ErrorResponse");
    _Driver->DbgPtr()->ShowInt(_CalcResponse, "_CalcResponse");
    _Driver->DbgPtr()->ShowInt(_GraphResponse, "_GraphResponse");

    _Driver->DbgPtr()->ShowInt(_NewlineAppended, "_NewlineAppended");
    _Driver->DbgPtr()->ShowInt(AppendNl_, "AppendNl_");
  #endif

  if (_Driver->IoState() == Mcalc_IOState::CALC_RESPONSE ||
      _Driver->IoState() == Mcalc_IOState::INPUT_RECEIVED ||
      _Driver->IoState() == Mcalc_IOState::OUTPUT_FETCHED ||
      _Driver->IoState() == Mcalc_IOState::PROCESS_DONE_ACK)
  {  
    _InputRequest = false;

    if (_InputRequestDetected)
      _InputRequestReplied = true;
    
    _CalcResponseSignal = _Driver->IoState() == Mcalc_IOState::CALC_RESPONSE;

    if (_CalcResponseSignal)
    {
      _CalcResponseDetected = true;
      _CalcResponseAnswered = false;
    }

    if (!_ExpectedStatesHandled)
    {
      SendExpectedResponse();
      _SignalHandled = _ExpectedStatesHandled ? Mcalc_IOState::CALC_RESPONSE:0;
    }
  }
  else
  {
    if (_ResultReturned &&
        _Driver->IoState() == Mcalc_IOState::INPUT_REQUIRED)
    {
      _InputRequest = true;
      _InputRequestDetected = true;
      _InputRequestReplied = false;
      
      _CalcResponseSignal = false;
      _CalcResponseDetected = false;
    }
    else
    {
      _CalcErrorSignal = (_ErrorResponse && _Driver->IoState() == Mcalc_IOState::CALC_ERROR);
      _GraphOutputSignal = (_GraphResponse && _Driver->IoState() == Mcalc_IOState::GRAPH_OUTPUT);
    }

    if (!_ExpectedStatesHandled &&
        (_CalcResponse || _ErrorResponse || _GraphResponse))
    {
      SendExpectedResponse();
      _SignalHandled = _ExpectedStatesHandled ?
                         (_InputRequest      ? Mcalc_IOState::INPUT_REQUIRED:
                          _CalcErrorSignal   ? Mcalc_IOState::CALC_ERROR:
                          _GraphOutputSignal ? Mcalc_IOState::GRAPH_OUTPUT:0):0;
    }
    else if (_GraphOutputSignal && _ExpectedStatesHandled)
      _SignalHandled = Mcalc_IOState::GRAPH_OUTPUT;
  }

  CalcSig_ = _CalcResponse ||
             _SignalHandled == Mcalc_IOState::INPUT_REQUIRED ||
             _SignalHandled == Mcalc_IOState::CALC_RESPONSE;
  GraphSig_ = (_GraphResult && _GraphResponse) ||
              _SignalHandled == Mcalc_IOState::GRAPH_OUTPUT;
  ErrorSig_ = _ErrorResponse ||
              _SignalHandled == Mcalc_IOState::CALC_ERROR;

  InputFileOk_ = !_Driver->InBatchFile() ||
                 ((_Driver->InProgramFile() || _Driver->InInputFile()) &&
                  ((CalcSig_ && ((_InputRequestDetected && _InputRequest) ||
                                 (_CalcResponseDetected && _CalcResponseSignal))) ||
                   (GraphSig_ && _GraphOutputSignal) ||
                   (ErrorSig_ && _CalcErrorSignal)));

  if (!_CmdHistoryCalled && !_WaitingForServerResponse &&
      (_ErrorResponse || (_ResponseFromInput && InputFileOk_)))
  {
    ProcessSendingResponse(BackLog_);
    _GraphResult = GraphPlotOpType::NO_GRAPH;
  }
  else if (!_ResponseFromInput)
  {
    if (_WaitingForServerResponse)
      RestoreResponseFromInput_ = true;
    else
    {
      _DoProcessReset = true;
      
      _SendingResponse = 0;
      _Processing = false;
    }
  }

  _Driver->ClearOutput();
  _InputBuffer = QString("");
  
  // If history button clicked then show history command dialog
  // and selected entry by user if any
  if (_CmdHistoryCalled && !_CmdHistoryLoading)
  {
    QString SesStr_;
    QString HistEntry_;
    QString Fname_ = "mcalc_cmdhistory";
    const char* EntryPtr_ = NULL;

    SesStr_.setNum(_Driver->SessionNum());
    Fname_ += SesStr_;
    Fname_ += QString(".dat");

    _CmdHistoryCalled = false;
    _CmdHistoryLoading = true;
    _CmdHistoryForm->LoadToTable(Fname_);
    _CmdHistoryEntryFound = _CmdHistoryForm->exec() == QDialog::Accepted;
    _CmdHistoryEntryFound = _CmdHistoryEntryFound ||
                            _CmdHistoryForm->GiveRetCode() == QDialog::Accepted;
    _CmdHistoryCleared = _CmdHistoryForm->IsClearHistorySet();

    if (_CmdHistoryEntryFound)
    {
      if (_CmdHistoryCleared)
      {
        _CmdHistoryEntryFound = false;
        
        if (_CmdHistoryForm->CmdFileFinished())
        {
          _ResponseFromInput = false;
          _Driver->SendUserResponse("cmdhistoryentry(cancel): clearhistory");
          _CmdHistoryForm->ResetClearHistory();
        }
        else if (_CmdHistoryForm->GiveRetCode() != QDialog::Rejected)
        {
          _CmdHistoryForm->ResetClearHistory();
          QMessageBox::information(0, QString(tr("Command History List Empty")),
            QString(tr("\nNo Entries In Command History\n")),
            QMessageBox::Ok);
        }
      }
      else
      {
        EntryPtr_ = _CmdHistoryForm->GiveCmdHistoryEntry();
      
        if (EntryPtr_)
        {
          HistEntry_ = EntryPtr_;
          BuildCombinedCharStr(HistEntry_);
        }
      }
    }
    else
    {
      if (_CmdHistoryCleared)
      {
        if (_CmdHistoryForm->CmdFileFinished())
        {
          _ResponseFromInput = false;
          _Driver->SendUserResponse("cmdhistoryentry(cancel): ");
          _CmdHistoryForm->ResetClearHistory();
        }
        else if (_CmdHistoryForm->GiveRetCode() != QDialog::Rejected)
        {
          _CmdHistoryForm->ResetClearHistory();
          QMessageBox::information(0, QString(tr("Command History List Empty")),
            QString(tr("\nNo Entries In Command History\n")),
            QMessageBox::Ok);
        }
      }
      else
      {
        if (_CmdHistoryForm->CmdFileFinished())
        {
          _ResponseFromInput = false;
          _Driver->SendUserResponse("cmdhistoryentry(cancel): ");
        }
        else if (_CmdHistoryForm->GiveRetCode() != QDialog::Rejected)
          QMessageBox::information(0, QString(tr("Command History List Empty")),
            QString(tr("\nNo Entries In Command History\n")),
            QMessageBox::Ok);
      }
    }
    
    _CmdHistoryLoading = false;
    _CmdHistoryCalled = false;
  }
  else if (_WaitingForServerResponse &&
           (_ResponseFromInput || RestoreResponseFromInput_))
  {
    _Processing =
    _ResponseFromInput = true;
    PrevSendVal_ =
    _SendingResponse = ResponseSignal::SEND_TOCALC;

    GuiReadyToSend_ = _Driver->IsGuiReadyToSend(_Driver->IoState(), true, true);
    ProcessAckDone_ = _Driver->IsProcessAckDone(_Driver->IoState());
    
    if (!_CmdHistoryCalled &&
        (_ErrorResponse || (_ResponseFromInput && InputFileOk_)))
    {
      ProcessSendingResponse(BackLog_);
      _GraphResult = GraphPlotOpType::NO_GRAPH;
    }

    GiveUserResponseResults(PrevSendVal_,
                            InError_, InputProcessed_, DoResetResponse_);

    if (GuiReadyToSend_ || ProcessAckDone_)
    {
      _WaitingForServerResponse = false;
      
      if (!_Processing && DoResetResponse_)
        DeleteBuffers_ = true;
    }

    if (DoResetResponse_)
    {
      _SendingResponse = 0;
      _Processing = false;
      _DoProcessReset = false;
    }

    if (DeleteBuffers_)
      DeleteInputBuffer();
  }

  #if ((MCALCDIALOG_DEBUG1b)|(MCALCDIALOG_DEBUG2b))
    QMessageBox::warning(0, "DEBUG ShowOutput()",
                         QString("\nLeaving ShowOutput") +
                         QString("\n_ErrorResponse == ") + QString::number(_ErrorResponse) +
                         QString("\n_Processing == ") + QString::number(_Processing) +
                         QString("\n_SendingResponse == ") + QString::number(_SendingResponse),
                         QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
  #elif MCALCDIALOG_DEBUG2d
    _Driver->DbgPtr()->ShowInt(_ErrorResponse, "_ErrorResponse");
    _Driver->DbgPtr()->ShowInt(_Processing, "_Processing");
    _Driver->DbgPtr()->ShowInt(_SendingResponse, "_SendingResponse");
    _Driver->DbgPtr()->LeaveLevel();
  #endif
}

/****************************************************************************/
void McalcDialog::ShowResultsFile(const QString& InFile_, const QString& OutFile_)
{
  if (_InputFileInProcess)
  {
    if (_ProgressForm && !_ProgressForm->IsClosed())
      _ProgressForm->ForceClose();

    _InputFilename = InFile_;
    _OutputFilename = OutFile_;
    ShowOutputFile();
  }
}

/****************************************************************************/
void McalcDialog::SendQuit()
{
  QString NullHistCmd_ = QString("cmdhistoryentry(cancel): ");

  _InputBuffer = QString(_Buttons[ButtonId::QUIT]->_Command);
  _CurPos =
  _Index = 0;

  if (_InputArray[0] && _InputArray[0]->_UserDefined)
  {
    delete[] _InputArray[0]->_Command;
    delete _InputArray[0];
  }

  _InputArray[0] = NULL;
  _Quitting = true;
  
  if (_CmdHistoryForm->CmdFileFinished() && _InputBuffer.length() &&
      _CmdHistoryEntryFound && _CmdHistoryForm->GiveCmdHistoryEntry())
  {        
    _CmdHistoryEntryFound = false;
    _InputBuffer = NullHistCmd_ + _InputBuffer;
  }

  _ResponseFromInput = false;
  _Driver->SendUserResponse(_InputBuffer, true);
  _InputBuffer = "";
}

/****************************************************************************/
void McalcDialog::SendBreak()
{
  QString NullHistCmd_ = QString("cmdhistoryentry(cancel): ");

  _InputBuffer = QString(_Buttons[ButtonId::BREAK]->_Command);
  _CurPos =
  _Index = 0;

  if (_InputArray[0] && _InputArray[0]->_UserDefined)
  {
    delete[] _InputArray[0]->_Command;
    delete _InputArray[0];
  }

  _InputArray[0] = NULL;

  if (_CmdHistoryForm->CmdFileFinished() && _InputBuffer.length() &&
      _CmdHistoryEntryFound && _CmdHistoryForm->GiveCmdHistoryEntry())
  {
    _CmdHistoryEntryFound = false;
    _InputBuffer = NullHistCmd_ + _InputBuffer;
  }

  _ResponseFromInput = false;
  _Driver->SendUserResponse(_InputBuffer, true);
  _InputBuffer = "";

  _SavedScreen = _UserTextEdit->text();
  _SavedScreen += "\n";
  _UserTextEdit->setText(_SavedScreen);
  _UserTextEdit->show();
}

/****************************************************************************/
void McalcDialog::CutInput()
{
  _SavedScreen = _UserTextEdit->text();
  int LastPos_ = _SavedScreen.findRev(_InputBuffer);
  _SavedScreen.remove(LastPos_, _InputBuffer.length());
  _SavedScreen = _SavedScreen.stripWhiteSpace();

  if (_SavedScreen.length())
    _SavedScreen += "\n";
}

/****************************************************************************/
bool McalcDialog::CheckUnprocessedSignals(int IoState_, bool SignalSent_)
{
  #if MCALCDIALOG_DEBUG2d
    _Driver->DbgPtr()->EnterLevel("McalcDialog::CheckUnprocessedSignals");
  #endif

  bool HandledProcesses_ = false;
  bool CompletedProcesses_ = false;
  bool UnhandledProcesses_ = false;
  bool UnloopedProcesses_ = false;

  bool CalcSig_ = false;
  bool GraphSig_ = false;
  bool ErrorSig_ = false;

    CompletedProcesses_ = (IoState_ == Mcalc_IOState::PROCESS_DONE_ACK &&
                           (_SignalHandled == 0 ||
                            _SignalHandled == _Driver->IoState())) ||
                          (IoState_ == Mcalc_IOState::OUTPUT_FETCHED &&
                           (_SignalHandled == 0 ||
                            _SignalHandled == _Driver->IoState())) ||
                          (IoState_ == Mcalc_IOState::BATCHFILE_ENDED_ACK &&
                           (_SignalHandled == 0 ||
                            _SignalHandled == _Driver->IoState()));

    HandledProcesses_ = (_CalcErrorSignal &&
                         IoState_ == Mcalc_IOState::CALC_ERROR &&
                         (_SignalHandled == 0 ||
                          _SignalHandled == _Driver->IoState())) ||
                        ((_CalcResponseSignal ||
                        (_CalcResponseDetected && _CalcResponseAnswered)) &&
                         IoState_ == Mcalc_IOState::CALC_RESPONSE &&
                         (_SignalHandled == 0 ||
                          _SignalHandled == _Driver->IoState())) ||
                        (_InputRequest &&
                         IoState_ == Mcalc_IOState::INPUT_RECEIVED &&
                         (_SignalHandled == 0 ||
                          _SignalHandled == _Driver->IoState())) ||
                        (_GraphOutputSignal &&
                         IoState_ == Mcalc_IOState::GRAPH_OUTPUT &&
                         (_SignalHandled == 0 ||
                          _SignalHandled == _Driver->IoState()));

    UnloopedProcesses_ = !_ExpectedStatesReceived &&
                         ((IoState_ == Mcalc_IOState::PROCESS_DONE &&
                           _SignalHandled != _Driver->IoState()) ||
                          (IoState_ == Mcalc_IOState::OUTPUT_READY &&
                           _SignalHandled != _Driver->IoState()) ||
                          (IoState_ == Mcalc_IOState::BATCHFILE_ENDED &&
                           _SignalHandled != _Driver->IoState()));

    UnhandledProcesses_ = !_ExpectedStatesReceived &&
                          ((!(_CalcErrorSignal && _SignalHandled == _Driver->IoState()) &&
                            IoState_ == Mcalc_IOState::CALC_ERROR) ||
                           (!(_CalcResponseSignal && _SignalHandled == _Driver->IoState()) &&
                            (_CalcResponseDetected && !_CalcResponseAnswered) &&
                            IoState_ == Mcalc_IOState::CALC_RESPONSE) ||
                           (!(_InputRequest && _SignalHandled == _Driver->IoState()) &&
                            (_CalcResponseDetected && !_CalcResponseAnswered) &&
                            IoState_ == Mcalc_IOState::INPUT_REQUIRED) ||
                           (!(_GraphOutputSignal && _SignalHandled == _Driver->IoState()) &&
                            IoState_ == Mcalc_IOState::GRAPH_OUTPUT));

  #if MCALCDIALOG_DEBUG2d
    _Driver->DbgPtr()->ShowInt(_ExpectedStatesReceived, "_ExpectedStatesReceived");
    _Driver->DbgPtr()->ShowInt(_ExpectedStatesHandled, "_ExpectedStatesHandled");
    _Driver->DbgPtr()->ShowInt(_CalcErrorSignal, "_CalcErrorSignal");
    _Driver->DbgPtr()->ShowInt(_CalcResponseSignal, "_CalcResponseSignal");
    _Driver->DbgPtr()->ShowInt(_InputRequest, "_InputRequest");
    _Driver->DbgPtr()->ShowInt(_CalcResponseDetected, "_CalcResponseDetected");
    _Driver->DbgPtr()->ShowInt(_CalcResponseAnswered, "_CalcResponseAnswered");
    _Driver->DbgPtr()->ShowInt(_GraphOutputSignal, "_GraphOutputSignal");
    _Driver->DbgPtr()->ShowInt(CompletedProcesses_, "CompletedProcesses_");
    _Driver->DbgPtr()->ShowInt(HandledProcesses_, "HandledProcesses_");
    _Driver->DbgPtr()->ShowInt(UnloopedProcesses_, "UnloopedProcesses_");
    _Driver->DbgPtr()->ShowInt(UnhandledProcesses_, "UnhandledProcesses_");
    _Driver->DbgPtr()->ShowInt(SignalSent_, "SignalSent_");
    _Driver->DbgPtr()->ShowInt(_Driver->InBatchFile(), "InBatchFile");
    _Driver->DbgPtr()->ShowInt(_Driver->InProgramFile(), "InProgramFile");
    _Driver->DbgPtr()->ShowInt(_Driver->InInputFile(), "InInputFile");
    
    _Driver->DbgPtr()->ShowStr(_Driver->IoStateToStr(IoState_), "IoState_");
    _Driver->DbgPtr()->ShowStr(_Driver->IoStateToStr(_SignalHandled), "_SignalHandled");
  #endif

  if (UnloopedProcesses_ || UnhandledProcesses_)
  {
    CalcSig_ = _CalcResponse ||
               _SignalHandled == Mcalc_IOState::INPUT_REQUIRED ||
               _SignalHandled == Mcalc_IOState::CALC_RESPONSE;
    GraphSig_ = (_GraphResult && _GraphResponse) ||
                _SignalHandled == Mcalc_IOState::GRAPH_OUTPUT;
    ErrorSig_ = _ErrorResponse ||
                _SignalHandled == Mcalc_IOState::CALC_ERROR;
  
    _EnterButton->setEnabled(true);
    _ReEnableTimer.stop();
    IoState_ = _Driver->IoState();

    _InputRequestDetected = IoState_ == Mcalc_IOState::INPUT_REQUIRED;
    _CalcResponseDetected = IoState_ == Mcalc_IOState::CALC_RESPONSE;

    if (CalcSig_ && ((_InputRequestDetected && _InputRequest) ||
                     (_CalcResponseDetected && _CalcResponseSignal)))
      _CalcResponse = false;
    else if (GraphSig_ && _GraphOutputSignal)
      _GraphResponse = false;
    else if (ErrorSig_ && _CalcErrorSignal)
      _ErrorResponse = false;

    if (_CalcResponseDetected || _InputRequestDetected)
    {
      _CalcResponseSignal =
      _CalcResponseAnswered = false;

      if (_InputRequestDetected)
        _InputRequest =
        _InputRequestReplied = false;
    }

    _SignalHandled = 0;
    _Driver->SetIoState(IoState_, false, true);
    SignalSent_ = true;
  }
  else if ((CompletedProcesses_ || HandledProcesses_) ||
           _Driver->IoState() == Mcalc_IOState::CALC_ERROR)
  {
    _EnterButton->setEnabled(true);
    _ReEnableTimer.stop();
    
    // if (!SignalSent_)
    //   SignalSent_ = (CompletedProcesses_ || HandledProcesses_);
    SignalSent_ = false;
  }

  #if MCALCDIALOG_DEBUG2d
    _Driver->DbgPtr()->LeaveLevel();
  #endif

  return SignalSent_;
}

/****************************************************************************/
bool McalcDialog::CheckResendSig(bool& InProgMsg_, bool& InFileMsg_,
                                 bool& NotInProgMsg_, bool& NotInFileMsg_,
                                 bool& TrailSpaces_, bool& AppNl_, bool& NewLn_, int& slen_)
{
  #if MCALCDIALOG_DEBUG2d
    _Driver->DbgPtr()->EnterLevel("McalcDialog::CheckResendSig");
  #endif

  QString TempQStr_;

  bool WasInProgram_ = false;
  bool ResendSig_ = false;
  
  char* scrptr = NULL;  
  const char* psptr = NULL;
  const char* ifsptr = NULL;

  int x;
  int slenv = 0;
  int pslen = 0;
  int ifslen = 0;
  int IoState_ = 0;

  InProgMsg_ = false;
  InFileMsg_ = false;
  NotInProgMsg_ = false;
  NotInFileMsg_ = false;
  TrailSpaces_ = false;
  AppNl_ = false;
  NewLn_ = false;
  slen_ = 0;
  
  TempQStr_ = _SavedScreen;
  TempQStr_ += QString(MSG_PROGRAM_ENDED);
  TempQStr_ += QString(MSG_INPUT_FILE_ENDED);

  WasInProgram_ = _Driver->InProgramFile();
  AppNl_ = false;
  NewLn_ = false;

  scrptr = _Driver->NewString(TempQStr_.ascii());
  if (scrptr)
    strcpy(scrptr, (_SavedScreen.length() ? _SavedScreen.ascii():""));

  slen_ = scrptr ? ::strlen(scrptr):0;
  slenv = slen_;
  pslen = strlen(MSG_PROGRAM_ENDED);
  ifslen = strlen(MSG_INPUT_FILE_ENDED);
  
  for (--slen_; slen_ >= 0; slen_--)
    if (!isspace(scrptr[slen_]) || scrptr[slen_] == '\n')
      break;

  x = (slen_ >= 0 && isspace(scrptr[slen_])) ? 1:0;

  if (WasInProgram_ && pslen+x < slenv)
  {
    TempQStr_ = _SavedScreen.right(pslen+x);
    psptr = TempQStr_.ascii();
  }
  else if (!WasInProgram_ && ifslen+x < slenv)
  {
    TempQStr_ = _SavedScreen.right(ifslen+x);
    ifsptr = TempQStr_.ascii();
  }

  if (slen_ >= 0 && !isspace(scrptr[slen_]) && scrptr[slen_])
    AppNl_ = true;
  else if (slen_ > 0 && !isspace(scrptr[slen_-1]) && scrptr[slen_] == '\n')
    NewLn_ = true;

  InProgMsg_ = (WasInProgram_ &&
                (psptr &&
                 ((x && pslen &&
                   strncmp(psptr, MSG_PROGRAM_ENDED, pslen) == 0) ||
                  strcmp(psptr, MSG_PROGRAM_ENDED) == 0)));
                     
  InFileMsg_ = (!WasInProgram_ &&
                (ifsptr &&
                 ((x && ifslen &&
                   strncmp(ifsptr, MSG_INPUT_FILE_ENDED, ifslen) == 0) ||
                  strcmp(ifsptr, MSG_INPUT_FILE_ENDED) == 0)));

  NotInProgMsg_ = (WasInProgram_ &&
                   (psptr &&
                    ((x && pslen &&
                      strncmp(psptr, MSG_PROGRAM_ENDED, pslen) != 0) ||
                     strcmp(psptr, MSG_PROGRAM_ENDED) != 0)));

  NotInFileMsg_ = (!WasInProgram_ &&
                   (ifsptr &&
                    ((x && ifslen &&
                      strncmp(ifsptr, MSG_INPUT_FILE_ENDED, ifslen) != 0) ||
                     strcmp(ifsptr, MSG_INPUT_FILE_ENDED) != 0)));

  TrailSpaces_ = slen_ >= 0 && scrptr[slen_] && isspace(scrptr[slen_]);

  IoState_ = _Driver->IoState();
  ResendSig_ = (InProgMsg_ || InFileMsg_) &&
               _Driver->InBatchFile() &&
               IoState_ == Mcalc_IOState::BATCHFILE_ENDED_ACK;

  delete[] scrptr;
  scrptr = NULL;

  #if MCALCDIALOG_DEBUG2d
    _Driver->DbgPtr()->ShowInt(x, "x");
    _Driver->DbgPtr()->ShowInt(pslen, "pslen");
    _Driver->DbgPtr()->ShowInt(ifslen, "ifslen");
    _Driver->DbgPtr()->ShowInt(AppNl_, "AppNl_");
    _Driver->DbgPtr()->ShowInt(NewLn_, "NewLn_");
    _Driver->DbgPtr()->ShowInt(InProgMsg_, "InProgMsg_");
    _Driver->DbgPtr()->ShowInt(InFileMsg_, "InFileMsg_");
    _Driver->DbgPtr()->ShowInt(NotInProgMsg_, "NotInProgMsg_");
    _Driver->DbgPtr()->ShowInt(NotInFileMsg_, "NotInFileMsg_");
    _Driver->DbgPtr()->ShowInt(TrailSpaces_, "TrailSpaces_");
    _Driver->DbgPtr()->ShowInt(ResendSig_, "ResendSig_");
    _Driver->DbgPtr()->ShowStr(_Driver->IoStateToStr(IoState_), "IoState_");
    _Driver->DbgPtr()->LeaveLevel();
  #endif

  return ResendSig_;
}

/****************************************************************************/
// class Mcalc_IOState
// {
//   public:
//   enum
//   {
//     PROCESS         = 1,     // - send process input data request from client program to calculator
//     OUTPUT_READY    = 2,     // - sent by calculator to indicate output data ready
//                              //     used to indicate text messages sent that are not meant as calculated answers
//                              //     examples: error messages, status messages, executed disp program commands...
//     CALC_HALT       = 4,     // - sent by client program to tell calculator to halt execution and quit
//     CALC_RESPONSE   = 8,     // - sent by calculator to indicate post processing response
//     INPUT_REQUIRED  = 16,    // - sent by calculator in script program or interactive text mode to
//                              //   indicate prompt from stdio/console input for additional required input data
//     OUTPUT_FETCHED  = 32,    // - sent by client program to indicate literal text string or graph plotting data fetched
//     INPUT_RECEIVED  = 64,    // - sent by client program to indicate required input data sent to calculator
//     BREAK_PROGRAM   = 128,   // - sent by client program to tell calculator to break program and exit program mode
//                              //   execution of program script if it is in program mode
//     IDLE_STATE      = 256,   // - calculator is in idle or initial starting state, set after CALC_HALT received
//     GRAPH_OUTPUT    = 512,   // - function graphing output is completed and ready to be read
//     GRAPH_WAIT      = 1024,  // - Function graphing is in process. Data points being plotted.
//     CALC_ERROR      = 2048,  // - sent by calculator to indicate calculator error from invalid input or other conditions
//     PROGRESS_READY  = 4096,  // - input data file -- calculation progress is ready and sent to gui client
//     ERROR_FETCH     = 8192,  // - set by calculator to indicate calculator error. Fetch output from error log file.
//     GRAPH_PROGRESS  = 16384, // - plotted data points -- graph plotting progress is ready and sent to gui client
//
//     INFILE_PROGRESS_ACK = 32768,  // - Input file processing progress acknowledged/fetched by client
//     GRAPH_PROGRESS_ACK  = 65536,  // - Graph plotting processing progress acknowledged/fetched by client
//     GRAPH_WAIT_ACK      = 131072, // - Graph wait signal acknowledged, graph plot operation data fetched
//
//     SPAWN_NEW_MCALC = 262144, // - sent by calculator to notify client to spawn another mcalc process
//     MCALC_SPAWNED   = 524288, // - sent by client program to indicate request to spawn mcalc process acknowledged and done
//
//     BATCHFILE_ENDED     = 1048576, // sent by calculator to indicate end of batch data input file processing
//     BATCHFILE_ENDED_ACK = 2097152, // sent by client to acknowledge and of batch data file signal
//     PROCESS_DONE        = 4194304, // sent by calculator to indicate process acknowledgement of non-output directives
//     PROCESS_DONE_ACK    = 8388608, // sent by client to acknowledge server directive execution
//
//     RESENDLASTSIG       = 16777216,  // Resend last signal sent by server
//     CLIENTPING          = 33554432, // Server ping signal to client
//     CLIENTPING_ACK      = 67108864, // Client acknowledgement of client ping signal
//   };
//
// expected valid IOState sequence
// 1. Client-->Calc : PROCESS, calculator input data sent
// non-graph output:
// 1.1 Calc-->Client : CALC_RESPONSE, Answer as calculated output returned to client         OR
//        Client-->Calc : (PROCESS|CALC_HALT|BREAK_PROGRAM), process, quit or break
// 1.2a Calc-->Client : INPUT_REQUIRED, Additional input data requested                      OR
//         Client-->Calc : INPUT_RECEIVED, Additional data sent by client
//            Client-->Calc : (PROCESS|CALC_HALT|BREAK_PROGRAM), process, quit or break
// 1.2b Calc-->Client : INPUT_REQUIRED, Additional input data requested                      OR
//         Client-->Calc : INPUT_RECEIVED, Additional data sent by client
//            Calc-->Client : INPUT_REQUIRED, Additional input data requested
// 1.3a Calc-->Client : OUTPUT_READY, Answer as non-calculated text string                    OR
//         Client-->Calc : OUTPUT_FETCHED, Non-calculated text string fetched
//            Client-->Calc : (PROCESS|CALC_HALT|BREAK_PROGRAM), process, quit or break
// 1.3b Calc-->Client : OUTPUT_READY, Answer as non-calculated text string                    OR
//         Client-->Calc : OUTPUT_FETCHED, Non-calculated text string fetched
//            Client-->Calc : OUTPUT_READY, Additional non-calculated text string output
// 1.4 Calc-->Client : CALC_ERROR, Calculator error from detected invalid input data
//        Client-->Calc : (PROCESS|CALC_HALT|BREAK_PROGRAM), process, quit or break
// 1.5 Calc-->Client : ERROR_FETCH, Calculator error from detected invalid input data
//        Client : Fetch output from error log file and set state to: CALC_ERROR
//        Client-->Calc : (PROCESS|CALC_HALT|BREAK_PROGRAM), process, quit or break
//
// graphing output:                                                                          OR
// 1.6a Calc-->Client : GRAPH_WAIT, Function graph data points being plotted,
//                                  graph operation data sent to client.
//         Client-->Calc : GRAPH_WAIT_ACK, Graph plotting operation type and data fetched
// 1.6b Calc-->Client : GRAPH_WAIT, Function graph data points being plotted,
//                                  graph operation data sent to client.
//         Client-->Calc : INPUT_RECEIVED, quit graph plotting signal sent by client
//
// 1.7 Calc-->Client : GRAPH_PROGRESS, Function graph plotting progress data sent
//        Client-->Calc : GRAPH_PROGRESS_ACK, Function graph plotting progress data fetched
// 1.8a Calc-->Client : GRAPH_OUTPUT, Graph plotting data is completed                       OR
//         Client-->Calc : OUTPUT_FETCHED, Graph plotting data points fetched
//            Client-->Calc : (PROCESS|CALC_HALT|BREAK_PROGRAM), process, quit or break
// 1.8b Calc-->Client : GRAPH_OUTPUT, Graph plotting data is completed
//         Client-->Calc : OUTPUT_FETCHED, Graph plotting data points fetched
//            Calc-->Client : BATCHFILE_ENDED, Batch data file for Graph plotting ended
//               Client-->Calc : BATCHFILE_ENDED_ACK, Acknowledge BATCHFILE_ENDED signal received
//                  Client-->Calc : (PROCESS|CALC_HALT|BREAK_PROGRAM), process, quit or break
//
// 1.9 Calc-->Client : CALC_ERROR, Calculator error from detected invalid input data
//        Client-->Calc : (PROCESS|CALC_HALT|BREAK_PROGRAM), process, quit or break
// 1.10 Calc-->Client : ERROR_FETCH, Calculator error from detected invalid input data
//         Client : Fetch output from error log file and set state to: CALC_ERROR
//         Client-->Calc : (PROCESS|CALC_HALT|BREAK_PROGRAM), process, quit or break
//
// 2. Client-->Calc : BREAK_PROGRAM, request calculator to break out from program mode
//       Client-->Calc : (PROCESS|CALC_HALT|BREAK_PROGRAM), process, quit or break
//
// 3. Client-->Calc : CALC_HALT, tell calculator to halt execution and quit
//       Calc->Client : IDLE_STATE, Calculator set to idle state before program termination
//
// 4. Calc-->Client : PROGRESS_READY, Send progress status of input data file processing
//       Client-->Calc : INFILE_PROGRESS_ACK, Non-calculated progress status text fetched
//          Calc-->Client : BATCHFILE_ENDED, Batch data file for math expressions ended
//             Client-->Calc : BATCHFILE_ENDED_ACK, Acknowledge BATCHFILE_ENDED signal received
//                Client-->Calc : (PROCESS|CALC_HALT|BREAK_PROGRAM), process, quit or break
//
// 5. Calc-->Client : SPAWN_NEW_MCALC, notify client to spawn another mcalc process
//       Client-->Calc : MCALC_SPAWNED, request to spawn mcalc process acknowledged and done
//
// 6a. Client-->Calc : PROCESS, process signal sent by client to process non-output calc. directive
//        Calc-->Client : PROCESS_DONE, send acknowledgement signal to client of directive execution
//           Client-->Calc : PROCESS_DONE_ACK, server directive execution acknowledgement from client
//              Client-->Calc : (PROCESS|CALC_HALT|BREAK_PROGRAM), process, quit or break
// 6b. Client-->Calc : PROCESS, process signal sent by client to process non-output calc. directive
//        Calc-->Client : PROCESS_DONE, send acknowledgement signal to client of directive execution
//           Client-->Calc : PROCESS_DONE_ACK, sent by client to acknowledge server directive execution
//              Client-->Calc : PROCESS_DONE, send additional acknowledgement signals to client of directive execution
//
// 7. Calc-->Client : CALC_HALT, calculator has self terminated and CALC_HALT signal is sent
//       Client : IDLE_STATE, Client sets calculator state file to idle state before quitting
//
// Input Data Batch File Mode:
// ---------------------------
// If calculator is executing a batch file or program,
// the following special cases apply:
//
//   INPUT_RECEIVED      --> INPUT_REQUIRED|OUTPUT_READY|CALC_RESPONSE|PROCESS|PROCESS_DONE
//   OUTPUT_FETCHED      --> INPUT_REQUIRED|OUTPUT_READY|CALC_RESPONSE|PROCESS|PROCESS_DONE
//   BREAK_PROGRAM       --> INPUT_REQUIRED|OUTPUT_READY|CALC_RESPONSE|PROCESS|PROCESS_DONE
//   BATCHFILE_ENDED_ACK --> INPUT_REQUIRED|OUTPUT_READY|CALC_RESPONSE|PROCESS|PROCESS_DONE
//
//   CALC_RESPONSE       --> INPUT_RECEIVED
//   CALC_ERROR          --> INPUT_RECEIVED
//   ERROR_FETCH         --> INPUT_RECEIVED
//
//   PROCESS_DONE        --> PROCESS_DONE_ACK
//   PROCESS_DONE_ACK    --> INPUT_REQUIRED|OUTPUT_READY|CALC_RESPONSE|PROCESS|PROCESS_DONE
//
// Control Signals Only (Not Saved As IO State):
// ---------------------------------------------
// 8. Client-->Calc : RESENDLASTSIG, sent by client to request resending of latest sent IO signal
//       Calc-->Client : Resending of last sent IO signal, (RESENDLASTSIG not saved)
//
// 9. Calc-->Client : CLIENTPING, sent by calculator to verify if client program is still active
//       Client-->Calc : CLIENTPING_ACK, response sent by client to verify that it is still active
//                       Calculator reverts back to previous IO state prior to sending CLIENTPING.
//                       Calculator waits for PROCESS, BREAK_PROGRAM or CALC_HALT signal from client.
//
// Valid IO States for client to start sending data:
//   IDLE_STATE         : calculator is in idle or initial starting state, set after CALC_HALT received
//   CALC_RESPONSE      : sent by calculator to indicate post processing response
//   PROCESS_DONE       : sent by calculator to indicate process acknowledgement of non-output directives
//   INPUT_REQUIRED     : sent by calculator in script program or interactive text mode to
//   OUTPUT_READY       : sent by calculator to indicate output data ready
//   CALC_ERROR         : sent by calculator to indicate calculator error from invalid input or other conditions
//   BATCHFILE_ENDED    : sent by calculator to indicate end of input batch file processing
//
// IO States that are handled elsewhere in the McalcDialog class
//   GRAPH_WAIT          : Handled by WaitForGraphOutput(), shows twirly bar on calc. input window. Sends OUTPUT_FETCHED
//   GRAPH_OUTPUT        : Handled by FetchAndGraphOutput(), sends OUTPUT_FETCHED to calc. after plotting graph
//   GRAPH_PROGRESS      : Handled by WaitForGraphProgress(), shows percentage completed of graph plot. Sends OUTPUT_FETCHED
//   PROGRESS_READY      : Handled by FetchProgress(), sends OUTPUT_FETCHED to calc. after showing progress
//   ERROR_FETCH         : Handled by _Driver object, _Driver sends CALC_ERROR signal to McalcDialog
//   BATCHFILE_ENDED     : Handled by AckEndOfBatchData(), Acknowledge BATCHFILE_ENDED signal received
//
// IO States where only calculator server program has permission to send data:
//   PROCESS             : send process input data request from client program to calculator
//   CALC_HALT           : sent by client program to tell calculator to halt execution and quit
//   OUTPUT_FETCHED      : sent by client program to indicate literal text string or graph plotting data fetched
//   INPUT_RECEIVED      : sent by client program to indicate required input data sent to calculator
//   BREAK_PROGRAM       : sent by client program to tell calculator to break program and exit program mode
//   BATCHFILE_ENDED_ACK : sent by client to acknowledge and of batch data file signal
//   PROCESS_DONE_ACK    : sent by client to acknowledge server directive execution
//
void McalcDialog::SendToInput()
{
  bool InCalcProcess_ = _GraphResult ||
                        (_GraphOutputSignal &&
                         _SignalHandled == Mcalc_IOState::GRAPH_OUTPUT) ||
                        _Driver->InBatchFile() ||
                        _Driver->InProgramFile() ||
                        _Driver->InInputFile();

  int MaxReadAttempts_ = InCalcProcess_ ? QMCALC_RETRY_READ_MAX:
                                          QMCALC_RETRY_ATTEMPTS;
  int ProcessAckDone_ = 0;
  int GuiReadyToSend_ = 0;
  int PrevSendVal_ = 0;
  int IoState_ = _Driver->IoState();
  int PrevState_ = IoState_;
  int slen = 0;

  bool SigSent1_ = false;
  bool SigSent2_ = false;
  bool SendToCalc_ = false;
  bool SendOkCond_ = false;
  bool PrevTimerStoppedSet_ = false;
  bool PrevPollNowSet_ = false;
  bool PrevTimerStopped_ = false;
  bool PrevPollNow_ = false;
  bool InError_ = _SendingResponse == ResponseSignal::ERROR_FOUND;
  bool DoResetResponse_ = false;
  bool EmptyLineReturned_ = false;
  bool ResolveBatchQuit_ = false;
  bool ResolveBatchCont_ = false;
  bool ExitEarly_ = false;
  bool WasInProgram_ = false;

  bool CalcSig_ = false;
  bool GraphSig_ = false;
  bool ErrorSig_ = false;

  bool CalcResponse_ = _CalcResponse;
  bool ErrorResponse_ = _ErrorResponse;
  bool GraphResponse_ = _GraphResponse;

  bool AppNl_ = false;
  bool NewLn_ = false;
  bool ScrActiveState_ = false;  

  bool InProgMsg_ = false;
  bool InFileMsg_ = false;
  bool NotInProgMsg_ = false;
  bool NotInFileMsg_ = false;
  bool TrailSpaces_ = false;
  bool ResendSig_ = false;
                                 
  #if ((MCALCDIALOG_DEBUG1b)|(MCALCDIALOG_DEBUG1c))
    QMessageBox::warning(0, "DEBUG SendToInput()",
                         QString("\nEntering SendToInput()") +
                         QString("\n_SendingResponse == ") + QString::number(_SendingResponse) +
                         QString("\n_Processing == ") + QString::number(_Processing),
                         QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
  #elif MCALCDIALOG_DEBUG2d
    _Driver->DbgPtr()->EnterLevel("McalcDialog::SendToInput");
    _Driver->DbgPtr()->ShowInt(_SendingResponse, "_SendingResponse");
    _Driver->DbgPtr()->ShowInt(_Processing, "_Processing");

    _Driver->DbgPtr()->ShowInt(_Driver->InBatchFile(), "InBatchFile(1)");
    _Driver->DbgPtr()->ShowInt(_Driver->InProgramFile(), "InProgramFile(1)");
    _Driver->DbgPtr()->ShowInt(_Driver->InInputFile(), "InInputFile(1)");
  #endif

  if (_Quitting)
    accept();
  else
  {
    _Driver->SetAcceptProcessAckDone(!InCalcProcess_);
    GuiReadyToSend_ = _Driver->ReadIoState(0, MaxReadAttempts_);
    IoState_ = _Driver->IoState();

    _CalcErrorSignal = (_ErrorResponse && IoState_ == Mcalc_IOState::CALC_ERROR);
    _GraphOutputSignal = (_GraphResponse && IoState_ == Mcalc_IOState::GRAPH_OUTPUT);

    CalcSig_ = _CalcResponse ||
               _SignalHandled == Mcalc_IOState::INPUT_REQUIRED ||
               _SignalHandled == Mcalc_IOState::CALC_RESPONSE;
    GraphSig_ = (_GraphResult && _GraphResponse) ||
                _SignalHandled == Mcalc_IOState::GRAPH_OUTPUT;
    ErrorSig_ = _ErrorResponse ||
                _SignalHandled == Mcalc_IOState::CALC_ERROR;
    ResendSig_ = CheckResendSig(InProgMsg_, InFileMsg_,
                                NotInProgMsg_, NotInFileMsg_,
                                TrailSpaces_, AppNl_, NewLn_, slen);

    if (!InCalcProcess_ || ResendSig_ ||
        IoState_ == Mcalc_IOState::CALC_ERROR)
    {
      SigSent1_ = CheckUnprocessedSignals(IoState_, false);

      if (!SigSent1_ && PrevState_ &&
          (ResendSig_ || (_Driver->WaitingForServerSend(PrevState_) &&
                          _Driver->IsCalcResponseSignals(IoState_))))
      {
        _EnterButton->setEnabled(true);
        _ReEnableTimer.stop();
        _Driver->SendResendLastSig();
        IoState_ = _Driver->IoState();

        #if MCALCDIALOG_DEBUG2d
          _Driver->DbgPtr()->ShowInt(_Driver->InBatchFile(), "InBatchFile(2)");
          _Driver->DbgPtr()->ShowInt(_Driver->InProgramFile(), "InProgramFile(2)");
          _Driver->DbgPtr()->ShowInt(_Driver->InInputFile(), "InInputFile(2)");
        #endif

        if (_Driver->IsCalcResponseSignals(IoState_))
        {
          _InputRequestDetected = IoState_ == Mcalc_IOState::INPUT_REQUIRED;
          _CalcResponseDetected = IoState_ == Mcalc_IOState::CALC_RESPONSE;

          if (CalcSig_ && ((_InputRequestDetected && _InputRequest) ||
                           (_CalcResponseDetected && _CalcResponseSignal)))
            CalcResponse_ =
            _CalcResponse = false;
          else if (GraphSig_ && _GraphOutputSignal)
            GraphResponse_ =
            _GraphResponse = false;
          else if (ErrorSig_ && _CalcErrorSignal)
            ErrorResponse_ =
            _ErrorResponse = false;

          if (_CalcResponseDetected || _InputRequestDetected)
          {
            _CalcResponseSignal =
            _CalcResponseAnswered = false;
            
            if (_InputRequestDetected)
              _InputRequest =
              _InputRequestReplied = false;
          }

          _SignalHandled = 0;
          _Driver->SetIoState(IoState_, false, true);
          return;
        }
      }
      else if (SigSent1_)
        return;
    }
    else if (_Driver->InBatchFile() &&
             _Driver->IsCalcResponseSignals(IoState_) &&
             !(_CalcResponseSignal || _InputRequest || ErrorResponse_) &&
             !(IoState_ == Mcalc_IOState::ERROR_FETCH ||
               IoState_ == Mcalc_IOState::GRAPH_WAIT ||
               IoState_ == Mcalc_IOState::BREAK_PROGRAM))
    {
      #if MCALCDIALOG_DEBUG2d
        _Driver->DbgPtr()->ShowStr(_Driver->IoStateToStr(IoState_), "IoState_(2)");
      #endif
    
      _EnterButton->setEnabled(true);
      _ReEnableTimer.stop();
      _InputRequestDetected = IoState_ == Mcalc_IOState::INPUT_REQUIRED;
      _CalcResponseDetected = IoState_ == Mcalc_IOState::CALC_RESPONSE;

      if (CalcSig_ && ((_InputRequestDetected && _InputRequest) ||
                       (_CalcResponseDetected && _CalcResponseSignal)))
        CalcResponse_ =
        _CalcResponse = false;
      else if (GraphSig_ && _GraphOutputSignal)
        GraphResponse_ =
        _GraphResponse = false;
      else if (ErrorSig_ && _CalcErrorSignal)
        ErrorResponse_ =
        _ErrorResponse = false;

      if (_CalcResponseDetected || _InputRequestDetected)
      {
        _CalcResponseSignal =
        _CalcResponseAnswered = false;

        if (_InputRequestDetected)
          _InputRequest =
          _InputRequestReplied = false;
      }

      _SignalHandled = 0;
      _Driver->SetIoState(IoState_, false, true);
      return;
    }
  }

  if (_SendingResponse == 0 &&
      (_Driver->IoState() == Mcalc_IOState::OUTPUT_FETCHED ||
       _Driver->IoState() == Mcalc_IOState::PROCESS_DONE_ACK ||
       _Driver->IoState() == Mcalc_IOState::BATCHFILE_ENDED_ACK))
    _Processing = false;
  else if (_SendingResponse == ResponseSignal::SEND_TOCALC &&
           (_Driver->IoState() == Mcalc_IOState::INPUT_RECEIVED ||
            _Driver->IoState() == Mcalc_IOState::CALC_RESPONSE ||
            _Driver->IoState() == Mcalc_IOState::PROCESS_DONE_ACK))
  {
    _Processing = false;
    _SendingResponse = 0;
  }
  else if (InError_)
    _SendingResponse = 0;

  if (_Driver->IoState() == Mcalc_IOState::CALC_RESPONSE ||
      _Driver->IoState() == Mcalc_IOState::INPUT_RECEIVED ||
      _Driver->IoState() == Mcalc_IOState::OUTPUT_FETCHED ||
      _Driver->IoState() == Mcalc_IOState::PROCESS_DONE_ACK)
  {
    _InputRequest = false;

    if (_InputRequestDetected)
      _InputRequestReplied = true;

    _CalcResponseSignal = _Driver->IoState() == Mcalc_IOState::CALC_RESPONSE;

    if (!_ExpectedStatesHandled)
    {
      SendExpectedResponse();
      _SignalHandled = _ExpectedStatesHandled ? Mcalc_IOState::CALC_RESPONSE:0;
    }
  }
  else
  {
    if (_ResultReturned &&
        _Driver->IoState() == Mcalc_IOState::INPUT_REQUIRED)
    {
      _InputRequest = true;
      _InputRequestDetected = true;
      _InputRequestReplied = false;

      _CalcResponseSignal = false;
      _CalcResponseDetected = false;
    }
    else
    {
      _CalcErrorSignal = (_ErrorResponse && _Driver->IoState() == Mcalc_IOState::CALC_ERROR);
      _GraphOutputSignal = (_GraphResponse && _Driver->IoState() == Mcalc_IOState::GRAPH_OUTPUT);
    }

    if (!_ExpectedStatesHandled &&
        (CalcResponse_ || ErrorResponse_ || GraphResponse_))
    {
      SendExpectedResponse();
      _SignalHandled = _ExpectedStatesHandled ?
                         (_InputRequest      ? Mcalc_IOState::INPUT_REQUIRED:
                          _CalcErrorSignal   ? Mcalc_IOState::CALC_ERROR:
                          _GraphOutputSignal ? Mcalc_IOState::GRAPH_OUTPUT:0):0;
    }
    else if (_GraphOutputSignal && _ExpectedStatesHandled)
      _SignalHandled = Mcalc_IOState::GRAPH_OUTPUT;
  }

  if (_SendingResponse != ResponseSignal::OUTPUT_SHOWN)
  {
    if (_Processing)
    {
      if (_SendingResponse > ResponseSignal::SEND_TOCALC)
      {
        _SendingResponse = 0;
        _Processing = false;
      }
      else if (!InError_)
      {
        if (_SendingResponse != 0 &&
            _Driver->IsServerStates(_Driver->IoState()))
        {
          _SendingResponse = 0;
          _Processing = false;
        }
        else
          ExitEarly_ = true;
      }
    }
    else if (_SendingResponse)
    {
      if (_SendingResponse > ResponseSignal::SEND_TOCALC)
        _SendingResponse = 0;
      else if (!InError_)
      {
        if (_SendingResponse != 0 &&
            _Driver->IsServerStates(_Driver->IoState()))
        {
          _SendingResponse = 0;
          _Processing = false;
        }
        else
          ExitEarly_ = true;
      }
    }
  }

  if (ExitEarly_)
    return;
  else
    _RecurseLimitGuard++;
  
  if (_Quitting)
    accept();
  else
  {
    IoState_ = _Driver->IoState();
    
    // Restart RetryReadTimer (poll server) upon reading IDLE IO state:
    if (IoState_ == Mcalc_IOState::IDLE_STATE ||
        _Driver->IsServerStates(IoState_))
    {
      PrevTimerStoppedSet_ = true;
      PrevTimerStopped_ = _PollTimerStopped;

      PrevPollNowSet_ = true;
      PrevPollNow_ = _PollingNow;
      
      _PollTimerStopped = true;
      _PollingNow = false;
      _RetryReadTimer.stop();
    }

    if (!GuiReadyToSend_ && _RecurseLimitGuard < QMCALC_RECURSE_LIMIT &&
        _Driver->ClientIsPolling())
    {
      PrevTimerStoppedSet_ = true;
      PrevTimerStopped_ = _PollTimerStopped;

      PrevPollNowSet_ = true;
      PrevPollNow_ = _PollingNow;
    
      _PollTimerStopped = true;
      _PollingNow = false;
      _RetryReadTimer.stop();

      MaxReadAttempts_ = InCalcProcess_ ? QMCALC_RETRY_READ_MAX:
                                          QMCALC_RETRY_ATTEMPTS;

      _Driver->SetAcceptProcessAckDone(!InCalcProcess_);
      GuiReadyToSend_ = _Driver->ReadIoState(0, MaxReadAttempts_);
      IoState_ = _Driver->IoState();

      #if MCALCDIALOG_DEBUG1b
        QMessageBox::warning(0, "DEBUG IsServerAlive(true)",
                             QString("\nIsServerAlive(true) executed ... if branch"),
                             QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
      #endif

      if (IsServerAlive(true))
      {
        SendOkCond_ = (_SendingResponse != ResponseSignal::OUTPUT_SHOWN &&
                       _Processing &&
                       (_SendingResponse > ResponseSignal::SEND_TOCALC ||
                        InError_ || (_SendingResponse != 0 &&
                                     _Driver->IsServerStates(IoState_)))) ||
                      (_SendingResponse != ResponseSignal::OUTPUT_SHOWN &&
                       !_Processing &&
                       (_SendingResponse == 0 ||
                        _SendingResponse > ResponseSignal::SEND_TOCALC ||
                        InError_ || (_SendingResponse != 0 &&
                                     _Driver->IsServerStates(IoState_))));

        if (SendOkCond_)
          SendToInput();
      }
    }
    else
    {
      #if MCALCDIALOG_DEBUG1b
        QMessageBox::warning(0, "DEBUG IsServerAlive(true)",
                             QString("\nIsServerAlive(true) executed ... else branch"),
                             QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
      #endif
      bool cond1_ = _Driver->ServerIsAlive();

      #if MCALCDIALOG_DEBUG1b
        QMessageBox::warning(0, "DEBUG ConfirmedServerAlive()",
                             QString("\nConfirmedServerAlive() executed ... else branch"),
                             QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
      #endif
      bool cond2_ = _Driver->ConfirmedServerAlive();

      #if MCALCDIALOG_DEBUG1b
        QMessageBox::warning(0, "DEBUG if condition",
                             QString("\nEntering if condition: if (cond1 || cond2)"),
                             QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
      #endif

      if (cond1_ || cond2_)
      {
        MaxReadAttempts_ = InCalcProcess_ ? QMCALC_RETRY_READ_MAX:
                                            QMCALC_RETRY_ATTEMPTS;

        _Driver->SetAcceptProcessAckDone(!InCalcProcess_);
        GuiReadyToSend_ = _Driver->ReadIoState(0, MaxReadAttempts_);
        IoState_ = _Driver->IoState();

        #if MCALCDIALOG_DEBUG1b
          QMessageBox::warning(0, "DEBUG ReadIoState",
                               QString("\nEntering ReadIoState()"),
                               QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
        #endif

        if (GuiReadyToSend_)
        {
          #if MCALCDIALOG_DEBUG1b
            QMessageBox::warning(0, "DEBUG ResetShutdownTimer",
                                 QString("\nEntering ResetShutdownTimer"),
                                 QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
          #endif
        
          ResetShutdownTimer();
        }

        CalcSig_ = _CalcResponse ||
                   _SignalHandled == Mcalc_IOState::INPUT_REQUIRED ||
                   _SignalHandled == Mcalc_IOState::CALC_RESPONSE;
        GraphSig_ = (_GraphResult && _GraphResponse) ||
                    _SignalHandled == Mcalc_IOState::GRAPH_OUTPUT;
        ErrorSig_ = _ErrorResponse ||
                    _SignalHandled == Mcalc_IOState::CALC_ERROR;
        ResendSig_ = CheckResendSig(InProgMsg_, InFileMsg_,
                                    NotInProgMsg_, NotInFileMsg_,
                                    TrailSpaces_, AppNl_, NewLn_, slen);

        InCalcProcess_ = _GraphResult ||
                         (_GraphOutputSignal &&
                          _SignalHandled == Mcalc_IOState::GRAPH_OUTPUT) ||
                         _Driver->InBatchFile() ||
                         _Driver->InProgramFile() ||
                         _Driver->InInputFile();

        if (!InCalcProcess_ || ResendSig_ ||
            IoState_ == Mcalc_IOState::CALC_ERROR)
        {
          SigSent2_ = CheckUnprocessedSignals(IoState_, false);

          if (!SigSent2_ && PrevState_ &&
              (ResendSig_ || (_Driver->WaitingForServerSend(PrevState_) &&
                              _Driver->IsCalcResponseSignals(IoState_))))
          {
            _EnterButton->setEnabled(true);
            _ReEnableTimer.stop();
            _Driver->SendResendLastSig();
            IoState_ = _Driver->IoState();

            #if MCALCDIALOG_DEBUG2d
              _Driver->DbgPtr()->ShowInt(_Driver->InBatchFile(), "InBatchFile(3)");
              _Driver->DbgPtr()->ShowInt(_Driver->InProgramFile(), "InProgramFile(3)");
              _Driver->DbgPtr()->ShowInt(_Driver->InInputFile(), "InInputFile(3)");
            #endif

            if (_Driver->IsCalcResponseSignals(IoState_))
            {
              _InputRequestDetected = IoState_ == Mcalc_IOState::INPUT_REQUIRED;
              _CalcResponseDetected = IoState_ == Mcalc_IOState::CALC_RESPONSE;

              if (CalcSig_ && ((_InputRequestDetected && _InputRequest) ||
                               (_CalcResponseDetected && _CalcResponseSignal)))
                CalcResponse_ =
                _CalcResponse = false;
              else if (GraphSig_ && _GraphOutputSignal)
                GraphResponse_ =
                _GraphResponse = false;
              else if (ErrorSig_ && _CalcErrorSignal)
                ErrorResponse_ =
                _ErrorResponse = false;

              if (_CalcResponseDetected || _InputRequestDetected)
              {
                _CalcResponseSignal =
                _CalcResponseAnswered = false;

                if (_InputRequestDetected)
                  _InputRequest =
                  _InputRequestReplied = false;
              }

              _SignalHandled = 0;
              _Driver->SetIoState(IoState_, false, true);
              return;
            }
          }
          else if (SigSent2_)
            return;
        }
        else if (_Driver->InBatchFile() &&
                 _Driver->IsCalcResponseSignals(IoState_) &&
                 !(_CalcResponseSignal || _InputRequest || ErrorResponse_ ) &&
                 !(IoState_ == Mcalc_IOState::ERROR_FETCH ||
                   IoState_ == Mcalc_IOState::GRAPH_WAIT ||
                   IoState_ == Mcalc_IOState::BREAK_PROGRAM))
        {
          #if MCALCDIALOG_DEBUG2d
            _Driver->DbgPtr()->ShowStr(_Driver->IoStateToStr(IoState_), "IoState_(3)");
          #endif
        
          _EnterButton->setEnabled(true);
          _ReEnableTimer.stop();
          _InputRequestDetected = IoState_ == Mcalc_IOState::INPUT_REQUIRED;
          _CalcResponseDetected = IoState_ == Mcalc_IOState::CALC_RESPONSE;

          if (CalcSig_ && ((_InputRequestDetected && _InputRequest) ||
                           (_CalcResponseDetected && _CalcResponseSignal)))
            CalcResponse_ =
            _CalcResponse = false;
          else if (GraphSig_ && _GraphOutputSignal)
            GraphResponse_ =
            _GraphResponse = false;
          else if (ErrorSig_ && _CalcErrorSignal)
            ErrorResponse_ =
            _ErrorResponse = false;

          if (_CalcResponseDetected || _InputRequestDetected)
          {
            _CalcResponseSignal =
            _CalcResponseAnswered = false;

            if (_InputRequestDetected)
              _InputRequest =
              _InputRequestReplied = false;
          }

          _SignalHandled = 0;
          _Driver->SetIoState(IoState_, false, true);
          return;
        }
      }
    }

    if (_RecurseLimitGuard == QMCALC_RECURSE_LIMIT)
    {
      #if MCALCDIALOG_DEBUG1b
        QMessageBox::warning(0, "DEBUG _RecurseLimitGuard",
                             QString("\n_RecurseLimitGuard == QMCALC_RECURSE_LIMIT") +
                             QString("\n_Quitting == ") + QString::number(_Quitting),
                             QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
      #endif

      if (!_Quitting)
      {
        SendQuit();
        return;
      }
      else
        accept();
    }
  }

  #if MCALCDIALOG_DEBUG1b
    QMessageBox::warning(0, "DEBUG SendToInput Main Body",
                         QString("\nEntering SendToInput Main Body"),
                         QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
  #endif

  int x, len;
  int done[3];
  char* sptr = NULL;

  QString CmdHistStr_;
  QString TempQStr_;

  bool ResponseRetval_ = false;
  bool ReadPrevVal_ = false;
  bool InputProcessed_ = false;
  bool ResponseSent_ = false;
  bool ProcessInput_ = true;
  bool Invalid_ = false;
  bool GetCommands_;
  bool DeleteBuffers_ = false;
  bool DoEnable_ = false;
  bool InputFileOk_ = false;
  bool SignalSent_ = SigSent1_ || SigSent2_;
  bool InBatchOrProg_ = _Driver->InProgramFile() || _Driver->InInputFile();

  CalcSig_ = _CalcResponse ||
             _SignalHandled == Mcalc_IOState::INPUT_REQUIRED ||
             _SignalHandled == Mcalc_IOState::CALC_RESPONSE;
  GraphSig_ = (_GraphResult && _GraphResponse) ||
              _SignalHandled == Mcalc_IOState::GRAPH_OUTPUT;
  ErrorSig_ = _ErrorResponse ||
              _SignalHandled == Mcalc_IOState::CALC_ERROR;

  InputFileOk_ = !_Driver->InBatchFile() ||
                 ((_Driver->InProgramFile() || _Driver->InInputFile()) &&
                  ((CalcSig_ && ((_InputRequestDetected && _InputRequest) ||
                                 (_CalcResponseDetected && _CalcResponseSignal))) ||
                   (GraphSig_ && _GraphOutputSignal) ||
                   (ErrorSig_ && _CalcErrorSignal)));

  bool CmdHistRespExpected_ = _CmdHistoryForm->CmdFileFinished() &&
                              _CmdHistoryEntryFound && _CmdHistoryForm->GiveCmdHistoryEntry();

  bool DoReset_ = !_Driver->InBatchFile() ||
                  !(_ErrorResponse || (_ResponseFromInput && InputFileOk_));

  DoReset_ = DoReset_ &&
             (_CalcResponse || _ErrorResponse || _GraphResponse) &&
             (!_Driver->HasExpectedStates() || _ExpectedStatesHandled);

  if (DoReset_)
  {
    _ErrorResponse = false;
    _CalcResponse = false;
    _GraphResponse = false;

    CalcResponse_ = _CalcResponse;
    ErrorResponse_ = _ErrorResponse;
    GraphResponse_ = _GraphResponse;
  }
  
  if (CmdHistRespExpected_)
    CmdHistStr_ = QString("cmdhistoryentry(") +
                  QString::number(_CmdHistoryForm->GiveCmdHistoryIndex()) +
                  QString("): ");
  else
    CmdHistStr_ = QString("cmdhistoryentry(cancel): ");

  _InputBuffer = "";
  _CmdEraseValid = false;

  if (_EvalMode)
  {
    done[0] = done[1] = done[2] = 0;
    _InputBuffer = _UserTextEdit->text();
    _InputBuffer = _InputBuffer.mid(_EvalPos);
    len = _InputBuffer.length();
    _EvalMode = false;

    for (x = 0; x < len; x++)
      if (_InputBuffer[x] == QChar('$'))
        done[0] = 1;
      else if (isalpha((_InputBuffer.ascii())[x]))
        done[1] = 1;
      else if (_InputBuffer[x] == QChar('='))
        done[2] = 1;
      else if (isspace((_InputBuffer.ascii())[x]))
        continue;
      else
        break;

    if (done[0] && done[1] && done[2])
    {
      GetCommands_ = false;
      _InputBuffer = CmdHistRespExpected_ ? (CmdHistStr_ + _InputBuffer.stripWhiteSpace()):_InputBuffer.stripWhiteSpace();
      _CmdHistoryEntryFound = false;
    }
    else
    {
      GetCommands_ = true;
      _InputBuffer = CmdHistRespExpected_ ? CmdHistStr_:QString("");
      _CmdHistoryEntryFound = false;
    }
  }
  else
  {
    GetCommands_ = true;
    _InputBuffer = CmdHistRespExpected_ ? CmdHistStr_:QString("");
    _CmdHistoryEntryFound = false;
  }

  if (GetCommands_)
    for (x = 0; x < _Index; x++)
      _InputBuffer += QString(_InputArray[x]->_Command);

  CmdHistStr_.stripWhiteSpace();
  _InputBuffer = _InputBuffer.stripWhiteSpace();
  QString LowerStr_ = _InputBuffer;
  LowerStr_ = LowerStr_.lower();

  ResolveBatchCont_ = (_BatchDataInput &&
                       _AllowBatchQuit &&
                       _NumGraphPlotDone &&
                       !_DoQuitBatchData);

  ResolveBatchQuit_ = (_BatchDataInput &&
                       _AllowBatchQuit &&
                       _NumGraphPlotDone &&
                       !_DoContinuePlot);

  if (!ResolveBatchQuit_ && !ResolveBatchCont_)
  {
    _GraphResult = GraphPlotOpType::NO_GRAPH;
    _GraphType = GraphType::NO_GRAPH;
  }
  
  if (_InputBuffer == CmdHistStr_)
  {
    _CmdHistoryEntryFound = false;
    _InputBuffer = QString("cmdhistoryentry(cancel): ");
  }

  char* newstr_ = strcpy(new char[LowerStr_.length() + 1], LowerStr_.ascii());
  len = LowerStr_.length();
  for (x = 0; x < len; x++)
    if (strncmp(&newstr_[x], "clear graph", 11) == 0)
    {
      LowerStr_ = &newstr_[x];
      break;
    }
    else if (strncmp(&newstr_[x], "graph", 5) == 0)
    {
      LowerStr_ = &newstr_[x];
      break;
    }
    else if (newstr_[x] == '=')
    {
      x++;
      while (newstr_[x] && isspace(newstr_[x]))
        x++;

      LowerStr_ = &newstr_[x];
      break;
    }

  if (strncmp(LowerStr_, "graph", 5) == 0)
  {
    #if MCALCDIALOG_DEBUG2a
      QMessageBox::warning(0, "DEBUG graph cmd entered",
                           QString("\nGraph command entered"),
                           QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
    #endif
  
    if (LowerStr_.length() > 5)
    {
      QString Rest_ = LowerStr_.mid(5);
      Rest_ = Rest_.stripWhiteSpace();

      if (strncmp(Rest_, "fmin", 4) == 0 ||
          strncmp(Rest_, "fmax", 4) == 0)
        _GraphType = GraphType::EXTREMA;
      else if (strncmp(Rest_, "deriv2", 6) == 0 ||
               strncmp(Rest_, "deriv", 5) == 0)
        _GraphType = GraphType::DERIVATIVE;
      else if (strncmp(Rest_, "integ", 5) == 0)
        _GraphType = GraphType::INTEGRAL;
      else if (strncmp(Rest_, "solve", 5) == 0)
        _GraphType = GraphType::ROOTSOLVE;
      else if (strncmp(Rest_, "intersect", 9) == 0)
        _GraphType = GraphType::INTERSECT1;
      else
      {
        if (Rest_[0] == QChar('('))
          _GraphType = GraphType::FUNCTION;
        else
          Invalid_ = true;
      }

      #if MCALCDIALOG_DEBUG2a
        QMessageBox::warning(0, "DEBUG graph cmd entered",
                             QString("\n_GraphType == ") + QString::number(_GraphType),
                             QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
      #endif
    }
    else
      Invalid_ = true;

    if (!Invalid_ && _GraphType != GraphType::NO_GRAPH &&
        !ErrorResponse_ && !CalcResponse_)
    {
      if (_GraphType != GraphType::FUNCTION)
        _GraphResult = GraphPlotOpType::APPLIED_FNCGRAPH;
      else
        _GraphResult = GraphPlotOpType::FUNCTION_PLOT;

      #if MCALCDIALOG_DEBUG2a
        QMessageBox::warning(0, "DEBUG GraphType confirmed",
                             QString("\n_GraphResult == ") + QString::number(_GraphResult),
                             QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
      #endif
    }

    #if MCALCDIALOG_DEBUG2a
      else {
        QMessageBox::warning(0, "DEBUG GraphType NOT confirmed",
                             QString("\nInvalid_ == ") + QString::number(Invalid_) +
                             QString("\n_GraphType == ") + QString::number(_GraphType),
                             QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
      }
    #endif
  }
  else if (strncmp(LowerStr_, "clear graph", 11) == 0)
  {
    _Plotter->Destruct();
    delete _Plotter;

    _Plotter = new Plotter();
    _Plotter->SetErrorMargin(QMCALC_ERROR_MARGIN);
    _Plotter->SetInfPointRadius(QMCALC_INF_POINT_RADIUS);
    _Plotter->setCaption(QObject::tr("Plotter"));
    _Plotter->SetSession(_Driver->SessionNum());
    _Plotter->SetThePrinter(_Printer);
    _CurveNum = 0;
    
    ProcessInput_ = false;
  }

  if (ProcessInput_)
  {
    // Process user input data only on valid IO States
    sptr = strcpy(new char[_InputBuffer.length() + 1], _InputBuffer.ascii());
    x = sptr ? strlen(sptr):0;
    for (--x; x >= 0; x--)
      if (isspace(sptr[x]))
        sptr[x] = 0;

    GuiReadyToSend_ = _Driver->IsGuiReadyToSend(_Driver->IoState(), true, true);
    ProcessAckDone_ = _Driver->IsProcessAckDone(_Driver->IoState());

    #if MCALCDIALOG_DEBUG1c
      QMessageBox::warning(0, "DEBUG Processing Input",
                       QString("\nEntering if (ProcessInput_)") +
                       QString("\n_Processing == ") + QString::number(_Processing) +
                       QString("\n_SendingResponse == ") + QString::number(_SendingResponse) +
                       QString("\n_Driver->IoState() == ") +
                         QString::number(_Driver->IoState()) +
                       QString("\nGuiReadyToSend_ == ") +
                         QString::number(GuiReadyToSend_) +
                       QString("\nProcessAckDone_ == ") +
                         QString::number(ProcessAckDone_) +
                       QString("\nResolveBatchQuit_ == ") +
                         QString::number(ResolveBatchQuit_) +
                       QString("\nResolveBatchCont_ == ") +
                         QString::number(ResolveBatchCont_) +
                       QString("\n_InputBuffer.length() == ") +
                         QString::number(_InputBuffer.length()),
                       QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
    #elif MCALCDIALOG_DEBUG2d
      _Driver->DbgPtr()->ShowMessage("\nEntering if (ProcessInput_)\n");
      _Driver->DbgPtr()->ShowInt(_Processing, "_Processing");
      _Driver->DbgPtr()->ShowInt(_SendingResponse, "_SendingResponse");
      _Driver->DbgPtr()->ShowStr(_Driver->IoStateToStr(_Driver->IoState()), "IoState()");
      _Driver->DbgPtr()->ShowInt(GuiReadyToSend_, "GuiReadyToSend_");
      _Driver->DbgPtr()->ShowInt(ProcessAckDone_, "ProcessAckDone_");
      _Driver->DbgPtr()->ShowInt(ResolveBatchQuit_, "ResolveBatchQuit_");
      _Driver->DbgPtr()->ShowInt(ResolveBatchCont_, "ResolveBatchCont_");
      _Driver->DbgPtr()->ShowInt(_InputBuffer.length(), "_InputBuffer.length()");
      
      if (_InputBuffer.length())
        _Driver->DbgPtr()->ShowStr(_InputBuffer.ascii(), "_InputBuffer.ascii()");
      else
        _Driver->DbgPtr()->ShowStr(_InputBuffer.ascii(), "");

      _Driver->DbgPtr()->ShowInt(_InputRequest, "_InputRequest(1)");
      _Driver->DbgPtr()->ShowInt(_InputRequestDetected, "_InputRequestDetected(1)");
      _Driver->DbgPtr()->ShowInt(_InputRequestReplied, "_InputRequestReplied(1)");
      _Driver->DbgPtr()->ShowInt(_CalcResponseSignal, "_CalcResponseSignal(1)");
      _Driver->DbgPtr()->ShowInt(_CalcResponseDetected, "_CalcResponseDetected(1)");
      _Driver->DbgPtr()->ShowInt(_CalcResponseAnswered, "_CalcResponseAnswered(1)");
      _Driver->DbgPtr()->ShowInt(CalcSig_, "CalcSig_(1)");
      _Driver->DbgPtr()->ShowInt(GraphSig_, "GraphSig_(1)");
      _Driver->DbgPtr()->ShowInt(ErrorSig_, "ErrorSig_(1)");
      _Driver->DbgPtr()->ShowInt(_CalcResponse, "_CalcResponse(1)");
      _Driver->DbgPtr()->ShowInt(_GraphResponse, "_GraphResponse(1)");
      _Driver->DbgPtr()->ShowInt(_ErrorResponse, "_ErrorResponse(1)");
    #endif

    if ((_InputBuffer.length() ||
         (!_CalcResponseAnswered &&
          ((_InputRequestDetected && _InputRequest) ||
           (_CalcResponseDetected && _CalcResponseSignal)))) &&
        (GuiReadyToSend_ || ProcessAckDone_ || ResolveBatchQuit_))
    {
      #if MCALCDIALOG_DEBUG2d
        _Driver->DbgPtr()->EnterLevel("if (_InputBuffer.length() && ...");
      #endif

      if (_ProgressForm && !_ProgressForm->IsClosed())
        _ProgressForm->ForceClose();
      
      if (!ErrorResponse_ &&
          _SendingResponse != ResponseSignal::ERROR_FOUND)
      {
        #if MCALCDIALOG_DEBUG1c
          QMessageBox::warning(0, "DEBUG SendToInput",
                           QString("\nExecuting SendUserResponse(_InputBuffer)"),
                           QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
        #endif

        if (_DoQuitBatchData)
        {
          SendToCalc_ = false;
          ReadPrevVal_ = false;
          _ResponseFromInput = false;

          _SavedScreen = _UserTextEdit->text();
          _Driver->SendUserResponse("q");
          _InputRequestDetected = _Driver->IoState() == Mcalc_IOState::INPUT_RECEIVED;

          if (_InputRequestDetected)
            _InputRequestReplied = true;

          if (_CalcResponseDetected)
            _CalcResponseAnswered = true;
        }
        else
        {
          _DoQuitBatchData = ResolveBatchQuit_ &&
                             sptr && ::strlen(sptr) == 1 &&
                             toupper(sptr[0]) == 'Q';

          #if MCALCDIALOG_DEBUG2d
            _Driver->DbgPtr()->ShowInt(_DoQuitBatchData, "_DoQuitBatchData(1)");
            if (_DoQuitBatchData)
              _Driver->DbgPtr()->ShowInt(0, "_DoContinuePlot");
          #endif

          if (_DoQuitBatchData)
          {
            _TwirlyTimer.stop();
            _DoContinuePlot = 0;

            SendToCalc_ = false;
            ReadPrevVal_ = false;
          }
          else if (ResolveBatchQuit_)
          {
            SendToCalc_ = false;
            ReadPrevVal_ = false;
          
            if (sptr &&
                ::strlen(sptr) != 0 && !_DoQuitBatchData)
              sptr[0] = 0;

            if (sptr && ::strlen(sptr) == 0)
            {
              _DoQuitBatchData = false;
              if (!_DoContinuePlot)
                _DoContinuePlot = 1;

              ResolveBatchCont_ = (_BatchDataInput &&
                                   _AllowBatchQuit &&
                                   _NumGraphPlotDone &&
                                   !_DoQuitBatchData);

              #if MCALCDIALOG_DEBUG2d
                _Driver->DbgPtr()->ShowInt(_DoQuitBatchData, "_DoQuitBatchData(2)");
                _Driver->DbgPtr()->ShowInt(_DoContinuePlot, "_DoContinuePlot");
                _Driver->DbgPtr()->ShowInt(ResolveBatchCont_, "ResolveBatchCont_");
              #endif

              if (ResolveBatchCont_)
              {
                if (_DoContinuePlot == 1)
                  StartTwirly();

                #if MCALCDIALOG_DEBUG2d
                  _Driver->DbgPtr()->ShowInt(_TwirlyState, "_TwirlyState");
                  _Driver->DbgPtr()->ShowInt(_TwirlyIncrNum, "_TwirlyIncrNum");
                  _Driver->DbgPtr()->ShowInt(_SendGraphResponse, "_SendGraphResponse");
                  _Driver->DbgPtr()->ShowInt(_PrevGraphResponse, "_PrevGraphResponse");
                  _Driver->DbgPtr()->LeaveLevel();
                #endif
                return;
              }
            }
          }
          else
            ReadPrevVal_ = true;

          if (ReadPrevVal_)
          {
            InBatchOrProg_ = _Driver->InProgramFile() || _Driver->InInputFile();

            CalcSig_ = _CalcResponse ||
                       _SignalHandled == Mcalc_IOState::INPUT_REQUIRED ||
                       _SignalHandled == Mcalc_IOState::CALC_RESPONSE;
            GraphSig_ = (_GraphResult && _GraphResponse) ||
                        _SignalHandled == Mcalc_IOState::GRAPH_OUTPUT;
            ErrorSig_ = _ErrorResponse ||
                        _SignalHandled == Mcalc_IOState::CALC_ERROR;

            InputFileOk_ = !_Driver->InBatchFile() ||
                           (InBatchOrProg_ &&
                            ((CalcSig_ &&
                             ((_InputRequestDetected && _InputRequest) ||
                              (_CalcResponseDetected && _CalcResponseSignal))) ||
                             (GraphSig_ && _GraphOutputSignal) ||
                             (ErrorSig_ && _CalcErrorSignal)));
            
            SendToCalc_ = InputFileOk_ &&
                          _Driver->IoState() != Mcalc_IOState::GRAPH_WAIT &&
                          _Driver->IoState() != Mcalc_IOState::OUTPUT_READY &&
                          _Driver->IoState() != Mcalc_IOState::GRAPH_OUTPUT;
          
            PrevSendVal_ =
            _SendingResponse = SendToCalc_ ? ResponseSignal::SEND_TOCALC:0;
          }
          else
          {
            SendToCalc_ = false;
            PrevSendVal_ = _SendingResponse = 0;
          }

          #if MCALCDIALOG_DEBUG2d
            _Driver->DbgPtr()->ShowInt(_Driver->InBatchFile(), "_Driver->InBatchFile()");
            _Driver->DbgPtr()->ShowInt(_Driver->InInputFile(), "_Driver->InInputFile()");
            _Driver->DbgPtr()->ShowInt(_Driver->InProgramFile(), "_Driver->InProgramFile()");
            
            _Driver->DbgPtr()->ShowInt(_InputRequest, "_InputRequest(2)");
            _Driver->DbgPtr()->ShowInt(_InputRequestDetected, "_InputRequestDetected(2)");
            _Driver->DbgPtr()->ShowInt(_InputRequestReplied, "_InputRequestReplied(2)");
            _Driver->DbgPtr()->ShowInt(_CalcResponseSignal, "_CalcResponseSignal(2)");
            _Driver->DbgPtr()->ShowInt(_CalcResponseDetected, "_CalcResponseDetected(2)");
            _Driver->DbgPtr()->ShowInt(_CalcResponseAnswered, "_CalcResponseAnswered(2)");
            _Driver->DbgPtr()->ShowInt(CalcSig_, "CalcSig_(2)");
            _Driver->DbgPtr()->ShowInt(GraphSig_, "GraphSig_(2)");
            _Driver->DbgPtr()->ShowInt(ErrorSig_, "ErrorSig_(2)");
            _Driver->DbgPtr()->ShowInt(_CalcResponse, "_CalcResponse(2)");
            _Driver->DbgPtr()->ShowInt(_GraphResponse, "_GraphResponse(2)");
            _Driver->DbgPtr()->ShowInt(_ErrorResponse, "_ErrorResponse(2)");
            
            _Driver->DbgPtr()->ShowInt(InputFileOk_, "InputFileOk_");
            _Driver->DbgPtr()->ShowInt(SendToCalc_, "SendToCalc_");
            _Driver->DbgPtr()->ShowInt(ReadPrevVal_, "ReadPrevVal_");
            _Driver->DbgPtr()->ShowStr(_Driver->IoStateToStr(_Driver->IoState()), "IoState()");
            _Driver->DbgPtr()->ShowStr(sptr, "sptr");
          #endif
        
          if (_Driver->IoState() == Mcalc_IOState::OUTPUT_READY ||
              _Driver->IoState() == Mcalc_IOState::GRAPH_OUTPUT)
          {
            _ResponseFromInput = false;
            PrevSendVal_ =
            _SendingResponse = 0;
            _InputRequest =
            _CalcResponseSignal = false;
            _InputRequestDetected = _Driver->IoState() == Mcalc_IOState::INPUT_REQUIRED;
            _CalcResponseDetected = _Driver->IoState() == Mcalc_IOState::CALC_RESPONSE;
            _GraphOutputSignal =
            _CalcErrorSignal = false;
            _SignalHandled = 0;
            
            SendToCalc_ = true;

            _ErrorResponse = false;
            _CalcResponse = false;
            _GraphResponse = false;
            
            _SavedScreen = _UserTextEdit->text();
            _Driver->SendUserResponse("\n");
          }
          else
          {
            _ResponseFromInput = SendToCalc_;
            
            if (_ResponseFromInput)
            {
              LowerStr_ = _InputBuffer;
              _InputBuffer = LowerStr_.lower();
              SendToCalc_ = true;

              if ((_CalcResponseDetected && _CalcResponseSignal) ||
                  (_InputRequestDetected && _InputRequest))
              {
                _CalcResponseAnswered = true;

                if (_InputRequestDetected)
                  _InputRequestReplied = true;
              }

              _SavedScreen = _UserTextEdit->text();
              #if QMCALC_WIN64VER
                DoEnable_ = InBatchOrProg_ ||
                            (_CalcResponseAnswered || _InputRequestReplied) ||
                            _Driver->IsClientStates(_Driver->IoState());
              #else
                DoEnable_ = InBatchOrProg_ ||
                            (_CalcResponseAnswered || _InputRequestReplied) ||
                            _Driver->IsClientStates(_Driver->IoState()) ||
                            _Driver->IoState() == Mcalc_IOState::SPAWN_NEW_MCALC;
              #endif

              DoEnable_ = DoEnable_ && _Driver->ShouldEnableEnter();
              _EnterButton->setEnabled(DoEnable_);
              if (!DoEnable_)
                _ReEnableTimer.start(QMCALC_REENABLE_DURATION);
              
              ResponseRetval_ = _Driver->SendUserResponse(_InputBuffer);

              if (ResponseRetval_)
              {
                _ErrorResponse = false;
                _CalcResponse = false;
                _GraphResponse = false;

                _WaitingForServerResponse = _Driver->WaitingForServerResponse();
              }
              else
              {
                SendToCalc_ = false;
                _ResponseFromInput = SendToCalc_;
              }
            }
            else if (ResolveBatchQuit_ ||
                     _Driver->IoState() == Mcalc_IOState::GRAPH_WAIT)
            {
              _InputRequestDetected = _Driver->IoState() == Mcalc_IOState::INPUT_REQUIRED;
              _CalcResponseDetected = _Driver->IoState() == Mcalc_IOState::CALC_RESPONSE;

              if ((_CalcResponseDetected && _CalcResponseSignal) ||
                  (_InputRequestDetected && _InputRequest))
              {
                _CalcResponseAnswered = true;

                if (_InputRequestDetected)
                  _InputRequestReplied = true;
              }
            
              _ResponseFromInput = false;
              PrevSendVal_ =
              _SendingResponse = 0;
              _InputRequest =
              _CalcResponseSignal = false;
              _GraphOutputSignal =
              _CalcErrorSignal = false;
              _SignalHandled = 0;
              
              SendToCalc_ = true;
              
              _ErrorResponse = false;
              _CalcResponse = false;
              _GraphResponse = false;
              
              _SavedScreen = _UserTextEdit->text();

              if (_DoQuitBatchData)
                _Driver->SendUserResponse(sptr);
              else
                _Driver->SendUserResponse("\n");
            }
          }
        }

        #if MCALCDIALOG_DEBUG2d
          _Driver->DbgPtr()->ShowInt(_TwirlyState, "_TwirlyState");
          _Driver->DbgPtr()->ShowInt(_TwirlyIncrNum, "_TwirlyIncrNum");
          _Driver->DbgPtr()->ShowInt(_SendGraphResponse, "_SendGraphResponse");
          _Driver->DbgPtr()->ShowInt(_PrevGraphResponse, "_PrevGraphResponse");
        #endif

        // IoState == Mcalc_IOState::CALC_RESPONSE   : no empty lines (process)
        // IoState == Mcalc_IOState::CALC_ERROR      : no empty lines (process)
        // IoState == Mcalc_IOState::ERROR_FETCH     : no empty lines (process)
        // IoState == Mcalc_IOState::OUTPUT_READY    : output fetched
        // IoState == Mcalc_IOState::PROCESS_DONE    : process done ack
        // IoState == Mcalc_IOState::GRAPH_OUTPUT    : graph output fetched
        // IoState == Mcalc_IOState::BATCHFILE_ENDED : AckEndOfBatchData
        // IoState == Mcalc_IOState::SPAWN_NEW_MCALC : SpawnNewMcalc
        // IoState == Mcalc_IOState::GRAPH_WAIT      : "q" or "", !SEND_TOCALC
        //
        if (_WaitingForServerResponse)
        {
          _Processing = _ResponseFromInput;
          InputProcessed_ =
          DoResetResponse_ = false;
        }
        else
          GiveUserResponseResults(PrevSendVal_,
                                  InError_, InputProcessed_, DoResetResponse_);

        if (_Driver->InBatchFile() &&
            !_Processing && !SendToCalc_ &&
            (InError_ ||
             (!_CalcResponseAnswered &&
              ((_InputRequestDetected && _InputRequest) ||
               (_CalcResponseDetected && _CalcResponseSignal)))))
        {
          _ErrorResponse = false;
          _CalcResponse = false;
          _GraphResponse = false;
          
          SendToCalc_ = true;
          DoEnable_ = _Driver->ShouldEnableEnter();
          _EnterButton->setEnabled(DoEnable_);
          if (!DoEnable_)
            _ReEnableTimer.start(QMCALC_REENABLE_DURATION);
          
          _Driver->SendUserResponse("\n");
        }

        if (!_WaitingForServerResponse)
        {
          if (InputProcessed_)
            _Processing = false;

          if (_GraphResult && _Plotter && !ErrorResponse_ && !CalcResponse_)
            _Plotter->SetUseFileBuffers(true);
        }
      }
      else
      {
        InError_ = true;
        InputProcessed_ = true;
        DoResetResponse_ = true;

        _InputRequestDetected = _Driver->IoState() == Mcalc_IOState::INPUT_REQUIRED;
        _CalcResponseDetected = _Driver->IoState() == Mcalc_IOState::CALC_RESPONSE;

        if ((_CalcResponseDetected && _CalcResponseSignal) ||
            (_InputRequestDetected && _InputRequest))
        {
          _CalcResponseAnswered = true;

          if (_InputRequestDetected)
            _InputRequestReplied = true;
        }

        _InputRequest =
        _CalcResponseSignal = false;
        _GraphOutputSignal =
        _CalcErrorSignal = false;
        _SignalHandled = 0;
        
        _Processing = false;
        _DoProcessReset = false;
        _SendingResponse = ResponseSignal::ERROR_FOUND;

        _ErrorResponse = false;
        _CalcResponse = false;
        _GraphResponse = false;

        if (_Driver->InBatchFile())
        {
          _SendingResponse = 0;
          DoEnable_ = _Driver->ShouldEnableEnter();
          _EnterButton->setEnabled(DoEnable_);
          if (!DoEnable_)
            _ReEnableTimer.start(QMCALC_REENABLE_DURATION);

          _Driver->SendUserResponse("\n");
        }
        else
        {
          if (_InputBuffer.length())
          {
            #if QMCALC_WIN64VER
              DoEnable_ = InBatchOrProg_ ||
                          (_CalcResponseAnswered || _InputRequestReplied) ||
                          _Driver->IsClientStates(_Driver->IoState());
            #else
              DoEnable_ = InBatchOrProg_ ||
                          (_CalcResponseAnswered || _InputRequestReplied) ||
                          _Driver->IsClientStates(_Driver->IoState()) ||
                          _Driver->IoState() == Mcalc_IOState::SPAWN_NEW_MCALC;
            #endif

            DoEnable_ = DoEnable_ && _Driver->ShouldEnableEnter();
            _EnterButton->setEnabled(DoEnable_);
            if (!DoEnable_)
              _ReEnableTimer.start(QMCALC_REENABLE_DURATION);

            _Driver->SendUserResponse(_InputBuffer);
          }
          else
            _Driver->SendUserResponse("\n");
        }
      }

      #if MCALCDIALOG_DEBUG2d
        _Driver->DbgPtr()->LeaveLevel();
      #endif
    }
    else if (ResolveBatchCont_ ||
             (_InputBuffer.length() == 0 &&
              ((_Driver->IoState() == Mcalc_IOState::BREAK_PROGRAM ||
                _Driver->IsServerStates(_Driver->IoState())) &&
               _Driver->IoState() != Mcalc_IOState::CALC_ERROR &&
               _Driver->IoState() != Mcalc_IOState::ERROR_FETCH &&
               _Driver->IoState() != Mcalc_IOState::GRAPH_OUTPUT &&
               _Driver->IoState() != Mcalc_IOState::OUTPUT_READY &&
               _Driver->IoState() != Mcalc_IOState::PROCESS_DONE &&
               _Driver->IoState() != Mcalc_IOState::CALC_RESPONSE &&
               _Driver->IoState() != Mcalc_IOState::BATCHFILE_ENDED)))
    {
      #if MCALCDIALOG_DEBUG2d
        _Driver->DbgPtr()->EnterLevel("if (ResolveBatchCont_ || ...");
      #endif
    
      if (_ProgressForm && !_ProgressForm->IsClosed())
        _ProgressForm->ForceClose();

      if (!ErrorResponse_ &&
          _SendingResponse != ResponseSignal::ERROR_FOUND)
      {
        #if MCALCDIALOG_DEBUG1c
          QMessageBox::warning(0, "DEBUG SendToInput",
                           QString("\nExecuting SendUserResponse(\"\\n\""),
                           QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
        #endif

        _DoQuitBatchData = false;
        if (!_DoContinuePlot)
          _DoContinuePlot = 1;

        #if MCALCDIALOG_DEBUG2d
          _Driver->DbgPtr()->ShowInt(_DoQuitBatchData, "_DoQuitBatchData");
          _Driver->DbgPtr()->ShowInt(_DoContinuePlot, "_DoContinuePlot");
          _Driver->DbgPtr()->ShowInt(ResolveBatchCont_, "ResolveBatchCont_");
          _Driver->DbgPtr()->ShowStr(_Driver->IoStateToStr(_Driver->IoState()), "IoState()");

          _Driver->DbgPtr()->ShowInt(_TwirlyState, "_TwirlyState");
          _Driver->DbgPtr()->ShowInt(_TwirlyIncrNum, "_TwirlyIncrNum");
          _Driver->DbgPtr()->ShowInt(_SendGraphResponse, "_SendGraphResponse");
          _Driver->DbgPtr()->ShowInt(_PrevGraphResponse, "_PrevGraphResponse");
        #endif

        if (ResolveBatchCont_)
        {
          if (_DoContinuePlot == 1)
            StartTwirly();

          #if MCALCDIALOG_DEBUG2d
            _Driver->DbgPtr()->LeaveLevel();
          #endif
          return;
        }
        else
        {
          _SendingResponse = 0;
          _ResponseFromInput = false;
          SendToCalc_ = true;

          if ((_CalcResponseDetected && _CalcResponseSignal) ||
              (_InputRequestDetected && _InputRequest))
          {
            _CalcResponseAnswered = true;

            if (_InputRequestDetected)
              _InputRequestReplied = true;

            if (_Driver->InBatchFile())
            {
              DoEnable_ = _Driver->ShouldEnableEnter();
              _EnterButton->setEnabled(DoEnable_);
              if (!DoEnable_)
                _ReEnableTimer.start(QMCALC_REENABLE_DURATION);
            }
          }

          _ErrorResponse = false;
          _CalcResponse = false;
          _GraphResponse = false;
                      
          _SavedScreen = _UserTextEdit->text();
          _Driver->SendUserResponse("\n");
          ResponseSent_ = true;
        }

        InError_ = _SendingResponse == ResponseSignal::ERROR_FOUND ||
                   _Driver->IoState() == Mcalc_IOState::CALC_ERROR ||
                   _Driver->IoState() == Mcalc_IOState::ERROR_FETCH;

        InputProcessed_ = false;
        DoResetResponse_ = InError_;
        _DoProcessReset = false;

        if (_Driver->InBatchFile() &&
            !ResponseSent_ &&
            !_Processing && !SendToCalc_ &&
            (InError_ ||
             (!_CalcResponseAnswered &&
              ((_InputRequestDetected && _InputRequest) ||
               (_CalcResponseDetected && _CalcResponseSignal)))))
        {
          _ErrorResponse = false;
          _CalcResponse = false;
          _GraphResponse = false;

          SendToCalc_ = true;

          DoEnable_ = _Driver->ShouldEnableEnter();
          _EnterButton->setEnabled(DoEnable_);
          if (!DoEnable_)
            _ReEnableTimer.start(QMCALC_REENABLE_DURATION);
          
          _Driver->SendUserResponse("\n");
        }
        else if (_InputBuffer.length() == 0 && !_Driver->InBatchFile() &&
                 _Driver->IoState() != Mcalc_IOState::BREAK_PROGRAM &&
                   (_Driver->IoState() == Mcalc_IOState::OUTPUT_READY ||
                    _Driver->IoState() == Mcalc_IOState::GRAPH_OUTPUT))
          EmptyLineReturned_ = true;
      }
      else
      {
        InError_ = true;
        InputProcessed_ = true;
        DoResetResponse_ = true;

        _InputRequestDetected = _Driver->IoState() == Mcalc_IOState::INPUT_REQUIRED;
        _CalcResponseDetected = _Driver->IoState() == Mcalc_IOState::CALC_RESPONSE;

        if ((_CalcResponseDetected && _CalcResponseSignal) ||
            (_InputRequestDetected && _InputRequest))
        {
          _CalcResponseAnswered = true;

          if (_InputRequestDetected)
            _InputRequestReplied = true;
        }

        _InputRequest =
        _CalcResponseSignal = false;
        _GraphOutputSignal =
        _CalcErrorSignal = false;
        _SignalHandled = 0;
        
        _Processing = false;
        _DoProcessReset = false;
        _SendingResponse = ResponseSignal::ERROR_FOUND;

        _ErrorResponse = false;
        _CalcResponse = false;
        _GraphResponse = false;

        if (_Driver->InBatchFile())
        {
          _SendingResponse = 0;
          DoEnable_ = _Driver->ShouldEnableEnter();
          _EnterButton->setEnabled(DoEnable_);
          if (!DoEnable_)
            _ReEnableTimer.start(QMCALC_REENABLE_DURATION);

          _Driver->SendUserResponse("\n");
        }
        else
        {
          if (_InputBuffer.length())
          {
            #if QMCALC_WIN64VER
              DoEnable_ = InBatchOrProg_ ||
                          (_CalcResponseAnswered || _InputRequestReplied) ||
                          _Driver->IsClientStates(_Driver->IoState());
            #else
              DoEnable_ = InBatchOrProg_ ||
                          (_CalcResponseAnswered || _InputRequestReplied) ||
                          _Driver->IsClientStates(_Driver->IoState()) ||
                          _Driver->IoState() == Mcalc_IOState::SPAWN_NEW_MCALC;
            #endif

            DoEnable_ = DoEnable_ && _Driver->ShouldEnableEnter();
            _EnterButton->setEnabled(DoEnable_);
            if (!DoEnable_)
              _ReEnableTimer.start(QMCALC_REENABLE_DURATION);
            
            _Driver->SendUserResponse(_InputBuffer);
          }
          else
            _Driver->SendUserResponse("\n");
        }
      }

      #if MCALCDIALOG_DEBUG2d
        _Driver->DbgPtr()->LeaveLevel();
      #endif      
    }
    else if (_InputBuffer.length() == 0 &&
             (_Driver->IoState() == Mcalc_IOState::CALC_ERROR ||
              _Driver->IoState() == Mcalc_IOState::ERROR_FETCH ||
              _Driver->IoState() == Mcalc_IOState::GRAPH_OUTPUT ||
              _Driver->IoState() == Mcalc_IOState::OUTPUT_READY ||
              (_CalcResponseAnswered &&
               _Driver->IoState() == Mcalc_IOState::CALC_RESPONSE) ||
              _Driver->IoState() == Mcalc_IOState::PROCESS_DONE ||
              _Driver->IoState() == Mcalc_IOState::IDLE_STATE ||
              _Driver->IoState() == Mcalc_IOState::BATCHFILE_ENDED ||
              _Driver->IsClientStates(_Driver->IoState())))
    {
      InError_ = _SendingResponse == ResponseSignal::ERROR_FOUND ||
                 _Driver->IoState() == Mcalc_IOState::CALC_ERROR ||
                 _Driver->IoState() == Mcalc_IOState::ERROR_FETCH;
    
      if ((_Driver->InBatchFile() && !_Processing) ||
          (InError_ ||
           (!_CalcResponseAnswered &&
            ((_InputRequestDetected && _InputRequest) ||
             (_CalcResponseDetected && _CalcResponseSignal)))))
      {
        SendToCalc_ = true;

        _ErrorResponse = false;
        _CalcResponse = false;
        _GraphResponse = false;

        if (_Driver->InBatchFile() && 
            _Driver->IoState() == Mcalc_IOState::PROCESS_DONE)
          _Driver->SendProcessDoneAcked(&_ExpectedStatesReceived);
        else
        {
          if (_Driver->InBatchFile())
          {
            DoEnable_ = _Driver->ShouldEnableEnter();
            _EnterButton->setEnabled(DoEnable_);
            if (!DoEnable_)
              _ReEnableTimer.start(QMCALC_REENABLE_DURATION);

            if (InFileMsg_ && AppNl_ &&
                _Driver->IoState() == Mcalc_IOState::INPUT_REQUIRED)
            {
              AppNl_ = false;
              WasInProgram_ = _Driver->InProgramFile();
              
              _SavedScreen = _UserTextEdit->text();
              _SavedScreen += "\n";
              
              if (WasInProgram_)
                _SavedScreen += MSG_PROGRAM_ENDED;
              else
                _SavedScreen += MSG_INPUT_FILE_ENDED;

              _UserTextEdit->setText(_SavedScreen);
              _UserTextEdit->show();
            }
          }

          _Driver->SendUserResponse("\n");
        }
      }
      else
      {
        if (_Driver->InBatchFile() && 
            _Driver->IoState() == Mcalc_IOState::PROCESS_DONE)
          _Driver->SendProcessDoneAcked(&_ExpectedStatesReceived);
        else
          EmptyLineReturned_ = true;
      }
    }
  }
  else
  {
    // Process user input data only on valid IO States
    GuiReadyToSend_ = _Driver->IsGuiReadyToSend(_Driver->IoState(), true, true);
    ProcessAckDone_ = _Driver->IsProcessAckDone(_Driver->IoState());
    
    if (GuiReadyToSend_ || ProcessAckDone_)
    {
      _ResponseFromInput = false;
      _SendingResponse = 0;
      
      _SavedScreen = _UserTextEdit->text();
      _Driver->SendUserResponse("cleargraph");
    }
  }

  if (!ProcessInput_ || _InputBuffer.length() == 0 ||
      (ResolveBatchQuit_ && _DoQuitBatchData) ||
      (ResolveBatchCont_ && _InputBuffer.length() > 0) ||
      (!_Processing && (_ResponseFromInput || DoResetResponse_) &&
                       (GuiReadyToSend_ || ProcessAckDone_)))
    DeleteBuffers_ = true;

  delete[] sptr;  
  delete[] newstr_;
  sptr = NULL;
  newstr_ = NULL;

  SignalSent_ = SigSent1_ || SigSent2_;
  _SavedScreen = _UserTextEdit->text();

  if ((_SavedScreen.length() > 0 &&
       (ResolveBatchQuit_ || _WaitingForServerResponse ||
        ((InputProcessed_ || DoResetResponse_) &&
         !_NewlineAppended && !_EqAnsNewLine && !_InputRequest))) ||
      (EmptyLineReturned_ && !_Driver->InBatchFile()))
  {
    ResendSig_ = CheckResendSig(InProgMsg_, InFileMsg_,
                                NotInProgMsg_, NotInFileMsg_,
                                TrailSpaces_, AppNl_, NewLn_, slen);
    
    if (!SignalSent_ &&
        _SignalHandled != Mcalc_IOState::BATCHFILE_ENDED_ACK)
    {
      ScrActiveState_ = 
        _Driver->IoState() != Mcalc_IOState::BATCHFILE_ENDED_ACK &&
        _Driver->IoState() != Mcalc_IOState::PROCESS_DONE_ACK &&
        _Driver->IoState() != Mcalc_IOState::CALC_HALT &&
        _Driver->IoState() != Mcalc_IOState::BREAK_PROGRAM &&
        _Driver->IoState() != Mcalc_IOState::GRAPH_PROGRESS &&
        _Driver->IoState() != Mcalc_IOState::GRAPH_PROGRESS_ACK  &&
        _Driver->IoState() != Mcalc_IOState::PROGRESS_READY &&
        _Driver->IoState() != Mcalc_IOState::INFILE_PROGRESS_ACK &&
        _Driver->IoState() != Mcalc_IOState::GRAPH_OUTPUT;

      if ((AppNl_ && (NotInProgMsg_ || NotInFileMsg_)) ||
          AppNl_ || (TrailSpaces_ && ScrActiveState_))
        _SavedScreen += "\n";
      else if (_Driver->IoState() == Mcalc_IOState::BATCHFILE_ENDED_ACK ||
               _Driver->IoState() == Mcalc_IOState::PROCESS_DONE_ACK)
      {
        if (_NewlineReq)
        {
          _SavedScreen += "\n";
          _NewlineReq = false;
        }
        else
          _NewlineReq = true;
      }
    }
    else if (NewLn_ && (InProgMsg_ || InFileMsg_))
    {
      TempQStr_ = _SavedScreen.left(slen+1);
      _SavedScreen = TempQStr_;
    }

    _UserTextEdit->setText(_SavedScreen);
    _UserTextEdit->show();

    #if MCALCDIALOG_DEBUG2d
      _Driver->DbgPtr()->ShowMessage("if ((_SavedScreen.length() > 0 &&\n"
                                     "  (ResolveBatchQuit_ || _WaitingForServerResponse ||...\n");
      _Driver->DbgPtr()->ShowMessage("_SavedScreen += \"\\n\";\n");
    #endif
  }

  MoveToEnd();

  #if IMPLEMENT_KEEP_ALIVE
    if (_PollTimerStopped && !_PollingNow &&
        PrevTimerStoppedSet_ && !PrevTimerStopped_ &&
        PrevPollNowSet_ && !PrevPollNow_)
      _RetryReadTimer.start(QMCALC_SERVERCHECK_INTERVAL);
  #endif

  if (DoResetResponse_ || ResolveBatchQuit_ || ResolveBatchCont_)
  {
    #if MCALCDIALOG_DEBUG1c
      QMessageBox::warning(0, "DEBUG Called From CalcDriver::SendToInput:",
                       QString("\nDoResetResponse_ == TRUE") +
                       QString("\n_SendingResponse == 0") +
                       QString("\n_Processing == false"),
                       QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
    #endif
  
    _SendingResponse = 0;
    _Processing = false;
    _DoProcessReset = false;

    if (ResolveBatchQuit_ && _DoQuitBatchData)
    {
      _Driver->ClearOutput();
      _GraphResult = GraphPlotOpType::NO_GRAPH;
      _ErrorResponse = false;
      _CalcResponse = false;
      _GraphResponse = false;

      _BatchDataInput = false;
      _AllowBatchQuit = false;
      _NumGraphPlotDone = 0;
      _DoContinuePlot = 0;
      _DoQuitBatchData = false;
    }
  }

  if (DeleteBuffers_)
    DeleteInputBuffer();

  #if MCALCDIALOG_DEBUG2d
    _Driver->DbgPtr()->LeaveLevel();
  #endif
}

/****************************************************************************/
void McalcDialog::GiveUserResponseResults(int PrevSendVal_, bool& InError_, bool& InputProcessed_, bool& DoReset_)
{
  InError_ = _SendingResponse == ResponseSignal::ERROR_FOUND ||
             _Driver->IoState() == Mcalc_IOState::CALC_ERROR ||
             _Driver->IoState() == Mcalc_IOState::ERROR_FETCH;

  _Processing = _ResponseFromInput && !_DoProcessReset &&
                _Driver->IoState() != Mcalc_IOState::GRAPH_WAIT &&
                _Driver->IoState() != Mcalc_IOState::OUTPUT_READY &&
                _Driver->IoState() != Mcalc_IOState::GRAPH_OUTPUT;
                
  InputProcessed_ = (_SendingResponse == ResponseSignal::ERROR_FOUND ||
                     _SendingResponse == ResponseSignal::OUTPUT_SHOWN) &&
                    _ResponseFromInput &&
                    PrevSendVal_ == ResponseSignal::SEND_TOCALC;

  DoReset_ = InError_ || InputProcessed_ ||
             (_ResponseFromInput && _SendingResponse == 0 &&
              PrevSendVal_ == ResponseSignal::SEND_TOCALC);

  _DoProcessReset = false;
}

/****************************************************************************/
void McalcDialog::DeleteEntry(bool Backspace_)
{
  int BoxRetVal_ = 0;
  bool CmdErased_ = false;  
  bool PrevCmdHistChar_ = false;
  bool CmdHistRespExpected_ = _CmdHistoryForm->CmdFileFinished() && _CmdHistoryEntryFound &&
                              _CmdHistoryForm->GiveCmdHistoryEntry();

  QString NullHistCmd_ = QString("cmdhistoryentry(cancel): ");
  _InputBuffer = "";

  if ((_Index > 0 && _CurPos < _Index) || (Backspace_ && _CurPos == _Index && _Index > 0))
  {
    if (!Backspace_)
      _CmdEraseValid = false;
    else if (_CmdEraseValid && !_CmdEraseConfirmed)
    {
      BoxRetVal_ = QMessageBox::question(this, QString(tr("Erase Command?")),
                            QString(tr("\nErase The Entire Command?\n")),
                            QMessageBox::Yes | QMessageBox::Default,
                            QMessageBox::No | QMessageBox::Escape);
      
      if (BoxRetVal_ == QMessageBox::Yes)
        _CmdEraseConfirmed = true;
      else if (BoxRetVal_ == QMessageBox::No)
        _CmdEraseValid = false;
    }
    
    _Index--;
    if (Backspace_ && _CurPos > 0)
      _CurPos--;

    int Length_ = _InputArray[_CurPos] ? _InputArray[_CurPos]->_Length:0;
    int x;

    if (Length_)
    {
      if (_InputArray[_CurPos] && _InputArray[_CurPos]->_UserDefined)
      {
        PrevCmdHistChar_ = _InputArray[_CurPos]->_CombinedCharStr;
        delete[] _InputArray[_CurPos]->_Command;
        delete _InputArray[_CurPos];
      }

      _InputArray[_CurPos] = NULL;

      if (_CurPos < _Index)
        for (x = _CurPos; x < _Index; x++)
          _InputArray[x] = _InputArray[x + 1];

      if (Backspace_)
      {
        for (x = 0; x < Length_; x++)
          _UserTextEdit->doKeyboardAction(QTextEdit::ActionBackspace);
      }
      else
      {
        for (x = 0; x < Length_; x++)
          _UserTextEdit->doKeyboardAction(QTextEdit::ActionDelete);
      }
      
      if (_CmdEraseValid && _CmdEraseConfirmed && PrevCmdHistChar_ && _CmdHistoryEntryLength > 0)
      {
        if (_CmdHistoryPos <= _CurPos)
        {
          _CmdHistoryEntryLength--;
  
          if (_CmdHistoryEntryLength == 0)
          {
            _CmdEraseValid = false;
            CmdErased_ = true;
          }
          else
          {
            PrevCmdHistChar_ = (_CurPos > 0) &&  _InputArray[_CurPos-1]->_CombinedCharStr;
            if (_CmdHistoryPos == _CurPos && PrevCmdHistChar_)
              _CmdHistoryPos--;
    
            if (PrevCmdHistChar_)
              DeleteEntry(true);
            else
            {
              _CmdHistoryEntryLength = 0;
              _CmdEraseValid = false;
              CmdErased_ = true;
            }
          }
        }
        else
        {
          _CmdHistoryEntryLength = 0;
          _CmdEraseValid = false;
          CmdErased_ = true;
        }
      }
      
      if ((CmdErased_ || _CurPos == 0) && CmdHistRespExpected_)
      {
        _ResponseFromInput = false;
        _Driver->SendUserResponse(NullHistCmd_);
        _CmdHistoryEntryFound = false;
      }
    }
  }
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void McalcDialog::closeEvent( QCloseEvent * ce )
{
  if (!_Quitting)
  {
    ce->ignore();
    SendQuit();
  }
  else
    ce->accept();
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
bool McalcDialog::eventFilter(QObject* target, QEvent* event)
{
  int x, Length_;
  bool DoReshow_ = false;

  if (target == _UserTextEdit)
    if (event->type() == QEvent::KeyPress)
    {
      QKeyEvent* keyEvent = (QKeyEvent*)event;
      
      if (keyEvent->key() != Qt::Key_Backspace)
        _CmdEraseValid = false;

      if (keyEvent->key() == Qt::Key_Up ||
          keyEvent->key() == Qt::Key_Down ||
          keyEvent->key() == Qt::Key_Tab ||
          keyEvent->key() == Qt::Key_Insert ||
          keyEvent->key() == Qt::Key_Home)
        return true;
      else if (keyEvent->key() == Qt::Key_Left)
      {
        if (_CurPos > 0)
        {
          --_CurPos;
          Length_ = _InputArray[_CurPos] ? _InputArray[_CurPos]->_Length:0;
          for (x = 0; x < Length_; x++)
            _UserTextEdit->moveCursor(QTextEdit::MoveBackward, false);

          return true;
        }
      }
      else if (keyEvent->key() == Qt::Key_Right)
      {
        if (_CurPos < _Index)
        {
          Length_ = _InputArray[_CurPos] ? _InputArray[_CurPos]->_Length:0;
          for (x = 0; x < Length_; x++)
            _UserTextEdit->moveCursor(QTextEdit::MoveForward, false);

          ++_CurPos;
          return true;
        }
      }
      else if (keyEvent->key() == Qt::Key_Backspace)
      {
        HandleButton(ButtonId::DEL);
        return true;
      }
      else if (keyEvent->key() == Qt::Key_Delete)
      {
        if (_Index && _CurPos < _Index)
          DeleteEntry(false);

        return true;
      }
      else if (keyEvent->key() == Qt::Key_End)
      {
        MoveToEnd();
        return true;
      }
      else if (keyEvent->key() == Qt::Key_Dollar)
      {
        if (_CurPos == 0)
        {
          _EvalMode = true;
          _EvalPos = _UserTextEdit->text().length();
        }
      }
      else if ((keyEvent->key() == Qt::Key_Enter || keyEvent->key() == Qt::Key_Return) ||
               (!keyEvent->text().isNull() && keyEvent->text().length()))
      {
        QString Text_;

        if (keyEvent->key() == Qt::Key_Enter || keyEvent->key() == Qt::Key_Return)
          Text_ = "\n";
        else
          Text_ = keyEvent->text();

        if (_CurPos < _Index)
        {
          DoReshow_ = true;
          for (x = _Index; x > _CurPos; x--)
            _InputArray[x] = _InputArray[x - 1];
        }

        _Index++;
        _InputArray[_CurPos] = new ButtonInfo;
        _InputArray[_CurPos]->_Command = strcpy(new char[2], Text_.ascii());
        _InputArray[_CurPos]->_Length = 1;
        _InputArray[_CurPos]->_UserDefined = true;
        _InputArray[_CurPos]->_CombinedCharStr = false;

        if (DoReshow_)
        {
          ReShowOutput();
          _CurPos++;
        }
        else
        {
          _InputBuffer = QString(_InputArray[_CurPos]->_Command);
          _UserTextEdit->setText(_UserTextEdit->text() + _InputBuffer);
          _UserTextEdit->scrollToBottom();
          _UserTextEdit->moveCursor(QTextEdit::MoveEnd, false);
          _UserTextEdit->show();
          _InputBuffer = QString("");
          _CurPos = _Index;
        }

        return true;
      }
    }

  return QDialog::eventFilter(target, event);
}

/****************************************************************************/
void McalcDialog::SendHistoryEntry()
{
  if (!_CmdHistoryCalled && !_CmdHistoryLoading)
  {    
    _CmdHistoryCalled = true;
    QString NullHistCmd_ = QString("cmdhistoryentry(cancel): ");
    QString CmdStr_ = QString(_Buttons[ButtonId::HISTORY]->_Command);
    
    if (_CmdHistoryForm->CmdFileFinished() &&
        _CmdHistoryEntryFound && _CmdHistoryForm->GiveCmdHistoryEntry())
    {
      _CmdHistoryEntryFound = false;
      CmdStr_ = NullHistCmd_ + CmdStr_;
    }

    _ResponseFromInput = false;
    _Driver->SendUserResponse(CmdStr_, true);
  }
}

/****************************************************************************/
void McalcDialog::ResetShutdownTimer()
{
  _PollTimerStopped = true;
  _PollingNow = false;
  
  _RetryReadTimer.stop();

  #if IMPLEMENT_KEEP_ALIVE
    if ((_Driver->PollingReset() && _Driver->ConfirmedServerAlive()) ||
        ((_Driver->ResetSignalSent() ||
          _Driver->PollingResetByServer()) && _Driver->ConfirmedClientAlive()) ||
        _Driver->PollServerRequired(0))
    {
      _PollTimerStopped = false;
      _RetryReadTimer.start(QMCALC_SERVERCHECK_INTERVAL);
    }
  #endif
}

/****************************************************************************/
void McalcDialog::CheckForServerAlive()
{
  _PollTimerStopped = true;  
  _PollingNow = true;
  
  _RetryReadTimer.stop();

  #if IMPLEMENT_KEEP_ALIVE
    _Driver->PollServerIfAlive(1);
  #endif
}

/****************************************************************************/
bool McalcDialog::IsServerAlive(bool AfterPolled_)
{
  #if IMPLEMENT_KEEP_ALIVE
    return (_Driver->ConfirmedServerAlive() &&
            (AfterPolled_ || _Driver->ServerIsAlive()));
  #else
    return true;
  #endif
}

/****************************************************************************/
void McalcDialog::AckEndOfBatchData()
{
  #if MCALCDIALOG_DEBUG2a
    QMessageBox::warning(0, "DEBUG Entering AckEndOfBatchData",
                         QString("\nEntering AckEndOfBatchData()"),
                         QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
  #elif MCALCDIALOG_DEBUG2d
    _Driver->DbgPtr()->EnterLevel("AckEndOfBatchData");
    _Driver->DbgPtr()->ShowInt(_CalcResponseAnswered, "_CalcResponseAnswered");
    _Driver->DbgPtr()->ShowInt(_InputRequestReplied, "_InputRequestReplied");
    _Driver->DbgPtr()->ShowInt(_InputRequestDetected, "_InputRequestDetected");
    _Driver->DbgPtr()->ShowInt(_InputRequest, "_InputRequest");
    _Driver->DbgPtr()->ShowInt(_CalcResponseDetected, "_CalcResponseDetected");
    _Driver->DbgPtr()->ShowInt(_CalcResponseSignal, "_CalcResponseSignal");
  #endif

  int slen = 0;
  bool AppNl_ = false;
  bool NewLn_ = false;

  bool InProgMsg_ = false;
  bool InFileMsg_ = false;
  bool NotInProgMsg_ = false;
  bool NotInFileMsg_ = false;
  bool TrailSpaces_ = false;
  bool WasInProgram_ = false;
  bool InBatch_ = false;

  _TwirlyTimer.stop();

  if (!_Driver->InProgressDataFile())
  {
    _Driver->SetInBatchFile(false, true);
    _Driver->StopAllTimers();
  }  

  _ExpectedStatesHandled = true;
  _ExpectedStatesReceived = false;
  _SignalHandled = Mcalc_IOState::BATCHFILE_ENDED;
  ProcessSendingResponse(QString(""));
  InBatch_ = _Driver->InBatchFile() || _Driver->InProgressDataFile();

  if (InBatch_ && !_Driver->InProgressDataFile())
  {
    _SendingResponse = 0;
    _Processing = false;
    _DoProcessReset = false;

    _InputRequestDetected = _Driver->IoState() == Mcalc_IOState::INPUT_REQUIRED;
    _CalcResponseDetected = _Driver->IoState() == Mcalc_IOState::CALC_RESPONSE;

    if ((_CalcResponseDetected && _CalcResponseSignal) ||
        (_InputRequestDetected && _InputRequest))
    {
      _CalcResponseAnswered = true;

      if (_InputRequestDetected)
        _InputRequestReplied = true;
    }
    else
      _InputRequestReplied =
      _CalcResponseAnswered = false;

    _InputRequest =
    _CalcResponseSignal = false;
    _GraphOutputSignal =
    _CalcErrorSignal = false;
    _SignalHandled = 0;

    DeleteInputBuffer();
  }
  else if (!InBatch_)
  {
    _Driver->ClearOutput();
    _Driver->ClearInput();
    _GraphResult = GraphPlotOpType::NO_GRAPH;

    _InputRequestDetected = _Driver->IoState() == Mcalc_IOState::INPUT_REQUIRED;
    _CalcResponseDetected = _Driver->IoState() == Mcalc_IOState::CALC_RESPONSE;

    if ((_CalcResponseDetected && _CalcResponseSignal) ||
        (_InputRequestDetected && _InputRequest))
    {
      _CalcResponseAnswered = true;

      if (_InputRequestDetected)
        _InputRequestReplied = true;
    }
    else
      _InputRequestReplied =
      _CalcResponseAnswered = false;
    
    _Processing = false;
    _ErrorResponse = false;
    _CalcResponse = false;
    _GraphResponse = false;

    _BatchDataInput = false;
    _AllowBatchQuit = false;
    _NumGraphPlotDone = 0;
    _DoContinuePlot = 0;
    _DoQuitBatchData = false;
    _SendingResponse = 0;

    _InputRequest =
    _CalcResponseSignal = false;
    _GraphOutputSignal =
    _CalcErrorSignal = false;
    _SignalHandled = 0;
    
    _InputBuffer = QString("");
    DeleteInputBuffer();
    WasInProgram_ = _Driver->InProgramFile();

    CheckResendSig(InProgMsg_, InFileMsg_,
                   NotInProgMsg_, NotInFileMsg_,
                   TrailSpaces_, AppNl_, NewLn_, slen);

    if (WasInProgram_)
    {
      if (NotInProgMsg_)
      {
        if (AppNl_)
          _SavedScreen += "\n";

        _SavedScreen += MSG_PROGRAM_ENDED;
        AppNl_ = false;
      }
      else if (AppNl_)
      {
        _SavedScreen += "\n";
        AppNl_ = false;
      }
    }
    else
    {
      if (NotInFileMsg_)
      {
        if (AppNl_)
          _SavedScreen += "\n";

        _SavedScreen += MSG_INPUT_FILE_ENDED;
        AppNl_ = false;
      }
      else if (AppNl_)
      {
        _SavedScreen += "\n";
        AppNl_ = false;
      }
    }

    if (AppNl_)
      _SavedScreen += "\n";

    _UserTextEdit->setText(_SavedScreen);
    _UserTextEdit->show();
    MoveToEnd();
  }

  #if MCALCDIALOG_DEBUG2d
    _Driver->DbgPtr()->LeaveLevel();
  #endif

  _SignalHandled = Mcalc_IOState::BATCHFILE_ENDED_ACK;
  
  if (!InBatch_)
  {
    _EnterButton->setEnabled(true);
    _ReEnableTimer.stop();
  }

  _Driver->SendEndBatchFileAcked(&_ExpectedStatesReceived);

  #if MCALCDIALOG_DEBUG2a
    QMessageBox::warning(0, "DEBUG Leaving AckEndOfBatchData",
                         QString("\nLeaving AckEndOfBatchData"),
                         QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton);
  #endif
}

/****************************************************************************/
void McalcDialog::ResetExpectedStates()
{
  #if MCALCDIALOG_DEBUG2d
    _Driver->DbgPtr()->EnterLevel("ResetExpectedStates");
    _Driver->DbgPtr()->ShowInt(_CalcResponseAnswered, "_CalcResponseAnswered");
    _Driver->DbgPtr()->ShowInt(_InputRequestReplied, "_InputRequestReplied");
    _Driver->DbgPtr()->ShowInt(_InputRequestDetected, "_InputRequestDetected");
    _Driver->DbgPtr()->ShowInt(_InputRequest, "_InputRequest");
    _Driver->DbgPtr()->ShowInt(_CalcResponseDetected, "_CalcResponseDetected");
    _Driver->DbgPtr()->ShowInt(_CalcResponseSignal, "_CalcResponseSignal");
  #endif

  _ExpectedStatesHandled = false;
  _ExpectedStatesReceived = false;

  _InputRequestDetected = _Driver->IoState() == Mcalc_IOState::INPUT_REQUIRED;
  _CalcResponseDetected = _Driver->IoState() == Mcalc_IOState::CALC_RESPONSE;
  
  if ((_CalcResponseDetected && _CalcResponseSignal) ||
      (_InputRequestDetected && _InputRequest))
  {
    _CalcResponseAnswered = true;

    if (_InputRequestDetected)
      _InputRequestReplied = true;
  }
  else
    _InputRequestReplied =
    _CalcResponseAnswered = false;
  
  _InputRequest =
  _CalcResponseSignal = false;
  _GraphOutputSignal =
  _CalcErrorSignal = false;
  _SignalHandled = 0;
              
  _ErrorResponse = false;
  _CalcResponse = false;
  _GraphResponse = false;

  #if MCALCDIALOG_DEBUG2d
    _Driver->DbgPtr()->LeaveLevel();
  #endif
}

/****************************************************************************/
