#ifndef PLOTTER_H
#define PLOTTER_H

#include <qpixmap.h>
#include <qwidget.h>
#include <qpointarray.h>
#include <qlabel.h>
#include <qvbox.h>
#include <qfile.h>
#include <qstring.h>
#include <qtextedit.h>
#include <qprinter.h>
#include <qmessagebox.h>
#include <qstylesheet.h>
#include <qpaintdevicemetrics.h>
#include <qsimplerichtext.h>
#include <qfont.h>

#include <map>
#include <vector>

#define PLOTTER_DEBUG		0
#define PLOTTERDATA_DEBUG	0

/****************************************************************************/
class QToolButton;
class PlotSettings;

typedef std::vector<double> CurveData;

/****************************************************************************/
struct GraphData
{
    CurveData* _CurveData;
    CurveData* _InfinityPts;
    bool _HasSecant;
    int _NumSecants;
    QString _Function;
    
    double _SecantData[8];
    double _SecantData2[8];
    double _SecantData3[8];
};

/****************************************************************************/
class Plotter : public QWidget
{
    Q_OBJECT
public:
    Plotter(QWidget *parent = 0, const char *name = 0,
            WFlags flags = 0);
    void Destruct();

    void ClearTracePt();
    void ShowTracePt(size_t CurveNum_, size_t Index_,
                     double Ptx, double Pty, double Radius_);
    void setPlotSettings(const PlotSettings &settings);
    void SetInfPointRadius(double Rad_);
    void SetErrorMargin(double Eps_);
    void SetSession(int Session_);
    void ScrollGraph(int Horz_, int Vert_);
    void initCurveData(size_t id, const QString& Function_);
    void setCurveData(size_t id, CurveData *data, CurveData *infdata);
    void popSecantData(size_t id);
    void pushSecantData(size_t id);
    void setSecantData(size_t id, bool HasSecant_,
                       double Pt1x, double Pt1y,
                       double Pt2x, double Pt2y,
                       double Pt3x, double Pt3y,
                       double Pt4x, double Pt4y);
    void clearCurve(size_t id);
    void clearCurves();
    QSize minimumSizeHint() const;
    QSize sizeHint() const;
    const PlotSettings& CurrentSettings() const;
    const CurveData& GetCurveData(size_t id);
    size_t NumCurves() const;
    void SetUseFileBuffers(bool Flag_);
    bool UseFileBuffers() const;
    void SetThePrinter(QPrinter* Printer_);
    void SetToPaintOnPrinter();

public slots:
    void zoomIn();
    void zoomOut();

protected:
    void paintEvent(QPaintEvent *event);
    void resizeEvent(QResizeEvent *event);
    void mousePressEvent(QMouseEvent *event);
    void mouseMoveEvent(QMouseEvent *event);
    void mouseReleaseEvent(QMouseEvent *event);
    void keyPressEvent(QKeyEvent *event);
    void wheelEvent(QWheelEvent *event);

private:
    void SetPrintMetrics(QPainter* p);
    void PrintPlotterElements(QPainter* p);
    void updateRubberBandRegion();
    void refreshPixmap();
    void drawGrid(QPainter *painter);
    void drawCurves(QPainter *painter);
    void FillSubinterval(QPainter* painter, const QPoint& Pt1, const QPoint& Pt2, int Zero_);
    void DrawGraphMarkers(QPainter *painter, const double* points, const QColor& color_);
    void PlotSecantLine(QPainter *painter, const double* points);
    void PlotTracePt(QPainter *painter, const double* points);
    void AdjustForTracePt();
    void SetTracePt(size_t CurveNum_, size_t Index_,
                    double Ptx, double Pty, double Radius_);
    void SaveCurve(size_t id);
    void ReadCurve(size_t id);
    void EraseDataFiles();

    enum { Margin = 40,
           MIN_WIDTH = 160 };
    double EPSILON;
    double _InfPtRad;
    
    bool _Tracing;
    size_t _CurveNum;
    size_t _TraceIndex;
    double _TracePts[8];
    double _TracePtx;
    double _TracePty;
    double _Radius;

    QTextEdit* _UserTextEdit;
    QPrinter* _Printer;
    QLabel* _Xplot;
    QLabel* _Yplot;
    QToolButton *zoomInButton;
    QToolButton *zoomOutButton;
    std::map<int, GraphData> curveMap;
    std::vector<PlotSettings> zoomStack;
    int curZoom;
    bool rubberBandIsShown;
    QRect rubberBandRect;
    QPixmap pixmap;
    int _Xoffset;
    int _Yoffset;

    size_t _NumCurves;    
    size_t _ActiveCurve;
    int _Session;
    bool _UseFileBuffers;
    bool _SetToPrint;
    QRect _PrintArea;
    double _Xtrans;
    double _Ytrans;
};

/****************************************************************************/
class PlotSettings
{
public:
    PlotSettings();

    void scroll(int dx, int dy);
    void adjust();
    double spanX() const { return maxX - minX; }
    double spanY() const { return maxY - minY; }

    double minX;
    double maxX;
    int numXTicks;
    double minY;
    double maxY;
    int numYTicks;

private:
    void adjustAxis(double &min, double &max, int &numTicks);
};

/****************************************************************************/
#endif
