/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/
// in progressform.h
// #include "calcdriver.h"
//
void ProgressForm::init()
{
  _Calc = NULL;
  _TotalSteps = 20;
  _DoneSteps = 0;
  _LabelStr = "";
  _Closed = false;
  _Ended = true;
}

/*****************************************************************************/
void ProgressForm::SetTotalSteps(int Steps_)
{
  _TotalSteps = Steps_;
  ResetWaitTextLabel();
}

/*****************************************************************************/
void ProgressForm::ResetProgressForm()
{
  _DoneSteps = 0;
  _ProgressBar->setTotalSteps(_TotalSteps);
  _ProgressBar->reset();
  _Ended = false;
  _Closed = !isVisible() && (_Ended || (_ProgressBar->progress() == _ProgressBar->totalSteps()));
  
  if (!_Closed)
    DoEndCalcProgress();
}

/*****************************************************************************/
void ProgressForm::SetCalcObject(CalcDriver* CalcPtr_)
{
  if (_Calc)
    return;

  _Calc = CalcPtr_;
  
  ResetProgressForm();
  setCaption(QString(tr("Input Data File Processing Progress Bar")));
  
  connect(_Calc, SIGNAL(SendCalcProgress(int)),
          this, SLOT(ReceiveCalcProgress(int)));
  connect(_Calc, SIGNAL(EndCalcProgress()),
          this, SLOT(DoEndCalcProgress()));    
  connect(_Calc, SIGNAL(SendTotalSteps(int)),
          this, SLOT(SetTotalSteps(int)));
  connect(_Calc, SIGNAL(SendCalcProgressLabel(const QString&)),
          this, SLOT(SetWaitTextLabel(const QString&)));
  connect(_Calc, SIGNAL(SendOutputFilename(const QString&)),
          this, SLOT(SetOutputFilename(const QString&)));
  connect(_Calc, SIGNAL(SendInputFilename(const QString&)),
          this, SLOT(SetInputFilename(const QString&)));
}

/*****************************************************************************/
int ProgressForm::IsClosed() const
{
  bool ret = !isVisible() && (_Ended || (_ProgressBar->progress() == _ProgressBar->totalSteps()));
  return ret;
}

/*****************************************************************************/
void ProgressForm::ForceClose()
{
  _Closed = !isVisible() && (_Ended || (_ProgressBar->progress() == _ProgressBar->totalSteps()));
  
  if (!_Closed)
    DoEndCalcProgress();
}

/*****************************************************************************/
void ProgressForm::DoEndCalcProgress()
{
  if (!isVisible())  
    show();
  
  _Closed = false;

  int x;
  for (x = _ProgressBar->progress(); x < _ProgressBar->totalSteps(); x++)
    _ProgressBar->setProgress(x, _TotalSteps);

  accept();
  _Closed = true;
  _Ended = true;

  _ProgressBar->setTotalSteps(_TotalSteps);
  _ProgressBar->reset();
  _DoneSteps = 0; 
}

/*****************************************************************************/
void ProgressForm::ReceiveCalcProgress(int Steps_)
{
  if (!isVisible())
    show();
  
  _Closed = false;

  _DoneSteps = Steps_;
  _ProgressBar->setProgress(_DoneSteps, _TotalSteps);
  UpdateWaitTextLabel();

  if (_DoneSteps == _ProgressBar->totalSteps())
  {
    accept();
    _Closed = true;
    _Ended = true;

    _ProgressBar->setTotalSteps(_TotalSteps);
    _ProgressBar->reset();
  }
}

/*****************************************************************************/
QString ProgressForm::GetOutputFilename() const
{
  return _OutputFile;
}

/*****************************************************************************/
void ProgressForm::SetOutputFilename(const QString& Str_)
{
  _OutputFile = Str_;
}

/*****************************************************************************/
QString ProgressForm::GetInputFilename() const
{
  return _InputFile;
}

/*****************************************************************************/
void ProgressForm::SetInputFilename(const QString& Str_)
{
  _InputFile = Str_;
  QString CaptionStr_ = QString(tr("Processing Input Data File: ")) + _InputFile;
  setCaption(CaptionStr_);
}

/*****************************************************************************/
void ProgressForm::SetWaitTextLabel( const QString & Str_ )
{
  _LabelStr = Str_;
  
  if (_LabelStr.length())
  {
    _WaitTextLabel->setText(_LabelStr);
    _WaitTextLabel->update(); 
  }
  
  _Closed = !isVisible() && (_Ended || (_ProgressBar->progress() == _ProgressBar->totalSteps()));
}

/*****************************************************************************/
void ProgressForm::UpdateWaitTextLabel()
{
  double pctdonefv_ = (double(_DoneSteps) / _TotalSteps) * 100;
  int pctdonernd_ = int(pctdonefv_ + .5);
  
  if (_Calc)
  {
    if (_LabelStr.length())
    {
      _WaitTextLabel->setText(_LabelStr + QString::number(pctdonernd_) +
                              QString(tr("% complete")));
    }
    else
    {
      _LabelStr = QString(tr("Input Data File Processing In Progress... "));
      _WaitTextLabel->setText(_LabelStr + QString::number(pctdonernd_) +
                              QString(tr("% complete")));
    }

    _WaitTextLabel->show();
    _WaitTextLabel->update();
    _WaitTextLabel->repaint();
  }
  
  _Closed = !isVisible() && (_Ended || (_ProgressBar->progress() == _ProgressBar->totalSteps()));
}

/*****************************************************************************/
void ProgressForm::ResetWaitTextLabel()
{
  if (_Calc)
    ResetProgressForm();
  
  UpdateWaitTextLabel();
}

/*****************************************************************************/
