// debug macros used with the methods defined in debugutils.h
//
// redefine in file being debugged by using the following preprocesssor definitions:
//
//   #undef IN_DEBUGGING_MODE
//   #define IN_DEBUGGING_MODE    1
//   #include "debugmacros.h"
//
// by default the IN_DEBUGGING_MODE switch is off as defined in the debugutils.h file
//

#if IN_DEBUGGING_MODE
  #undef SHOWMETHOD
  #undef SHOWPARENTMETHOD
  #undef SETDBGFILE
  #undef ENTERLEVEL
  #undef LEAVELEVEL
  #undef SHOWMESSAGE
  #undef SHOWSTR
  #undef SHOWCHAR
  #undef SHOWINT
  #undef SHOWFLOAT
  #undef SHOWADDR
  #undef PTRCHECK
  #undef SHOWPTRCHECK
  #undef SETCURRENTDEBUGGER
  #undef GETCURRENTDEBUGGER

  #define SHOWPARENTMETHOD(p,m) \
            p->m; p->DbgPtr()->ShowMessage("Executed: "#m"\n")
  #define SHOWMETHOD(p,m) \
            m; p->DbgPtr()->ShowMessage("Executed: "#m"\n")

  #define SETDBGFILE(p,f)             p->DbgPtr()->SetFilename(f)
  #define ENTERLEVEL(p,s)             p->DbgPtr()->EnterLevel(s)
  #define LEAVELEVEL(p)               p->DbgPtr()->LeaveLevel()
  #define SHOWMESSAGE(p,s)            p->DbgPtr()->ShowMessage(s)
  #define SHOWSTR(p,s,n)              p->DbgPtr()->ShowStr(s,n)
  #define SHOWCHAR(p,c,n)             p->DbgPtr()->ShowChar(c,n)
  #define SHOWINT(p,v,n)              p->DbgPtr()->ShowInt(v,n)
  #define SHOWFLOAT(p,v,n)            p->DbgPtr()->ShowFloat(v,n)
  #define SHOWADDR(p,a,n)             p->DbgPtr()->ShowAddr(a,n)
  #define PTRCHECK(p,a,b)             p->DbgPtr()->PtrCheck(a,b)
  #define SHOWPTRCHECK(p,a,f,b)       p->DbgPtr()->ShowPtrCheck(a,f,b)
  #define SETCURRENTDEBUGGER(p,d)     p->SetCurrentDebugger(d)
  #define GETCURRENTDEBUGGER(p)       p->DbgPtr()
#else
  #define SHOWMETHOD(p,m)
  #define SHOWPARENTMETHOD(p,m)
  
  #define SETDBGFILE(p,f)           
  #define ENTERLEVEL(p,s)           
  #define LEAVELEVEL(p)             
  #define SHOWMESSAGE(p,s)          
  #define SHOWSTR(p,s,n)
  #define SHOWCHAR(p,c,n)
  #define SHOWINT(p,v,n)
  #define SHOWFLOAT(p,v,n)
  #define SHOWADDR(p,a,n)
  #define PTRCHECK(p,a,b)           
  #define SHOWPTRCHECK(p,a,f,b)     
  #define SETCURRENTDEBUGGER(p,d)   
  #define GETCURRENTDEBUGGER(p)     
#endif
