#ifndef EXECPRGNAME_H
  #include "execprgname.h"
#endif

/****************************************************************************/
// ExecutingProgramName class definitions
/****************************************************************************/
ExecutingProgramName::ExecutingProgramName(const char* Name_):
_Name(Name_ ? strcpy(new char[strlen(Name_)+1], Name_):NULL),
_PrgExecuted(NULL),
_Length(Name_ ? ::strlen(Name_):0),
_InInputFile(false),
_InProgramFile(Name_ != NULL),
_InputFilePause(false),
_Level(1),
_Next(NULL)
{}

/****************************************************************************/
ExecutingProgramName::ExecutingProgramName(char* Name_, const char* PrgExec_,
                                           bool InputFile_, int Level_, bool Pause_):
_Name((Level_ > 1) ? Name_:
      Name_ ? strcpy(new char[strlen(Name_)+1], Name_):NULL),
_PrgExecuted(PrgExec_),
_Length(Name_ ? ::strlen(Name_):0),
_InInputFile(Name_ && InputFile_),
_InProgramFile(Name_ && !InputFile_),
_InputFilePause(Pause_),
_Level((Level_ > 1) ? (Level_-1):0),
_Next(NULL)
{}

/****************************************************************************/
ExecutingProgramName::~ExecutingProgramName()
{
  _PrgExecuted = NULL;

  delete[] _Name;
  _Name = NULL;

  delete _Next;
  _Next = NULL;
}

/****************************************************************************/
ExecutingProgramName* ExecutingProgramName::CopyOldProgramName(char* Name_, const char* PrgExec_,
                                                               bool InputFile_, int Level_, bool Pause_)
{
  if (Name_)
  {
    if (_Name)
    {
      if (_Next)
        _Next->CopyOldProgramName(_Name, _PrgExecuted,
                                  _InInputFile, _Level, _InputFilePause);
      else
        _Next = new ExecutingProgramName(_Name, _PrgExecuted,
                                         _InInputFile, _Level+1, _InputFilePause);
    }
  
    _Name = (Level_ > 1) ? Name_:
                           strcpy(new char[strlen(Name_)+1], Name_);
    _PrgExecuted = NULL;
    _Length = Name_ ? ::strlen(Name_):0;
    _InInputFile = InputFile_;
    _InProgramFile = !InputFile_;
    _InputFilePause = Pause_;
    _Level = (Level_ > 1) ? Level_:0;
  }

  return this;
}

/****************************************************************************/
ExecutingProgramName* ExecutingProgramName::SetNewProgramName(const char* Name_)
{
  if (Name_)
  {
    if (_Name)
    {
      if (_Next)
        _Next->CopyOldProgramName(_Name, _PrgExecuted,
                                  _InInputFile, _Level, _InputFilePause);
      else
        _Next = new ExecutingProgramName(_Name, _PrgExecuted,
                                         _InInputFile, _Level+1, _InputFilePause);
    }
    
    _Name = strcpy(new char[strlen(Name_)+1], Name_);
    _PrgExecuted = NULL;
    _Length = ::strlen(Name_);
    _InInputFile = false;
    _InProgramFile = true;
    _InputFilePause = false;
    _Level++;
  }

  return this;
}

/****************************************************************************/
ExecutingProgramName* ExecutingProgramName::PopLevel(ExecutingProgramName*& OldNode_)
{
  ExecutingProgramName* OlderLevel_ = _Next ? _Next:this;

  if (_Next)
  {
    _Next = NULL;
    OldNode_ = this;
  }
  else
    OldNode_ = NULL;
  
  return OlderLevel_;
}

/****************************************************************************/
const char* ExecutingProgramName::NameIndexAt(size_t x, char ch)
{
  if (_Name && x < _Length)
  {
    _Name[x] = ch;
    return (_Name+x);
  }

  return (_Name ? (_Name+_Length):NULL);
}

/****************************************************************************/
const char* ExecutingProgramName::NameIndexAt(size_t x)
{
  if (_Name)
    return ((x < _Length) ? (_Name+x):(_Name+_Length));

  return NULL;
}

/****************************************************************************/
const char* ExecutingProgramName::ReplaceName(const char* Name_, bool SetPrgExec_)
{
  if (Name_)
  {
    if (::strlen(Name_) > _Length)
    {
      delete[] _Name;
      _Name = strcpy(new char[strlen(Name_)+1], Name_);
      _Length = ::strlen(Name_);
    }
    else
      ::strcpy(_Name, Name_);

    _PrgExecuted = SetPrgExec_ ? _Name:NULL;
    return _Name;
  }

  return NULL;
}

/****************************************************************************/
int ExecutingProgramName::StriCaseComp(const char* s1, const char* s2, bool SkipWs_) const
{
  size_t i;
  size_t max = s1 ? strlen(s1):0;

  if (SkipWs_ && s1)
    while (*s1)
      if (isspace(*s1))
        s1++;
      else
        break;
  
  if (s2 && ::strlen(s2) > max)
    max = ::strlen(s2);

  for (i = 0; i < max; i++)
  {
    if (!(*s1) && !(*s2))
      return 1;
    else if (!(*s1) || !(*s2))
      return 0;

    if (isalpha(*s1) && isalpha(*s2))
    {
      if (tolower(*s1) != tolower(*s2))
        return 0;
    }
    else if ((*s1) != (*s2))
      return 0;

    s1++;
    s2++;
  }

  return 1;
}

/****************************************************************************/
bool ExecutingProgramName::MatchName(const char* Name_)
{
  return StriCaseComp(_Name, Name_);
}

/****************************************************************************/
bool ExecutingProgramName::IsMatchingPrgExec() const
{
  return ((_Name && _PrgExecuted == _Name) ||
          (_Name && _PrgExecuted && StriCaseComp(_PrgExecuted, _Name)));
}

/****************************************************************************/
bool ExecutingProgramName::IsBatchInputFile() const
{
  size_t FileLen_ = NameLength();
  return StriCaseComp(Name()+FileLen_-3, ".in");
}

/****************************************************************************/
void ExecutingProgramName::SetAsInputFile(bool flag_)
{
  _InInputFile = flag_;
  _InProgramFile = !flag_;

  if (!flag_)
    _InputFilePause = false;
}

/****************************************************************************/
void ExecutingProgramName::SetPauseSwitch(bool flag_)
{
  _InputFilePause = flag_;
}

/****************************************************************************/
void ExecutingProgramName::SetPrgExecuted(const char* Name_)
{
  _PrgExecuted = Name_;
}

/****************************************************************************/
