// header includes for sortdialog.h
//
#ifndef MCHEADERS_H
#define MCHEADERS_H

#include <qeventloop.h>
#include <qapplication.h>
#include <qvariant.h>
#include <qdialog.h>
#include <qtimer.h>
#include <qmessagebox.h>
#include <qfile.h>
#include <qstring.h>
#include <qsplashscreen.h>
#include <qtextedit.h>
#include <qobject.h>
#include <qprocess.h>
#include <qbuttongroup.h>
#include <qprinter.h>
#include <qpainter.h>

#define QMCALC_WIN64VER             0
#define QMCALC_ERROR_MARGIN         .00001
#define QMCALC_INF_POINT_RADIUS     .125
#define QMCALC_MINOR_AXIS_RADIUS    .25
#define QMCALC_MAJOR_AXIS_RADIUS    2
#define QMCALC_TWIRLY_INTERVAL      500
#define QMCALC_SERVERCHECK_INTERVAL 20000
#define QMCALC_GRAPH_RADIUS         5
#define QMCALC_RECURSE_LIMIT        10
#define QMCALC_RETRY_READ_MAX       5
#define QMCALC_RETRY_ATTEMPTS       5
#define QMCALC_MAX_FATAL_ERRORS     10
#define QMCALC_TIMEOUT_WARNING      20     // send calculator timeout warning at x seconds
#define QMCALC_TIMEOUT_DURATION     3      // calc. timeout warning message duration at x seconds
#define QMCALC_REENABLE_DURATION    20000  // QMCALC_TIMEOUT_WARNING x 1000

struct ButtonInfo
{
  char* _Command;
  int _Length;
  bool _UserDefined;
  bool _CombinedCharStr;
};

struct ButtonId
{
  enum
  {
    NO_BUTTON          = 0,
    QUIT               = 1,
    NUM0               = 2,
    NUM1               = 3,
    NUM2               = 4,
    NUM3               = 5,
    NUM4               = 6,
    NUM5               = 7,
    NUM6               = 8,
    NUM7               = 9,
    NUM8               = 10,
    NUM9               = 11,
    ASSIGN             = 12,
    DIVASSIGN          = 13,
    MULTASSIGN         = 14,
    MINUSASSIGN        = 15,
    PLUSASSIGN         = 16,
    MODASSIGN          = 17,
    DIV                = 18,
    MULT               = 19,
    MINUS              = 20,
    PLUS               = 21,
    MOD                = 22,
    NEG                = 23,
    DECPOINT           = 24,
    RIGHTBRACKET       = 25,
    LEFTBRACKET        = 26,
    CEIL               = 27,
    FLOOR              = 28,
    MAX                = 29,
    MIN                = 30,
    RAND               = 31,
    SIN                = 32,
    COS                = 33,
    TAN                = 34,
    ASIN               = 35,
    ACOS               = 36,
    ATAN               = 37,
    SINH               = 38,
    COSH               = 39,
    TANH               = 40,
    SQR                = 41,
    SQRT               = 42,
    CUBE               = 43,
    CUBERT             = 44,
    PERM               = 45,
    COMB               = 46,
    COMBREP            = 47,
    FACT               = 48,
    EQUAL              = 49,
    NOTEQUAL           = 50,
    GREATERTHAN        = 51,
    LESSTHAN           = 52,
    GREATERTHANOREQUAL = 53,
    LESSTHANOREQUAL    = 54,
    EXP                = 55,
    LOG                = 56,
    LOG10              = 57,
    POW                = 58,
    POLTORECX          = 59,
    POLTORECY          = 60,
    RECTOPOLR          = 61,
    RECTOPOLA          = 62,
    ROUND              = 63,
    RND                = 64,
    PERCENT            = 65,
    INVERSE            = 66,
    FRAC               = 67,
    SCI                = 68,
    FROMCMP2BIN        = 69,
    FROMBIN            = 70,
    FROMOCT            = 71,
    FROMHEX            = 72,
    TOCMP2BIN          = 73,
    TOBIN              = 74,
    TOOCT              = 75,
    TOHEX              = 76,
    ITEMPERM           = 77,
    ITEMCOMB           = 78,
    ITEMCOMBREP        = 79,
    FRACPART           = 80,
    INTPART            = 81,
    ABS                = 82,
    AND                = 83,
    OR                 = 84,
    XOR                = 85,
    NOT                = 86,
    DERIV              = 87,
    INTEG              = 88,
    FMIN               = 89,
    FMAX               = 90,
    SOLVE              = 91,
    HEXPREFIX          = 92,
    EXEC               = 93,
    EVAL               = 94,
    GETPREC            = 95,
    HELP               = 96,
    EDIT               = 97,
    GRAPH              = 98,
    DEL                = 99,
    CLEAR              = 100,
    ENTER              = 101,
    ORASSIGN           = 102,
    ANDASSIGN          = 103,
    AVGMEAN            = 104,
    AVGMODE            = 105,
    AVGMEDIAN          = 106,
    STDDEV             = 107,
    SUM                = 108,
    PRODUCT            = 109,
    SHOW               = 110,
    MATSOLVE           = 111,
    GRAPHALLPTS        = 112,
    DERIV2             = 113,
    COMMA              = 114,
    XVAR               = 115,
    PI                 = 116,
    NAT_E              = 117,
    CLEARGRAPH         = 118,
    BREAK              = 119,
    PERMREP            = 120,
    ITEMPERMREP        = 121,
    INTERSECT          = 122,
    TRACE              = 123,
    PRINT              = 124,
    SET                = 125,
    SETUNI             = 126,
    SETINT             = 127,
    SETDIF             = 128,
    SETXDIF            = 129,
    SHOWSET            = 130,
    GRAPHPREC          = 131,
    HISTORY            = 132,
    MAX_BUTTONS        = 133
  };
};

struct ResponseSignal
{
  enum
  {
    NO_RESPONSE     = 0,
    SEND_TOCALC     = 1,
    SEND_TOCALC_ACK = 2,
  
    SEND_GRAPHWAITFETCHED     = 199,
    SEND_GRAPHPROGRESSFETCHED = 299,
  
    OUTPUT_SHOWN = 999,
    ERROR_FOUND  = 9999
  };
};

struct GraphPlotOpType
{
  enum
  {
    NO_GRAPH          = 0,  // No graph operations specified
    
    FUNCTION_PLOT     = 1,  // straight function plot of math expression
    APPLIED_FNCGRAPH  = 2,  // extra applied functions: deriv, integ, etc...
    BATCH_GRAPH_PLOT  = 3   // batch input of graph operations
  };
};

struct GraphType
{
  enum
  {
    NO_GRAPH     = 0,
    
    FUNCTION     = 1,
    EXTREMA      = 2,
    DERIVATIVE   = 3,
    INTEGRAL     = 4,
    ROOTSOLVE    = 5,
    INTERSECT1   = 6,
    INTERSECT2   = 7,

    MIN_EXTREMA  = 101,
    MAX_EXTREMA  = 102,
    
    FIRST_DERIV  = 201,
    SECOND_DERIV = 202
  };
};

#endif
