/****************************************************************************
** $Id: qt/application.cpp   3.3.1   edited Jul 17 2003 $
**
** Copyright (C) 1992-2002 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/

#include "calcedit.h"

#include <qimage.h>
#include <qpixmap.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qtextedit.h>
#include <qfile.h>
#include <qfiledialog.h>
#include <qstatusbar.h>
#include <qmessagebox.h>
#include <qprinter.h>
#include <qapplication.h>
#include <qaccel.h>
#include <qtextstream.h>
#include <qpainter.h>
#include <qpaintdevicemetrics.h>
#include <qwhatsthis.h>
#include <qsimplerichtext.h>

#include "filesave.xpm"
#include "fileopen.xpm"
#include "fileprint.xpm"

ApplicationWindow::ApplicationWindow():
QMainWindow( 0, "Qmcalc program editor main window", WDestructiveClose | WGroupLeader )
{
    _DirPath1valid =
    _DirPath2valid =
    _DirPath3valid = false;
    _CustomPathValid = false;
    _HasCaption = false;
    _FileNotFound = false;
    _FileDialog = new QFileDialog(NULL, "ScriptEditor");
    
  #if ((defined(__linux__) | defined(__unix__)) & defined(Q_OS_LINUX))
    _DirPath1 = QDir::homeDirPath();
    _DirPath2 = _DirPath1 + QString("qmcalc-2");
    _DirPath3 = QString("/usr/local/bin/qmcalc-2");
  #else
    _DirPath1 = QDir::homeDirPath();
    _DirPath2 = _DirPath1 + QString("Qmcalc");
    _DirPath3 = QString("c:\\Program Files\\Cybernadian\\Qmcalc");
  #endif

    printer = new QPrinter( QPrinter::HighResolution );
    QPixmap openIcon, saveIcon, printIcon;

    QToolBar * fileTools = new QToolBar( this, "file operations" );
    fileTools->setLabel( "File Operations" );

    openIcon = QPixmap( fileopen );
    QToolButton * fileOpen
        = new QToolButton( openIcon, "Open File", QString::null,
                           this, SLOT(choose()), fileTools, "open file" );

    saveIcon = QPixmap( filesave );
    QToolButton * fileSave
        = new QToolButton( saveIcon, "Save File", QString::null,
                           this, SLOT(save()), fileTools, "save file" );

    printIcon = QPixmap( fileprint );
    QToolButton * filePrint
        = new QToolButton( printIcon, "Print File", QString::null,
                           this, SLOT(print()), fileTools, "print file" );


    (void)QWhatsThis::whatsThisButton( fileTools );

    const char * fileOpenText = "<p><img source=\"fileopen\"> "
                 "Click this button to open a <em>new file</em>.<br>"
                 "You can also select the <b>Open</b> command "
                 "from the <b>File</b> menu.</p>";

    QWhatsThis::add( fileOpen, fileOpenText );

    QMimeSourceFactory::defaultFactory()->setPixmap( "fileopen", openIcon );

    const char * fileSaveText = "<p>Click this button to save the file you "
                 "are editing. You will be prompted for a file name.\n"
                 "You can also select the <b>Save</b> command "
                 "from the <b>File</b> menu.</p>";

    QWhatsThis::add( fileSave, fileSaveText );

    const char * filePrintText = "Click this button to print the file you "
                 "are editing.\n"
                 "You can also select the Print command "
                 "from the File menu.";

    QWhatsThis::add( filePrint, filePrintText );


    QPopupMenu * file = new QPopupMenu( this );
    menuBar()->insertItem( "&File", file );


    file->insertItem( "&New", this, SLOT(newDoc()), CTRL+Key_N );

    int id;
    id = file->insertItem( openIcon, "&Open...",
                           this, SLOT(choose()), CTRL+Key_O );
    file->setWhatsThis( id, fileOpenText );

    id = file->insertItem( saveIcon, "&Save",
                           this, SLOT(save()), CTRL+Key_S );
    file->setWhatsThis( id, fileSaveText );

    id = file->insertItem( "Save &As...", this, SLOT(saveAs()) );
    file->setWhatsThis( id, fileSaveText );

    file->insertSeparator();

    id = file->insertItem( printIcon, "&Print...",
                           this, SLOT(print()), CTRL+Key_P );
    file->setWhatsThis( id, filePrintText );

    file->insertSeparator();

    file->insertItem( "&Close", this, SLOT(close()), CTRL+Key_W );

    file->insertItem( "&Quit", qApp, SLOT( closeAllWindows() ), CTRL+Key_Q );

    menuBar()->insertSeparator();

    QPopupMenu * help = new QPopupMenu( this );
    menuBar()->insertItem( "&Help", help );

    help->insertItem( "&About", this, SLOT(about()), Key_F1 );
    help->insertSeparator();
    help->insertItem( "What's &This", this, SLOT(whatsThis()), SHIFT+Key_F1 );

    e = new QTextEdit( this, "editor" );
    e->setFocus();
    setCentralWidget( e );
    statusBar()->message( "Ready", 2000 );
   
    // Setup default working directory path of file editor
    bool DirPathValid_ = false;
    QString DirPath_ = "";       // default working directory path of file editor
                                 // leave blank for auto detect.
    
    _DirPath1valid =
    _DirPath2valid =
    _DirPath3valid = false;
    _FileNotFound = false;

    _QDirin.setFilter(QDir::Files);
    _QDirin.setNameFilter("*.prg;*.in");
    _QDirin.setSorting(QDir::Name);

    if (DirPath_.length())
    {
      _QDirin.setPath(DirPath_);
      DirPathValid_ = _QDirin.count() > 0;
    }
    
    if (!DirPathValid_ || !DirPath_.length())
    {
      _CustomPath = "";
      _CustomPathValid = false;

      _QDirin.setPath(_DirPath1);
      _DirPath1valid = _QDirin.count() > 0;
    
      if (!_DirPath1valid)
      {
        _QDirin.setPath(_DirPath2);
        _DirPath2valid = _QDirin.count() > 0;
      
        if (!_DirPath2valid)
        {
          _QDirin.setPath(_DirPath3);
          _DirPath3valid = _QDirin.count() > 0;

          if (!_DirPath3valid)
            _FileNotFound = true;
        }
      }
    }
    else
    {
      _CustomPath = DirPath_;
      _CustomPathValid = true;
    }
    
    if (_FileDialog)
    {
      if (_DirPath1valid)
        _FileDialog->setDir(_DirPath1);
      else if (_DirPath2valid)
        _FileDialog->setDir(_DirPath2);
      else if (_DirPath3valid)
        _FileDialog->setDir(_DirPath3);
      else if (_CustomPathValid)
        _FileDialog->setDir(_CustomPath);
      
      _FileFilter = "Qmcalc Data Files (*.prg *.in)";
      _FileDialog->setFilter(_FileFilter);
    }

    resize( 450, 600 );
    
    QString OutFilePath_;
    QString InFilePath_;
    QString CaptionStr_;
    bool FileSet_ = false;
    
    if (qApp->argc() > 2)
    {
      FileSet_ = qApp->argv()[2] && QFile::exists(QString(qApp->argv()[2]));
      
      if (!FileSet_)
      {
        #if ((defined(__linux__) | defined(__unix__)) & defined(Q_OS_LINUX))
          if (_DirPath1valid)
          {
            InFilePath_ = OutFilePath_ = _DirPath1 + QString("/");
            InFilePath_ += QString(qApp->argv()[1]);
            OutFilePath_ += QString(qApp->argv()[2]);
            FileSet_ = true;
          }
          else if (_DirPath2valid)
          {
            InFilePath_ = OutFilePath_ = _DirPath2 + QString("/");
            InFilePath_ += QString(qApp->argv()[1]);
            OutFilePath_ += QString(qApp->argv()[2]);
            FileSet_ = true;
          }
          else if (_DirPath3valid)
          {
            InFilePath_ = OutFilePath_ = _DirPath3 + QString("/");
            InFilePath_ += QString(qApp->argv()[1]);
            OutFilePath_ += QString(qApp->argv()[2]);
            FileSet_ = true;
          }
          else
            FileSet_= false;
  
          if (FileSet_)
          {
            FileSet_ = false;            
    
            if (QFile::exists(InFilePath_))
            {
              if (QFile::exists(OutFilePath_))
              {
                _CaptionStr = QString(qApp->argv()[2]) + QString(": ");
                _CaptionStr += QString(tr("Results From Processing Input Data File: ")) + QString(qApp->argv()[1]);
              }
              else
                _CaptionStr = QString(tr("Results From Processing Input Data File: ")) + QString(qApp->argv()[1]);

              setUpdatesEnabled(true);
              setCaption(_CaptionStr);              
              _HasCaption = true;
              resize( 600, 600 );
              update(); repaint();
              // setUpdatesEnabled(false);
            }

            if (QFile::exists(OutFilePath_))
            {
              _CaptionStr = QString(qApp->argv()[2]) + QString(": ");
              _CaptionStr += QString(tr("Results From Processing Input Data File: "));
    
              if (qApp->argv()[1])
                _CaptionStr += QString(qApp->argv()[1]);

              _HasCaption = true;
              setCaption(_CaptionStr);

              setUpdatesEnabled(true);
              load(OutFilePath_);
              resize( 600, 600 );
              update(); repaint();
              // setUpdatesEnabled(false);
            }
          }

        #else
          if (_DirPath1valid)
          {
            InFilePath_ = OutFilePath_ = _DirPath1 + QString("\\");
            InFilePath_ += QString(qApp->argv()[1]);
            OutFilePath_ += QString(qApp->argv()[2]);
            FileSet_ = true;
          }
          else if (_DirPath2valid)
          {
            InFilePath_ = OutFilePath_ = _DirPath2 + QString("\\");
            InFilePath_ += QString(qApp->argv()[1]);
            OutFilePath_ += QString(qApp->argv()[2]);
            FileSet_ = true;
          }
          else if (_DirPath3valid)
          {
            InFilePath_ = OutFilePath_ = _DirPath3 + QString("\\");
            InFilePath_ += QString(qApp->argv()[1]);
            OutFilePath_ += QString(qApp->argv()[2]);
            FileSet_ = true;
          }
          else
            FileSet_ = false;

          if (FileSet_)
          {
            FileSet_= false;

            if (QFile::exists(InFilePath_))
            {
              if (QFile::exists(OutFilePath_))
              {
                _CaptionStr = QString(qApp->argv()[2]) + QString(": ");
                _CaptionStr += QString(tr("Results From Processing Input Data File: ")) + QString(qApp->argv()[1]);
              }
              else
                _CaptionStr = QString(tr("Results From Processing Input Data File: ")) + QString(qApp->argv()[1]);

              setUpdatesEnabled(true);
              setCaption(_CaptionStr);
              _HasCaption = true;
              resize( 600, 600 );
              update(); repaint();
              // setUpdatesEnabled(false);
            }

            if (QFile::exists(OutFilePath_))
            {
              _CaptionStr = QString(qApp->argv()[2]) + QString(": ");
              _CaptionStr += QString(tr("Results From Processing Input Data File: "));
    
              if (qApp->argv()[1])
                _CaptionStr += QString(qApp->argv()[1]);

              _HasCaption = true;
              setCaption(_CaptionStr);
      
              setUpdatesEnabled(true);
              load(OutFilePath_);
              resize( 600, 600 );
              update(); repaint();
              // setUpdatesEnabled(false);
            }
          }         
        #endif
      }
      else
      {
        FileSet_ = false;

        if (qApp->argv()[1] && QFile::exists(QString(qApp->argv()[1])))
        {
          if (qApp->argv()[2] && QFile::exists(QString(qApp->argv()[2])))
          {
            _CaptionStr = QString(qApp->argv()[2]) + QString(": ");
            _CaptionStr += QString(tr("Results From Processing Input Data File: ")) + QString(qApp->argv()[1]);
          }
          else
            _CaptionStr = QString(tr("Results From Processing Input Data File: ")) + QString(qApp->argv()[1]);

          setUpdatesEnabled(true);
          setCaption(_CaptionStr);
          _HasCaption = true;
          resize( 600, 600 );
          update(); repaint();
          // setUpdatesEnabled(false);
        }        

        if (qApp->argv()[2] && QFile::exists(QString(qApp->argv()[2])))
        {
          _CaptionStr = QString(qApp->argv()[2]) + QString(": ");
          _CaptionStr += QString(tr("Results From Processing Input Data File: "));            
    
          if (qApp->argv()[1])
            _CaptionStr += QString(qApp->argv()[1]);
    
          _HasCaption = true;
          setCaption(_CaptionStr);          
  
          setUpdatesEnabled(true);
          load(QString(qApp->argv()[2]));
          resize( 600, 600 );
          update(); repaint();
          // setUpdatesEnabled(false);	  
        }
      }
    }
    else    
      choose();
}


ApplicationWindow::~ApplicationWindow()
{
    delete printer;
    delete _FileDialog;
}

bool ApplicationWindow::HasCaption() const
{
  return _HasCaption;
}

void ApplicationWindow::newDoc()
{
    ApplicationWindow *ed = new ApplicationWindow;
    ed->setCaption(_HasCaption ? _CaptionStr:QString("Qmcalc Program Editor"));
    ed->show();
    ed->update();
}

void ApplicationWindow::choose()
{
    QString DirPath_ = _FileDialog->dirPath();
    QString fn = _FileDialog->getOpenFileName( DirPath_,
                                               _FileFilter,
                                               this,
                                               "ScriptEditor",
                                               "Choose a data file to open");
    if ( !fn.isEmpty() )
        load( fn );
    else
        statusBar()->message( "Loading aborted", 2000 );
}


void ApplicationWindow::load( const QString &fileName )
{
    QFile f( fileName );
    if ( !f.open( IO_ReadOnly ) )
        return;

    QTextStream ts( &f );
    e->setText( ts.read() );
    e->setModified( FALSE );
    setCaption(_HasCaption ? _CaptionStr:fileName);
    statusBar()->message( "Loaded document " + fileName, 2000 );
    update();
}


void ApplicationWindow::save()
{
    if ( filename.isEmpty() ) {
        saveAs();
        return;
    }

    QString text = e->text();
    QFile f( filename );
    if ( !f.open( IO_WriteOnly ) ) {
        statusBar()->message( QString("Could not write to %1").arg(filename),
                              2000 );
        return;
    }

    QTextStream t( &f );
    t << text;
    f.close();

    e->setModified( FALSE );

    setCaption( filename );
    statusBar()->message( QString( "File %1 saved" ).arg( filename ), 2000 );
    update();
}


void ApplicationWindow::saveAs()
{
    QString DirPath_ = _FileDialog->dirPath();
    QString fn = QFileDialog::getSaveFileName( DirPath_,
                                               _FileFilter,
                                               this,
                                               "ScriptEditor",
                                               "Choose a filename to save under" );
    if ( !fn.isEmpty() ) {
        filename = fn;
        save();
    } else {
        statusBar()->message( "Saving aborted", 2000 );
    }
}


void ApplicationWindow::print()
{
    printer->setFullPage( TRUE );
    if ( printer->setup(this) ) {                 // printer dialog
        statusBar()->message( "Printing..." );
        QPainter p;
        if( !p.begin( printer ) ) {               // paint on printer
            statusBar()->message( "Printing aborted", 2000 );
            return;
        }

        QPaintDeviceMetrics metrics( p.device() );
        int dpiy = metrics.logicalDpiY();
        int margin = (int) ( (2/2.54)*dpiy ); // 2 cm margins
        QRect body( margin, margin, metrics.width() - 2*margin, metrics.height() - 2*margin );
        QSimpleRichText richText( QStyleSheet::convertFromPlainText(e->text()),
                                  QFont(),
                                  e->context(),
                                  e->styleSheet(),
                                  e->mimeSourceFactory(),
                                  body.height() );
        richText.setWidth( &p, body.width() );
        QRect view( body );
        int page = 1;
        do {
            richText.draw( &p, body.left(), body.top(), view, colorGroup() );
            view.moveBy( 0, body.height() );
            p.translate( 0 , -body.height() );
            p.drawText( view.right() - p.fontMetrics().width( QString::number( page ) ),
                        view.bottom() + p.fontMetrics().ascent() + 5, QString::number( page ) );
            if ( view.top()  >= richText.height() )
                break;
            printer->newPage();
            page++;
        } while (TRUE);

        statusBar()->message( "Printing completed", 2000 );
    } else {
        statusBar()->message( "Printing aborted", 2000 );
    }
}

void ApplicationWindow::closeEvent( QCloseEvent* ce )
{
    if ( !e->isModified() ) {
        ce->accept();
        return;
    }

    switch( QMessageBox::information( this, "Qmcalc Calculator Program Editor",
                                      "Do you want to save the changes"
                                      " to the document?",
                                      "Yes", "No", "Cancel",
                                      0, 1 ) ) {
    case 0:
        save();
        ce->accept();
        break;
    case 1:
        ce->accept();
        break;
    case 2:
    default: // just for sanity
        ce->ignore();
        break;
    }
}


void ApplicationWindow::about()
{
    QMessageBox::about( this, "Qmcalc Calculator Program Editor",
                        "This text editor can be used to create\n"
                        "or edit program or input files for use\n"
                        "with the Qmcalc calculator.");
}
