/****************************************************************************
** $Id: qt/application.h   3.3.1   edited May 27 2003 $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for Qt.  This example
** program may be used, distributed and modified without limitation.
**
*****************************************************************************/

#ifndef CALCEDIT_H
#define CALCEDIT_H

#include <qmainwindow.h>
#include <qfiledialog.h>

class QTextEdit;

class ApplicationWindow: public QMainWindow
{
    Q_OBJECT

public:
    ApplicationWindow();
    ~ApplicationWindow();
    
    bool HasCaption() const;

protected:
    void closeEvent( QCloseEvent* );

private slots:
    void newDoc();
    void choose();
    void load( const QString &fileName );
    void save();
    void saveAs();
    void print();
    void about();

private:
    QPrinter *printer;
    QTextEdit *e;
    QString filename;
    
    QDir _QDirin;
    QFileDialog* _FileDialog;
    QString _FileFilter;
    
    QString _DirPath1;
    QString _DirPath2;
    QString _DirPath3;
    QString _CustomPath;
    QString _CaptionStr;
    
    bool _HasCaption;    
    bool _DirPath1valid;
    bool _DirPath2valid;
    bool _DirPath3valid;
    bool _CustomPathValid;
    bool _FileNotFound;
};


#endif
